
#include <Windows.h>
#include <D3D8.h>

#include "Main.h"
#include "Fmath.h"
#include "TxGen.h"
#include "D3DU8.h"
#include "Rand.h"

// ------------------------------------------------------------------------------------------------

#define D3DFVF_CONEBACK_VERTEX1 (D3DFVF_XYZ|D3DFVF_DIFFUSE|D3DFVF_TEX1|D3DFVF_TEXCOORDSIZE2(0))
typedef struct _CONEBACK_VERTEX1
  {
    D3DVECTOR Vertex;
    DWORD Diffuse;
    float TexU1, TexV1;
   } CONEBACK_VERTEX1;

LPDIRECT3DVERTEXBUFFER8 ConeBack_VertexBuffer1 = NULL;
CONEBACK_VERTEX1 *ConeBack_LockedVertexBuffer1;

LPDIRECT3DINDEXBUFFER8 ConeBack_IndexBuffer1 = NULL;
WORD *ConeBack_LockedIndexBuffer1;

extern LPDIRECT3DTEXTURE8 SphereBack_Texture1;
extern LPDIRECT3DTEXTURE8 SphereBack_Texture2;
extern LPDIRECT3DTEXTURE8 SphereBack_Texture3;
extern LPDIRECT3DTEXTURE8 SphereBack_Texture4;
extern LPDIRECT3DTEXTURE8 MetaBalls_Texture4;

// ------------------------------------------------------------------------------------------------

int ConeBack_Initialize( void )
  {
    int X, Y, Col;
    float DX, DY, DC;

    // --- Create VertexBuffer1
    if ( Direct3DDevice->CreateVertexBuffer( 65*37*sizeof( CONEBACK_VERTEX1 ), 0, D3DFVF_CONEBACK_VERTEX1,
      D3DPOOL_DEFAULT, &ConeBack_VertexBuffer1 ) != D3D_OK ) return 0;
    if ( ConeBack_VertexBuffer1->Lock( 0, 65*37*sizeof( CONEBACK_VERTEX1 ), (BYTE**) &ConeBack_LockedVertexBuffer1, 0 ) != D3D_OK ) return 0;

    for ( Y=0; Y<37; Y++ )
      for ( X=0; X<65; X++ )
        {
          D3DUVec3Create( &ConeBack_LockedVertexBuffer1[ Y*65+X ].Vertex, 10.0f*X, 10.0f*Y + 60.0f, 1.0f );

          DX = (float) X + (float) Y * 0.4f - 48.0f;
          DY = ( Y - 15.0f ) / 3.0f;
          DC = Fsqrt( Fsqr( DX ) + Fsqr( DY ));

          ConeBack_LockedVertexBuffer1[ Y*65+X ].TexU1= 1.6f * DX / ( DC + 6.0f );
          ConeBack_LockedVertexBuffer1[ Y*65+X ].TexV1= 1.6f * DY / ( DC + 6.0f );

          Col = Fround( 10.0f + Fsqr( DC + 38.0f ) / 20.0f );
          if ( Col > 255 ) Col = 255;

          ConeBack_LockedVertexBuffer1[ Y*65+X ].Diffuse = 0x010101 * Col;
         }

    ConeBack_VertexBuffer1->Unlock();

    // --- Create IndexBuffer1.
    if ( Direct3DDevice->CreateIndexBuffer( 13824*sizeof( WORD ), 0, D3DFMT_INDEX16, D3DPOOL_DEFAULT, &ConeBack_IndexBuffer1 ) != D3D_OK ) return 0;
    if ( ConeBack_IndexBuffer1->Lock( 0, 13824*sizeof( WORD ), (BYTE**) &ConeBack_LockedIndexBuffer1, 0 ) != D3D_OK ) return 0;

    for ( Y=0; Y<36; Y++ )
      for ( X=0; X<64; X++ )
        {
          ConeBack_LockedIndexBuffer1[ (Y*64+X)*6+0 ] = Y*65+X;
          ConeBack_LockedIndexBuffer1[ (Y*64+X)*6+1 ] = Y*65+X+1;
          ConeBack_LockedIndexBuffer1[ (Y*64+X)*6+2 ] = Y*65+X+65;
          ConeBack_LockedIndexBuffer1[ (Y*64+X)*6+3 ] = Y*65+X+1;
          ConeBack_LockedIndexBuffer1[ (Y*64+X)*6+4 ] = Y*65+X+66;
          ConeBack_LockedIndexBuffer1[ (Y*64+X)*6+5 ] = Y*65+X+65;
         }

    ConeBack_IndexBuffer1->Unlock();

    return 1;
   }

// ------------------------------------------------------------------------------------------------

void ConeBack_Cleanup( void )
  {
    if ( ConeBack_VertexBuffer1 ) ConeBack_VertexBuffer1->Release();
    if ( ConeBack_IndexBuffer1 ) ConeBack_IndexBuffer1->Release();
   }

// ------------------------------------------------------------------------------------------------

void ConeBack_Render( float Time )
  {
    float Light;

    // --- Setup Lighting.
    Direct3DDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
    Direct3DDevice->LightEnable( 0, FALSE );

    // --- Setup Texture Stage0.
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_DISABLE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MIPFILTER, D3DTEXF_NONE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_COUNT2 );

    // --- Setup Texture Stage1.
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_MODULATE );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLORARG1, D3DTA_CURRENT );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLORARG2, D3DTA_TFACTOR );

    Direct3DDevice->SetTextureStageState( 2, D3DTSS_COLOROP, D3DTOP_DISABLE );

    // --- Blending.
    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
    Direct3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
    
    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, FALSE );
    Direct3DDevice->SetVertexShader( D3DFVF_CONEBACK_VERTEX1 );

    Direct3DDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );

    if ( Time <= 17.0f * 64.0f - 32.0f ) Light = 0.0f;
    if (( Time > 17.0f * 64.0f - 32.0f ) && ( Time <= 17.0f * 64.0f +32.0f )) Light = ( Time - ( 17.0f * 64.0f - 32.0f )) / 64.0f;
    if (( Time > 17.0f * 64.0f + 32.0f ) && ( Time <= 20.0f * 64.0f )) Light = 1.0f;
    if (( Time > 20.0f * 64.0f ) && ( Time <= 21.0f * 64.0f )) Light = ( 21.0f * 64.0f - Time ) / 64.0f;
    if ( Time > 21.0f * 64.0f ) Light = 0.0f;

    Direct3DDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x010101 * Fround( 192.0f * Light ));

    // --- Setup Matrices.
    Direct3DDevice->SetTransform( D3DTS_WORLD, &D3DUMatrixIdentity );

    D3DUVec3Create( &D3DVector_CameraPosition, 319.5f, 240.5f, -1.0f );
    D3DUVec3Create( &D3DVector_CameraTarget, 319.5f, 240.5f, 0.0f );
    D3DUVec3Create( &D3DVector_Up, 0.0f, -1.0f, 0.0f );
    D3DUMatrixLookAtLH( &D3DMatrix_View, &D3DVector_CameraPosition, &D3DVector_CameraTarget, &D3DVector_Up );
    Direct3DDevice->SetTransform( D3DTS_VIEW, &D3DMatrix_View );

    D3DUMatrixOrthoLH( &D3DMatrix_Projection, 640.0f, 360.0f, 0.1f, 10.0f );
    Direct3DDevice->SetTransform( D3DTS_PROJECTION, &D3DMatrix_Projection );

    // --- Setup Texture Matrix.
    D3DUMatrixTranslation( &D3DMatrix_Texture0, Time/39.0f, Time/21.0f, -Time/54.0f );
    D3DUMatrixRotationZ( &D3DMatrix_Temp, Time/261.0f );
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationY( &D3DMatrix_Temp, 0.2f * Fsin( Time/59.4f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationX( &D3DMatrix_Temp, 0.2f * Fsin( Time/55.0f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    Direct3DDevice->SetTransform( D3DTS_TEXTURE0, &D3DMatrix_Texture0 );

    // --- Render1.
    Direct3DDevice->SetTexture( 0, SphereBack_Texture3 );
    Direct3DDevice->SetStreamSource( 0, ConeBack_VertexBuffer1, sizeof( CONEBACK_VERTEX1 ));
    Direct3DDevice->SetIndices( ConeBack_IndexBuffer1, 0 );
    Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 65*37, 0, 64*36*2 );

    // --- Setup Texture Matrix.
    D3DUMatrixTranslation( &D3DMatrix_Texture0, Time/34.0f, Time/31.0f, -Time/58.0f );
    D3DUMatrixRotationZ( &D3DMatrix_Temp, Time/251.0f );
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationY( &D3DMatrix_Temp, 0.2f * Fsin( Time/63.4f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationX( &D3DMatrix_Temp, 0.2f * Fsin( Time/65.0f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    Direct3DDevice->SetTransform( D3DTS_TEXTURE0, &D3DMatrix_Texture0 );

    // --- Render2.
    Direct3DDevice->SetTexture( 0, SphereBack_Texture4 );
    Direct3DDevice->SetStreamSource( 0, ConeBack_VertexBuffer1, sizeof( CONEBACK_VERTEX1 ));
    Direct3DDevice->SetIndices( ConeBack_IndexBuffer1, 0 );
    Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 65*37, 0, 64*36*2 );

    // --- Setup Texture Matrix.
    D3DUMatrixTranslation( &D3DMatrix_Texture0, -Time/44.0f, Time/21.0f, Time/28.0f );
    D3DUMatrixRotationZ( &D3DMatrix_Temp, Time/241.0f );
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationY( &D3DMatrix_Temp, 0.1f * Fsin( Time/43.0f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationX( &D3DMatrix_Temp, 0.1f * Fsin( Time/47.0f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    Direct3DDevice->SetTransform( D3DTS_TEXTURE0, &D3DMatrix_Texture0 );

    // --- Render2.
    Direct3DDevice->SetTexture( 0, SphereBack_Texture2 );
    Direct3DDevice->SetStreamSource( 0, ConeBack_VertexBuffer1, sizeof( CONEBACK_VERTEX1 ));
    Direct3DDevice->SetIndices( ConeBack_IndexBuffer1, 0 );
    Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 65*37, 0, 64*36*2 );

    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, TRUE );
   }