
// --- Marching Cubes: Metaballs & Julia3D.
//  Copyright (c) 2000. Remage / Fresh!mindworkz.
//  Thanks to Rod / Mandula, Arpi / Astral, Bred / Rg42.

#define GRID 32             
#define GRID2 16            // GRID/2
#define GRID3 0.12f       // 1.0f / GRID2;
#define GRIDC 0.01f       //  1.0f / (GRID*3)
#define GRIDS 1024        // GRID*GRID

#define BLOBS 6

float *Blobs, *BlobShd;
int *Frames;
Vect BlobPos[ BLOBS ];

#include "Polytab.h"

int X, Y, Z, Ofs, DX1, DX2, DY1, DY2, DZ1, DZ2, Pt, Cube;
float X0, Y0, Z0, DB, Dist2, BlobIso, BlobMax, BlobMax1, BlobMax2;

void Blob_Init( void )
  {
    int I, J, K;
    float dX, dY, dZ, CDist;

    Blobs = (float*) malloc( GRID*GRID*GRID*sizeof( float ));
    BlobShd = (float*) malloc( GRID*GRID*GRID*sizeof( float ));
    Frames = (int*) malloc( GRID*GRID*GRID*sizeof( int ));
    for ( I = 0; I < GRID*GRID*GRID; I++ )
      Frames[I] = -1;

    for ( I = 0; I < GRID; I++ )
      for ( J = 0; J < GRID; J++ )
        for ( K = 0; K < GRID; K++ )
          {
            dX = (float) (( I-GRID2 ) - GRID2 );
            dY = (float) (( J-GRID2 ) - ( GRID2-1 ));
            dZ = (float) (( K-GRID2 ) - ( GRID2-2 ));
            CDist = Fsqrt( dX*dX + dY*dY + dZ*dZ ) / 32.0f;
            if ( CDist > 1.0f ) CDist = 1.0f;
            BlobShd[ I*GRIDS + J*GRID + K ] = 1.0f - CDist;
           }

   }

void MarchingCubes( char Negative )
  {
    glDisable( GL_BLEND );

    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();
    gluPerspective( 70.0f, 640.0f / 360.0f, 1.0f, 100.0f ); 
    gluLookAt( GRID2, GRID2-1, GRID2-2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f );

    glMatrixMode( GL_MODELVIEW );
    glLoadIdentity();

    glBegin( GL_TRIANGLES );

    for ( X = 0; X < GRID-1; X++ )
      for ( Y = 0; Y < GRID-1; Y++ )
        for ( Z = 0; Z < GRID-1; Z++ )
          {
            Ofs = X*GRIDS +Y*GRID + Z;
            if ( Frames[ Ofs ] == Frame ) // !=
              {
                // Frames[ Ofs ] = Frame;

                Cube = 
                  (( Blobs[ Ofs ] > BlobIso ) ? 1:0 ) +
                  (( Blobs[ Ofs+1 ] > BlobIso ) ? 2:0 ) +
                  (( Blobs[ Ofs+GRID+1 ] > BlobIso ) ? 4:0 ) +
                  (( Blobs[ Ofs+GRID ] > BlobIso ) ? 8:0 ) +
                  (( Blobs[ Ofs+GRIDS ] > BlobIso ) ? 16:0 ) +
                  (( Blobs[ Ofs+GRIDS+1 ] > BlobIso ) ? 32:0 ) +
                  (( Blobs[ Ofs+GRIDS+GRID+1 ] > BlobIso ) ? 64:0 ) +
                  (( Blobs[ Ofs+GRIDS+GRID ] > BlobIso ) ? 128:0 );
                
                if ( Cube & 128 ) Cube ^= 255;

                if ( Cube-- )
                  {
                    Pt = 0;
                    Cube <<= 4;

                    while ( Polytab[ Cube + Pt ] > 0 )
                      {
                        // 0.459, 0.424, 0.427
                        glColor3f( 
                          BackR + ( 61.0f / 255.0f /*0.459f*/ - BackR ) * BlobShd[ Ofs ] * GlobalShade,
                          BackG + ( 97.0f / 255.0f /*0.424f*/ - BackG ) * BlobShd[ Ofs ] * GlobalShade,
                          BackB + ( 122.0f / 255.0f /*0.427f*/ - BackB ) * BlobShd[ Ofs ] * GlobalShade );
//                      glColor3f( (float) (X+Y+Z) * 0.9f * GRIDC, (float) (X+Y+Z) * GRIDC, (float) (X+Y+Z) * GRIDC );

                        for ( int w = 0; w < 3; w++ )
                          {
                            DX2 = X + (( Polytab[ Cube + Pt ] >> 5 ) & 1 );
                            DY2 = Y + (( Polytab[ Cube + Pt ] >> 4 ) & 1 );
                            DZ2 = Z + (( Polytab[ Cube + Pt ] >> 3 ) & 1 );
                            DX1 = X + (( Polytab[ Cube + Pt ] >> 2 ) & 1 );
                            DY1 = Y + (( Polytab[ Cube + Pt ] >> 1 ) & 1 );
                            DZ1 = Z + (( Polytab[ Cube + Pt ]          ) & 1 );

                            DB = 1.0f / ( Blobs[ DX2*GRIDS + DY2*GRID + DZ2 ] - Blobs[ DX1*GRIDS + DY1*GRID + DZ1 ] );

                            if ( DX1 == DX2 ) X0 = (float) DX1; else
                              X0 = DX1 + ( DX2 - DX1 ) * ( BlobIso - Blobs[ DX1*GRIDS + DY1*GRID + DZ1 ] ) * DB;
                            if ( DY1 == DY2 ) Y0 = (float) DY1; else
                              Y0 = DY1 + ( DY2 - DY1 ) * ( BlobIso - Blobs[ DX1*GRIDS + DY1*GRID + DZ1 ] ) * DB;
                            if ( DZ1 == DZ2 ) Z0 = (float) DZ1; else
                              Z0 = DZ1 + ( DZ2 - DZ1 ) * ( BlobIso - Blobs[ DX1*GRIDS + DY1*GRID + DZ1 ] ) * DB;
                
                            glVertex3f( X0 - GRID2, Y0 - GRID2, Z0 - GRID2  );
                            Pt++;
                           }
                       }  
                   }

                if ( Negative )
                  {

                    Cube = 
                      (( Blobs[ Ofs ] < -BlobIso ) ? 1:0 ) +
                      (( Blobs[ Ofs+1 ] < -BlobIso ) ? 2:0 ) +
                      (( Blobs[ Ofs+GRID+1 ] < -BlobIso ) ? 4:0 ) +
                      (( Blobs[ Ofs+GRID ] < -BlobIso ) ? 8:0 ) +
                      (( Blobs[ Ofs+GRIDS ] < -BlobIso ) ? 16:0 ) +
                      (( Blobs[ Ofs+GRIDS+1 ] < -BlobIso ) ? 32:0 ) +
                      (( Blobs[ Ofs+GRIDS+GRID+1 ] < -BlobIso ) ? 64:0 ) +
                      (( Blobs[ Ofs+GRIDS+GRID ] < -BlobIso ) ? 128:0 );

                    if ( Cube & 128 ) Cube ^= 255;

                    if ( Cube-- )
                      {
                        Pt = 0;
                        Cube <<= 4;

                        while ( Polytab[ Cube + Pt ] > 0 )
                          {
                            glColor3f( 
                              BackR + ( 0.125f - BackR ) * BlobShd[ Ofs ] * GlobalShade,
                              BackG + ( 0.353f - BackG ) * BlobShd[ Ofs ] * GlobalShade,
                              BackB + ( 0.361f - BackB ) * BlobShd[ Ofs ] * GlobalShade );
                            // glColor3f( (float) (X+Y+Z) * GRIDC, (float) (X+Y+Z) * 0.9f * GRIDC, (float) (X+Y+Z) * GRIDC );

                            for ( int w = 0; w < 3; w++ )
                              {
                                DX2 = X + (( Polytab[ Cube + Pt ] >> 5 ) & 1 );
                                DY2 = Y + (( Polytab[ Cube + Pt ] >> 4 ) & 1 );
                                DZ2 = Z + (( Polytab[ Cube + Pt ] >> 3 ) & 1 );
                                DX1 = X + (( Polytab[ Cube + Pt ] >> 2 ) & 1 );
                                DY1 = Y + (( Polytab[ Cube + Pt ] >> 1 ) & 1 );
                                DZ1 = Z + (( Polytab[ Cube + Pt ] >> 0 ) & 1 );

                                DB = 1.0f / ( Blobs[ DX2*GRIDS + DY2*GRID + DZ2 ] - Blobs[ DX1*GRIDS + DY1*GRID + DZ1 ] );

                                if ( DX1 == DX2 ) X0 = (float) DX1; else
                                  X0 = DX1 + ( DX2 - DX1 ) * ( -BlobIso - Blobs[ DX1*GRIDS + DY1*GRID + DZ1 ] ) * DB;
                                if ( DY1 == DY2 ) Y0 = (float) DY1; else
                                  Y0 = DY1 + ( DY2 - DY1 ) * ( -BlobIso - Blobs[ DX1*GRIDS + DY1*GRID + DZ1 ] ) * DB;
                                if ( DZ1 == DZ2 ) Z0 = (float) DZ1; else
                                  Z0 = DZ1 + ( DZ2 - DZ1 ) * ( -BlobIso - Blobs[ DX1*GRIDS + DY1*GRID + DZ1 ] ) * DB;
                  
                                glVertex3f( X0 - GRID2, Y0 - GRID2, Z0 - GRID2  );
                                Pt++;
                               }
                           }  
                       }
                   }
               }
           }

    glEnd();
   }

void Blob_Draw( float Timer, char Negative )
  {
    int i, j ,k;

    BlobMax = 10.0f;
    BlobMax1 = BlobMax*BlobMax;
    BlobMax2 = 1.0f / BlobMax1;

    for ( i = 0; i < 32; i++ )
      for ( j = 0; j < 32; j++ )
        for ( k = 0; k < 32; k++ )
          Blobs[ i*32*32 + j*32 + k ] = 0.0f;

    for ( int B = 0; B < BLOBS; B++ )
      {
        BlobPos[ B ].X = GRID2 + ( 5.0f + 2.0f * Fsin( Timer * ( 5+B ) * 0.000096f )) * Fcos(( B/8.0f ) + Timer * ( 4+B ) * 0.0005f );
        BlobPos[ B ].Y = GRID2 + ( 5.0f + 2.0f * Fsin( Timer * ( 5+B ) * 0.000093f )) * Fsin(( B/8.0f ) + Timer * ( 4+B ) * 0.0005f );
        BlobPos[ B ].Z = GRID2 + 7.0f * Fcos(( B/8.0f ) + Timer * ( 4+B ) * 0.00045f );

        for ( i = 0; i < GRID; i++ )
          for ( j = 0; j < GRID; j++ )
            for ( k = 0; k < GRID; k++ )
              {
                Dist2 = ( i-BlobPos[ B ].X )*( i-BlobPos[ B ].X ) + ( j-BlobPos[ B ].Y )*( j-BlobPos[ B ].Y ) + ( k-BlobPos[ B ].Z )*( k-BlobPos[ B ].Z );
                if ( Dist2 < BlobMax1 )
                  {
                    if ( Negative && ( B&1 ))
                      Blobs[ i*GRIDS + j*GRID + k ] -= ( 1.0f - Dist2 * BlobMax2 ) * ( 1.0f - Dist2 * BlobMax2 ); else
                      Blobs[ i*GRIDS + j*GRID + k ] += ( 1.0f - Dist2 * BlobMax2 ) * ( 1.0f - Dist2 * BlobMax2 ); 
                    Frames[ i*GRIDS + j*GRID + k ] = Frame;
                   }
               }
       }
    MarchingCubes( Negative );
   }

#define TRAD1 9.0f

void TBlob_Draw( float Timer )
  {
    int i, j ,k;

    BlobMax = 6.0f;
    BlobMax1 = BlobMax*BlobMax;
    BlobMax2 = 1.0f / BlobMax1;

    for ( i = 0; i < GRID; i++ )
      for ( j = 0; j < GRID; j++ )
        for ( k = 0; k < GRID; k++ )
          {
            X0 = Fcos( Timer*0.007f ) * ( i-15.5f) - Fsin( Timer*0.007f ) * ( k-15.5f );
            Y0 = j-15.5f;
            Z0 = Fsin( Timer*0.007f ) * ( i-15.5f) + Fcos( Timer*0.007f ) * ( k-15.5f );
            DB = TRAD1 - Fsqrt( X0*X0 + Y0*Y0 );
            Dist2 = Z0*Z0 + DB*DB;
            if ( Dist2 < BlobMax1 ) 
              { 
                Blobs[ i*32*32 + j*32 + k ] = -( 1.0f - Dist2 * BlobMax2 ) * ( 1.0f - Dist2 * BlobMax2 );
                Frames[ i*32*32 + j*32 + k ] = Frame;
               } else
              Blobs[ i*32*32 + j*32 + k ] = 0.0f;
           }

    BlobMax = 9.0f;
    BlobMax1 = BlobMax*BlobMax;
    BlobMax2 = 1.0f / BlobMax1;

    for ( int B = 0; B < 4; B++ )
      {
        BlobPos[ B ].X = GRID2 + ( 5.0f + 2.0f * Fsin( Timer * ( 5+B ) * 0.000096f )) * Fcos(( B/8.0f ) + Timer * ( 4+B ) * 0.0005f );
        BlobPos[ B ].Y = GRID2 + ( 5.0f + 2.0f * Fsin( Timer * ( 5+B ) * 0.000093f )) * Fsin(( B/8.0f ) + Timer * ( 4+B ) * 0.0005f );
        BlobPos[ B ].Z = GRID2 + 7.0f * Fcos(( B/8.0f ) + Timer * ( 4+B ) * 0.00045f );

        for ( i = 0; i < GRID; i++ )
          for ( j = 0; j < GRID; j++ )
            for ( k = 0; k < GRID; k++ )
              {
                Dist2 = ( i-BlobPos[ B ].X )*( i-BlobPos[ B ].X ) + ( j-BlobPos[ B ].Y )*( j-BlobPos[ B ].Y ) + ( k-BlobPos[ B ].Z )*( k-BlobPos[ B ].Z );
                if ( Dist2 < BlobMax1 )
                  {
                    if ( !B )
                      Blobs[ i*GRIDS + j*GRID + k ] -= ( 1.0f - Dist2 * BlobMax2 ) * ( 1.0f - Dist2 * BlobMax2 ); else
                      Blobs[ i*GRIDS + j*GRID + k ] += ( 1.0f - Dist2 * BlobMax2 ) * ( 1.0f - Dist2 * BlobMax2 ); 
                    Frames[ i*GRIDS + j*GRID + k ] = Frame;
                   }
               }
       }
    MarchingCubes( 1 );
   }

// === 3D Julia Morph.

#define JULIA_ITERATION 4

// float Julia_CR = -0.55f, Julia_CI = 0.4f, Julia_CJ = 0.58f, Julia_CK = 0.0f;
float Julia_CR = -0.65f, Julia_CI = 0.4f, Julia_CJ = 0.58f, Julia_CK = 0.2f;

float Julia_Pixel( float x, float y, float z, float w )
  {
    float lprev, length, temp;
   	int m;
    m = 0;
    length = 0;
    do
      {
        temp = x+x;
        x = x*x - y*y - z*z - w*w + Julia_CR;
        y = temp*y + Julia_CI;
        z = temp*z + Julia_CJ;
        w = temp*w + Julia_CK;
        m++;
        lprev = length;
        length = x*x + y*y + z*z + w*w;
       } while (( m < JULIA_ITERATION ) && ( length < 255.0f ));
    // return ( m - 1 - ( lprev - 255.0f ) / ( length - lprev )) / JULIA_ITERATION;
    // return 1.0f - m / JULIA_ITERATION;
    if ( length > 255.0f ) length = 255.0f;
    return length / 256.0f;
   }

void Julia_Draw( float Timer )
  {
    int i, j, k;

    Julia_CI = 1.2f * Fsin( Timer * 0.0032f / 2 );
    Julia_CJ = 1.2f * Fsin( Timer * 0.0051f / 2 );
    Julia_CK = 1.2f * Fsin( Timer * 0.0037f / 2 );
    Julia_CR = 1.2f * Fsin( Timer * 0.0024f / 2 );

    for ( i = 0; i < GRID; i++ )
      for ( j = 0; j < GRID; j++ )
        for ( k = 0; k < GRID; k++ )
          Blobs[ i*GRID*GRID + j*GRID + k ] =
            Julia_Pixel( GRID3 * ( i - GRID2 ), GRID3 * ( j - GRID2 ), GRID3 * ( k - GRID2 ), 0.0f );

    BlobIso = 0.5f;

    MarchingCubes( 0 );
   }
