#include "GamePartner.h"

#define MIN(a,b) ((a)<(b)?(a):(b))
#define isPiece(a)	((a)>T_BPAWN)
#define isPawn(a)	((a)<T_ROOK)
#define canPin(a)	((a)>=T_ROOK && (a)<=T_QUEEN)

#define QUEENMVLIM	14

#define OPENING		0
#define MIDDLEGAME	1
#define ENDGAME		2

enum
{
	PIECE = 0,
	MENACE,
	KINGPROTECT,
	CASE,
	BONUS,
	PAWNSTRUCT,
	LOCKED,
	DBL_PAWN,
	ALONE_PAWN,
	PASSED_PAWN,
	CASTLE,
	CASTLE_KING,
	CASTLE_KROOK,
	CASTLE_QROOK,
	CASTLE_KPAWN,
	CASTLE_QPAWN,
	QUEENMV,
	ROOKLINK,
	OVERLOAD,
	UNPROTECT,
	CHECK
};

#define MAX_NODES		55000
#define MAX_DEPTH		8
#define MAX_BACKBOARDS	2048
#define MAX_LEVELS		5
#define MAX_KEEP		7
#define MAX_ROOT		255

typedef struct
{
	u16 index;  /* index in nodes buffer */
	u8	src,dst;/* move from parent */
	u8	quiet;	/* quiet flag */
	s16	value;	/* node evaluation */
	s16	bb;		/* board used (-1 = none) */
	u8	cnt;	/* number of children */
	u16	children[MAX_KEEP]; /* children */
} CH_NODE;

void	control(Board,u8);
s16		eval(Board,u8);
u8		random();
u8		verify(Board,u8,u8);
u8		getPatMat(Board,u8);
void	searchMove(u8);
s16		compute(u8,u8,u8,u8,u8,CH_NODE*,s16,s16,u8);
u8		play(u8,u8,Board,u8,u8);
void	playMove(u8,u8,u8,u8,u8);
void	initSearch();
void	init(u8,u8);

CH_NODE ch_tree[MAX_NODES]; /* search tree */
u16 free_nodes[MAX_NODES];

u8 reset,nbmoves;
struct _board bboards[MAX_BACKBOARDS];
s16 free_bb[MAX_BACKBOARDS];
u8 history[1024];
u16 histcnt;
u8 moves50;
u8 phase;
CH_NODE*curnode;
Board curboard;

const s16 vboard[] = {
	0,1,1,1,1,1,1,0,
	1,1,2,2,2,2,1,1,
	1,2,2,3,3,2,2,1,
	1,2,3,4,4,3,2,1,
	1,2,3,4,4,3,2,1,
	1,2,2,3,3,2,2,1,
	1,1,2,2,2,2,1,1,
	0,1,1,1,1,1,1,0
};

const u8 lvl_keep[] = {1, 2, 3, 4, 4, 5, 6, 7};

const LEVEL levels[MAX_LEVELS] = {
	{4,	0},
	{6,	2},
	{6,	0},
	{8,	2},
	{8,	0}
};

const LEVEL *level;

const s16 vpieces[]		= {10,10,50,30,150,30,200};
const s16 locked[]		= {0,0,5,3,10,3,0};
const s16 unprotected[] = {1,1,5,3,10,3,0};

const u8 promotion[] = {T_QUEEN,T_ROOK,T_BISHOP,T_KNIGHT};

const s16 pawn_bonus[3][8] = {
		{0,0,0,0,0,0,0,0},		/* Opening */
		{0,0,0,0,10,50,100,0},	/* Middle */
		{0,0,0,0,50,100,200,0}};/* End */


#define HELP_WANTED 250

const s16 phases[3][21] = {
	/* Opening */
	{
		30,		/* PIECE */
		5,		/* MENACE */
		15,		/* KINGPROTECT */
		5,		/* CASE */
		1,		/* BONUS */
		2,		/* PAWNSTRUCT */
		5,		/* LOCKED */

		50,		/* DBL_PAWN */
		40,		/* ALONE_PAWN */
		50,		/* PASSED_PAWN */
		50,		/* CASTLE */
		200,	/* CASTLE_KING */
		80,		/* CASTLE_KROOK */
		70,		/* CASTLE_QROOK */
		50,		/* CASTLE_KPAWN */
		40,		/* CASTLE_QPAWN */
		120,	/* QUEENMV */
		25,		/* ROOKLINK */
		5,		/* OVERLOAD */
		1,		/* UNPROTECT */
		30		/* CHECK */
	},
	/* Middle game */
	{
		30,		/* PIECE */
		4,		/* MENACE */
		20,		/* KINGPROTECT */
		5,		/* CASE */
		1,		/* BONUS */
		1,		/* PAWNSTRUCT */
		5,		/* LOCKED */

		50,		/* DBL_PAWN */
		40,		/* ALONE_PAWN */
		60,		/* PASSED_PAWN */
		20,		/* CASTLE */
		150,	/* CASTLE_KING */
		70,		/* CASTLE_KROOK */
		60,		/* CASTLE_QROOK */
		40,		/* CASTLE_KPAWN */
		20,		/* CASTLE_QPAWN */
		0,		/* QUEENMV */
		25,		/* ROOKLINK */
		5,		/* OVERLOAD */
		1,		/* UNPROTECT */
		30		/* CHECK */
	},
	/* End game */
	{
		30,		/* PIECE */
		3,		/* MENACE */
		10,		/* KINGPROTECT */
		4,		/* CASE */
		1,		/* BONUS */
		1,		/* PAWNSTRUCT */
		5,		/* LOCKED */

		50,		/* DBL_PAWN */
		40,		/* ALONE_PAWN */
		80,		/* PASSED_PAWN */
		0,		/* CASTLE */
		0,		/* CASTLE_KING */
		0,		/* CASTLE_KROOK */
		0,		/* CASTLE_QROOK */
		0,		/* CASTLE_KPAWN */
		0,		/* CASTLE_QPAWN */
		0,		/* QUEENMV */
		50,		/* ROOKLINK */
		5,		/* OVERLOAD */
		1,		/* UNPROTECT */
		100		/* CHECK */
	}
};

extern	void	userAction();
extern	s16		getChessClock();
extern	u32		getMachineTime();
extern	s16		getTimeBonus();
