require 'luagl'
require 'luaglut'
require 'memarray'
local fi = require 'luafreeimage'
require 'config'

local total_textures = 86

local splif_version = '0.1b'
local splif_titletext = 'Trilobit ScriPtable Lua Interactive MultiplatForm (SPLIF) version ' .. splif_version
local debugmode = 0
local res_w = 0
local res_h = 0
local res_override = 0

local quit = false
local reloading = false
local fps = 60
local fps_str = ''
local msec = 1000 / fps
local frames = 0
local cur_fps = 0
local start_time
local fps_time
local elapsed_time
local millis = 0
local timedelta = 0
local last_frame = 0
local row
local order
local ppm, width, height
local sync_set = 0
local debug_pause = 1
local seeked = 0
local song_time_end = 0
local load_number
local loading = 1
local init_done = 0
do_seekeffect = 0
local rewind_start = 0
local picnum = 0
local effects = {}
timeline = {}
timeline.effects = {}
temptimeline = {}
local spectrum = {}

local mouse_x = 0
local mouse_y = 0

local mouse_over_slider = 0

local slider_x = 10
local slider_y = 10
local slider_w = 20
local slider_h = 10
local slider_bar_pos = 0

local function glutBitmapString(font, str)
        for i = 1, string.len(str) do
                glutBitmapCharacter(font, string.byte(str, i))
        end
end

function deepcopy(object)
    local lookup_table = {}
    local function _copy(object)
        if type(object) ~= "table" then
            return object
        elseif lookup_table[object] then
            return lookup_table[object]
        end
        local new_table = {}
        lookup_table[object] = new_table
        for index, value in pairs(object) do
            new_table[_copy(index)] = _copy(value)
        end
        return setmetatable(new_table, getmetatable(object))
    end
    return _copy(object)
end

function engine_init()
	abra_air_texid = load_texture_RGBA('abra_air.png')
	abra_texid = load_texture_RGBA('abra.png')
	abra_sink_texid = load_texture_RGBA('abra_sink.png')
	abra_speech_0_texid = load_texture_RGBA('abra_speech_0.png')
	abra_speech_1_texid = load_texture_RGBA('abra_speech_1.png')
	bird_texid = load_texture_RGBA('bird.png')
	bubble_abra_texid = load_texture_RGBA('bubble_abra.png')
	bubble_shout_texid = load_texture_RGBA('bubble_shout.png')
	bubble_speech2_texid = load_texture_RGBA('bubble_speech2.png')
	bubble_speech_texid = load_texture_RGBA('bubble_speech.png')
	bubble_thought2_texid = load_texture_RGBA('bubble_thought2.png')
	bubble_thought_texid = load_texture_RGBA('bubble_thought.png')
	bunnybg_texid = load_texture_RGBA('bunnybg.png')
	bunnyhat_texid = load_texture_RGBA('bunnyhat.png')
	bunnymonocle_texid = load_texture_RGBA('bunnymonocle.png')
	bunny_texid = load_texture_RGBA('bunny.png')
	bunnywhite_0_texid = load_texture_RGBA('bunnywhite_0.png')
	bunnywhite_1_texid = load_texture_RGBA('bunnywhite_1.png')
	butterfly_0_texid = load_texture_RGBA('butterfly_0.png')
	butterfly_1_texid = load_texture_RGBA('butterfly_1.png')
	cactus_texid = load_texture_RGBA('cactus.png')
	canvas_texid = load_texture_RGBA('canvas.png')
	chameleon_texid = load_texture_RGBA('chameleon.png')
	cloud_happy_texid = load_texture_RGBA('cloud_happy.png')
	cloud_mew_texid = load_texture_RGBA('cloud_mew.png')
	cloud_sad_texid = load_texture_RGBA('cloud_sad.png')
	credits_texid = load_texture_RGBA('credits.png')
	demoname_texid = load_texture_RGBA('demoname.png')
	desertbg_texid = load_texture_RGBA('desertbg.png')
	e11_texid = load_texture_RGBA('e11.png')
	e12_texid = load_texture_RGBA('e12.png')
	e1_texid = load_texture_RGBA('e1.png')
	e2_texid = load_texture_RGBA('e2.png')
	e3_texid = load_texture_RGBA('e3.png')
	e4_texid = load_texture_RGBA('e4.png')
	e5_texid = load_texture_RGBA('e5.png')
	e6_texid = load_texture_RGBA('e6.png')
	e7_texid = load_texture_RGBA('e7.png')
	e8_texid = load_texture_RGBA('e8.png')
	e9_texid = load_texture_RGBA('e9.png')
	flower_0_texid = load_texture_RGBA('flower_0.png')
	flower_1_texid = load_texture_RGBA('flower_1.png')
	flower_2_texid = load_texture_RGBA('flower_2.png')
	flower_3_texid = load_texture_RGBA('flower_3.png')
	flower_4_texid = load_texture_RGBA('flower_4.png')
	fuckings_texid = load_texture_RGBA('fuckings.png')
	giraffe_texid = load_texture_RGBA('giraffe.png')
	greets_texid = load_texture_RGBA('greets.png')
	heart_0_texid = load_texture_RGBA('heart_0.png')
	heart_1_texid = load_texture_RGBA('heart_1.png')
	heart_2_texid = load_texture_RGBA('heart_2.png')
	kiss_texid = load_texture_RGBA('kiss.png')
	lips_0_texid = load_texture_RGBA('lips_0.png')
	lips_1_texid = load_texture_RGBA('lips_1.png')
	lips_2_texid = load_texture_RGBA('lips_2.png')
	mari_pic_texid = load_texture_RGBA('mari_pic.png')
	mouse_texid = load_texture_RGBA('mouse.png')
	music_credit_texid = load_texture_RGBA('music_credit.png')
	ostrich_texid = load_texture_RGBA('ostrich.png')
	palm_texid = load_texture_RGBA('palm.png')
	peace_texid = load_texture_RGBA('peace.png')
	ponybg_texid = load_texture_RGBA('ponybg.png')
	ponycloth_texid = load_texture_RGBA('ponycloth.png')
	pony_texid = load_texture_RGBA('pony.png')
	ponyyellow_texid = load_texture_RGBA('ponyyellow.png')
	proudly_present_0_texid = load_texture_RGBA('proudly_present_0.png')
	proudly_present_1_texid = load_texture_RGBA('proudly_present_1.png')
	qclogo_texid = load_texture_RGBA('qclogo.png')
	rainbow_texid = load_texture_RGBA('rainbow.png')
	rainbowbg_texid = load_texture_RGBA('rainbowbg.png')
	rainbow_sun_texid = load_texture_RGBA('rainbow_sun.png')
	rain_texid = load_texture_RGBA('rain.png')
	redbg_texid = load_texture_RGBA('redbg.png')
	sade_pic_texid = load_texture_RGBA('sade_pic.png')
	savannahbg_texid = load_texture_RGBA('savannahbg.png')
	scenemissing_texid = load_texture_RGBA('scenemissing.png')
	smooch_texid = load_texture_RGBA('smooch.png')
	snake_texid = load_texture_RGBA('snake.png')
	star_0_texid = load_texture_RGBA('star_0.png')
	star_1_texid = load_texture_RGBA('star_1.png')
	star_2_texid = load_texture_RGBA('star_2.png')
	sun_0_texid = load_texture_RGBA('sun_0.png')
	sun_1_texid = load_texture_RGBA('sun_1.png')
	theend_texid = load_texture_RGBA('theend.png')
	thiswasit_texid = load_texture_RGBA('thiswasit.png')
	visy_pic_texid = load_texture_RGBA('visy_pic.png')
	zebra_texid = load_texture_RGBA('zebra.png')

	engine_load_effects()
end

function engine_load_effects()
	print("engine_load_effects")
	local fxlist = config_effects()
	for _, effect in pairs(fxlist) do
		res, errmsg = loadfile(effect.file)
		if errmsg == nil then
			res()
			effect.load = loadstring("return "..effect.name.."_load()")
			effect.init = loadstring("return "..effect.name.."_init")()
			effect.paint = loadstring("return "..effect.name.."_paint")()
			effect.load()
		else
			print("Error in engine_load_effects(): " .. errmsg)
			return false
		end
	end
	loading = 0
	effects = fxlist
	return engine_make_timeline()
end

function engine_get_effect(name) 
	for _, effect in pairs(effects) do
		if effect.name == name then
			return effect
		end
	end
	return false
end

function engine_make_timeline()
	print("engine_make_timeline()")
	temptimeline.current = nil
	temptimeline.current_start = nil
	temptimeline.current_end = nil
	temptimeline.effects = nil
	temptimeline.effects = {}

	local timing = nil

	local effe = {}

	for _, timing in pairs(dofile("timing.lua")) do
		table.insert(effe, timing)
	end

	temptimeline.effects = effe

	local prev_timing = 0

	for _, timing in pairs(temptimeline.effects) do
		if not timing.start then
			if not timing.delta then
				print ("timing.delta info missing and no start specified for effect.")
				os.exit()
			else
				timing.start = prev_timing.start + timing.delta
			end
		end
		prev_timing = timing
	end

	table.sort(temptimeline.effects, function(a,b)  return tonumber(a.start) <= tonumber(b.start) end)
	
	timeline = deepcopy(temptimeline)
	
	engine_next_effect()
	
	return true
end

function engine_spectrum() 
	
	if debug_pause == 1 then
	
		temp = song_spectrum()
		for i = 0, 511 do
			spectrum[i] = ( spectrum[i] * 0.3 ) + (temp[i] *0.7)
		end
	
	end

	return spectrum;
end

function engine_next_effect()
	local selected = nil
	local selected_start = 0
	local selected_params = nil
	local selected_end = nil

	for _, timing in pairs(timeline.effects) do
		if millis >= timing.start then 
			selected = timing.effect
			selected_start = timing.start
			selected_params = timing.params
		else
			if selected_end == nil then
				selected_end = timing.start
				break
			end
		end
		
	end
	
	selected = engine_get_effect(selected)
	
	--print(millis .. " switch to " .. selected.name)
	
	if selected_end == nil then
		selected_end = 999999
	end
	
	last = timeline.current
	
	timeline.current_start = millis
	timeline.current_end = selected_end
	timeline.current_params = selected_params
	timeline.current = selected
	
	timeline.current.init(millis)
	reloading = false
end

function engine_main() 

	res_override, res_w, res_h, res_hz, res_windowed = demo_getresolution()
	
	for i = 0, 511 do
		spectrum[i] = 0.5
	end

	glutInit(arg)

	if res_override == 1 then
		if res_windowed >= 1 then glutInitWindowSize(res_w, res_h)
		else glutGameModeString(res_w .. "x" .. res_h .. ":32" .. "@" .. res_hz)
		end
	end

	local jit_version = "(N/A)"

	if jit then
		if jit.version then
			jit_version = jit.version
		end
	end

	print('[ ' .. splif_titletext .. ' ]')
	print('[ Running on Lua: "' .. _VERSION .. '" LuaJIT: "' .. jit_version .. '" LuaGL: "' .. luagl.VERSION .. '" LuaGLUT: "' .. luaglut.VERSION .. '" FMOD Ex: "' .. song_getfmodversion() .. '" ]')
	freeimage_version, freeimage_copyright = fi.getInfo()
	print('[ FreeImage: "' .. freeimage_version .. '" (' .. freeimage_copyright .. ') ]')

	glutInitDisplayMode(GLUT_RGB + GLUT_DOUBLE + GLUT_DEPTH + GLUT_MULTISAMPLE)
	if arg then title = arg[0] else title = splif_titletext end
	if res_windowed >= 1 then window = glutCreateWindow(title)
	else window = glutEnterGameMode()
	end

	if res_windowed == 2 then glutFullScreen() end
	
	glutSetCursor(GLUT_CURSOR_NONE)

	glutDisplayFunc(display_func)
	glutKeyboardFunc(keyboard_func)
	glutReshapeFunc(resize_func)
	glutTimerFunc(msec, timer_func, 0)
	
	-- rodent stuff
	glutMouseFunc(mouse_func)
	glutMotionFunc(mouse_motion)
	glutPassiveMotionFunc(mouse_motion)
	
	song_time_end = song_getlength()

	-- hack for osx tearing and other misc inits

	demosystem_init()

	if res_override == 1 and res_windowed == 0 then
		print('[ Requested screen mode: ' .. res_w .. 'x' .. res_h .. ' ('  .. res_hz .. 'Hz) ]')
	end
	if res_windowed == 0 then print ("[ Screen mode: " .. glutGameModeGet(GLUT_GAME_MODE_WIDTH) .. "x" .. glutGameModeGet(GLUT_GAME_MODE_HEIGHT) .. "x" .. glutGameModeGet(GLUT_GAME_MODE_PIXEL_DEPTH) .. " (" .. glutGameModeGet(GLUT_GAME_MODE_REFRESH_RATE) .. "Hz) ]") end

	co = coroutine.create(engine_init)
	start_time = glutGet(GLUT_ELAPSED_TIME)
	fps_time = start_time
	print("Are you experienced?")

	glutMainLoop()
	
end

function load_texture(fname)
	io.write("Loading texture " .. fname .. "...")
	local dib = fi.bitmap()
	assert(dib:load("png", "../data/" .. fname))
	assert(dib:convertTo32Bits(dib))
	width = dib:getWidth()
	height = dib:getHeight()
	local ppm = memarray('uchar', width * height * 3)
	i = 0
   for y = 1, height do
      local dst_idx = (height - y) * width * 3
      for x = 0, width - 1 do
	 iR, iG, iB, iA = dib:getRGBA(x,height-y)
         
         ppm[dst_idx + 3*x + 0] = iR
         ppm[dst_idx + 3*x + 1] = iG
         ppm[dst_idx + 3*x + 2] = iB
	 i = i + 3
      end
   end
	print("done.")
	if loading == 1 then 
		picnum = picnum + 1
		coroutine.yield() 
	end
	return ppm, width, height
end

function load_texture_RGBA(fname)
	io.write("Loading texture " .. fname .. "...")
	local dib = fi.bitmap()
	assert(dib:load("png", "../data/" .. fname))
	assert(dib:convertTo32Bits(dib))
	width = dib:getWidth()
	height = dib:getHeight()
	local ppm = memarray('uchar', width * height * 4)
	i = 0
   for y = 1, height do
      local dst_idx = (height - y) * width * 4
      for x = 0, width - 1 do
	 iR, iG, iB, iA = dib:getRGBA(x,height-y)
         
         ppm[dst_idx + 4*x + 0] = iR
         ppm[dst_idx + 4*x + 1] = iG
         ppm[dst_idx + 4*x + 2] = iB
         ppm[dst_idx + 4*x + 3] = iA
	 i = i + 4
      end
   end
	texnum = memarray('uchar', 1)

	glGenTextures(1, texnum:ptr())
	texture_number = texnum[0]
	glBindTexture(GL_TEXTURE_2D, texture_number)
        glTexImage2D(GL_TEXTURE_2D, 0, 4, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, ppm:ptr())
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_ENV_MODE, GL_MODULATE)
        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE)

	print("done. (texture id #" .. texture_number .. ")")
	if loading == 1 then 
		picnum = picnum + 1
		coroutine.yield() 
	end

	return texture_number
end

--[[
function load_texture(fname)
   local f
   local width = 0
   local height = 0
   local depth = 0
   local data

   f = assert(io.open(fname, 'rb'))
   assert(f:read('*l') == 'P6')
   width = f:read('*n')
   height = f:read('*n')
   depth = f:read('*l')
   depth = f:read('*l')
   data = f:read('*a')
   f:close()

   local ppm = memarray('uchar', width * height * 3)
   for y = 1, height do
      local dst_idx = (height - y) * width * 3
      local src_idx = (y - 1) * width * 3
      for x = 0, width - 1 do
         ppm[dst_idx + 3*x + 0] = string.byte(data, src_idx + 3*x + 1)
         ppm[dst_idx + 3*x + 1] = string.byte(data, src_idx + 3*x + 2)
         ppm[dst_idx + 3*x + 2] = string.byte(data, src_idx + 3*x + 3)
      end
   end

   return ppm, width, height
end
--]]


function load_texture_ALPHA(fname)
   local f
   local width = 0
   local height = 0
   local depth = 0
   local data

   f = assert(io.open(fname, 'rb'))
   assert(f:read('*l') == 'P6')
   width = f:read('*n')
   height = f:read('*n')
   depth = f:read('*l')
   depth = f:read('*l')
   data = f:read('*a')
   f:close()

   local ppm = memarray('uchar', width * height * 4)
   for y = 1, height do
      local dst_idx = (height - y) * width * 4
      local src_idx = (y - 1) * width * 3
      for x = 0, width - 1 do
         ppm[dst_idx + 4*x + 0] = string.byte(data, src_idx + 3*x + 1)
         ppm[dst_idx + 4*x + 1] = string.byte(data, src_idx + 3*x + 2)
         ppm[dst_idx + 4*x + 2] = string.byte(data, src_idx + 3*x + 3)

	 colvalue = ppm[dst_idx + 4*x + 0] + ppm[dst_idx + 4*x + 1] + ppm[dst_idx + 4*x + 2]
	 colvalue = colvalue / 3

         if colvalue == 0 then ppm[dst_idx + 4*x + 3] = 1
	 else
		ppm[dst_idx + 4*x + 3] = 0
	 end
      end
   end

   return ppm, width, height
end

function debug()
	glDisable(GL_BLEND)
	glDisable(GL_TEXTURE_2D)
	glMatrixMode(GL_PROJECTION)
	glPushMatrix()
	glLoadIdentity()
	glOrtho(0, glutGet(GLUT_WINDOW_WIDTH), 0, glutGet(GLUT_WINDOW_HEIGHT), -3, 3)
	if debugmode == 1 then
		if sync_set > 0 then
			sync_str = '[sync #' .. sync_set .. ' set]'
		else
			sync_str = ''
		end
		fps_str = 'effect: '.. timeline.current.name ..' millis: [' .. millis .. '] order: [' .. order .. '] row: [' .. row .. '] fps: [' .. cur_fps .. '] ' .. sync_str
		glColor3d(1,1,1)
		glRasterPos2d(2,glutGet(GLUT_WINDOW_HEIGHT)-16)
		glutBitmapString(GLUT_BITMAP_8_BY_13, fps_str) 
		glColor3d(0.2,0.2,0.2)
		glRasterPos2d(2,glutGet(GLUT_WINDOW_HEIGHT)-30)
		glutBitmapString(GLUT_BITMAP_8_BY_13, fps_str )
		
		-- susiruma cursori, tein itse, sstin
		glColor3d(1,1,0.2)
		y1=glutGet(GLUT_WINDOW_HEIGHT)-mouse_y;
		glBegin(GL_TRIANGLES)
		glVertex3d(mouse_x, y1,0)
		glVertex3d(mouse_x+10, y1,0)
		glVertex3d(mouse_x, y1-10,0)
		glEnd()
		
		draw_song_slider()
	end
	glPopMatrix()
end

function draw_song_slider() 
	local song_duration = song_getlength()
	
	slider_bar_pos = slider_w * (millis/song_duration)
	
	slider_x = 10
	slider_y = 10
	slider_w = glutGet(GLUT_WINDOW_WIDTH)-20
	slider_h = 10
	
	if mouse_over_slider == 1 then
		glColor3d(0.9,0.9,0.9)
	else
		glColor3d(0.5,0.5,0.5)
	end
	
	glBegin(GL_QUADS)
	
	glVertex3d(slider_x, slider_y,-0.1)
	glVertex3d(slider_x+slider_w, slider_y,-0.1)
	glVertex3d(slider_x+slider_w, slider_y+slider_h,-0.1)
	glVertex3d(slider_x, slider_y+slider_h,-0.1)
	
	glEnd();
	
	glColor3d(0,0,0)
	
	glBegin(GL_QUADS)
	
	glVertex3d(slider_x+slider_bar_pos, slider_y,0)
	glVertex3d(slider_x+slider_bar_pos+5, slider_y,0)
	glVertex3d(slider_x+slider_bar_pos+5, slider_y+slider_h,0)
	glVertex3d(slider_x+slider_bar_pos, slider_y+slider_h,0)
	
	glEnd();
	
end

function display_func()
	if reloading == false then

		if quit then return end

		if loading == 1 then
			glClearColor(1-picnum/total_textures,1-picnum/total_textures,1-picnum/total_textures, 1)
			glClear(GL_COLOR_BUFFER_BIT + GL_DEPTH_BUFFER_BIT)
			glutSwapBuffers()
			coroutine.resume(co)
			return 
		end

		elapsed_time = glutGet(GLUT_ELAPSED_TIME) - fps_time


		last_frame = millis
		millis = song_getmillis()
		if millis == nil then millis = 0 end
		row = song_getrow()
		order = song_getorder()

		timedelta = millis-last_frame
		if seeked == 1 then
			print("seek check")
			engine_next_effect()
			seeked = false
		end

		if millis >= timeline.current_end then
			engine_next_effect()
		end
		
		timeline.current.paint(millis, timedelta, timeline.current_params)

		debug()

		if fps_time > 5000 and init_done == 0 then
			print("playing song")
			if init_done == 0 then song_play() end
			init_done = 1
		elseif fps_time < 5000 then
			glClearColor(0,0,0,1)
			glClear(GL_COLOR_BUFFER_BIT)
		end

		glutSwapBuffers()

		if millis >= song_time_end then
			quit = true
			if res_windowed == 0 then glutLeaveGameMode() end
			glutDestroyWindow(window)
			os.exit(0)
		end

		frames = frames + 1
		if elapsed_time > 1000 then
			cur_fps = frames * 1000 / elapsed_time
			fps_time = fps_time + elapsed_time
			frames = 0
		end

	end

end


function resize_func(w, h)
	local ratio = w / h
	glMatrixMode(GL_PROJECTION)
	glLoadIdentity()
	if w < h then
		glViewport(0,0,w,w)
		ratio = w/w
	else
		local center_x = 0
		if w > 2560 then 
			center_x = (w / 2) - (2560/2)
			w = 2560
		end
		if h > 1440 then h = 1440
		end
		
		ratio = w / h
		glViewport(center_x,0,w,h)
	end
	gluPerspective(45,ratio,1,10000)
	glMatrixMode(GL_MODELVIEW)
	glLoadIdentity()
	glEnable(GL_DEPTH_TEST)
	glEnable(GL_NORMALIZE)
end

function timer_func()
	if quit then return end

	glutSetWindow(window)
	glutTimerFunc(msec, timer_func, 0)
	glutPostRedisplay()
end

function keyboard_func(key,x,y)
	if key == 27 then
		quit = true
		if res_windowed == 0 then glutLeaveGameMode() end
		glutDestroyWindow(window)
		os.exit(0)
	end
	if key == 32 then
		debugmode = -debugmode
	end
	
	if debugmode == 1 then
	
		if key == 114 then
			--print("reload")
			reloading = true
			engine_make_timeline()
		end 
		-- syncpoints
		if key >= 49 and key <= 57 then
			print('sync #' .. key-48 .. ', millis: ' .. millis .. ' order: ' .. order .. ' row: ' .. row)
			sync_set = key-48
		end

		-- song seeking
		if key == 97 then
			seeked = 1
			song_seek(0)
		end
		if key == 100 then
			seeked = 1
			song_seek(1)
		end
		if key == 119 then
			seeked = 1
			song_seek(2)
		end
		if key == 115 then
			seeked = 1
			song_seek(3)
		end
		
		if key == 122 then
			song_seek(4)
		end
		if key == 120 then
			song_seek(5)
		end
		if key == 112 then
			if debug_pause == 1 then 
				song_pause(0)
			else 
				song_pause(1)
			end
			debug_pause = -debug_pause
		end
	end


end

function mouse_func(button, state, x , y) 
	--print ("mouse_func button = " .. button .. " state = " .. state .. " x = " .. x .. " y = " .. y)
	mouse_x = x
	mouse_y = y
end

function mouse_entry(state) 
	--print ("mouse_entry state=" .. state)
end

function mouse_motion(x, y) 
	--print ("mouse move x = " .. x .. " y = " .. y)
	mouse_x = x
	mouse_y = y
	
	if debugmode == 1 then
		mouse_over_slider = 0
		
		-- glunproject mouse coordz
	
	end
end

engine_main()




