; Procedury pojawiania się napisów TERMINATOR i VS THE EMPIRE
; z grubsza polega na śledzeniu wartości pikseli w obrazku - filtrze wraz z liczącym co ramkę licznikiem
; i modyfikacji tylko tych pilseli napisów, które mieszczą się w zadanym przedziale
; pozostałe punkty obrazka nie są w danej ramce przetwarzane

start_alfa:		EQU  16384				; obrazek z filtrem umieszczony będzie pod tym adresem 
				; najpierw ustawiane są parametry dla terminatora lub imperium poprzez modyfikację kodu głównej procedury "alfa"
				; na koniec wywoływana jest ta procedura, wspólna dla obu napisów
				; można było napisać dwie oddzielne, ale zrobiłem w ten sposób
				
alfa_terminator:
				CALL alfa_dane			; wywołanie procedury przygotowawczej, patrz niżej
				LD HL,32768				; skopiowanie napisu do obszaru roboczego (nie jest skompresowany)
				LD DE,start_alfa+8192
				LD BC,2688
				LDIR
				LD HL,start_alfa+8192	; ustawienie parametrów do procedury "alfa": adres źródłowy napisu
				LD (start_napis+1),HL
				LD HL,32768				; adres docelowy napisu (początek ekranu)
				LD (start_ekran+1),HL	
				LD A,11					; wysokość napisu podzielona przez 2
				LD (ap2-1),A
				LD A,2					; opóźnienie przy rysowaniu, żeby oba napisy rysowały się z podobnym tempie
				LD (epauza+1),A
				LD B,30
				CALL czekaj
				JP alfa					; idź do głównej procedury
alfa_empire:
				CALL alfa_dane			; wywołanie procedury przygotowawczej, patrz niżej
				LD HL,32768+2688		; skopiowanie napisu do obszaru roboczego (nie jest skompresowany)
				LD DE,start_alfa+8192
				LD BC,4736
				LDIR
				LD HL,start_alfa+8192	; ustawienie parametrów do procedury "alfa": adres źródłowy napisu
				LD (start_napis+1),HL
				LD HL,32768+16384+2048+1024+512	; adres docelowy napisu (dół ekranu)
				LD (start_ekran+1),HL
				LD A,18					; wysokość napisu podzielona przez 2
				LD (ap2-1),A
				LD A,1					; opóźnienie przy rysowaniu, żeby oba napisy rysowały się z podobnym tempie
				LD (epauza+1),A			; ten jest wyższy i rysowałby się zauważalnie wolniej
				JP alfa					; idź do głównej procedury

alfa_dane:		; procedura przygotowująca		
				LD HL,start_alfa		; czyszczenie obszaru roboczego, czyli 16384 bajtów od adresu 16384
				LD DE,start_alfa+1
				LD BC,start_alfa-1
				LD (HL),0
				LDIR
				LD A,11					; przełączenie się na bank 11 w górnym RAMie, gdzie są obrazki napisów i filtru
				OUT (hmpr),A
				LD A,15					; przeniesienie filtra pod adres 16384, ale co drugą linię
				LD HL,32768+2688+4736	; jeden punkt z filtra odpowiada 4 punktom (kwadracikowi) z napisu
				LD DE,start_alfa		; dzieki temu adres punktu w napisie = adres punktu w masce + 8192
	alf1:		LD BC,128
				LDIR
				INC D
				LD E,0
				DEC a
				JR NZ,alf1				; zdublowanie filtra, jest mniejszy (niższy) niż dolny napis
				LD HL,start_alfa
				LD DE,1920*2+start_alfa
				LD BC,1920
				LDIR
				RET
				
				
alfa:			; główna procedura rysująca napisy TERMINATOR i vs THE EMPIRE
				; będzie przeliczała prostokąt o szerokości 64 bajty (128 punktów), bo dla całej szerokości linii byłaby zbyt wolna
				LD A,50
				LD (ap9+1),A			; ustawienie progu wartości klucza dla pierwszego przebiegu, czyli 50
				XOR A					; i startu dla pierwszeg przebiegu, czyli lewa krawędź ekranu (=0)
				LD (ap8+1),A
				OUT (hmpr),A			; przełączamy się na ekran w banku 0
				LD (alfa_petla+1),A
	askoki:		LD A,40					; modyfikacja kodu w czterech miejscach polegająca na ustawieniu skoku JR Z lub JR NZ (kod 40 lub 32)
				LD (aps1),A				; prawidłowo powinno być JR NZ, ale na początku zrobiłem błąd w kodzie i się okazało,
				LD (aps2),A				; że tak też fajnie wygląda
				LD (aps3),A				; więc napis TERMINATOR pojawi się za pomocą procedury z błędem :-)
				LD (aps4),A
				LD E,1					; początkowa wartość klucza, z którym porównywane są wartości z filtra
				LD A,3					; 3 przebiegi po 128 punktów szerokości: lewa połowa, środek, prawa połowa
	apetla:			
				PUSH AF
				CALL alfa_petla			; wywołanie całej procedury dla 1/3 napisu
				LD A,(alfa_petla+1)
				ADD A,32				; przeunięcie się w poziomie o 64 punkty (32 bajty). nie 100 punktów, choć taka była szerokość
				LD (alfa_petla+1),A		; obrabiane obszary muszą na siebie zachodzić
				LD (start_napis+1),A
				LD (start_ekran+1),A
				LD (ap8+1),A
				LD A,(ap9+1)			
				ADD A,50				; przesunięcie się z wartościami klucza do następnej 50-tki
				LD (ap9+1),A
				POP AF
				DEC A
				JR NZ,apetla
				RET
	
alfa_petla:
				LD HL,start_alfa		; adres filtra
				EXX
	start_napis:LD HL,start_alfa+8192	; adres źródłowy napisu
	start_ekran:LD DE,32768				; adres docelowy napisu na ekranie
				EXX
	epauza:		LD B,1					; pauza w zaeżności od tego, który to napis. dla Terminatora czekaj na ramkę, dla Empire nie czekaj wcale
				CALL czekaj
				
				LD B,18					; wysokość napisu, ustawiana przez procedurę wyżej
	ap2:			
				PUSH BC
				LD B,64					; szerokość obrabianego prostokąta w bajtach. dla całej szerokości (128) działa za wolno
	ap1:
				LD A,(HL)				; pobierz wartość z filtra
				SUB E					; odejmij wartość klucza
				LD D,A					; różnicę zapamiętaj w D
				AND %11111000			; sprawdzenie, czy różnica jest mniejsza od 8. jeżeli jest mniejsza od 8, to po tej operacji A=0
				JP NZ,alfa_nie			; jeżeli jest >=8, to się tym punktem nie zajmujemy i idziemy dalej
				OR D					; przywrócenie zawartości różnicy z D do akumulatora tak, żeby dla 0 była ustawiona flaga Z
				EX AF,AF'				
				LD A,L					; przeniesienie adresu z maski na adres w napisie i na ekranie
				EXX
				LD E,A
				LD L,A
				LD A,(HL)				; pobranie bajtu z napisu
				LD (DE),A				; i wrzucenie na ekran, ale to będzie jeszcze modyfikowane dalej
				set 7,E					; przejście do następnej linii
				set 7,L
				LD A,(HL)				; i przeniesienie bajtu z następnej linii (1 bajt z filtra odpowiada za 2 bajty, czyli 4 punkty z ekranu)
				LD (DE),A
				EXX
				EX AF,AF'
				JP Z,alfa_nie			; jeżeli różnica była zero, to tak zostawiamy i skaczemy dalej, wartość z napisu została po prostu przeniesiona na ekran
				EXX						; a jeżeli było wiecej niż 0, to 
				NEG
				AND 7					; obliczamy wartość przeciwną, czyli 7 minus różnica
				LD C,A					; i zapamiętujemy ją w C dla dolnej połówki bajtu			
				RLCA					; przesuwamy w lewo 4 razy
				RLCA
				RLCA
				RLCA
				LD B,A					; i zapamiętujemy ją w B dla górnej połówki bajtu			
				
				LD A,(DE)				; pobieramy wartość z ekranu (jest tam już przeniesiona wartość z napisu)
				AND 240					; zajmujemy się tylko górną połówką
		aps1:	JR Z,ap4				; jeżeli jest zero, czyli w tym punkcie jest kolor tła, to skaczemy do dolnej połówki
				LD A,(DE)				; a jeżeli nie, to w miejsce punktu z napisu wpisujemy 
				AND 15
				OR B					; ... wpisujemy wartość różnicy
				LD (DE),A				; i wrzucamy z powrotem na ekran
	ap4:			
				LD A,(DE)				; to samo dla dolnej połówki bajtu
				AND 15
		aps2:	JR Z,ap5				; jeżeli jest zero, czyli w tym punkcie jest kolor tła, to skaczemy do punktów bezpośrednio pod tymi
				LD A,(DE)				; a jeżeli nie, to w miejsce punktu z napisu wpisujemy 
				AND 240
				OR C					; ... wpisujemy wartość różnicy
				LD (DE),A				; i wrzucamy z powrotem na ekran
	ap5:			
				RES 7,E					; zwiększamy adresy w napisie i na ekranie o 128, czyli idziemy do tej samej kolumny w następnej linii
				RES 7,L
				LD A,(DE)				; i robimy dokładnie to samo co wyżej z bajtem w drugiej linii
				AND 240
		aps3:	JR Z,ap6
				LD A,(DE)
				AND 15
				OR B
				LD (DE),A
	ap6:			
				LD A,(DE)
				AND 15
		aps4:	JR Z,ap7
				LD A,(DE)
				AND 240
				OR C
				LD (DE),A
	ap7:					
				EXX
	alfa_nie:
				INC L				; przechodzimy do następnego punktu w filtrze
				DJNZ ap1			; i tak 64 razy
				EXX
				INC H				; przechodzimy do następnej linii w napisie
				INC D				; ... na ekranie
				EXX
				INC H				; ... i w filtrze
	ap8:		LD L,0				; tu procedura wyżej wstawia wartość, od której zaczyna się linia. 
				POP BC
				DJNZ ap2			; i tak tyle razy, ile wynosi wysokość napisu
				
				INC E				; po przejściu raz całego napisu zwiększamy wartość klucza o 1
				LD A,E
	ap9:		CP 50				; i idziemy z następnym, aż osiągniemy wartość wpisaną tutaj
				JP NZ,alfa_petla	; dla pierwszego przebiegu 50, potem 100, a potem 150
				
				RET
				
alfa_empty:		; pusta procedura dla części nr 5, gdzie są jednocześnie Terminator i Vader
				LD B,100
				CALL czekaj
				RET
