"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntitlementsPath = getEntitlementsPath;
exports.setAssociatedDomains = setAssociatedDomains;
exports.withAssociatedDomains = void 0;

function _fs() {
  const data = _interopRequireDefault(require("fs"));

  _fs = function () {
    return data;
  };

  return data;
}

function _path() {
  const data = _interopRequireDefault(require("path"));

  _path = function () {
    return data;
  };

  return data;
}

function _slash() {
  const data = _interopRequireDefault(require("slash"));

  _slash = function () {
    return data;
  };

  return data;
}

function _iosPlugins() {
  const data = require("../plugins/ios-plugins");

  _iosPlugins = function () {
    return data;
  };

  return data;
}

function _fs2() {
  const data = require("../utils/fs");

  _fs2 = function () {
    return data;
  };

  return data;
}

function Paths() {
  const data = _interopRequireWildcard(require("./Paths"));

  Paths = function () {
    return data;
  };

  return data;
}

function _Xcodeproj() {
  const data = require("./utils/Xcodeproj");

  _Xcodeproj = function () {
    return data;
  };

  return data;
}

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const withAssociatedDomains = (0, _iosPlugins().createEntitlementsPlugin)(setAssociatedDomains, 'withAssociatedDomains');
exports.withAssociatedDomains = withAssociatedDomains;

function setAssociatedDomains(config, {
  'com.apple.developer.associated-domains': _,
  ...entitlementsPlist
}) {
  var _config$ios;

  if ((_config$ios = config.ios) !== null && _config$ios !== void 0 && _config$ios.associatedDomains) {
    return { ...entitlementsPlist,
      'com.apple.developer.associated-domains': config.ios.associatedDomains
    };
  }

  return entitlementsPlist;
}

function getEntitlementsPath(projectRoot) {
  const paths = Paths().getAllEntitlementsPaths(projectRoot);
  let targetPath = null;
  /**
   * Add file to pbxproj under CODE_SIGN_ENTITLEMENTS
   */

  const project = (0, _Xcodeproj().getPbxproj)(projectRoot);
  const projectName = (0, _Xcodeproj().getProjectName)(projectRoot);
  const productName = (0, _Xcodeproj().getProductName)(project); // Use posix formatted path, even on Windows

  const entitlementsRelativePath = (0, _slash().default)(_path().default.join(projectName, `${productName}.entitlements`));
  const entitlementsPath = (0, _slash().default)(_path().default.normalize(_path().default.join(projectRoot, 'ios', entitlementsRelativePath)));
  const pathsToDelete = [];

  while (paths.length) {
    const last = (0, _slash().default)(_path().default.normalize(paths.pop()));

    if (last !== entitlementsPath) {
      pathsToDelete.push(last);
    } else {
      targetPath = last;
    }
  } // Create a new entitlements file


  if (!targetPath) {
    targetPath = entitlementsPath; // Use the default template

    let template = ENTITLEMENTS_TEMPLATE; // If an old entitlements file exists, copy it's contents into the new file.

    if (pathsToDelete.length) {
      // Get the last entitlements file and use it as the template
      const last = pathsToDelete[pathsToDelete.length - 1];
      template = _fs().default.readFileSync(last, 'utf8');
    }

    _fs().default.mkdirSync(_path().default.dirname(entitlementsPath), {
      recursive: true
    });

    _fs().default.writeFileSync(entitlementsPath, template);

    Object.entries(project.pbxXCBuildConfigurationSection()).filter(_Xcodeproj().isNotComment).filter(_Xcodeproj().isBuildConfig).filter(_Xcodeproj().isNotTestHost).forEach(({
      1: {
        buildSettings
      }
    }) => {
      buildSettings.CODE_SIGN_ENTITLEMENTS = `"${entitlementsRelativePath}"`;
    });

    _fs().default.writeFileSync(project.filepath, project.writeSync());
  } // Clean up others


  deleteEntitlementsFiles(pathsToDelete);
  return entitlementsPath;
}

function deleteEntitlementsFiles(entitlementsPaths) {
  for (const path of entitlementsPaths) {
    (0, _fs2().removeFile)(path);
  }
}

const ENTITLEMENTS_TEMPLATE = `
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
<plist version="1.0">
<dict>
</dict>
</plist>
`;
//# sourceMappingURL=Entitlements.js.map