# -*- coding: utf-8 -*-
"""
Created on Wed Feb 14 18:19:32 2024

@author: honka
"""

import pyglet
import socket


from pyglet.gl import *
from pyglet.graphics import Group
from pyglet.graphics.shader import Shader, ShaderProgram

from math import sin, cos


VALOT = True

if VALOT:
    from salivalot import *
    udp_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    udp_socket.sendto(all_black(),('valot.instanssi',9909))

###################################
# Create a Window, and render Batch
###################################
config = pyglet.gl.Config(double_buffer=True, depth_size=24)
window = pyglet.window.Window(width=1920, height = 1080,
fullscreen=True, resizable=True, vsync=False, config=config)
batch = pyglet.graphics.Batch()



pyglet.font.add_file('Norse.otf')
pyglet.font.add_file('NorseBold.otf')
title = pyglet.font.load('Norse')
title_text = pyglet.text.Label('DAEMON', font_name = 'Norse',bold=True, font_size = 72*window.height//1020,
                               x=window.width//2, y=window.height//2,
                               anchor_x = 'center', anchor_y = 'center', color = (255,0,0,255))

middle_text1 = pyglet.text.Label('THE MORE YOU TRY TO CONTROL IT',bold=True, font_name = 'Norse', font_size = 64*window.height//1020,
                               x=window.width//20, y=19*window.height//20,
                               anchor_x = 'left', anchor_y = 'top', color = (255,0,0,255))

middle_text2 = pyglet.text.Label('THE MORE CHAOTIC IT BECOMES', bold=True, font_name = 'Norse', font_size = 64*window.height//1020,
                               x=19*window.width//20, y=window.height//20,
                               anchor_x = 'right', anchor_y = 'bottom', color = (255,0,0,255))


letter_text = 'LINUX'
letters = []
letter_dist = 0.4*window.height

letterbatch = pyglet.graphics.Batch()
circle = pyglet.shapes.Arc(window.width//2,window.height//2,letter_dist*0.45/0.4, thickness = 5,batch=letterbatch)
circle2 = pyglet.shapes.Arc(window.width//2,window.height//2,letter_dist*0.35/0.4, thickness = 5,batch=letterbatch)

for i in range(len(letter_text)):
    letters.append(pyglet.text.Label(letter_text[i], font_name = 'Norse',bold=True, font_size = 72*window.height//1020,
                               x=window.width//2+int(letter_dist*sin(6.28*i/5)), y=window.height//2+int(letter_dist*cos(6.28*i/5)),
                               anchor_x = 'center', anchor_y = 'center', color = (255,0,51,255),batch=letterbatch))



#label = pyglet.text.Label("Demo in progress.", x=5, y=5, font_name = 'Norse', batch=batch)
frames = [pyglet.image.load('xenia1.png'), pyglet.image.load('xenia2.png')]

audio_samples = {}
audio_samples['drum'] = pyglet.resource.media('rumpu.wav',streaming=False)
audio_samples['bass'] = pyglet.resource.media('bass.wav',streaming=False)
audio_samples['bass2'] = pyglet.resource.media('bass2.wav',streaming=False)
audio_samples['music'] = pyglet.resource.media('instanssi_demo.wav',streaming=False)

for i in range(len(frames)):
    frames[i].anchor_x = frames[i].width // 2 
    frames[i].anchor_y = frames[i].height // 2 

    frames[i] = pyglet.sprite.Sprite(frames[i],window.width // 2,window.height // 2 + frames[i].height // 50)
    frames[i].color = (255,0,int(255*0.2))#(220,0,11)#(145,30,40)#(200,0,40)
    #frames[i].opacity = 150


scale = 0.35
frames[0].update(scale=scale)
frames[1].update(scale=scale)

#DEFINE 
frame_rotation = 0
total_time = 0#14/0.4

fps_display = pyglet.window.FPSDisplay(window=window)


event_loop = pyglet.app.EventLoop()

@event_loop.event
def on_window_close(window):
    event_loop.exit()

@window.event
def on_draw():
    window.clear()
    batch.draw()
    
    global total_time
    
    if 0.4*total_time > 14 and 0.4*total_time < 14.75:
        title_text.draw()


    if 0.4*total_time > 17 and 0.4*total_time < 18:
        middle_text1.draw()

    if 0.4*total_time > 18 and 0.4*total_time < 19:
        middle_text2.draw()
        
    if int(0.4*total_time) >= 23 and int(0.4*total_time) <= 38:
        letterbatch.draw()
    
        if int(1.75*total_time) % 6 in [0,]:
            frames[1].draw()
        else:
            frames[0].draw()

    if VALOT:
        if int(0.4*total_time) > 38:
            udp_socket.sendto(all_black(),('valot.instanssi',9909))

    if int(0.4*total_time) >= 40:
        pyglet.app.exit()
            
    #fps_display.draw()


###############################
# Define a basic Shader Program
###############################
_vertex_source = """#version 330 core
    in vec2 position;
    in vec3 tex_coords;
    out vec3 texture_coords;

    uniform WindowBlock 
    {                       // This UBO is defined on Window creation, and available
        mat4 projection;    // in all Shaders. You can modify these matrixes with the
        mat4 view;          // Window.view and Window.projection properties.
    } window;  

    void main()
    {
        gl_Position = window.projection * window.view * vec4(position, 1, 1);
        texture_coords = tex_coords;
    }
"""

_fragment_source = """#version 330 core

in vec3 texture_coords;
out vec4 final_colors;

uniform sampler2D our_texture;
uniform float time;
uniform float fade;
uniform vec2 iResolution;

float iTime = time;


vec2 rcoo(vec2 xy,float angle){
    return vec2(xy.x*cos(angle)+xy.y*sin(angle),-xy.x*sin(angle)+xy.y*cos(angle));
}

vec3 map(float x){
    return clamp(vec3(x,0.0,0.2*x)+vec3(1.0)*exp(-5.0*(1.0-x)),0.,1.0);

}


void main()
{
    vec2 fragCoord = texture_coords.xy;

    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = vec2(fragCoord.x,fragCoord.y*iResolution.y/iResolution.x);
    vec2 mid = vec2(0.5,0.5*iResolution.y/iResolution.x);
    vec2 xy = uv-mid;
    
    // Time varying pixel color
    vec3 col = vec3(0.0);//0.5 + 0.5*cos(iTime+uv.xyx+vec3(0,2,4));

    vec2 xy2;

    float scale;

    float tsc = 6.28*0.2/2.5;

    int angle = int(100.0*0.5*(atan(xy.y,xy.x)/3.14 + 1.0));

    float grid = sin(500.0*pow(length(xy),0.05) - 5.0*iTime+atan(xy.y,xy.x));

    if(angle % 5 == 0 && grid > 0.95){
        col += vec3(1.0)*(1.0-exp(-length(xy)));
    }

    int n = 5;

    for(int i = 0; i<n;i++){
        xy2 = rcoo(xy,float(i)/float(n)*6.28);
        
        scale = 0.08 + 0.005*sin((5.0*iTime-1.6)*tsc);
        
        col += map(exp(-2500.0*pow(xy2.y+scale,2.0)));
        if (xy2.y < -0.08){
           //This part sends forth the pentagram
           col += map( exp(10.0*(sin(10.0*xy2.y + 2.5*iTime*tsc)-1.0))*exp(1.0*(xy2.y+scale)));
        }

        if(n == 5){
        col += 0.2*vec3(1.0,0.0,0.0)*pow(pow(abs(sin((1.25*iTime+0.3)*tsc)),8.0),4.0);
        col += 0.2*vec3(1.0,1.0,1.0)*pow(pow(abs(sin((1.25*iTime+0.5)*tsc)),8.0),8.0);
        }
    }

    // Output to screen
    final_colors = vec4(col,1.0) * mix(vec4(0.0,0.0,1.0,1.0),vec4(1.00),exp(-2.0*length(xy)+0.75))*mix(vec4(1.0),vec4(0.0,0.0,0.1,1.0),exp(-dot(xy,xy)/0.035))*fade ;

    //final_colors += texture(our_texture,xy);

    //fragColor = vec4(.75) * mix(vec4(0.0,0.0,1.0,1.0),vec4(1.00),exp(-2.0*length(xy)+0.75));

}
"""

_fragment_source2 = """#version 330 core

in vec3 texture_coords;
out vec4 final_colors;

uniform sampler2D our_texture;
uniform float time;

uniform vec2 iResolution;
float iTime = time;

#define ARRMAX 5
float a_arr[ARRMAX] = float[ARRMAX](1.0,2.0,3.0,5.0,3.0);
float b_arr[ARRMAX] = float[ARRMAX](2.0,3.0,1.0,2.0,4.0);
float phase[ARRMAX] = float[ARRMAX](0.0,3.14,0.0,0.0,0.0);

void main()
{
    vec2 fragCoord = texture_coords.xy;

    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = vec2(fragCoord.x,fragCoord.y*iResolution.y/iResolution.x);
    vec2 mid = vec2(0.5,0.5*iResolution.y/iResolution.x);
    vec2 xy = uv-mid;

    
    vec3 col = vec3(0.0);

    //Lissajous parameters
    float A = 0.1 + 0.075*exp((int(.4*time)-.4*time)*1.5);
    float B = 0.1 + 0.075*exp((int(.4*time)-.4*time)*1.5);
    float a = a_arr[int(.4*time) % ARRMAX];
    float b = b_arr[int(0.4*time) % ARRMAX];
    float delta = phase[int(0.4*time) % ARRMAX];
    
    float dt = 0.035/sqrt(a*a+b*b)*2.0;

    #define IMAX 500
    //#define IMAX 50

    //if(0.4*time >= 9.0){
        
        
            xy = round(30.0*time*xy)/(30.0*time);                        
    //}

    if(0.4*time >= 1.0){
        a = a/6.28;
        b = b/6.28;
        for(int i = 0; i < IMAX; i++){
            //float x = A*sin(a*i*dt - a*10.0*time);            
            //float y = B*sin(b*i*dt + delta - b*10.0*time + max(.4*time-5,0.0));
            float x = A*(2.0*abs(2*fract(a*i*dt - a*10.0*time)-1.0)-1.0);            
            float y = B*(2.0*abs(2*fract(b*i*dt + delta/6.28 - b*10.0*time + max(.4*time-5,0.0)/6.28)-1.0)-1.0);
     
 
           col += vec3(0.25,0.0,0.0)*exp(-1.0*i/IMAX)*exp(-0.5*pow(length(xy-vec2(x,y))/0.008,2.0));                 
            col += 0.25*exp(-1.0*i/IMAX)*exp(-0.5*pow(length(xy-vec2(x,y))/0.003,2.0));       
        }
    }

    col += vec3(0.5,0.0,0.0)*(1.0-exp(-max(time-1/0.4,0.0)/12.5))*exp(-pow(100.0*(1.0+0.1*sin(1.8*time))*length(xy)/time,2.0));
    //col += vec3(1.0)*(1.0-exp(-time/30.0))*exp(-pow(150.0*length(xy)/time,2.0));

    // Output to screen
    
    
    final_colors = vec4(pow(col,vec3(1.0/2.2)),1.0);

}
"""

_fragment_source3 = """#version 330 core

in vec3 texture_coords;
out vec4 final_colors;

uniform sampler2D our_texture;
uniform float time;

uniform vec2 iResolution;
float iTime = time;

float gauss(vec2 x, vec2 x0, float sigma){
    return exp(-0.5*pow(length(x-x0)/sigma,2.0));    
    
}

float gaussians(vec2 xy){
    float val = gauss(xy,0.3*vec2(sin(0.353643*time),cos(1.347657*time)*iResolution.y/iResolution.x),0.05+0.01*sin(time));
    val += gauss(xy,0.3*vec2(sin(0.9383*time+1.3),cos(0.7347657*time+4.3)*iResolution.y/iResolution.x),0.05+0.01*sin(1.2*time+0.4));
    val += gauss(xy,0.3*vec2(sin(0.437862*time+2.4),cos(1.1563*time+1.2)*iResolution.y/iResolution.x),0.05+0.01*sin(0.75*time+0.98));
    val += gauss(xy,0.3*vec2(sin(1.3763*time+3.056),cos(0.347657*time+7.0)*iResolution.y/iResolution.x),0.05+0.01*sin(1.2*time+0.3434));
    val += gauss(xy,0.3*vec2(sin(0.862*time+3.4),cos(0.563*time+7.2)*iResolution.y/iResolution.x),0.05+0.01*sin(1.4*time+4.30));
    
    val += pow(time/10.0,2.0)*0.1*(sin(17.0*(1.0+sin(time))*xy.x + 14.0*xy.x) + cos(11.0*xy.x * 16.0*xy.y +time));


    val += 2.0*pow(max(time/10.0-1.25,0.0),4.0)*fract(sin(dot(xy, vec2(12.9898, 78.233))) * 43758.5453);

    return val;
 }

vec3 dgaus(vec2 xy){
    
    vec2 d = vec2(0.001,0.0);
    float dx = (gaussians(xy+d)-gaussians(xy-d))/(2.0*d.x);
    float dy = (gaussians(xy+d.yx)-gaussians(xy-d.yx))/(2.0*d.x);

    return normalize(vec3(dx,dy,1.0));    
}

void main()
{
    vec2 fragCoord = texture_coords.xy;

    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = vec2(fragCoord.x,fragCoord.y*iResolution.y/iResolution.x);
    vec2 mid = vec2(0.5,0.5*iResolution.y/iResolution.x);
    vec2 xy = uv-mid;

    
    vec3 col = vec3(0.0);

    //create some gaussians
    float val = gaussians(xy);
    val *= 0.5;

    vec3 ldir = vec3(xy,0.0)-vec3(sin(2.0*time),sin(1.0*time),2.5);

    if (val > 0.25){
        //col = vec3(clamp(sqrt(val)-0.4,0.0,1.0),clamp(val-0.5,0.0,1.0),clamp(val-0.25,0.0,1.0));
        col = vec3(0.15,0.0,0.0);
        
        col += vec3(0.5,0.5,0.5)*pow(clamp(-dot(ldir,dgaus(xy)),0.0,1.0),2.0);
        col *= (val-0.25)/0.25;
    }
    

    // Output to screen
    final_colors = vec4(pow(clamp(col,0.0,1.0),vec3(1.0/2.2)),1.0);

}
"""

vert_shader = Shader(_vertex_source, 'vertex')
frag_shader = Shader(_fragment_source2, 'fragment')
shader_program = ShaderProgram(vert_shader, frag_shader)

vert_shader = Shader(_vertex_source, 'vertex')
frag_shader = Shader(_fragment_source, 'fragment')
shader_program2 = ShaderProgram(vert_shader, frag_shader)

vert_shader = Shader(_vertex_source, 'vertex')
frag_shader = Shader(_fragment_source3, 'fragment')
shader_program3 = ShaderProgram(vert_shader, frag_shader)

#####################################################
# Define a custom `Group` to encapsulate OpenGL state
#####################################################
class RenderGroup(Group):
    """A Group that enables and binds a Texture and ShaderProgram.

    RenderGroups are equal if their Texture and ShaderProgram
    are equal.
    """
    def __init__(self, texture, program, order=0, parent=None):
        """Create a RenderGroup.

        :Parameters:
            `texture` : `~pyglet.image.Texture`
                Texture to bind.
            `program` : `~pyglet.graphics.shader.ShaderProgram`
                ShaderProgram to use.
            `order` : int
                Change the order to render above or below other Groups.
            `parent` : `~pyglet.graphics.Group`
                Parent group.
        """
        super().__init__(order, parent)
        self.texture = texture
        self.program = program

    def set_state(self):
        glActiveTexture(GL_TEXTURE0)
        glBindTexture(self.texture.target, self.texture.id)
        glEnable(GL_BLEND)
        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
        self.program.use()

    def unset_state(self):
        glDisable(GL_BLEND)

    def __hash__(self):
        return hash((self.texture.target, self.texture.id, self.order, self.parent, self.program))

    def __eq__(self, other):
        return (self.__class__ is other.__class__ and
                self.texture.target == other.texture.target and
                self.texture.id == other.texture.id and
                self.order == other.order and
                self.program == other.program and
                self.parent == other.parent)


#########################################################
# Load a Texture, and create a VertexList from the Shader
#########################################################


#def create_quad(x, y, texture):
#    x2 = x + texture.width
#    y2 = y + texture.height
#    return x, y, x2, y, x2, y2, x, y2




tex = pyglet.resource.texture('xenia1.png')
group = RenderGroup(tex, shader_program,order = 0)
indices = (0, 1, 2, 0, 2, 3)
#vertex_positions = create_quad(400, 200, tex)

vertex_positions = (0, 0, window.width, 0, window.width, window.height,0,window.height)

# count, mode, indices, batch, group, *data
vertex_list = shader_program.vertex_list_indexed(4, GL_TRIANGLES, indices, batch, group,
                                                 position=('f', vertex_positions),
                                                 tex_coords=('f', tex.tex_coords))

shader_program['iResolution'] = (window.width, window.height)

group2 = RenderGroup(tex, shader_program2,order = 1)
group2.visible = False
# count, mode, indices, batch, group, *data
vertex_list = shader_program2.vertex_list_indexed(4, GL_TRIANGLES, indices, batch, group2,
                                                 position=('f', vertex_positions),
                                                 tex_coords=('f', tex.tex_coords))

shader_program2['iResolution'] = (window.width, window.height)


group3 = RenderGroup(tex, shader_program3, order = 2)
group3.visible = False
# count, mode, indices, batch, group, *data
vertex_list = shader_program3.vertex_list_indexed(4, GL_TRIANGLES, indices, batch, group3,
                                                 position=('f', vertex_positions),
                                                 tex_coords=('f', tex.tex_coords))

shader_program3['iResolution'] = (window.width, window.height)
#shader_program3['texDimensions'] = (tex.width, tex.height)

temp = False

intro_light_time = 0

light_indeces = [22,23,0,21,1,20,2,19,3,18,4,17,5,16,6,15,7,14,8,13,9,12,10,11]
light_counter = 0

def update(dt):
    global frame_rotation, total_time, temp, intro_light_time, light_counter
    prev_time = int(0.4*total_time)
    prev_time2 = int(3.2*total_time)
    total_time += dt   
    intro_light_time += dt
    shader_program['time'] = total_time
    shader_program2['time'] = total_time - 24.25/0.4
    shader_program3['time'] = total_time - 15/0.4
    shader_program2['fade'] = max(1.0 - max(total_time - 32.25/0.4,0.0)*0.125,0.0)
    
    
    if int(0.4*total_time) != prev_time and int(0.4*total_time) < 15.0:
        audio_samples['drum'].play()
        intro_light_time = 0
        light_counter += 1

    if int(0.4*total_time) >= 5.0 and int(0.4*total_time) < 13.0 and int(3.2*total_time) != prev_time2:
        if int((int(0.4*total_time) - 1)/2) % 4 != 0:
            audio_samples['bass'].play()
        else:
            audio_samples['bass2'].play()


    if int(0.4*total_time) < 13:
        if VALOT:
            udp_socket.sendto(decay_light(light_indeces[:min(2+2*light_counter,len(light_indeces))],[255,0,0],max(1.0-0.5*intro_light_time,0.0)),('valot.instanssi',9909))        
        
    if group.visible and int(0.4*total_time) >= 13:
        group.visible = False
        if VALOT:
            udp_socket.sendto(all_black(),('valot.instanssi',9909))
        
    if not temp and int(0.4*total_time) >= 15:
        temp = True
        audio_samples['music'].play()
        group3.visible = True        

    if group3.visible and VALOT:
            udp_socket.sendto(rotating_light(total_time - 15/0.4,[(22,-2),(23,2)],[200,200,200],[100,0,0]),('valot.instanssi',9909))        
    if not group2.visible and int(0.4*total_time) >= 23:
        group2.visible = True
        group3.visible = False


    mixphase = 0.0
    if total_time - 35/0.4 < 2.0:        
        mixphase =  sin((1.25*(total_time - 24.25/0.4)+0.5)*6.28*0.2/2.5)**16

    for i in range(len(frames)):
        frames[i].color = (255,0+int(255*mixphase),51+int(204*mixphase))        
        frames[i].opacity = int(255*max(1.0 - max(total_time - 35/0.4,0.0)*0.125,0.0))


    for i in range(len(letters)):
        letters[i].color = (255,0+int(255*mixphase),51+int(204*mixphase))        

        letters[i].position = (window.width//2+int(letter_dist*sin(6.28*(i+(0.4*total_time-23))/5)), 
                               window.height//2+int(letter_dist*cos(6.28*(i+(0.4*total_time-23))/5)),
                               0.0)
        letters[i].opacity = int(255*max(1.0 - max(total_time - 35/0.4,0.0)*0.125,0.0))

    if group2.visible and VALOT:
        udp_socket.sendto(rotating_light(total_time - 15/0.4,[(22,-3),(23,4),(12,-4),(12,3)],[255,0,255],[200+int(55*mixphase),int(255*mixphase),int(255*mixphase)]),('valot.instanssi',9909)) 
        udp_socket.sendto(decay_uvs(mixphase),('valot.instanssi',9909)) 

    circle.color = (255,0+int(255*mixphase),51+int(204*mixphase))
    circle.opacity = int(255*max(1.0 - max(total_time - 35/0.4,0.0)*0.125,0.0))     
    circle2.color = (255,0+int(255*mixphase),51+int(204*mixphase))
    circle2.opacity = int(255*max(1.0 - max(total_time - 35/0.4,0.0)*0.125,0.0))            
    #frame_rotation = 75*total_time
    #frames[0].update(rotation=frame_rotation)
    #frames[1].update(rotation=frame_rotation)

    


pyglet.clock.schedule_interval(update, 1/120.0)

#####################
# Enter the main loop
#####################
pyglet.app.run()
