﻿local starscroller={}
local brightStars={}
local mediumStars={}
local dimStars={}
local totalElapsedTime=0
local function randomSquareSize()
return ({2,3,4,5})[math.random(1,4)] end
local function randomSpeed(minSpeed,maxSpeed)
return math.random(minSpeed,maxSpeed) end
local function spawnStarRight(star,minSpeed,maxSpeed)
star.minSpeed=minSpeed
star.maxSpeed=maxSpeed
local s=randomSquareSize()
star.width=s
star.height=s
star.speed=randomSpeed(minSpeed,maxSpeed)
star.y=math.random(0,1080)
local jitter=math.random(0,8)
star.x=1920+jitter+star.width end
local function seedStarInFlight(star,minSpeed,maxSpeed)
star.minSpeed=minSpeed
star.maxSpeed=maxSpeed
star.speed=randomSpeed(minSpeed,maxSpeed)
star.y=math.random(0,1080)
local s=randomSquareSize()
star.width=s
star.height=s
star.x=math.random(0,1920) end
local function spawnStarRightFar(star,minSpeed,maxSpeed,spreadSeconds)
star.minSpeed=minSpeed
star.maxSpeed=maxSpeed
local s=randomSquareSize()
star.width=s
star.height=s
star.speed=randomSpeed(minSpeed,maxSpeed)
star.y=math.random(0,1080)
local extra=math.random(0,math.floor(star.speed*spreadSeconds))
local jitter=math.random(0,16)
star.x=1920+extra+jitter+star.width end
local function createStars(starTable,count,minSpeed,maxSpeed,seededOnScreen)
for i=1,count do
local star={}
if seededOnScreen then
seedStarInFlight(star,minSpeed,maxSpeed)
else
spawnStarRight(star,minSpeed,maxSpeed) end
table.insert(starTable,star) end end
local function createStarsOffscreenRight(starTable,count,minSpeed,maxSpeed,spreadSeconds)
for i=1,count do
local star={}
spawnStarRightFar(star,minSpeed,maxSpeed,spreadSeconds)
table.insert(starTable,star) end end
function starscroller.load()
math.randomseed(os.time())
createStarsOffscreenRight(brightStars,60,320,390,4.0)
createStarsOffscreenRight(mediumStars,190,140,190,4.0)
createStarsOffscreenRight(dimStars,300,40,80,4.0) end
local function calculateslowedspeed(originalSpeed,elapsedTime)
if elapsedTime<41.00 then
return originalSpeed
elseif elapsedTime>=41.00+12.00 then
return 0
else
local slowdownElapsed=elapsedTime-41.00
local t=slowdownElapsed/12.00
return originalSpeed*(1-t) end end
local function updatestars(starTable,dt,elapsedTime)
for _,star in ipairs(starTable) do
local slowedSpeed=calculateslowedspeed(star.speed,elapsedTime)
star.x=star.x-slowedSpeed*dt
if star.x<-star.width then
spawnStarRight(star,star.minSpeed,star.maxSpeed) end end end
local function handleStarRamp()
local t=math.min(totalElapsedTime/60.0,1.0)
local targetBright=math.floor(60+(210-60)*t)
local targetMedium=math.floor(190+(1000-190)*t)
local targetDim=math.floor(300+(1500-300)*t)
if #brightStars<targetBright then
createStarsOffscreenRight(brightStars,targetBright-#brightStars,320,390,2.0) end
if #mediumStars<targetMedium then
createStarsOffscreenRight(mediumStars,targetMedium-#mediumStars,140,190,2.0) end
if #dimStars<targetDim then
createStarsOffscreenRight(dimStars,targetDim-#dimStars,40,80,2.0) end end
function starscroller.update(dt)
totalElapsedTime=totalElapsedTime+dt
handleStarRamp()
updatestars(brightStars,dt,totalElapsedTime)
updatestars(mediumStars,dt,totalElapsedTime)
updatestars(dimStars,dt,totalElapsedTime) end
function starscroller.draw()
love.graphics.setColor(1,1,1,0.1)
for _,star in ipairs(dimStars) do
love.graphics.rectangle("fill",math.floor(star.x),math.floor(star.y),star.width,star.height) end
love.graphics.setColor(1,1,1,0.3)
for _,star in ipairs(mediumStars) do
love.graphics.rectangle("fill",math.floor(star.x),math.floor(star.y),star.width,star.height) end
love.graphics.setColor(1,1,1,0.8)
for _,star in ipairs(brightStars) do
love.graphics.rectangle("fill",math.floor(star.x),math.floor(star.y),star.width,star.height) end end
return starscroller
