uniform float iTime;

#define PI 3.14159265359

float scrollSpeed = 1.0; // Uniform for scrolling speed

// Function to return classic rainbow colors based on a position input
vec3 rainbowColor(float position) {
    position = fract(position); // Wrap the position within 0 to 1
    if (position < 1.0 / 6.0) {
        return vec3(1.0, position * 6.0, 0.0);  // Red to Orange
    } else if (position < 2.0 / 6.0) {
        return vec3(1.0 - (position - 1.0 / 6.0) * 6.0, 1.0, 0.0);  // Orange to Yellow
    } else if (position < 3.0 / 6.0) {
        return vec3(0.0, 1.0, (position - 2.0 / 6.0) * 6.0);  // Yellow to Green
    } else if (position < 4.0 / 6.0) {
        return vec3(0.0, 1.0 - (position - 3.0 / 6.0) * 6.0, 1.0);  // Green to Blue
    } else if (position < 5.0 / 6.0) {
        return vec3((position - 4.0 / 6.0) * 6.0, 0.0, 1.0);  // Blue to Indigo
    } else {
        return vec3(1.0, 0.0, 1.0 - (position - 5.0 / 6.0) * 6.0);  // Indigo to Violet
    }
}

// Function to cycle through rainbow colors over time
vec3 cyclingBackgroundColor(float time) {
    float position = mod(time * 0.1, 1.0); // Adjust speed of cycling with the multiplier
    return rainbowColor(position);
}

void main() {
    vec2 iResolution = vec2(1920., 1080.);
    //vec2 uv = fragCoord.xy / iResolution.xy;  // Normalize coordinates to [0,1]
    vec2 uv = gl_TexCoord[0].xy;
    uv.x *= iResolution.x / iResolution.y;    // Adjust for aspect ratio
    
    // Create a wavy pattern for the vertical rainbow line
    float waveSpeed = 1.5;   // Speed of the wave
    float waveFrequency = 3.0;   // Number of waves across the screen
    float waveAmplitude = 0.3;   // Amplitude of the wave (affects how far the wave distorts vertically)
    float totalThickness = 0.6;  // Total thickness of the rainbow band
    
    // Calculate the vertical offset of the rainbow band, adding scrolling effect
    float wavyY = 0.5 + sin(uv.x * waveFrequency + (iTime * waveSpeed + scrollSpeed * iTime)) * waveAmplitude;
    
    // Create the rainbow colors, making them scroll individually
    float colorScrollOffset = iTime * 1.5;  // Adjust this value to change color scroll speed
    float colorPosition = uv.x + colorScrollOffset;  // Apply scroll to color position

    // Cycle the background color
    vec3 backgroundColor = cyclingBackgroundColor(iTime);

    vec3 color = mix(backgroundColor, rainbowColor(fract(colorPosition)), smoothstep(totalThickness, totalThickness - 0.01, abs(uv.y - wavyY)));

    gl_FragColor = vec4(color, 1.0);
}
