/**************************
***** Compiler Parameters *****
***************************
@P EffectName: TextureFXEffect
@P   - EffectNodeBase.EffectNodeBaseShader: mixin ShiftRGB_TextureFX [{Control = mixin DoFloat4 [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat4<Input_3> [{Value = InputFloat4<ShaderFX.InputValueFloat4,PerUpdate>}]]}]}, {Value = GetVarFloat4<Input_3>}]}, {Direction = mixin DoFloat [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat<Input_0> [{Value = InputFloat<ShaderFX.InputValueFloat,PerUpdate>}]]}]}, {Value = GetVarFloat<Input_0>}]}, {Hue = mixin DoFloat [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat<Input_2> [{Value = InputFloat<ShaderFX.InputValueFloat.i2,PerUpdate>}]]}]}, {Value = GetVarFloat<Input_2>}]}, {Shift = mixin DoFloat [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat<Input_1> [{Value = InputFloat<ShaderFX.InputValueFloat.i1,PerUpdate>}]]}]}, {Value = GetVarFloat<Input_1>}]}]
@P Direction: mixin DoFloat [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat<Input_0> [{Value = InputFloat<ShaderFX.InputValueFloat,PerUpdate>}]]}]}, {Value = GetVarFloat<Input_0>}]
@P Shift: mixin DoFloat [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat<Input_1> [{Value = InputFloat<ShaderFX.InputValueFloat.i1,PerUpdate>}]]}]}, {Value = GetVarFloat<Input_1>}]
@P Hue: mixin DoFloat [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat<Input_2> [{Value = InputFloat<ShaderFX.InputValueFloat.i2,PerUpdate>}]]}]}, {Value = GetVarFloat<Input_2>}]
@P Control: mixin DoFloat4 [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat4<Input_3> [{Value = InputFloat4<ShaderFX.InputValueFloat4,PerUpdate>}]]}]}, {Value = GetVarFloat4<Input_3>}]
***************************
****  ConstantBuffers  ****
***************************
cbuffer PerDraw [Size: 64]
@C    MatrixTransform_id73 => SpriteBase.MatrixTransform
cbuffer PerUpdate [Size: 32]
@C    InputValue_id92 => ShaderFX.InputValueFloat4
@C    InputValue_id98 => ShaderFX.InputValueFloat
@C    InputValue_id104 => ShaderFX.InputValueFloat.i2
@C    InputValue_id110 => ShaderFX.InputValueFloat.i1
***************************
******  Resources    ******
***************************
@R    PerDraw => PerDraw [Stage: Vertex, Slot: (0-0)]
@R    Sampler0_id52 => Texturing.Sampler0 [Stage: Pixel, Slot: (0-0)]
@R    Texture0_id14 => Texturing.Texture0 [Stage: Pixel, Slot: (0-0)]
@R    PerUpdate => PerUpdate [Stage: Pixel, Slot: (0-0)]
***************************
*****     Sources     *****
***************************
@S    ShiftRGB_TextureFX => 4c00533e7b75ec20670cd7f4f2e157c8
@S    FilterBase => 5bd9cb7e7eb80aa436e148c74d845c07
@S    TextureFX => 27bb4f1f808a5eedf6dfeaa75c669c29
@S    ImageEffectShader => 8064e30cc02e5eb4052f420259dbf05e
@S    SpriteBase => 5a7aa9dfd5b5c7613053f4f66c79ca0d
@S    ShaderBase => 4ecbcd2528b64a79eebe81a863892d8c
@S    ShaderBaseStream => b705b699a7385d39c7de52a8d13f3978
@S    Texturing => 91ef3011c1071c2e5d41cd3ee0418b18
@S    Camera => f5d1a113ef7a27319900e8cc2e11ae0d
@S    ShaderUtils => 27e27e08e991883f970444d1aebe3b58
@S    ComputeFloat4 => f871947e9f604da432ea9fc3c9cb4363
@S    ComputeColor => c875a0e093379dd74cd9a5a73aca830f
@S    ComputeFloat => 3607bb1fa125ec30a7afa60be79c4817
@S    DoFloat4 => 312f1c610231ffe618620ce43634d0aa
@S    ComputeVoid => b62583a94b8503c79e9107f4b5bc9392
@S    ComputeOrder => 1d9b1cd3f5e3ad3f3f10e4fc88326cc7
@S    AssignVarFloat4 => 3a0c495ce724365e837c33156190acbe
@S    StreamVariableFloat4 => 2bfe58666cb67eed05b9410465550725
@S    InputFloat4 => f6891eacc9ea2d912dcfded49ea96a71
@S    DeclFloat4 => 03cb445d0e450d0a37ad5f24c8a93feb
@S    GetVarFloat4 => 2805d4f95c82389ce488a02bbf6e99f5
@S    DoFloat => 6cd1241010567bf9b5fdfccc1367f0fd
@S    AssignVarFloat => bdbba6e547b89ed4fc75c07ceb551948
@S    StreamVariableFloat => 247690c18e04365d061235ca1cb870ff
@S    InputFloat => f487ac725dafb0434d14d0273ee628a8
@S    DeclFloat => 75bf7e6f5246ed3d7aa33ab3c7183aa4
@S    GetVarFloat => 959a28f1937e5e493bc7459164561cc0
***************************
*****     Stages      *****
***************************
@G    Vertex => 79eb7ff071584feaa45b858a38e87b6a
//
// Generated by Microsoft (R) HLSL Shader Compiler 10.1
//
//
// Buffer Definitions: 
//
// cbuffer PerDraw
// {
//
//   float4x4 MatrixTransform_id73;     // Offset:    0 Size:    64
//
// }
//
//
// Resource Bindings:
//
// Name                                 Type  Format         Dim      HLSL Bind  Count
// ------------------------------ ---------- ------- ----------- -------------- ------
// PerDraw                           cbuffer      NA          NA            cb0      1 
//
//
//
// Input signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// POSITION                 0   xyzw        0     NONE   float   xyzw
// TEXCOORD                 0   xy          1     NONE   float   xy  
//
//
// Output signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// SV_Position              0   xyzw        0      POS   float   xyzw
// TEXCOORD                 0   xy          1     NONE   float   xy  
//
vs_5_0
dcl_globalFlags refactoringAllowed
dcl_constantbuffer CB0[4], immediateIndexed
dcl_input v0.xyzw
dcl_input v1.xy
dcl_output_siv o0.xyzw, position
dcl_output o1.xy
//
// Initial variable locations:
//   v0.x <- __input__.Position_id72.x; v0.y <- __input__.Position_id72.y; v0.z <- __input__.Position_id72.z; v0.w <- __input__.Position_id72.w; 
//   v1.x <- __input__.TexCoord_id62.x; v1.y <- __input__.TexCoord_id62.y; 
//   o1.x <- <VSMain return value>.TexCoord_id62.x; o1.y <- <VSMain return value>.TexCoord_id62.y; 
//   o0.x <- <VSMain return value>.ShadingPosition_id0.x; o0.y <- <VSMain return value>.ShadingPosition_id0.y; o0.z <- <VSMain return value>.ShadingPosition_id0.z; o0.w <- <VSMain return value>.ShadingPosition_id0.w
//
#line 311 "C:\Users\alex\Documents\vvvv\gamma\Exports\5sun2\log\shader_TextureFXEffect_0c84164487763b4ce0ba431c53137315.hlsl"
dp4 o0.x, v0.xyzw, cb0[0].xyzw
dp4 o0.y, v0.xyzw, cb0[1].xyzw
dp4 o0.z, v0.xyzw, cb0[2].xyzw
dp4 o0.w, v0.xyzw, cb0[3].xyzw

#line 315
mov o1.xy, v1.xyxx
ret 
// Approximately 6 instruction slots used
@G    Pixel => 2b5cf63f5fb011f1a65f1a66f4d77bd2
//
// Generated by Microsoft (R) HLSL Shader Compiler 10.1
//
//
// Buffer Definitions: 
//
// cbuffer PerUpdate
// {
//
//   float4 InputValue_id92;            // Offset:    0 Size:    16
//   float InputValue_id98;             // Offset:   16 Size:     4
//   float InputValue_id104;            // Offset:   20 Size:     4
//   float InputValue_id110;            // Offset:   24 Size:     4
//
// }
//
//
// Resource Bindings:
//
// Name                                 Type  Format         Dim      HLSL Bind  Count
// ------------------------------ ---------- ------- ----------- -------------- ------
// Sampler0_id52                     sampler      NA          NA             s0      1 
// Texture0_id14                     texture  float4          2d             t0      1 
// PerUpdate                         cbuffer      NA          NA            cb0      1 
//
//
//
// Input signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// SV_Position              0   xyzw        0      POS   float       
// TEXCOORD                 0   xy          1     NONE   float   xy  
//
//
// Output signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// SV_Target                0   xyzw        0   TARGET   float   xyzw
//
ps_5_0
dcl_globalFlags refactoringAllowed
dcl_constantbuffer CB0[2], immediateIndexed
dcl_sampler s0, mode_default
dcl_resource_texture2d (float,float,float,float) t0
dcl_input_ps linear v1.xy
dcl_output o0.xyzw
dcl_temps 6
//
// Initial variable locations:
//   v0.x <- __input__.ShadingPosition_id0.x; v0.y <- __input__.ShadingPosition_id0.y; v0.z <- __input__.ShadingPosition_id0.z; v0.w <- __input__.ShadingPosition_id0.w; 
//   v1.x <- __input__.TexCoord_id62.x; v1.y <- __input__.TexCoord_id62.y; 
//   o0.x <- <PSMain return value>.ColorTarget_id2.x; o0.y <- <PSMain return value>.ColorTarget_id2.y; o0.z <- <PSMain return value>.ColorTarget_id2.z; o0.w <- <PSMain return value>.ColorTarget_id2.w
//
#line 180 "C:\Users\alex\Documents\vvvv\gamma\Exports\5sun2\log\shader_TextureFXEffect_0c84164487763b4ce0ba431c53137315.hlsl"
mov r0.zw, l(0,0,-1.000000,0.666667)
mov r1.zw, l(0,0,0,-0.333333)

#line 261
add r2.xyzw, cb0[1].xxxx, l(0.000000, 0.250000, 0.000000, 0.250000)
mul r2.xyzw, r2.xyzw, l(6.283185, 6.283185, 6.283185, 6.283185)
sincos r2.xyzw, null, r2.xyzw  // r2.z <- dir.x; r2.w <- dir.y; r2.z <- dir.x; r2.w <- dir.y

#line 284
mul r3.xyzw, cb0[1].zzzz, l(0.100000, 0.100000, -0.100000, -0.100000)  // r3.w <- offset.x; r3.w <- offset.x

#line 262
mad r2.xyzw, r2.xyzw, r3.xyzw, v1.xyxy  // r2.z <- uv.x; r2.w <- uv.y; r2.z <- uv.x; r2.w <- uv.y

#line 263
sample_l_indexable(texture2d)(float,float,float,float) r3.xyw, r2.zwzz, t0.yzwx, s0, l(0.000000)  // r3.w <- col.x; r3.x <- col.y; r3.y <- col.z; r3.w <- col.x; r3.x <- col.y; r3.y <- col.z
sample_l_indexable(texture2d)(float,float,float,float) r2.xyw, r2.xyxx, t0.yzwx, s0, l(0.000000)  // r2.w <- col.x; r2.x <- col.y; r2.y <- col.z; r2.w <- col.x; r2.x <- col.y; r2.y <- col.z

#line 180
lt r4.x, r3.x, r3.y
mov r0.xy, r3.yxyy
mov r1.xy, r0.yxyy
movc r0.xyzw, r4.xxxx, r0.xyzw, r1.xyzw  // r0.x <- P.x; r0.y <- P.y; r0.z <- P.z; r0.w <- P.w

#line 181
lt r1.x, r3.w, r0.x
mov r3.xyz, r0.xywx
mov r0.xyw, r3.wywx
movc r0.xyzw, r1.xxxx, r3.yzxw, r0.yzxw  // r0.x <- Q.y; r0.y <- Q.z; r0.z <- Q.x; r0.w <- Q.w

#line 182
min r1.x, r0.x, r0.w
add r1.x, r0.z, -r1.x  // r1.x <- C

#line 183
mad r1.y, r1.x, l(6.000000), l(0.000000)
add r0.w, -r0.x, r0.w
div r0.w, r0.w, r1.y
add r0.w, r0.y, r0.w
mov r0.x, |r0.w|  // r0.x <- H

#line 224
add r0.w, r0.z, l(0.000000)
div r0.y, r1.x, r0.w  // r0.y <- S

#line 264
mov r1.x, cb0[1].y
mov r1.yz, l(0,0,0,0)
add r0.xyz, r0.xyzx, r1.xzzx

#line 172
frc r0.x, r0.x  // r0.x <- H

#line 175
mad r0.x, r0.x, l(6.000000), l(-4.000000)
add_sat r0.x, -|r0.x|, l(2.000000)  // r0.x <- <HUEtoRGB_id8 return value>.z

#line 219
add r0.x, r0.x, l(-1.000000)
mad r0.x, r0.x, r0.y, l(1.000000)
mul r0.x, r0.z, r0.x  // r0.x <- <HSVtoRGB_id9 return value>.z

#line 180
mov r3.zw, l(0,0,-1.000000,0.666667)
mov r4.zw, l(0,0,0,-0.333333)

#line 290
sample_l_indexable(texture2d)(float,float,float,float) r5.xyzw, v1.xyxx, t0.xyzw, s0, l(0.000000)  // r5.x <- <InTex0_id26 return value>.x; r5.y <- <InTex0_id26 return value>.y; r5.z <- <InTex0_id26 return value>.z; r5.w <- <InTex0_id26 return value>.w

#line 180
mov r3.xy, r5.zyzz
mov r4.xy, r3.yxyy
lt r1.w, r3.y, r5.z
movc r3.xyzw, r1.wwww, r3.xyzw, r4.xyzw  // r3.x <- P.x; r3.y <- P.y; r3.z <- P.z; r3.w <- P.w

#line 181
lt r1.w, r5.x, r3.x
mov r4.xyz, r3.xywx
mov r4.w, r5.x
mov r3.xyw, r4.wywx
movc r3.xyzw, r1.wwww, r4.yzxw, r3.yzxw  // r3.x <- Q.y; r3.y <- Q.z; r3.z <- Q.x; r3.w <- Q.w

#line 182
min r1.w, r3.x, r3.w
add r1.w, -r1.w, r3.z  // r1.w <- C

#line 183
mad r4.x, r1.w, l(6.000000), l(0.000000)
add r3.w, -r3.x, r3.w
div r3.w, r3.w, r4.x
add r3.w, r3.y, r3.w
mov r3.x, |r3.w|  // r3.x <- H

#line 224
add r3.w, r3.z, l(0.000000)
div r3.y, r1.w, r3.w  // r3.y <- S

#line 264
add r3.xyz, r1.xzzx, r3.xyzx

#line 172
frc r1.w, r3.x  // r1.w <- H

#line 174
mad r1.w, r1.w, l(6.000000), l(-2.000000)
add_sat r1.w, -|r1.w|, l(2.000000)  // r1.w <- <HUEtoRGB_id8 return value>.y

#line 219
add r1.w, r1.w, l(-1.000000)
mad r1.w, r1.w, r3.y, l(1.000000)
mul r0.y, r3.z, r1.w  // r0.y <- <HSVtoRGB_id9 return value>.y

#line 180
lt r1.w, r0.y, r0.x
mov r3.xy, r0.yxyy
mov r0.zw, l(0,0,-1.000000,0.666667)
mov r3.zw, l(0,0,0,-0.333333)
movc r0.xyzw, r1.wwww, r0.xyzw, r3.xyzw  // r0.x <- P.x; r0.y <- P.y; r0.z <- P.z; r0.w <- P.w
lt r1.w, r2.x, r2.y
mov r3.xy, r2.yxyy
mov r4.xy, r3.yxyy
mov r3.zw, l(0,0,-1.000000,0.666667)
mov r4.zw, l(0,0,0,-0.333333)
movc r3.xyzw, r1.wwww, r3.xyzw, r4.xyzw  // r3.x <- P.x; r3.y <- P.y; r3.z <- P.z; r3.w <- P.w; r3.x <- P.x; r3.y <- P.y; r3.z <- P.z; r3.w <- P.w

#line 181
lt r1.w, r2.w, r3.x
mov r2.xyz, r3.xywx
mov r3.xyw, r2.wywx
movc r2.xyzw, r1.wwww, r2.yzxw, r3.yzxw  // r2.x <- Q.y; r2.y <- Q.z; r2.z <- Q.x; r2.w <- Q.w; r2.x <- Q.y; r2.y <- Q.z; r2.z <- Q.x; r2.w <- Q.w

#line 182
min r1.w, r2.x, r2.w
add r1.w, -r1.w, r2.z  // r1.w <- C; r1.w <- C

#line 183
mad r3.x, r1.w, l(6.000000), l(0.000000)
add r2.w, -r2.x, r2.w
div r2.w, r2.w, r3.x
add r2.w, r2.y, r2.w
mov r2.x, |r2.w|  // r2.x <- H; r2.x <- H

#line 224
add r2.w, r2.z, l(0.000000)
div r2.y, r1.w, r2.w  // r2.y <- S; r2.y <- S

#line 264
add r2.xyz, r1.xzzx, r2.xyzx

#line 172
frc r1.w, r2.x  // r1.w <- H

#line 173
mad r1.w, r1.w, l(6.000000), l(-3.000000)
add_sat r1.w, |r1.w|, l(-1.000000)  // r1.w <- <HUEtoRGB_id8 return value>.x

#line 219
add r1.w, r1.w, l(-1.000000)
mad r1.w, r1.w, r2.y, l(1.000000)
mul r2.w, r2.z, r1.w  // r2.w <- <HSVtoRGB_id9 return value>.x

#line 181
lt r1.w, r2.w, r0.x
mov r2.xyz, r0.xywx
mov r0.xyw, r2.wywx
movc r0.xyzw, r1.wwww, r2.yzxw, r0.yzxw  // r0.x <- Q.y; r0.y <- Q.z; r0.z <- Q.x; r0.w <- Q.w

#line 182
min r1.w, r0.x, r0.w
add r1.w, r0.z, -r1.w  // r1.w <- C

#line 183
mad r2.x, r1.w, l(6.000000), l(0.000000)
add r0.w, -r0.x, r0.w
div r0.w, r0.w, r2.x
add r0.w, r0.y, r0.w
mov r0.x, |r0.w|  // r0.x <- H

#line 224
add r0.w, r0.z, l(0.000000)
div r0.y, r1.w, r0.w  // r0.y <- S

#line 285
add r0.xyz, r0.xyzx, -r1.xyzx

#line 172
frc r0.x, r0.x  // r0.x <- H

#line 175
mad r1.xyz, r0.xxxx, l(6.000000, 6.000000, 6.000000, 0.000000), l(-3.000000, -2.000000, -4.000000, 0.000000)

#line 176
mad_sat r1.xyz, |r1.xyzx|, l(1.000000, -1.000000, -1.000000, 0.000000), l(-1.000000, 2.000000, 2.000000, 0.000000)  // r1.x <- <HUEtoRGB_id8 return value>.x; r1.y <- <HUEtoRGB_id8 return value>.y; r1.z <- <HUEtoRGB_id8 return value>.z

#line 219
add r1.xyz, r1.xyzx, l(-1.000000, -1.000000, -1.000000, 0.000000)
mad r0.xyw, r1.xyxz, r0.yyyy, l(1.000000, 1.000000, 0.000000, 1.000000)

#line 295
mad r0.xyz, r0.xywx, r0.zzzz, -r5.xyzx
mov r0.w, l(0)
mad o0.xyzw, cb0[0].xyzw, r0.xyzw, r5.xyzw

#line 304
ret 
// Approximately 117 instruction slots used
***************************
*************************/
static const float Epsilon_id83 = 0.0000000596;
struct PS_STREAMS 
{
    float2 TexCoord_id62;
    float Input_1_id109;
    float Input_2_id103;
    float Input_0_id97;
    float4 Input_3_id91;
    float4 ColorTarget_id2;
};
struct PS_OUTPUT 
{
    float4 ColorTarget_id2 : SV_Target0;
};
struct PS_INPUT 
{
    float4 ShadingPosition_id0 : SV_Position;
    float2 TexCoord_id62 : TEXCOORD0;
};
struct VS_STREAMS 
{
    float4 Position_id72;
    float2 TexCoord_id62;
    float4 ShadingPosition_id0;
};
struct VS_OUTPUT 
{
    float4 ShadingPosition_id0 : SV_Position;
    float2 TexCoord_id62 : TEXCOORD0;
};
struct VS_INPUT 
{
    float4 Position_id72 : POSITION;
    float2 TexCoord_id62 : TEXCOORD0;
};
cbuffer PerDraw 
{
    float4x4 MatrixTransform_id73;
};
cbuffer PerUpdate 
{
    float4 InputValue_id92;
    float InputValue_id98;
    float InputValue_id104;
    float InputValue_id110;
};
cbuffer PerView 
{
    float NearClipPlane_id74 = 1.0f;
    float FarClipPlane_id75 = 100.0f;
    float2 ZProjection_id76;
    float2 ViewSize_id77;
    float AspectRatio_id78;
};
cbuffer Globals 
{
    float2 Texture0TexelSize_id15;
    float2 Texture1TexelSize_id17;
    float2 Texture2TexelSize_id19;
    float2 Texture3TexelSize_id21;
    float2 Texture4TexelSize_id23;
    float2 Texture5TexelSize_id25;
    float2 Texture6TexelSize_id27;
    float2 Texture7TexelSize_id29;
    float2 Texture8TexelSize_id31;
    float2 Texture9TexelSize_id33;
};
Texture2D Texture0_id14;
Texture2D Texture1_id16;
Texture2D Texture2_id18;
Texture2D Texture3_id20;
Texture2D Texture4_id22;
Texture2D Texture5_id24;
Texture2D Texture6_id26;
Texture2D Texture7_id28;
Texture2D Texture8_id30;
Texture2D Texture9_id32;
TextureCube TextureCube0_id34;
TextureCube TextureCube1_id35;
TextureCube TextureCube2_id36;
TextureCube TextureCube3_id37;
Texture3D Texture3D0_id38;
Texture3D Texture3D1_id39;
Texture3D Texture3D2_id40;
Texture3D Texture3D3_id41;
SamplerState Sampler_id42;
SamplerState PointSampler_id43 
{
    Filter = MIN_MAG_MIP_POINT;
};
SamplerState LinearSampler_id44 
{
    Filter = MIN_MAG_MIP_LINEAR;
};
SamplerState LinearBorderSampler_id45 
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Border;
    AddressV = Border;
};
SamplerComparisonState LinearClampCompareLessEqualSampler_id46 
{
    Filter = COMPARISON_MIN_MAG_LINEAR_MIP_POINT;
    AddressU = Clamp;
    AddressV = Clamp;
    ComparisonFunc = LessEqual;
};
SamplerState AnisotropicSampler_id47 
{
    Filter = ANISOTROPIC;
};
SamplerState AnisotropicRepeatSampler_id48 
{
    Filter = ANISOTROPIC;
    AddressU = Wrap;
    AddressV = Wrap;
    MaxAnisotropy = 16;
};
SamplerState PointRepeatSampler_id49 
{
    Filter = MIN_MAG_MIP_POINT;
    AddressU = Wrap;
    AddressV = Wrap;
};
SamplerState LinearRepeatSampler_id50 
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};
SamplerState RepeatSampler_id51 
{
    AddressU = Wrap;
    AddressV = Wrap;
};
SamplerState Sampler0_id52;
SamplerState Sampler1_id53;
SamplerState Sampler2_id54;
SamplerState Sampler3_id55;
SamplerState Sampler4_id56;
SamplerState Sampler5_id57;
SamplerState Sampler6_id58;
SamplerState Sampler7_id59;
SamplerState Sampler8_id60;
SamplerState Sampler9_id61;
float Compute_id53()
{
    return InputValue_id104;
}
float Compute_id44()
{
    return InputValue_id98;
}
void Compute_id56(inout PS_STREAMS streams)
{
    streams.Input_2_id103 = Compute_id53();
}
void Compute_id47(inout PS_STREAMS streams)
{
    streams.Input_0_id97 = Compute_id44();
}
float Compute_id62()
{
    return InputValue_id110;
}
float4 Compute_id35()
{
    return InputValue_id92;
}
float3 HUEtoRGB_id8(in float H)
{
    H = frac(H);
    float R = abs(H * 6 - 3) - 1;
    float G = 2 - abs(H * 6 - 2);
    float B = 2 - abs(H * 6 - 4);
    return saturate(float3(R, G, B));
}
float3 RGBtoHCV_id11(in float3 RGB)
{
    float4 P = (RGB.g < RGB.b) ? float4(RGB.bg, -1.0, 2.0 / 3.0) : float4(RGB.gb, 0.0, -1.0 / 3.0);
    float4 Q = (RGB.r < P.x) ? float4(P.xyw, RGB.r) : float4(RGB.r, P.yzx);
    float C = Q.x - min(Q.w, Q.y);
    float H = abs((Q.w - Q.y) / (6 * C + Epsilon_id83) + Q.z);
    return float3(H, C, Q.x);
}
float Compute_id59(inout PS_STREAMS streams)
{
    return streams.Input_2_id103;
}
void Compute_id58(inout PS_STREAMS streams)
{

    {
        Compute_id56(streams);
    }
}
float Compute_id50(inout PS_STREAMS streams)
{
    return streams.Input_0_id97;
}
void Compute_id49(inout PS_STREAMS streams)
{

    {
        Compute_id47(streams);
    }
}
void Compute_id65(inout PS_STREAMS streams)
{
    streams.Input_1_id109 = Compute_id62();
}
void Compute_id38(inout PS_STREAMS streams)
{
    streams.Input_3_id91 = Compute_id35();
}
float3 HSVtoRGB_id9(in float3 HSV)
{
    float3 RGB = HUEtoRGB_id8(HSV.x);
    return ((RGB - 1) * HSV.y + 1) * HSV.z;
}
float3 RGBtoHSV_id12(in float3 RGB)
{
    float3 HCV = RGBtoHCV_id11(RGB);
    float S = HCV.y / (HCV.z + Epsilon_id83);
    return float3(HCV.x, S, HCV.z);
}
float Compute_id33(inout PS_STREAMS streams)
{
    Compute_id58(streams);
    return Compute_id59(streams);
}
float Compute_id32(inout PS_STREAMS streams)
{
    Compute_id49(streams);
    return Compute_id50(streams);
}
float Compute_id68(inout PS_STREAMS streams)
{
    return streams.Input_1_id109;
}
void Compute_id67(inout PS_STREAMS streams)
{

    {
        Compute_id65(streams);
    }
}
float4 Compute_id41(inout PS_STREAMS streams)
{
    return streams.Input_3_id91;
}
void Compute_id40(inout PS_STREAMS streams)
{

    {
        Compute_id38(streams);
    }
}
float4 ts_id29(inout PS_STREAMS streams, Texture2D tex2d, float2 uv, float hue, float2 offset)
{
    float2 dir = sin((Compute_id32(streams) + float2(0, .25)) * 2 * acos(-1));
    uv += dir * offset;
    float3 col = tex2d.SampleLevel(Sampler0_id52, uv, 0).rgb;
    return float4(HSVtoRGB_id9(float3(Compute_id33(streams), 0, 0) + RGBtoHSV_id12(col)), 1);
}
float Compute_id34(inout PS_STREAMS streams)
{
    Compute_id67(streams);
    return Compute_id68(streams);
}
float4 Compute_id31(inout PS_STREAMS streams)
{
    Compute_id40(streams);
    return Compute_id41(streams);
}
float4 Filter_id30(inout PS_STREAMS streams, float4 tex0col)
{
    float4 c = tex0col;
    float2 uv = streams.TexCoord_id62;
    float shift = Compute_id34(streams);
    float hue = Compute_id33(streams);
    c.r = ts_id29(streams, Texture0_id14, uv, hue, shift * .1).r;
    c.g = ts_id29(streams, Texture0_id14, uv, hue, shift * 0).g;
    c.b = ts_id29(streams, Texture0_id14, uv, hue, shift * -.1).b;
    c.rgb = HSVtoRGB_id9(-float3(hue, 0, 0) + RGBtoHSV_id12(c.rgb));
    return c;
}
float4 InTex0_id26(inout PS_STREAMS streams)
{
    return Texture0_id14.SampleLevel(Sampler0_id52, streams.TexCoord_id62, 0);
}
float4 Shading_id28(inout PS_STREAMS streams)
{
    float4 col = InTex0_id26(streams);
    return lerp(col, Filter_id30(streams, col), Compute_id31(streams));
}
PS_OUTPUT PSMain(PS_INPUT __input__)
{
    PS_STREAMS streams = (PS_STREAMS)0;
    streams.TexCoord_id62 = __input__.TexCoord_id62;
    streams.ColorTarget_id2 = Shading_id28(streams);
    PS_OUTPUT __output__ = (PS_OUTPUT)0;
    __output__.ColorTarget_id2 = streams.ColorTarget_id2;
    return __output__;
}
VS_OUTPUT VSMain(VS_INPUT __input__)
{
    VS_STREAMS streams = (VS_STREAMS)0;
    streams.Position_id72 = __input__.Position_id72;
    streams.TexCoord_id62 = __input__.TexCoord_id62;
    streams.ShadingPosition_id0 = mul(streams.Position_id72, MatrixTransform_id73);
    VS_OUTPUT __output__ = (VS_OUTPUT)0;
    __output__.ShadingPosition_id0 = streams.ShadingPosition_id0;
    __output__.TexCoord_id62 = streams.TexCoord_id62;
    return __output__;
}
