/**************************
***** Compiler Parameters *****
***************************
@P EffectName: TextureFXEffect
@P   - EffectNodeBase.EffectNodeBaseShader: mixin Electricity_Internal_TextureFX [{BackgroundColor = mixin DoFloat4 [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat4<Input_0> [{Value = InputFloat4<ShaderFX.InputValueFloat4_Color,PerUpdate>}]]}]}, {Value = GetVarFloat4<Input_0>}]}, {ElectricityColor = mixin DoFloat4 [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat4<Input_1> [{Value = InputFloat4<ShaderFX.InputValueFloat4_Color.i1,PerUpdate>}]]}]}, {Value = GetVarFloat4<Input_1>}]}]
@P BackgroundColor: mixin DoFloat4 [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat4<Input_0> [{Value = InputFloat4<ShaderFX.InputValueFloat4_Color,PerUpdate>}]]}]}, {Value = GetVarFloat4<Input_0>}]
@P ElectricityColor: mixin DoFloat4 [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat4<Input_1> [{Value = InputFloat4<ShaderFX.InputValueFloat4_Color.i1,PerUpdate>}]]}]}, {Value = GetVarFloat4<Input_1>}]
***************************
****  ConstantBuffers  ****
***************************
cbuffer PerDraw [Size: 64]
@C    MatrixTransform_id73 => SpriteBase.MatrixTransform
cbuffer PerUpdate [Size: 32]
@C    InputValue_id98 => ShaderFX.InputValueFloat4_Color
@C    InputValue_id104 => ShaderFX.InputValueFloat4_Color.i1
cbuffer Globals [Size: 112]
@C    Texture0TexelSize_id15 => Texturing.Texture0TexelSize
@C    Texture1TexelSize_id17 => Texturing.Texture1TexelSize
@C    Texture2TexelSize_id19 => Texturing.Texture2TexelSize
@C    Texture3TexelSize_id21 => Texturing.Texture3TexelSize
@C    Texture4TexelSize_id23 => Texturing.Texture4TexelSize
@C    Texture5TexelSize_id25 => Texturing.Texture5TexelSize
@C    Texture6TexelSize_id27 => Texturing.Texture6TexelSize
@C    Texture7TexelSize_id29 => Texturing.Texture7TexelSize
@C    Texture8TexelSize_id31 => Texturing.Texture8TexelSize
@C    Texture9TexelSize_id33 => Texturing.Texture9TexelSize
@C    Time_id87 => Electricity_Internal_TextureFX.Time
@C    Height_id91 => Electricity_Internal_TextureFX.Height
@C    VertexNoise_id92 => Electricity_Internal_TextureFX.VertexNoise
@C    GlowStrength_id93 => Electricity_Internal_TextureFX.GlowStrength
@C    GlowFallOff_id94 => Electricity_Internal_TextureFX.GlowFallOff
@C    AmbientGlow_id95 => Electricity_Internal_TextureFX.AmbientGlow
@C    AmbientGlowHeightScale_id96 => Electricity_Internal_TextureFX.AmbientGlowHeightScale
***************************
******  Resources    ******
***************************
@R    PerDraw => PerDraw [Stage: Vertex, Slot: (0-0)]
@R    LinearRepeatSampler_id50 => Texturing.LinearRepeatSampler [Stage: Pixel, Slot: (0-0)]
@R    NoiseTexture_id88 => Electricity_Internal_TextureFX.NoiseTexture [Stage: Pixel, Slot: (0-0)]
@R    PerUpdate => PerUpdate [Stage: Pixel, Slot: (0-0)]
@R    Globals => Globals [Stage: Pixel, Slot: (1-1)]
***************************
*****     Sources     *****
***************************
@S    Electricity_Internal_TextureFX => c53e86da01222b28e0d1f3bab7bd2865
@S    TextureFX => 27bb4f1f808a5eedf6dfeaa75c669c29
@S    ImageEffectShader => 8064e30cc02e5eb4052f420259dbf05e
@S    SpriteBase => 5a7aa9dfd5b5c7613053f4f66c79ca0d
@S    ShaderBase => 4ecbcd2528b64a79eebe81a863892d8c
@S    ShaderBaseStream => b705b699a7385d39c7de52a8d13f3978
@S    Texturing => 91ef3011c1071c2e5d41cd3ee0418b18
@S    Camera => f5d1a113ef7a27319900e8cc2e11ae0d
@S    ShaderUtils => 27e27e08e991883f970444d1aebe3b58
@S    ComputeColor => c875a0e093379dd74cd9a5a73aca830f
@S    DoFloat4 => 312f1c610231ffe618620ce43634d0aa
@S    ComputeFloat4 => f871947e9f604da432ea9fc3c9cb4363
@S    ComputeVoid => b62583a94b8503c79e9107f4b5bc9392
@S    ComputeOrder => 1d9b1cd3f5e3ad3f3f10e4fc88326cc7
@S    AssignVarFloat4 => 3a0c495ce724365e837c33156190acbe
@S    StreamVariableFloat4 => 2bfe58666cb67eed05b9410465550725
@S    InputFloat4 => f6891eacc9ea2d912dcfded49ea96a71
@S    DeclFloat4 => 03cb445d0e450d0a37ad5f24c8a93feb
@S    GetVarFloat4 => 2805d4f95c82389ce488a02bbf6e99f5
***************************
*****     Stages      *****
***************************
@G    Vertex => 79eb7ff071584feaa45b858a38e87b6a
//
// Generated by Microsoft (R) HLSL Shader Compiler 10.1
//
//
// Buffer Definitions: 
//
// cbuffer PerDraw
// {
//
//   float4x4 MatrixTransform_id73;     // Offset:    0 Size:    64
//
// }
//
//
// Resource Bindings:
//
// Name                                 Type  Format         Dim      HLSL Bind  Count
// ------------------------------ ---------- ------- ----------- -------------- ------
// PerDraw                           cbuffer      NA          NA            cb0      1 
//
//
//
// Input signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// POSITION                 0   xyzw        0     NONE   float   xyzw
// TEXCOORD                 0   xy          1     NONE   float   xy  
//
//
// Output signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// SV_Position              0   xyzw        0      POS   float   xyzw
// TEXCOORD                 0   xy          1     NONE   float   xy  
//
vs_5_0
dcl_globalFlags refactoringAllowed
dcl_constantbuffer CB0[4], immediateIndexed
dcl_input v0.xyzw
dcl_input v1.xy
dcl_output_siv o0.xyzw, position
dcl_output o1.xy
//
// Initial variable locations:
//   v0.x <- __input__.Position_id72.x; v0.y <- __input__.Position_id72.y; v0.z <- __input__.Position_id72.z; v0.w <- __input__.Position_id72.w; 
//   v1.x <- __input__.TexCoord_id62.x; v1.y <- __input__.TexCoord_id62.y; 
//   o1.x <- <VSMain return value>.TexCoord_id62.x; o1.y <- <VSMain return value>.TexCoord_id62.y; 
//   o0.x <- <VSMain return value>.ShadingPosition_id0.x; o0.y <- <VSMain return value>.ShadingPosition_id0.y; o0.z <- <VSMain return value>.ShadingPosition_id0.z; o0.w <- <VSMain return value>.ShadingPosition_id0.w
//
#line 228 "C:\Users\alex\Documents\vvvv\gamma\Exports\5sun2\log\shader_TextureFXEffect_250795f73f29ab381c66e9cccffdfcf6.hlsl"
dp4 o0.x, v0.xyzw, cb0[0].xyzw
dp4 o0.y, v0.xyzw, cb0[1].xyzw
dp4 o0.z, v0.xyzw, cb0[2].xyzw
dp4 o0.w, v0.xyzw, cb0[3].xyzw

#line 232
mov o1.xy, v1.xyxx
ret 
// Approximately 6 instruction slots used
@G    Pixel => 444de8d89bd9b895b092e1f2ebddfe43
//
// Generated by Microsoft (R) HLSL Shader Compiler 10.1
//
//
// Buffer Definitions: 
//
// cbuffer PerUpdate
// {
//
//   float4 InputValue_id98;            // Offset:    0 Size:    16
//   float4 InputValue_id104;           // Offset:   16 Size:    16
//
// }
//
// cbuffer Globals
// {
//
//   float2 Texture0TexelSize_id15;     // Offset:    0 Size:     8 [unused]
//   float2 Texture1TexelSize_id17;     // Offset:    8 Size:     8 [unused]
//   float2 Texture2TexelSize_id19;     // Offset:   16 Size:     8 [unused]
//   float2 Texture3TexelSize_id21;     // Offset:   24 Size:     8 [unused]
//   float2 Texture4TexelSize_id23;     // Offset:   32 Size:     8 [unused]
//   float2 Texture5TexelSize_id25;     // Offset:   40 Size:     8 [unused]
//   float2 Texture6TexelSize_id27;     // Offset:   48 Size:     8 [unused]
//   float2 Texture7TexelSize_id29;     // Offset:   56 Size:     8 [unused]
//   float2 Texture8TexelSize_id31;     // Offset:   64 Size:     8 [unused]
//   float2 Texture9TexelSize_id33;     // Offset:   72 Size:     8 [unused]
//   float Time_id87;                   // Offset:   80 Size:     4
//   float Height_id91;                 // Offset:   84 Size:     4
//      = 0x3e800000 
//   float VertexNoise_id92;            // Offset:   88 Size:     4
//      = 0x3f000000 
//   float GlowStrength_id93;           // Offset:   92 Size:     4
//      = 0x3f000000 
//   float GlowFallOff_id94;            // Offset:   96 Size:     4
//      = 0x3f000000 
//   float AmbientGlow_id95;            // Offset:  100 Size:     4
//      = 0x3e800000 
//   float AmbientGlowHeightScale_id96; // Offset:  104 Size:     4
//      = 0x3f000000 
//
// }
//
//
// Resource Bindings:
//
// Name                                 Type  Format         Dim      HLSL Bind  Count
// ------------------------------ ---------- ------- ----------- -------------- ------
// LinearRepeatSampler_id50          sampler      NA          NA             s0      1 
// NoiseTexture_id88                 texture  float4          3d             t0      1 
// PerUpdate                         cbuffer      NA          NA            cb0      1 
// Globals                           cbuffer      NA          NA            cb1      1 
//
//
//
// Input signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// SV_Position              0   xyzw        0      POS   float       
// TEXCOORD                 0   xy          1     NONE   float   xy  
//
//
// Output signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// SV_Target                0   xyzw        0   TARGET   float   xyzw
//
ps_5_0
dcl_globalFlags refactoringAllowed
dcl_constantbuffer CB0[2], immediateIndexed
dcl_constantbuffer CB1[7], immediateIndexed
dcl_sampler s0, mode_default
dcl_resource_texture3d (float,float,float,float) t0
dcl_input_ps linear v1.xy
dcl_output o0.xyzw
dcl_temps 2
//
// Initial variable locations:
//   v0.x <- __input__.ShadingPosition_id0.x; v0.y <- __input__.ShadingPosition_id0.y; v0.z <- __input__.ShadingPosition_id0.z; v0.w <- __input__.ShadingPosition_id0.w; 
//   v1.x <- __input__.TexCoord_id62.x; v1.y <- __input__.TexCoord_id62.y; 
//   o0.x <- <PSMain return value>.ColorTarget_id2.x; o0.y <- <PSMain return value>.ColorTarget_id2.y; o0.z <- <PSMain return value>.ColorTarget_id2.z; o0.w <- <PSMain return value>.ColorTarget_id2.w
//
#line 203 "C:\Users\alex\Documents\vvvv\gamma\Exports\5sun2\log\shader_TextureFXEffect_250795f73f29ab381c66e9cccffdfcf6.hlsl"
mov r0.w, cb1[5].x

#line 199
add r1.xy, v1.xyxx, l(-0.500000, -0.500000, 0.000000, 0.000000)  // r1.x <- uv.x; r1.y <- uv.y

#line 200
mad r0.y, -cb1[5].z, |r1.y|, cb1[5].x  // r0.y <- t.x

#line 202
add r0.x, r1.y, r1.x  // r0.x <- xs1

#line 204
sample_l_indexable(texture3d)(float,float,float,float) r1.z, r0.xywx, t0.yzxw, s0, l(0.000000)  // r1.z <- noise1

#line 206
mad r0.x, -r0.x, r0.x, l(1.000000)
mad r1.z, r1.z, l(2.000000), l(-1.000000)
mul r1.z, r1.z, cb1[5].y

#line 208
mad r0.x, -r1.z, r0.x, r1.y

#line 203
add r0.z, v1.x, l(-0.500000)
sample_l_indexable(texture3d)(float,float,float,float) r0.y, r0.zywz, t0.yxzw, s0, l(0.000000)  // r0.y <- noise0

#line 205
mad r0.y, r0.y, l(2.000000), l(-1.000000)
mul r0.y, r0.y, cb1[5].y
mad r0.z, -r1.x, r1.x, l(1.000000)

#line 207
mad r0.y, -r0.y, r0.z, r1.y

#line 210
mul r0.z, r0.z, cb1[6].y
mul r0.w, r1.y, r1.y

#line 209
mad r0.x, |r0.y|, l(3.000000), |r0.x|
mul r0.x, r0.x, l(0.500000)
log r0.x, r0.x
mul r0.y, cb1[6].x, l(0.100000)
mul r0.x, r0.x, r0.y
exp r0.x, r0.x
add r0.x, -r0.x, l(1.000000)  // r0.x <- glow

#line 211
mul r0.x, r0.x, r0.x
mul r0.x, r0.x, cb1[5].w

#line 210
mul r0.y, cb1[6].z, cb1[6].z
mad r0.y, -r0.w, r0.y, l(1.000000)
mul r0.y, r0.y, r0.z  // r0.y <- ambGlow

#line 211
mul r0.y, r0.y, r0.y
mad r0.x, r0.x, l(20.000000), r0.y  // r0.x <- s

#line 212
mul r0.x, r0.x, r0.x
add r1.xyzw, -cb0[0].xyzw, cb0[1].xyzw
mad o0.xyzw, r0.xxxx, r1.xyzw, cb0[0].xyzw

#line 221
ret 
// Approximately 35 instruction slots used
***************************
*************************/
struct PS_STREAMS 
{
    float2 TexCoord_id62;
    float4 Input_0_id97;
    float4 Input_1_id103;
    float4 ColorTarget_id2;
};
struct PS_OUTPUT 
{
    float4 ColorTarget_id2 : SV_Target0;
};
struct PS_INPUT 
{
    float4 ShadingPosition_id0 : SV_Position;
    float2 TexCoord_id62 : TEXCOORD0;
};
struct VS_STREAMS 
{
    float4 Position_id72;
    float2 TexCoord_id62;
    float4 ShadingPosition_id0;
};
struct VS_OUTPUT 
{
    float4 ShadingPosition_id0 : SV_Position;
    float2 TexCoord_id62 : TEXCOORD0;
};
struct VS_INPUT 
{
    float4 Position_id72 : POSITION;
    float2 TexCoord_id62 : TEXCOORD0;
};
cbuffer PerDraw 
{
    float4x4 MatrixTransform_id73;
};
cbuffer PerUpdate 
{
    float4 InputValue_id98;
    float4 InputValue_id104;
};
cbuffer PerView 
{
    float NearClipPlane_id74 = 1.0f;
    float FarClipPlane_id75 = 100.0f;
    float2 ZProjection_id76;
    float2 ViewSize_id77;
    float AspectRatio_id78;
};
cbuffer Globals 
{
    float2 Texture0TexelSize_id15;
    float2 Texture1TexelSize_id17;
    float2 Texture2TexelSize_id19;
    float2 Texture3TexelSize_id21;
    float2 Texture4TexelSize_id23;
    float2 Texture5TexelSize_id25;
    float2 Texture6TexelSize_id27;
    float2 Texture7TexelSize_id29;
    float2 Texture8TexelSize_id31;
    float2 Texture9TexelSize_id33;
    float Time_id87;
    float Height_id91 = 0.25f;
    float VertexNoise_id92 = 0.5f;
    float GlowStrength_id93 = 0.5f;
    float GlowFallOff_id94 = 0.5f;
    float AmbientGlow_id95 = 0.25f;
    float AmbientGlowHeightScale_id96 = 0.5f;
};
Texture2D Texture0_id14;
Texture2D Texture1_id16;
Texture2D Texture2_id18;
Texture2D Texture3_id20;
Texture2D Texture4_id22;
Texture2D Texture5_id24;
Texture2D Texture6_id26;
Texture2D Texture7_id28;
Texture2D Texture8_id30;
Texture2D Texture9_id32;
TextureCube TextureCube0_id34;
TextureCube TextureCube1_id35;
TextureCube TextureCube2_id36;
TextureCube TextureCube3_id37;
Texture3D Texture3D0_id38;
Texture3D Texture3D1_id39;
Texture3D Texture3D2_id40;
Texture3D Texture3D3_id41;
SamplerState Sampler_id42;
SamplerState PointSampler_id43 
{
    Filter = MIN_MAG_MIP_POINT;
};
SamplerState LinearSampler_id44 
{
    Filter = MIN_MAG_MIP_LINEAR;
};
SamplerState LinearBorderSampler_id45 
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Border;
    AddressV = Border;
};
SamplerComparisonState LinearClampCompareLessEqualSampler_id46 
{
    Filter = COMPARISON_MIN_MAG_LINEAR_MIP_POINT;
    AddressU = Clamp;
    AddressV = Clamp;
    ComparisonFunc = LessEqual;
};
SamplerState AnisotropicSampler_id47 
{
    Filter = ANISOTROPIC;
};
SamplerState AnisotropicRepeatSampler_id48 
{
    Filter = ANISOTROPIC;
    AddressU = Wrap;
    AddressV = Wrap;
    MaxAnisotropy = 16;
};
SamplerState PointRepeatSampler_id49 
{
    Filter = MIN_MAG_MIP_POINT;
    AddressU = Wrap;
    AddressV = Wrap;
};
SamplerState LinearRepeatSampler_id50 
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};
SamplerState RepeatSampler_id51 
{
    AddressU = Wrap;
    AddressV = Wrap;
};
SamplerState Sampler0_id52;
SamplerState Sampler1_id53;
SamplerState Sampler2_id54;
SamplerState Sampler3_id55;
SamplerState Sampler4_id56;
SamplerState Sampler5_id57;
SamplerState Sampler6_id58;
SamplerState Sampler7_id59;
SamplerState Sampler8_id60;
SamplerState Sampler9_id61;
Texture3D NoiseTexture_id88;
float4 Compute_id40()
{
    return InputValue_id104;
}
float4 Compute_id31()
{
    return InputValue_id98;
}
void Compute_id43(inout PS_STREAMS streams)
{
    streams.Input_1_id103 = Compute_id40();
}
void Compute_id34(inout PS_STREAMS streams)
{
    streams.Input_0_id97 = Compute_id31();
}
float4 Compute_id46(inout PS_STREAMS streams)
{
    return streams.Input_1_id103;
}
void Compute_id45(inout PS_STREAMS streams)
{

    {
        Compute_id43(streams);
    }
}
float4 Compute_id37(inout PS_STREAMS streams)
{
    return streams.Input_0_id97;
}
void Compute_id36(inout PS_STREAMS streams)
{

    {
        Compute_id34(streams);
    }
}
float4 Compute_id30(inout PS_STREAMS streams)
{
    Compute_id45(streams);
    return Compute_id46(streams);
}
float4 Compute_id29(inout PS_STREAMS streams)
{
    Compute_id36(streams);
    return Compute_id37(streams);
}
float4 Shading_id28(inout PS_STREAMS streams)
{
    float2 uv = streams.TexCoord_id62 - 0.5;
    float2 t = float2(Time_id87 - VertexNoise_id92 * abs(uv.y), Time_id87);
    float xs0 = uv.x;
    float xs1 = uv.x + uv.y;
    float noise0 = NoiseTexture_id88.SampleLevel(LinearRepeatSampler_id50, float3(xs0, t), 0).x;
    float noise1 = NoiseTexture_id88.SampleLevel(LinearRepeatSampler_id50, float3(xs1, t), 0).x;
    float mid0 = Height_id91 * (noise0 * 2 - 1) * (1 - xs0 * xs0);
    float mid1 = Height_id91 * (noise1 * 2 - 1) * (1 - xs1 * xs1);
    float dist0 = abs(uv.y - mid0);
    float dist1 = abs(uv.y - mid1);
    float glow = 1.0 - pow(0.5 * (3 * dist0 + dist1), GlowFallOff_id94 / 10.0);
    float ambGlow = AmbientGlow_id95 * (1 - uv.x * uv.x) * (1 - AmbientGlowHeightScale_id96 * AmbientGlowHeightScale_id96 * uv.y * uv.y);
    float s = GlowStrength_id93 * glow * glow * 20 + ambGlow * ambGlow;
    return lerp(Compute_id29(streams), Compute_id30(streams), s * s);
}
PS_OUTPUT PSMain(PS_INPUT __input__)
{
    PS_STREAMS streams = (PS_STREAMS)0;
    streams.TexCoord_id62 = __input__.TexCoord_id62;
    streams.ColorTarget_id2 = Shading_id28(streams);
    PS_OUTPUT __output__ = (PS_OUTPUT)0;
    __output__.ColorTarget_id2 = streams.ColorTarget_id2;
    return __output__;
}
VS_OUTPUT VSMain(VS_INPUT __input__)
{
    VS_STREAMS streams = (VS_STREAMS)0;
    streams.Position_id72 = __input__.Position_id72;
    streams.TexCoord_id62 = __input__.TexCoord_id62;
    streams.ShadingPosition_id0 = mul(streams.Position_id72, MatrixTransform_id73);
    VS_OUTPUT __output__ = (VS_OUTPUT)0;
    __output__.ShadingPosition_id0 = streams.ShadingPosition_id0;
    __output__.TexCoord_id62 = streams.TexCoord_id62;
    return __output__;
}
