
.include "fb32x32.inc"

.include "globals.inc"


.segment "DATA"

width:
   .byte $00
pixelsleft:
   .byte $00

.segment "CODE"


scroll_setcolors:
   sta   colortext+1
   stx   colorbackground+1
   sty   colorshadow+1
   rts

scroll_settext:
   sta   text+1
   stx   text+2
   stz   pixelsleft
   rts

scroll_setfb:
   sta   scrvec0+1
   stx   scrvec1+1
   sty   width
   rts

scroll_update:
scrvec0:
   lda   #$ff
   sta   vector+0
scrvec1:
   lda   #$ff
   sta   vector+1

   ; copy data 1 pixel to the left
   lda   width             ; width
   asl
   asl
   asl
   tax
   ldy   #$00
:
   iny
   lda   (vector),y
   dey
   sta   (vector),y
   iny
   dex
   bne   :-

   ; add new pixels on the right
   ldy   width
   dey

   ; step 1: check if pixel is by char
   lda   pixelsleft
   bne   nonewchar

text:
   lda   $ffff
   beq   notextleft
   inc   text+1
   bne   :+
   inc   text+2
:

   jsr   getchar
   sta   pixelsleft
notextleft:
   ldx   #$00
nonewchar:
   dec   pixelsleft
newloop:
   asl   charbuffer,x
   bcs   colortext

   ; step 2: check if shadow from pixel to left
   dey
   lda   (vector),y
   iny
   cmp   colortext+1
   beq   colorshadow

   ; step 3: then it's background
colorbackground:
   lda   #$00
   .byte $2c
colorshadow:
   lda   #$00
   .byte $2c
colortext:
   lda   #$00

   sta   (vector),y
   tya
   clc
   adc   width             ; next line
   tay
   inx
   cpx   #$08
   bcc   newloop
   rts
