
	org #8000

	;test code

begin

	ld hl,music_data
	call play
	ret
	
	
	
	;engine code

;squat by Shiru, 06'17
;Squeeker like, just without the output value table
;4 channels of tone with different duty cycle
;sample drums, non-interrupting
;customizeable noise percussion, interrupting


;music data is all 16-bit words, first control then a few optional ones

;control word is PSSSSSSS DDDN4321, where P=percussion,S=speed, D=drum, N=noise mode, 4321=channels
;D triggers non-interruping sample drum
;P trigger
;if 1, channel 1 freq follows
;if 2, channel 2 freq follows
;if 3, channel 3 freq follows
;if 4, channel 4 freq follows
;if N, channel 4 mode follows, it is either #0000 (normal) or #04cb (noise)
;if P, percussion follows, LSB=volume, MSB=pitch



RLC_H=#04cb			;to enable noise mode
NOP_2=#0000			;to disable noise mode
RLC_HL=#06cb		;to enable sample reading
ADD_IX_IX=#29dd		;to disable sample reading


play

	di
	
	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld (pattern_ptr),de
	
	ld e,(hl)
	inc hl
	ld d,(hl)
	
	ld (loop_ptr),de

	dec hl
	ld (sample_list),hl
	
	ld hl,ADD_IX_IX
	ld (sample_read),hl
	ld hl,NOP_2					;normal mode
	ld (noise_mode),hl
	
	ld ix,0						;needs to be 0 to skip sample reading

	ld c,0
	exx
	ld de,#0808					;sample bit counter and reload value

play_loop

pattern_ptr=$+1
	ld sp,0
	
return_loop

	pop bc						;control word
								;B=duration of the row (0=loop)
								;C=flags DDDN4321 (Drum, Noise, 1-4 channel update)
	ld a,b
	or a
	jp nz,no_loop
	
loop_ptr=$+1
	ld sp,0
	
	jp return_loop
	
no_loop

	ld a,c
	
	rra
	jr nc,skip_note_0
	
	pop hl
	ld (ch0_add),hl
	
skip_note_0

	rra
	jr nc,skip_note_1

	pop hl
	ld (ch1_add),hl
	
skip_note_1

	rra
	jr nc,skip_note_2
	
	pop hl
	ld (ch2_add),hl
	
skip_note_2

	rra
	jr nc,skip_note_3
	
	pop hl
	ld (ch3_add),hl
	
skip_note_3

	rra
	jr nc,skip_mode_change
	
	pop hl						;nop:nop or rlc h
	ld (noise_mode),hl

skip_mode_change

	and 7
	jp z,skip_drum
	
sample_list=$+1
	ld hl,0						;sample_list-2
	add a,a
	add a,l
	ld l,a
	ld a,(hl)
	inc l
	ld h,(hl)
	ld l,a
	ld (sample_ptr),hl
	ld hl,RLC_HL
	ld (sample_read),hl

skip_drum

	bit 7,b						;check percussion flag
	jp z,skip_percussion

	res 7,b						;clear percussion flag
	dec b						;compensate speed

	ld (noise_bc),bc
	ld (noise_de),de

	pop hl						;read percussion parameters

	ld a,l						;noise volume
	ld (noise_volume),a
	ld b,h						;noise pitch
	ld c,h
	ld de,#2174					;utz's rand seed			
	exx
	ld bc,811					;noise duration, takes as long as inner sound loop

noise_loop

	exx							;4
	dec c						;4
	jr nz,noise_skip			;7/12
	ld c,b						;4
	add hl,de					;11
	rlc h						;8		utz's noise generator idea
	inc d						;4		improves randomness
	jp noise_next				;10
	
noise_skip

	jr $+2						;12
	jr $+2						;12
	nop							;4
	nop							;4
	
noise_next

	ld a,h						;4
	
noise_volume=$+1
	cp #80						;7
	sbc a,a						;4
	out (#fe),a					;11
	exx							;4

	dec bc						;6
	ld a,b						;4
	or c						;4
	jp nz,noise_loop			;10=106t

	exx

noise_bc=$+1
	ld bc,0
noise_de=$+1
	ld de,0



skip_percussion

	ld (pattern_ptr),sp

sample_ptr=$+1
	ld hl,0

	ld c,0						;internal loop runs 256 times

sound_loop

sample_read=$
	rlc (hl)					;15 	rotate sample bits in place, rl (hl) or add ix,ix (dummy operation)
	sbc a,a						;4		sbc a,a to make bit into 0 or 255, or xor a to keep it 0

	dec e						;4--+	count bits
	jp z,sample_cycle			;10 |
	jp sample_next				;10

sample_cycle

	ld e,d						;4	|	reload counter
	inc hl						;6--+	advance pointer --24t

sample_next

	exx							;4		squeeker type unrolled code
	ld b,a						;4		sample mask
	xor a						;4
	
	ld sp,sound_list			;10
		
	pop de						;10		ch0_acc
	pop hl						;10		ch0_add
	add hl,de					;11
	rla							;4
	ld (ch0_acc),hl				;16
						
	pop de						;10		ch1_acc
	pop hl						;10		ch1_add
	add hl,de					;11
	rla							;4
	ld (ch1_acc),hl				;16
	
	pop de						;10		ch2_acc
	pop hl						;10		ch2_add
	add hl,de					;11
	rla							;4
	ld (ch2_acc),hl				;16

	pop de						;10		ch3_acc
	pop hl						;10		ch3_add
	add hl,de					;11
	
noise_mode=$
	ds 2,0						;8		rlc h for noise effects

	rla							;4
	ld (ch3_acc),hl				;16

	add a,c						;4		no table like in Squeeker, channels summed as is, for uneven 'volume'
	add a,#ff					;7
	sbc a,#ff					;7
	ld c,a						;4
	sbc a,a						;4

	or b						;4		mix sample
	
	out (#fe),a					;11
		
	exx							;4

	dec c						;4
	jp nz,sound_loop			;10=336t


	dec hl						;last byte of a 256/8 byte sample packet is #80 means it was the last packet
	ld a,(hl)
	inc hl
	cp #80
	jr nz,sample_no_stop

	ld hl,ADD_IX_IX
	ld (sample_read),hl			;disable sample reading

sample_no_stop

	djnz sound_loop

	ld (sample_ptr),hl
	
	jp play_loop
	
	
		
;variables in the sound_list can't be reordered because of stack-based fetching

sound_list

ch0_add		dw 0
ch0_acc		dw 0
ch1_add		dw 0
ch1_acc		dw 0
ch2_add		dw 0
ch2_acc		dw 0
ch3_add		dw 0
ch3_acc		dw 0


;compiled music data

	align 2

music_data
	dw .pattern
	dw .loop
;sample data

.sample_list
	dw .sample_1
	dw .sample_2
	dw .sample_3
	dw .sample_4
	dw .sample_5
	dw .sample_6
	dw .sample_7
	align 256/8

.sample_1
	db 2,0,17,223,255,255,255,255,250,128,0,0,0,0,127,228
	db 0,0,0,1,255,255,255,255,255,255,255,255,255,0,0,0
	db 0,0,0,0,0,0,3,191,255,254,128,0,0,0,255,255
	db 255,255,255,255,255,250,0,0,0,0,0,0,0,76,63,128
.sample_2
	db 0,0,20,0,15,160,4,128,0,255,254,0,0,0,13,255
	db 255,255,240,0,0,63,255,255,254,8,0,127,128,8,15,255
	db 0,39,160,27,128,0,0,0,16,63,255,84,32,0,0,1
	db 255,247,255,223,248,0,2,114,227,255,255,230,74,40,64,0
	db 8,128,239,127,242,0,0,0,13,94,245,255,142,129,1,0
	db 36,65,23,223,255,253,240,32,0,1,219,255,255,204,140,192
	db 0,35,234,246,168,4,81,185,208,1,0,2,4,32,183,44
	db 18,160,16,41,106,91,147,54,187,191,82,66,0,23,127,128
.sample_3
.sample_4
.sample_5
.sample_6
.sample_7


.pattern
.loop
	dw #337,#15a,#2b4,#40c,NOP_2
	dw #300
	dw #300
	dw #300
	dw #300
	dw #301,#0
	dw #301,#15a
	dw #300
	dw #301,#2b4
	dw #300
	dw #301,#15a
	dw #300
	dw #300
	dw #301,#0
	dw #301,#15a
	dw #301,#0
	dw #301,#15a
	dw #300
	dw #300
	dw #300
	dw #300
	dw #301,#0
	dw #301,#15a
	dw #300
	dw #301,#2b4
	dw #300
	dw #300
	dw #300
	dw #320
	dw #300
	dw #300
	dw #300
	dw #327,#103,#206,#308
	dw #300
	dw #300
	dw #300
	dw #300
	dw #301,#0
	dw #301,#103
	dw #300
	dw #301,#206
	dw #300
	dw #301,#103
	dw #300
	dw #300
	dw #301,#0
	dw #301,#103
	dw #301,#0
	dw #301,#103
	dw #300
	dw #300
	dw #300
	dw #300
	dw #301,#0
	dw #301,#103
	dw #300
	dw #301,#206
	dw #300
	dw #300
	dw #300
	dw #300
	dw #300
	dw #300
	dw #300
	dw #327,#cd,#337,#44a
	dw #300
	dw #300
	dw #300
	dw #300
	dw #301,#0
	dw #301,#cd
	dw #300
	dw #301,#19b
	dw #300
	dw #301,#cd
	dw #300
	dw #300
	dw #301,#0
	dw #301,#cd
	dw #301,#0
	dw #301,#cd
	dw #300
	dw #300
	dw #300
	dw #300
	dw #301,#0
	dw #301,#cd
	dw #300
	dw #301,#19b
	dw #300
	dw #300
	dw #300
	dw #320
	dw #300
	dw #300
	dw #300
	dw #327,#e6,#39b,#268
	dw #300
	dw #300
	dw #300
	dw #300
	dw #301,#0
	dw #301,#e6
	dw #300
	dw #301,#1cd
	dw #300
	dw #301,#e6
	dw #300
	dw #300
	dw #301,#0
	dw #301,#e6
	dw #301,#0
	dw #301,#e6
	dw #300
	dw #300
	dw #300
	dw #300
	dw #301,#0
	dw #301,#e6
	dw #300
	dw #325,#1cd,#626
	dw #304,#62e
	dw #30f,#0,#0,#636,#0
	dw #304,#63e
	dw #304,#646
	dw #304,#64e
	dw #30c,#656,#626
	dw #30c,#65e,#62e
	dw #32f,#15a,#2b4,#66e,#636
	dw #308,#63e
	dw #308,#646
	dw #308,#64e
	dw #308,#656
	dw #309,#0,#65e
	dw #309,#15a,#65e
	dw #300
	dw #345,#2b4,#66e
	dw #304,#65e
	dw #305,#15a,#646
	dw #304,#65e
	dw #304,#66e
	dw #301,#0
	dw #309,#15a,#66e
	dw #309,#0,#65e
	dw #32d,#15a,#819,#646
	dw #308,#65e
	dw #308,#666
	dw #300
	dw #304,#568
	dw #301,#0
	dw #309,#15a,#809
	dw #300
	dw #345,#2b4,#40c
	dw #300
	dw #308,#558
	dw #300
	dw #324,#66e
	dw #300
	dw #308,#3fc
	dw #300
	dw #327,#103,#206,#4d1
	dw #300
	dw #308,#65e
	dw #300
	dw #300
	dw #301,#0
	dw #309,#103,#4c1
	dw #300
	dw #341,#206
	dw #300
	dw #301,#103
	dw #300
	dw #304,#4d1
	dw #305,#0,#4c9
	dw #305,#103,#4c1
	dw #305,#0,#4b9
	dw #325,#103,#4b1
	dw #304,#4a9
	dw #30c,#4a1,#4d1
	dw #30c,#499,#4c9
	dw #30c,#4a1,#4c1
	dw #30d,#0,#4a9,#4b9
	dw #30d,#103,#4b1,#4b1
	dw #30c,#4b9,#4a9
	dw #34d,#206,#4c1,#4a1
	dw #30c,#4c9,#499
	dw #30c,#4d1,#4a1
	dw #308,#4a9
	dw #308,#4b1
	dw #308,#4b9
	dw #308,#4c1
	dw #308,#4c9
	dw #32f,#cd,#337,#3d2,#4c1
	dw #300
	dw #300
	dw #300
	dw #300
	dw #301,#0
	dw #309,#cd,#3c2
	dw #300
	dw #345,#19b,#568
	dw #300
	dw #305,#cd,#4d1
	dw #300
	dw #304,#44a
	dw #301,#0
	dw #30d,#cd,#40c,#558
	dw #301,#0
	dw #32d,#cd,#4d1,#4c1
	dw #300
	dw #308,#43a
	dw #300
	dw #308,#3fc
	dw #301,#0
	dw #309,#cd,#4c1
	dw #300
	dw #345,#19b,#66e
	dw #300
	dw #300
	dw #300
	dw #324,#737
	dw #300
	dw #30c,#4d1,#65e
	dw #300
	dw #327,#e6,#39b,#44a
	dw #300
	dw #308,#727
	dw #300
	dw #308,#4c1
	dw #301,#0
	dw #309,#e6,#43a
	dw #300
	dw #341,#1cd
	dw #300
	dw #301,#e6
	dw #300
	dw #304,#39b
	dw #301,#0
	dw #301,#e6
	dw #301,#0
	dw #325,#e6,#40c
	dw #300
	dw #308,#38b
	dw #300
	dw #304,#39b
	dw #301,#0
	dw #30d,#e6,#4d1,#3fc
	dw #300
	dw #345,#1cd,#626
	dw #304,#62e
	dw #304,#636
	dw #304,#63e
	dw #304,#646
	dw #304,#64e
	dw #30c,#656,#626
	dw #30c,#65e,#62e
	dw #32f,#15a,#2b4,#66e,#636
	dw #308,#63e
	dw #308,#646
	dw #308,#64e
	dw #308,#656
	dw #309,#0,#65e
	dw #309,#15a,#65e
	dw #300
	dw #345,#2b4,#66e
	dw #304,#65e
	dw #305,#15a,#646
	dw #304,#65e
	dw #304,#66e
	dw #301,#0
	dw #309,#15a,#66e
	dw #309,#0,#65e
	dw #32d,#15a,#819,#646
	dw #308,#65e
	dw #308,#666
	dw #300
	dw #304,#568
	dw #301,#0
	dw #309,#15a,#809
	dw #300
	dw #345,#2b4,#40c
	dw #300
	dw #308,#558
	dw #300
	dw #324,#66e
	dw #300
	dw #308,#3fc
	dw #300
	dw #327,#103,#206,#4d1
	dw #300
	dw #308,#65e
	dw #300
	dw #300
	dw #301,#0
	dw #309,#103,#4c1
	dw #300
	dw #341,#206
	dw #300
	dw #301,#103
	dw #300
	dw #304,#4d1
	dw #305,#0,#4c9
	dw #305,#103,#4c1
	dw #305,#0,#4b9
	dw #325,#103,#4b1
	dw #304,#4a9
	dw #30c,#4a1,#4d1
	dw #30c,#499,#4c9
	dw #30c,#4a1,#4c1
	dw #30d,#0,#4a9,#4b9
	dw #30d,#103,#4b1,#4b1
	dw #30c,#4b9,#4a9
	dw #34d,#206,#4c1,#4a1
	dw #30c,#4c9,#499
	dw #30c,#4d1,#4a1
	dw #308,#4a9
	dw #308,#4b1
	dw #308,#4b9
	dw #308,#4c1
	dw #308,#4c9
	dw #32f,#cd,#337,#3d2,#4c1
	dw #300
	dw #300
	dw #300
	dw #300
	dw #301,#0
	dw #309,#cd,#3c2
	dw #300
	dw #345,#19b,#568
	dw #300
	dw #305,#cd,#4d1
	dw #300
	dw #304,#44a
	dw #301,#0
	dw #30d,#cd,#40c,#558
	dw #301,#0
	dw #32d,#cd,#4d1,#4c1
	dw #300
	dw #308,#43a
	dw #300
	dw #308,#3fc
	dw #301,#0
	dw #309,#cd,#4c1
	dw #300
	dw #345,#19b,#66e
	dw #300
	dw #300
	dw #300
	dw #324,#737
	dw #300
	dw #30c,#4d1,#65e
	dw #300
	dw #327,#e6,#39b,#44a
	dw #300
	dw #308,#727
	dw #300
	dw #308,#4c1
	dw #301,#0
	dw #309,#e6,#43a
	dw #300
	dw #341,#1cd
	dw #300
	dw #301,#e6
	dw #300
	dw #304,#39b
	dw #301,#0
	dw #301,#e6
	dw #301,#0
	dw #325,#e6,#40c
	dw #300
	dw #308,#38b
	dw #300
	dw #304,#39b
	dw #301,#0
	dw #30d,#e6,#4d1,#3fc
	dw #300
	dw #345,#1cd,#626
	dw #304,#62e
	dw #304,#636
	dw #304,#63e
	dw #304,#646
	dw #304,#64e
	dw #30c,#656,#626
	dw #30c,#65e,#62e
	dw #327,#15a,#568,#819
	dw #302,#337
	dw #302,#568
	dw #302,#337
	dw #302,#568
	dw #303,#0,#337
	dw #30b,#15a,#568,#809
	dw #302,#337
	dw #303,#2b4,#568
	dw #302,#337
	dw #303,#15a,#568
	dw #302,#337
	dw #306,#568,#9a2
	dw #303,#0,#337
	dw #303,#15a,#568
	dw #303,#0,#337
	dw #303,#15a,#568
	dw #302,#337
	dw #30a,#568,#992
	dw #302,#337
	dw #306,#568,#ad0
	dw #303,#0,#337
	dw #303,#15a,#568
	dw #302,#337
	dw #303,#2b4,#568
	dw #302,#337
	dw #30e,#568,#819,#ac0
	dw #302,#337
	dw #322,#568
	dw #302,#337
	dw #302,#568
	dw #302,#337
	dw #32f,#103,#40c,#c23,#809
	dw #302,#4d1
	dw #302,#40c
	dw #302,#4d1
	dw #302,#40c
	dw #303,#0,#4d1
	dw #30b,#103,#40c,#c13
	dw #302,#4d1
	dw #303,#206,#40c
	dw #302,#4d1
	dw #303,#103,#40c
	dw #302,#4d1
	dw #302,#40c
	dw #303,#0,#4d1
	dw #303,#103,#40c
	dw #303,#0,#4d1
	dw #303,#103,#40c
	dw #302,#4d1
	dw #302,#40c
	dw #302,#4d1
	dw #302,#40c
	dw #303,#0,#4d1
	dw #303,#103,#40c
	dw #302,#4d1
	dw #303,#206,#40c
	dw #302,#4d1
	dw #302,#40c
	dw #302,#4d1
	dw #302,#40c
	dw #302,#4d1
	dw #302,#40c
	dw #302,#4d1
	dw #327,#cd,#337,#819
	dw #302,#40c
	dw #302,#337
	dw #302,#40c
	dw #302,#337
	dw #303,#0,#40c
	dw #30b,#cd,#337,#809
	dw #302,#40c
	dw #307,#19b,#337,#ad0
	dw #302,#40c
	dw #303,#cd,#337
	dw #302,#40c
	dw #306,#337,#737
	dw #303,#0,#40c
	dw #30b,#cd,#337,#ac0
	dw #303,#0,#40c
	dw #307,#cd,#337,#819
	dw #302,#40c
	dw #30a,#337,#727
	dw #302,#40c
	dw #306,#337,#9a2
	dw #303,#0,#40c
	dw #30b,#cd,#337,#809
	dw #302,#40c
	dw #307,#19b,#337,#737
	dw #302,#40c
	dw #30a,#337,#992
	dw #302,#40c
	dw #326,#337,#66e
	dw #302,#40c
	dw #30a,#337,#727
	dw #302,#40c
	dw #327,#e6,#39b,#895
	dw #302,#44a
	dw #30a,#39b,#65e
	dw #302,#44a
	dw #302,#39b
	dw #303,#0,#44a
	dw #30b,#e6,#39b,#885
	dw #302,#44a
	dw #303,#1cd,#39b
	dw #302,#44a
	dw #303,#e6,#39b
	dw #302,#44a
	dw #306,#39b,#895
	dw #307,#0,#44a,#917
	dw #307,#e6,#39b,#9a2
	dw #307,#0,#44a,#a34
	dw #307,#e6,#39b,#ad0
	dw #306,#44a,#b74
	dw #30e,#39b,#c23,#885
	dw #30e,#44a,#cdc,#907
	dw #30e,#39b,#e6e,#992
	dw #30f,#0,#44a,#d9f,#a24
	dw #30f,#e6,#39b,#1033,#ac0
	dw #30e,#44a,#f4a,#b64
	dw #32f,#1cd,#39b,#c23,#c13
	dw #30e,#44a,#b74,#ccc
	dw #30f,#0,#39b,#ad0,#e5e
	dw #30e,#44a,#a34,#d8f
	dw #30e,#39b,#9a2,#1023
	dw #30e,#44a,#917,#f3a
	dw #30e,#39b,#895,#c13
	dw #30a,#44a,#b64
	dw #32f,#15a,#568,#819,#ac0
	dw #30a,#337,#a24
	dw #30a,#568,#992
	dw #30a,#337,#907
	dw #30a,#568,#885
	dw #303,#0,#337
	dw #30b,#15a,#568,#809
	dw #302,#337
	dw #303,#2b4,#568
	dw #302,#337
	dw #303,#15a,#568
	dw #302,#337
	dw #306,#568,#9a2
	dw #303,#0,#337
	dw #303,#15a,#568
	dw #303,#0,#337
	dw #303,#15a,#568
	dw #302,#337
	dw #30a,#568,#992
	dw #302,#337
	dw #306,#568,#ad0
	dw #303,#0,#337
	dw #303,#15a,#568
	dw #302,#337
	dw #303,#2b4,#568
	dw #302,#337
	dw #30e,#568,#819,#ac0
	dw #302,#337
	dw #322,#568
	dw #302,#337
	dw #302,#568
	dw #302,#337
	dw #32f,#103,#40c,#c23,#809
	dw #302,#4d1
	dw #302,#40c
	dw #302,#4d1
	dw #302,#40c
	dw #303,#0,#4d1
	dw #30b,#103,#40c,#c13
	dw #302,#4d1
	dw #303,#206,#40c
	dw #302,#4d1
	dw #303,#103,#40c
	dw #302,#4d1
	dw #302,#40c
	dw #303,#0,#4d1
	dw #303,#103,#40c
	dw #303,#0,#4d1
	dw #303,#103,#40c
	dw #302,#4d1
	dw #302,#40c
	dw #302,#4d1
	dw #302,#40c
	dw #303,#0,#4d1
	dw #303,#103,#40c
	dw #302,#4d1
	dw #303,#206,#40c
	dw #302,#4d1
	dw #302,#40c
	dw #302,#4d1
	dw #302,#40c
	dw #302,#4d1
	dw #302,#40c
	dw #302,#4d1
	dw #327,#cd,#337,#819
	dw #302,#40c
	dw #302,#337
	dw #302,#40c
	dw #302,#337
	dw #303,#0,#40c
	dw #30b,#cd,#337,#809
	dw #302,#40c
	dw #307,#19b,#337,#ad0
	dw #302,#40c
	dw #303,#cd,#337
	dw #302,#40c
	dw #306,#337,#737
	dw #303,#0,#40c
	dw #30b,#cd,#337,#ac0
	dw #303,#0,#40c
	dw #307,#cd,#337,#819
	dw #302,#40c
	dw #30a,#337,#727
	dw #302,#40c
	dw #306,#337,#9a2
	dw #303,#0,#40c
	dw #30b,#cd,#337,#809
	dw #302,#40c
	dw #307,#19b,#337,#737
	dw #302,#40c
	dw #30a,#337,#992
	dw #302,#40c
	dw #326,#337,#66e
	dw #302,#40c
	dw #30a,#337,#727
	dw #302,#40c
	dw #327,#e6,#39b,#895
	dw #302,#44a
	dw #30a,#39b,#65e
	dw #302,#44a
	dw #302,#39b
	dw #303,#0,#44a
	dw #30b,#e6,#39b,#885
	dw #302,#44a
	dw #303,#1cd,#39b
	dw #302,#44a
	dw #303,#e6,#39b
	dw #302,#44a
	dw #302,#39b
	dw #303,#0,#44a
	dw #303,#e6,#39b
	dw #303,#0,#44a
	dw #303,#e6,#39b
	dw #302,#44a
	dw #302,#39b
	dw #302,#44a
	dw #302,#39b
	dw #303,#0,#44a
	dw #303,#e6,#39b
	dw #302,#44a
	dw #327,#1cd,#39b,#626
	dw #306,#44a,#62e
	dw #307,#0,#39b,#636
	dw #306,#44a,#63e
	dw #306,#39b,#646
	dw #306,#44a,#64e
	dw #30e,#39b,#656,#626
	dw #30e,#44a,#65e,#62e
	dw #32f,#15a,#2b4,#66e,#636
	dw #308,#63e
	dw #308,#646
	dw #308,#64e
	dw #308,#656
	dw #309,#0,#65e
	dw #309,#15a,#65e
	dw #300
	dw #345,#2b4,#66e
	dw #304,#65e
	dw #305,#15a,#646
	dw #304,#65e
	dw #304,#66e
	dw #301,#0
	dw #309,#15a,#66e
	dw #309,#0,#65e
	dw #32d,#15a,#819,#646
	dw #308,#65e
	dw #308,#666
	dw #300
	dw #304,#568
	dw #301,#0
	dw #309,#15a,#809
	dw #300
	dw #345,#2b4,#40c
	dw #300
	dw #308,#558
	dw #300
	dw #324,#66e
	dw #300
	dw #308,#3fc
	dw #300
	dw #327,#103,#206,#4d1
	dw #300
	dw #308,#65e
	dw #300
	dw #300
	dw #301,#0
	dw #309,#103,#4c1
	dw #300
	dw #341,#206
	dw #300
	dw #301,#103
	dw #300
	dw #304,#4d1
	dw #305,#0,#4c9
	dw #305,#103,#4c1
	dw #305,#0,#4b9
	dw #325,#103,#4b1
	dw #304,#4a9
	dw #30c,#4a1,#4d1
	dw #30c,#499,#4c9
	dw #30c,#4a1,#4c1
	dw #30d,#0,#4a9,#4b9
	dw #30d,#103,#4b1,#4b1
	dw #30c,#4b9,#4a9
	dw #34d,#206,#4c1,#4a1
	dw #30c,#4c9,#499
	dw #30c,#4d1,#4a1
	dw #308,#4a9
	dw #308,#4b1
	dw #308,#4b9
	dw #308,#4c1
	dw #308,#4c9
	dw #32f,#cd,#337,#3d2,#4c1
	dw #300
	dw #300
	dw #300
	dw #300
	dw #301,#0
	dw #309,#cd,#3c2
	dw #300
	dw #345,#19b,#568
	dw #300
	dw #305,#cd,#4d1
	dw #300
	dw #304,#44a
	dw #301,#0
	dw #30d,#cd,#40c,#558
	dw #301,#0
	dw #32d,#cd,#4d1,#4c1
	dw #300
	dw #308,#43a
	dw #300
	dw #308,#3fc
	dw #301,#0
	dw #309,#cd,#4c1
	dw #300
	dw #345,#19b,#66e
	dw #300
	dw #300
	dw #300
	dw #324,#737
	dw #300
	dw #30c,#4d1,#65e
	dw #300
	dw #327,#e6,#39b,#44a
	dw #300
	dw #308,#727
	dw #300
	dw #308,#4c1
	dw #301,#0
	dw #309,#e6,#43a
	dw #300
	dw #341,#1cd
	dw #300
	dw #301,#e6
	dw #300
	dw #304,#39b
	dw #301,#0
	dw #301,#e6
	dw #301,#0
	dw #325,#e6,#40c
	dw #300
	dw #308,#38b
	dw #300
	dw #304,#39b
	dw #301,#0
	dw #30d,#e6,#4d1,#3fc
	dw #300
	dw #345,#1cd,#626
	dw #304,#62e
	dw #304,#636
	dw #304,#63e
	dw #304,#646
	dw #304,#64e
	dw #30c,#656,#626
	dw #30c,#65e,#62e
	dw #32f,#15a,#2b4,#66e,#636
	dw #308,#63e
	dw #308,#646
	dw #308,#64e
	dw #308,#656
	dw #309,#0,#65e
	dw #309,#15a,#65e
	dw #300
	dw #345,#2b4,#66e
	dw #304,#65e
	dw #305,#15a,#646
	dw #304,#65e
	dw #304,#66e
	dw #301,#0
	dw #309,#15a,#66e
	dw #309,#0,#65e
	dw #32d,#15a,#819,#646
	dw #308,#65e
	dw #308,#666
	dw #300
	dw #304,#568
	dw #301,#0
	dw #309,#15a,#809
	dw #300
	dw #345,#2b4,#40c
	dw #300
	dw #308,#558
	dw #300
	dw #324,#66e
	dw #300
	dw #308,#3fc
	dw #300
	dw #327,#103,#206,#4d1
	dw #300
	dw #308,#65e
	dw #300
	dw #300
	dw #301,#0
	dw #309,#103,#4c1
	dw #300
	dw #341,#206
	dw #300
	dw #301,#103
	dw #300
	dw #304,#4d1
	dw #305,#0,#4c9
	dw #305,#103,#4c1
	dw #305,#0,#4b9
	dw #325,#103,#4b1
	dw #304,#4a9
	dw #30c,#4a1,#4d1
	dw #30c,#499,#4c9
	dw #30c,#4a1,#4c1
	dw #30d,#0,#4a9,#4b9
	dw #30d,#103,#4b1,#4b1
	dw #30c,#4b9,#4a9
	dw #34d,#206,#4c1,#4a1
	dw #30c,#4c9,#499
	dw #30c,#4d1,#4a1
	dw #308,#4a9
	dw #308,#4b1
	dw #308,#4b9
	dw #308,#4c1
	dw #308,#4c9
	dw #32f,#cd,#337,#3d2,#4c1
	dw #300
	dw #300
	dw #300
	dw #300
	dw #301,#0
	dw #309,#cd,#3c2
	dw #300
	dw #345,#19b,#568
	dw #300
	dw #305,#cd,#4d1
	dw #300
	dw #304,#44a
	dw #301,#0
	dw #30d,#cd,#40c,#558
	dw #301,#0
	dw #32d,#cd,#4d1,#4c1
	dw #300
	dw #308,#43a
	dw #300
	dw #308,#3fc
	dw #301,#0
	dw #309,#cd,#4c1
	dw #300
	dw #345,#19b,#66e
	dw #300
	dw #300
	dw #300
	dw #324,#737
	dw #300
	dw #30c,#4d1,#65e
	dw #300
	dw #327,#e6,#39b,#44a
	dw #300
	dw #308,#727
	dw #300
	dw #308,#4c1
	dw #301,#0
	dw #309,#e6,#43a
	dw #300
	dw #341,#1cd
	dw #300
	dw #301,#e6
	dw #300
	dw #304,#39b
	dw #301,#0
	dw #301,#e6
	dw #301,#0
	dw #325,#e6,#40c
	dw #300
	dw #308,#38b
	dw #300
	dw #304,#39b
	dw #301,#0
	dw #30d,#e6,#4d1,#3fc
	dw #300
	dw #345,#1cd,#626
	dw #304,#62e
	dw #304,#636
	dw #304,#63e
	dw #304,#646
	dw #304,#64e
	dw #30c,#656,#626
	dw #30c,#65e,#62e
	dw #327,#184,#611,#917
	dw #302,#39b
	dw #302,#611
	dw #302,#39b
	dw #302,#611
	dw #303,#0,#39b
	dw #30b,#184,#611,#907
	dw #302,#39b
	dw #303,#308,#611
	dw #302,#39b
	dw #303,#184,#611
	dw #302,#39b
	dw #306,#611,#ad0
	dw #303,#0,#39b
	dw #303,#184,#611
	dw #303,#0,#39b
	dw #303,#184,#611
	dw #302,#39b
	dw #30a,#611,#ac0
	dw #302,#39b
	dw #306,#611,#c23
	dw #303,#0,#39b
	dw #303,#184,#611
	dw #302,#39b
	dw #303,#308,#611
	dw #302,#39b
	dw #30e,#611,#917,#c13
	dw #302,#39b
	dw #322,#611
	dw #302,#39b
	dw #302,#611
	dw #302,#39b
	dw #32f,#122,#48b,#d9f,#907
	dw #302,#568
	dw #302,#48b
	dw #302,#568
	dw #302,#48b
	dw #303,#0,#568
	dw #30b,#122,#48b,#d8f
	dw #302,#568
	dw #303,#245,#48b
	dw #302,#568
	dw #303,#122,#48b
	dw #302,#568
	dw #302,#48b
	dw #303,#0,#568
	dw #303,#122,#48b
	dw #303,#0,#568
	dw #303,#122,#48b
	dw #302,#568
	dw #302,#48b
	dw #302,#568
	dw #302,#48b
	dw #303,#0,#568
	dw #303,#122,#48b
	dw #302,#568
	dw #303,#245,#48b
	dw #302,#568
	dw #302,#48b
	dw #302,#568
	dw #302,#48b
	dw #302,#568
	dw #302,#48b
	dw #302,#568
	dw #327,#e6,#39b,#917
	dw #302,#48b
	dw #302,#39b
	dw #302,#48b
	dw #302,#39b
	dw #303,#0,#48b
	dw #30b,#e6,#39b,#907
	dw #302,#48b
	dw #307,#1cd,#39b,#c23
	dw #302,#48b
	dw #303,#e6,#39b
	dw #302,#48b
	dw #306,#39b,#819
	dw #303,#0,#48b
	dw #30b,#e6,#39b,#c13
	dw #303,#0,#48b
	dw #307,#e6,#39b,#917
	dw #302,#48b
	dw #30a,#39b,#809
	dw #302,#48b
	dw #306,#39b,#ad0
	dw #303,#0,#48b
	dw #30b,#e6,#39b,#907
	dw #302,#48b
	dw #307,#1cd,#39b,#819
	dw #302,#48b
	dw #30a,#39b,#ac0
	dw #302,#48b
	dw #326,#39b,#737
	dw #302,#48b
	dw #30a,#39b,#809
	dw #302,#48b
	dw #327,#103,#40c,#9a2
	dw #302,#4d1
	dw #30a,#40c,#727
	dw #302,#4d1
	dw #302,#40c
	dw #303,#0,#4d1
	dw #30b,#103,#40c,#992
	dw #302,#4d1
	dw #303,#206,#40c
	dw #302,#4d1
	dw #303,#103,#40c
	dw #302,#4d1
	dw #306,#40c,#9a2
	dw #307,#0,#4d1,#a34
	dw #307,#103,#40c,#ad0
	dw #307,#0,#4d1,#b74
	dw #307,#103,#40c,#c23
	dw #306,#4d1,#cdc
	dw #30e,#40c,#d9f,#992
	dw #30e,#4d1,#e6e,#a24
	dw #30e,#40c,#1033,#ac0
	dw #30f,#0,#4d1,#f4a,#b64
	dw #30f,#103,#40c,#122f,#c13
	dw #30e,#4d1,#112a,#ccc
	dw #32f,#206,#40c,#d9f,#d8f
	dw #30e,#4d1,#cdc,#e5e
	dw #30f,#0,#40c,#c23,#1023
	dw #30e,#4d1,#b74,#f3a
	dw #30e,#40c,#ad0,#121f
	dw #30e,#4d1,#a34,#111a
	dw #30e,#40c,#9a2,#d8f
	dw #30a,#4d1,#ccc
	dw #32f,#184,#611,#917,#c13
	dw #30a,#39b,#b64
	dw #30a,#611,#ac0
	dw #30a,#39b,#a24
	dw #30a,#611,#992
	dw #303,#0,#39b
	dw #30b,#184,#611,#907
	dw #302,#39b
	dw #303,#308,#611
	dw #302,#39b
	dw #303,#184,#611
	dw #302,#39b
	dw #306,#611,#ad0
	dw #303,#0,#39b
	dw #303,#184,#611
	dw #303,#0,#39b
	dw #303,#184,#611
	dw #302,#39b
	dw #30a,#611,#ac0
	dw #302,#39b
	dw #306,#611,#c23
	dw #303,#0,#39b
	dw #303,#184,#611
	dw #302,#39b
	dw #303,#308,#611
	dw #302,#39b
	dw #30e,#611,#917,#c13
	dw #302,#39b
	dw #322,#611
	dw #302,#39b
	dw #302,#611
	dw #302,#39b
	dw #32f,#122,#48b,#d9f,#907
	dw #302,#568
	dw #302,#48b
	dw #302,#568
	dw #302,#48b
	dw #303,#0,#568
	dw #30b,#122,#48b,#d8f
	dw #302,#568
	dw #303,#245,#48b
	dw #302,#568
	dw #303,#122,#48b
	dw #302,#568
	dw #302,#48b
	dw #303,#0,#568
	dw #303,#122,#48b
	dw #303,#0,#568
	dw #303,#122,#48b
	dw #302,#568
	dw #302,#48b
	dw #302,#568
	dw #302,#48b
	dw #303,#0,#568
	dw #303,#122,#48b
	dw #302,#568
	dw #303,#245,#48b
	dw #302,#568
	dw #302,#48b
	dw #302,#568
	dw #302,#48b
	dw #302,#568
	dw #302,#48b
	dw #302,#568
	dw #327,#e6,#39b,#917
	dw #302,#48b
	dw #302,#39b
	dw #302,#48b
	dw #302,#39b
	dw #303,#0,#48b
	dw #30b,#e6,#39b,#907
	dw #302,#48b
	dw #307,#1cd,#39b,#c23
	dw #302,#48b
	dw #303,#e6,#39b
	dw #302,#48b
	dw #306,#39b,#819
	dw #303,#0,#48b
	dw #30b,#e6,#39b,#c13
	dw #303,#0,#48b
	dw #307,#e6,#39b,#917
	dw #302,#48b
	dw #30a,#39b,#809
	dw #302,#48b
	dw #306,#39b,#ad0
	dw #303,#0,#48b
	dw #30b,#e6,#39b,#907
	dw #302,#48b
	dw #307,#1cd,#39b,#819
	dw #302,#48b
	dw #30a,#39b,#ac0
	dw #302,#48b
	dw #326,#39b,#737
	dw #302,#48b
	dw #30a,#39b,#809
	dw #302,#48b
	dw #327,#103,#40c,#9a2
	dw #302,#4d1
	dw #30a,#40c,#727
	dw #302,#4d1
	dw #302,#40c
	dw #303,#0,#4d1
	dw #30b,#103,#40c,#992
	dw #302,#4d1
	dw #303,#206,#40c
	dw #302,#4d1
	dw #303,#103,#40c
	dw #302,#4d1
	dw #302,#40c
	dw #303,#0,#4d1
	dw #303,#103,#40c
	dw #303,#0,#4d1
	dw #303,#103,#40c
	dw #302,#4d1
	dw #302,#40c
	dw #302,#4d1
	dw #302,#40c
	dw #303,#0,#4d1
	dw #303,#103,#40c
	dw #302,#4d1
	dw #327,#206,#40c,#6ef
	dw #306,#4d1,#6f7
	dw #307,#0,#40c,#6ff
	dw #306,#4d1,#707
	dw #306,#40c,#70f
	dw #306,#4d1,#717
	dw #30e,#40c,#71f,#6ef
	dw #30e,#4d1,#727,#6f7
	dw #32f,#19b,#337,#7a5,#76d
	dw #308,#775
	dw #308,#77d
	dw #308,#785
	dw #308,#78d
	dw #309,#0,#795
	dw #309,#19b,#795
	dw #300
	dw #345,#337,#7a5
	dw #304,#795
	dw #305,#19b,#77d
	dw #304,#795
	dw #304,#7a5
	dw #301,#0
	dw #309,#19b,#7a5
	dw #309,#0,#795
	dw #32d,#19b,#9a2,#77d
	dw #308,#795
	dw #308,#79d
	dw #300
	dw #304,#66e
	dw #301,#0
	dw #309,#19b,#992
	dw #300
	dw #345,#337,#4d1
	dw #300
	dw #308,#65e
	dw #300
	dw #324,#7a5
	dw #300
	dw #308,#4c1
	dw #300
	dw #327,#134,#268,#5ba
	dw #300
	dw #308,#795
	dw #300
	dw #300
	dw #301,#0
	dw #309,#134,#5aa
	dw #300
	dw #341,#268
	dw #300
	dw #301,#134
	dw #300
	dw #304,#5ba
	dw #305,#0,#5b2
	dw #305,#134,#5aa
	dw #305,#0,#5a2
	dw #325,#134,#59a
	dw #304,#592
	dw #30c,#58a,#5ba
	dw #30c,#582,#5b2
	dw #30c,#58a,#5aa
	dw #30d,#0,#592,#5a2
	dw #30d,#134,#59a,#59a
	dw #30c,#5a2,#592
	dw #34d,#268,#5aa,#58a
	dw #30c,#5b2,#582
	dw #30c,#5ba,#58a
	dw #308,#592
	dw #308,#59a
	dw #308,#5a2
	dw #308,#5aa
	dw #308,#5b2
	dw #32f,#f4,#3d2,#48b,#5aa
	dw #300
	dw #300
	dw #300
	dw #300
	dw #301,#0
	dw #309,#f4,#47b
	dw #300
	dw #345,#1e9,#66e
	dw #300
	dw #305,#f4,#5ba
	dw #300
	dw #304,#51a
	dw #301,#0
	dw #30d,#f4,#4d1,#65e
	dw #301,#0
	dw #32d,#f4,#5ba,#5aa
	dw #300
	dw #308,#50a
	dw #300
	dw #308,#4c1
	dw #301,#0
	dw #309,#f4,#5aa
	dw #300
	dw #345,#1e9,#7a5
	dw #300
	dw #300
	dw #300
	dw #324,#895
	dw #300
	dw #30c,#5ba,#795
	dw #300
	dw #327,#112,#44a,#51a
	dw #300
	dw #308,#885
	dw #300
	dw #308,#5aa
	dw #301,#0
	dw #309,#112,#50a
	dw #300
	dw #341,#225
	dw #300
	dw #301,#112
	dw #300
	dw #304,#44a
	dw #301,#0
	dw #301,#112
	dw #301,#0
	dw #325,#112,#4d1
	dw #300
	dw #308,#43a
	dw #300
	dw #304,#44a
	dw #301,#0
	dw #30d,#112,#5ba,#4c1
	dw #300
	dw #345,#225,#75d
	dw #304,#765
	dw #304,#76d
	dw #304,#775
	dw #304,#77d
	dw #304,#785
	dw #30c,#78d,#75d
	dw #30c,#795,#765
	dw #32f,#19b,#337,#7a5,#76d
	dw #308,#775
	dw #308,#77d
	dw #308,#785
	dw #308,#78d
	dw #309,#0,#795
	dw #309,#19b,#795
	dw #300
	dw #345,#337,#7a5
	dw #304,#795
	dw #305,#19b,#77d
	dw #304,#795
	dw #304,#7a5
	dw #301,#0
	dw #309,#19b,#7a5
	dw #309,#0,#795
	dw #32d,#19b,#9a2,#77d
	dw #308,#795
	dw #308,#79d
	dw #300
	dw #304,#66e
	dw #301,#0
	dw #309,#19b,#992
	dw #300
	dw #345,#337,#4d1
	dw #300
	dw #308,#65e
	dw #300
	dw #324,#7a5
	dw #300
	dw #308,#4c1
	dw #300
	dw #327,#134,#268,#5ba
	dw #300
	dw #308,#795
	dw #300
	dw #300
	dw #301,#0
	dw #309,#134,#5aa
	dw #300
	dw #341,#268
	dw #300
	dw #301,#134
	dw #300
	dw #304,#5ba
	dw #305,#0,#5b2
	dw #305,#134,#5aa
	dw #305,#0,#5a2
	dw #325,#134,#59a
	dw #304,#592
	dw #30c,#58a,#5ba
	dw #30c,#582,#5b2
	dw #30c,#58a,#5aa
	dw #30d,#0,#592,#5a2
	dw #30d,#134,#59a,#59a
	dw #30c,#5a2,#592
	dw #34d,#268,#5aa,#58a
	dw #30c,#5b2,#582
	dw #30c,#5ba,#58a
	dw #308,#592
	dw #308,#59a
	dw #308,#5a2
	dw #308,#5aa
	dw #308,#5b2
	dw #32f,#f4,#3d2,#48b,#5aa
	dw #300
	dw #300
	dw #300
	dw #300
	dw #301,#0
	dw #309,#f4,#47b
	dw #300
	dw #345,#1e9,#66e
	dw #300
	dw #305,#f4,#5ba
	dw #300
	dw #304,#51a
	dw #301,#0
	dw #30d,#f4,#4d1,#65e
	dw #301,#0
	dw #32d,#f4,#5ba,#5aa
	dw #300
	dw #308,#50a
	dw #300
	dw #308,#4c1
	dw #301,#0
	dw #309,#f4,#5aa
	dw #300
	dw #345,#1e9,#7a5
	dw #300
	dw #300
	dw #300
	dw #324,#895
	dw #300
	dw #30c,#5ba,#795
	dw #300
	dw #327,#112,#44a,#51a
	dw #300
	dw #308,#885
	dw #300
	dw #308,#5aa
	dw #301,#0
	dw #309,#112,#50a
	dw #300
	dw #341,#225
	dw #300
	dw #301,#112
	dw #300
	dw #304,#44a
	dw #301,#0
	dw #301,#112
	dw #301,#0
	dw #325,#112,#4d1
	dw #300
	dw #308,#43a
	dw #300
	dw #304,#44a
	dw #301,#0
	dw #30d,#112,#5ba,#4c1
	dw #300
	dw #345,#225,#75d
	dw #304,#765
	dw #304,#76d
	dw #304,#775
	dw #304,#77d
	dw #304,#785
	dw #30c,#78d,#75d
	dw #30c,#795,#765
	dw #a0f,#19b,#337,#7a5,#76d
	dw #a00
	dw #a00
	dw #a00
	dw #a00
	dw #a00
	dw #a00
	dw #a00
	dw #a00
	dw #a00
	dw #a00
	dw #a00
	dw #a00
	dw #a00
	dw #a00
	dw #a00
	dw #a00
	dw #a00
	dw #a00
	dw #a00
	dw #a0f,#0,#0,#0,#0
	dw #a00
	dw #a00
	dw 0
