/*
 * Decompiled with CFR 0.152.
 */
package org.kd.hellogdx;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import org.kd.hellogdx.AnimationManager;
import org.kd.hellogdx.SceneA;
import org.kd.hellogdx.SceneB;

public class Animation
extends ApplicationAdapter {
    SpriteBatch batch;
    AnimationManager animationManager;

    @Override
    public void create() {
        this.batch = new SpriteBatch();
        this.animationManager = new AnimationManager();
        SceneA sceneA = new SceneA();
        SceneB sceneB = new SceneB();
        sceneA.create();
        sceneB.create();
        this.animationManager.addScene("sceneA", sceneA);
        this.animationManager.addScene("sceneB", sceneB);
        this.animationManager.switchScene("sceneA");
    }

    @Override
    public void render() {
        float delta = Gdx.graphics.getDeltaTime();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.animationManager.update(delta);
        this.batch.begin();
        this.animationManager.render();
        this.batch.end();
        if (Gdx.input.isKeyJustPressed(62)) {
            this.animationManager.switchScene("sceneB");
        }
    }

    @Override
    public void dispose() {
        this.batch.dispose();
        this.animationManager.disposeScenes();
    }
}

