// Prosty hash 2D -> 1D
float hash21(vec2 p) {
    p = fract(p * vec2(123.34, 456.21));
    p += dot(p, p + 45.32);
    return fract(p.x * p.y);
}

// Voronoi: wejście współrzędne i czas, wyjście: odległość do najbliższej komórki
float voronoi(vec2 xy, float time) {
    vec2 g = floor(xy);       // indeksy komórki
    vec2 f = fract(xy);       // pozycja wewnątrz komórki

    float minDist = 1.0;

    // sprawdzamy sąsiednie komórki (3x3)
    for (int j = -1; j <= 1; ++j) {
        for (int i = -1; i <= 1; ++i) {
            vec2 cell = vec2(float(i), float(j));
            vec2 id   = g + cell;

            // losowe przesunięcie punktu w komórce + lekkie „bujanie” w czasie
            float h = hash21(id);
            float a = h * 6.28318530718; // 2*pi
            vec2 offset = vec2(cos(a), sin(a)) * 0.35 * sin(time * 0.5 + h * 10.0);

            vec2 featurePoint = cell + vec2(hash21(id + 1.23), hash21(id + 4.56)) * 0.6 + offset;

            float d = length(f - featurePoint);
            minDist = min(minDist, d);
        }
    }

    return minDist;
}

//float voronoiEdges(vec2 xy, float time) {
//    vec2 g = floor(xy);
//    vec2 f = fract(xy);
//
//    float d1 = 1.0; // najbliższy
//    float d2 = 1.0; // drugi najbliższy
//
//    for (int j = -1; j <= 1; ++j) {
//        for (int i = -1; i <= 1; ++i) {
//            vec2 cell = vec2(float(i), float(j));
//            vec2 id   = g + cell;
//
//            float h = hash21(id);
//            float a = h * 6.28318530718; // 2*pi
//            vec2 offset = vec2(cos(a), sin(a)) * 0.35 * sin(time * 0.5 + h * 10.0);
//
//            vec2 featurePoint =
//                cell + vec2(hash21(id + 1.23), hash21(id + 4.56)) * 0.6 + offset;
//
//            float d = length(f - featurePoint);
//
//            // śledzimy dwie najmniejsze odległości
//            if (d < d1) {
//                d2 = d1;
//                d1 = d;
//            } else if (d < d2) {
//                d2 = d;
//            }
//        }
//    }
//
//    // różnica odległości najbliższych punktów:
//    // mała przy krawędziach, duża w środku komórki
//    float edgeMetric = d2 - d1;
//
//    // adaptacyjna grubość linii dzięki fwidth
//    float width = fwidth(edgeMetric) * 2.0;
//
//    // 1.0 na krawędzi, 0.0 w środku komórki, miękkie przejście
//    float v = 1.0 - smoothstep(0.0, width, edgeMetric);
//    return v;
//}

float voronoiEdges(vec2 xy, float time) {
    vec2 g = floor(xy);
    vec2 f = fract(xy);

    float d1 = 1.0; // najbliższy
    float d2 = 1.0; // drugi najbliższy

    for (int j = -1; j <= 1; ++j) {
        for (int i = -1; i <= 1; ++i) {
            vec2 cell = vec2(float(i), float(j));
            vec2 id   = g + cell;

            float h = hash21(id);
            float a = h * 6.28318530718; // 2*pi
            vec2 offset = vec2(cos(a), sin(a)) * 0.35 * sin(time * 0.5 + h * 10.0);

            vec2 featurePoint =
                cell + vec2(hash21(id + 1.23), hash21(id + 4.56)) * 0.6 + offset;

            float d = length(f - featurePoint);

            if (d < d1) {
                d2 = d1;
                d1 = d;
            } else if (d < d2) {
                d2 = d;
            }
        }
    }

    float edgeMetric = d2 - d1;

    // stała "grubość" krawędzi – można doregulować
    const float EDGE_THICKNESS = 0.04;

    // 1.0 na krawędzi, 0.0 w środku komórki, bez antyaliasingu
    float v = 1.0 - step(EDGE_THICKNESS, edgeMetric);
    return v;
}