	;
	; CLEAR	MONSTERS SCREEN	BY USING MASKS
	; R0 - HOR.MASK
	; R1 - VER.MASK
CLMM:	CLR R5
	MOV #MNVSC,R3
0$:	ASL R0
	BCS 1$
	BEQ 2$
4$:	CALL @SNDPR
	ADD #64.,R3
	BR 0$
1$:	MOV R1,R2 ; LINE MARKED	-> PROCESS
	MOV R3,R4
5$:	ASL R2
	BCS 3$
	BEQ 4$
	ADD #4.,R4
	BR 5$
3$:	MOV R5,(R4)+
	MOV R5,(R4)+
	BR 5$
2$:	RET
	;
	; COPY MONSTERS	SCREEN BY USING	MASKS
	; R0 - VER.MASK
	; R1 - HOR.MASK
CPMM:	MOV #MNSPS,-(SP)
	MOV #MNVSC,R3
0$:	ASL R0
	BCS 1$
	BEQ 2$
4$:	CALL @SNDPR
	ADD #64.,R3
	ADD #256.,(SP)
	BR 0$
1$:	MOV R1,R2 ; LINE MARKED	-> PROCESS
	MOV R3,R4
	MOV (SP),R5
5$:	ASL R2
	BCS 3$
	BEQ 4$
	ADD #4.,R4
	ADD #4.,R5
	BR 5$
3$:	MOV (R4),128.(R5)
	MOV (R4)+,(R5)+
	MOV (R4),128.(R5)
	MOV (R4)+,(R5)+
	BR 5$
2$:	TST (SP)+
	RET
	;
	; REDRAW MASKS INIT
MSKSIN:	MOV #-1.,(PC)+
HMSK:	.WORD 0
	MOV #-1.,(PC)+
VMSK:	.WORD 0
	RET
	;
	; PROCESS MONSTERS
MNPRC:	MOV VMSK,R0
	MOV HMSK,R1
	CALL CLMM
	MOV HMSK,-(SP)
	MOV VMSK,-(SP)
	CLR HMSK
	CLR VMSK
	CALL CLDP
	CALL DFB
	MOV VMSK,R0
	BIS (SP)+,R0
	MOV HMSK,R1
	BIS (SP)+,R1
	CALL CPMM
	RET
	;
	; CALCULATE: DIST,POS,DRAW
CLDP:	MOV PLA,R0
	CALL GCOS
	SWAB R1
	MOVB R1,R1
	MOV R1,XCOS
	MOV PLA,R0
	CALL GSIN
	SWAB R1
	MOVB R1,R1
	MOV R1,XSIN
	CLR DCNT
	MOV #MNBF,R5
	;
CLMN:	MOVB (R5),SHTYPE
	BEQ CLNT
	MOV 8.(R5),R1
	CMPB VIS(R1),FRCNTR
	BNE CLNT
	;
	MOVB 1.(R5),SHCRFR
	BICB #360,SHCRFR
	MOV 4.(R5),R0
	MOV 6.(R5),R3
	;
	MOV R0,-(SP)
	;
	; CALC DIST
	SUB PLX,R0
	ASR R0
	MOV XCOS,R1
	CALL SPMULS
	CALL @SNDPR
	;
	MOV R3,R0
	SUB PLY,R0
	ASR R0
	MOV XSIN,R1
	MOV R2,R4
	CALL SPMULS
	CALL @SNDPR
	ADD R4,R2
	;
	ASR R2
	ASR R2
	ASR R2
	ASR R2
	ASR R2
	;
	MOV (SP)+,R0
	;
	MOV R2,R4	; SAVE DISTANCE
	BLE CLNT
	;
	; CALC POS
	SUB PLX,R0
	ASR R0
	MOV (PC)+,R1
XSIN:	.WORD 0
	CALL SPMULS
	CALL @SNDPR
	;
	MOV R3,R0
	SUB PLY,R0
	ASR R0
	MOV (PC)+,R1
XCOS:	.WORD 0
	MOV R2,R3
	CALL SPMULS
	CALL @SNDPR
	;
	SUB R3,R2
	BPL 1$
	NEG R2		; IF <0
	CALL SPDIV
	NEG R2
	BR 2$
1$:	CALL SPDIV	; IF >0
	;
2$:	CALL @SNDPR
	MOV R2,R0
	BPL 3$
	NEG R2
3$:	CMP R2,#64.
	BHIS CLNT
	ADD #32.,R0	; POSITION -32..32->0..64
	;
	; FILL STORE BUFFER
	MOV DCNT,R3		; DRAW BUFFER FILL
	ASL R3
	MOV R3,R2
	ASL R3
	ADD R2,R3		; *6
	ADD #SRTB,R3
	MOV SHTYPE,(R3)+	; SHTYPE,SHCRFR
	MOV R0,(R3)+		; R0=POSITION
	MOV R4,(R3)+		; R4=SCALE
	INC DCNT		; NEXT
	;
	CALL DPROJ2		; FIRE HUNTER->PLAYER
	;
CLNT:	CALL @SNDPR
	ADD #MNRS,R5
	CMP #MNBFE,R5
	BNE CLMN
	RET
	;
	; DRAW FROM STORED DRAW	BUFFER
DFB:	MOV DCNT,R5
	BEQ 1$
	MOV #SRTB,R1
	DEC R5
	BNE 2$
	; 1 TO DRAW
	MOV (R1)+,R3
	MOV R3,SHTYPE
	MOVB R3,R3
	ASL R3
	MOV DRTAB-2(R3),R3
	MOV (R1)+,R0
	MOV (R1)+,R4
	CALL (R3)
1$:	RET
	; 2 OR MORE
2$:	MOV R1,R2
4$:	MOV R2,R1
	MOV R5,R4
3$:	CMP 4(R1),6+4(R1)
	BHI 5$
	; 1
	MOV (R1),R0
	MOV 6(R1),(R1)
	MOV R0,6(R1)
	; 2
	MOV 2(R1),R0
	MOV 6+2(R1),2(R1)
	MOV R0,6+2(R1)
	; 3
	MOV 4(R1),R0
	MOV 6+4(R1),4(R1)
	MOV R0,6+4(R1)
	;
5$:	ADD #6,R1
	SOB R4,3$
	SOB R5,4$
	; DRAW AFTER SORT
	MOV DCNT,R5
6$:	MOV (R2)+,R3
	MOV R3,SHTYPE
	MOVB R3,R3
	ASL R3
	MOV DRTAB-2(R3),R3
	MOV (R2)+,R0
	MOV (R2)+,R4
	MOV R2,-(SP)
	CALL (R3)
	MOV (SP)+,R2
	SOB R5,6$
	RET
	;
SRTB:	.BLKB 180.	; 6*30=180 BYTES
	.EVEN
	;
	; SPRITE&FX DRAW ROUTINES
DRTAB:	.WORD SPDRW		; TYPE 1
	.WORD SPDRW		; TYPE 2
	.WORD SPDRF		; TYPE 3
	.WORD SPDRF		; TYPE 4
	.WORD SPDRW		; TYPE 5
	;
XFRAMS:	.WORD XFR1,XFR2,XFR3,XFR4,XFR5,XFR6
XSCLRS:	.BYTE 1,1,1,1,2,2,2,3,3,4,4,5,5,5,6,6
XSIZES:	.BYTE 1,3,3,5,5,7
XFR1:	.BYTE 377
XFR2:	.BYTE 0,377,0
	.BYTE 377,377,377
	.BYTE 0,377,0
XFR3:	.BYTE 377,377,377
	.BYTE 377,377,377
	.BYTE 377,377,377
XFR4:	.BYTE 0,0,377,0,0
	.BYTE 0,377,377,377,0
	.BYTE 377,377,377,377,377
	.BYTE 0,377,377,377,0
	.BYTE 0,0,377,0,0
XFR5:	.BYTE 0,377,377,377,0
	.BYTE 377,377,377,377,377
	.BYTE 377,377,377,377,377
	.BYTE 377,377,377,377,377
	.BYTE 0,377,377,377,0
XFR6:	.BYTE 0,0,377,377,377,0,0
	.BYTE 0,377,377,377,377,377,0
	.BYTE 377,377,377,377,377,377,377
	.BYTE 377,377,377,377,377,377,377
	.BYTE 377,377,377,377,377,377,377
	.BYTE 0,377,377,377,377,377,0
	.BYTE 0,0,377,377,377,0,0
	.EVEN
	;
	; SCALERS TABLE
SCTB:	.WORD SCL1,SCL2,SCL3,SCL4,SCL5,SCL6,SCL5,SCL6
	.WORD SCL7,SCL8,SCL7,SCL8,SCL7,SCL8,SCL7,SCL8
	.WORD SCL8,SCL8,SCL8,SCL8,SCL8,SCL8,SCL8,SCL8
	.WORD SCL8,SCL8,SCL8,SCL8,SCL8,SCL8,SCL8,SCL8
	;
	; SPECIAL VERSION FOR ATTACKS
SPDRF:	MOV R5,-(SP)
	; 16384/DIST
	CALL SPDVX
	CALL @SNDPR
	; CALC WIDTH&HEIGHT
	ASR R2
	ASR R2
	MOV R2,-(SP)
	ASR R2
	ASR R2
	BEQ XR1
	CMP R2,#16.
	BHI XR1
	; OFFSET
	MOV R2,R4
	ASR R4
	; CHOICE SCALE VARIANT
	MOVB XSCLRS-1(R2),R2
	; TAKE FRAME
	MOV R2,R5
	ASL R5
	MOV XFRAMS-2(R5),R3
	; TAKE SIZE
	MOVB XSIZES-1(R2),R2
	MOV R2,R5
	ASR R5
	SUB R5,R0
	MOV R2,R1
	ADD #MNVSC,R0
	; OFFSET
	SUB R5,R4
	; VMSK
	MOV R2,R5
	ADD R4,R5
	ASL R5
	MOV DRMSKV-2(R5),(PC)+
VTMP:	.WORD 0
	; OFFSETx64
	SWAB R4
	ASR R4
	ASR R4
XR2:	CMPB R0,#64.
	BHIS XR4
	MOVB R0,R5
	; COMPARE WITH RAWH
	ASL R5
	MOV FRBF1(R5),R5
	BIC #177000,R5
	CMP R5,(SP)
	BGE XR4
	; UPDATE MASKS
	MOVB R0,R5
	ASR R5
	BIS DRMSKH(R5),HMSK
	BIS VTMP,VMSK
	; DRAW
	MOV R0,-(SP)
	MOV R2,-(SP)
	ADD R4,R0
XR3:	MOVB (R3)+,(R0)
	ADD #64.,R0
	SOB R2,XR3
	MOV (SP)+,R2
	MOV (SP)+,R0
XR4:	CALL @SNDPR
	INC R0
	SOB R1,XR2
XR1:	TST (SP)+
	MOV (SP)+,R5
	RET
	;
SPDRW:	MOV R5,-(SP)
	; 16384/DIST
	CALL SPDVX
	CALL @SNDPR
	; CALC WIDTH&HEIGHT
	ASR R2
	ASR R2
	MOV R2,-(SP)
	ASR R2
	ASR R2
	BEQ SR1			; CAN'T	BE ZERO
	CMP R2,#32.
	BHI SR1			; V.CLIP NOT SUPPORTED
	; TAKE ANIMATION FRAME
	MOVB SHTYPE,R4
	MOV R4,R5		; FOR MATERIAL
	ASL R4
	MOV ANIMAS-2(R4),R4
	BEQ TSCLX
	MOVB SHCRFR,R1
	INC R1
	ASL R1
	ADD R1,R4
	MOV (R4),(PC)+
ANIFR:	.WORD 0
	; TAKE SCALER
TSCLX:	MOV R2,R4
	ASL R4
	MOV SCTB-2.(R4),SR0+2
	MOV SCLR-2.(R4),(PC)+	; -2. BECAUSE TO INDEX
TSCLR:	.WORD 0
	MOV R2,R4
	ASR R4
	SUB R4,R0		; POSITION -X..+X
	MOV R2,R1		; SAVE COUNTER R2->R1 W=H
	DEC R1			; -1 (1..64->0..63)
	SWAB R1			; COUNTER IN MSB NOW
	BISB MTRLM-1.(R5),R1	; MATERIAL
	MOV TSCLR,(PC)+		; SUBTEXEL
HSCLR:	.WORD 0
	ASR HSCLR
	; ADD VIRTUAL SCREEN OFFSET
	ADD #MNVSC,R0
	; DRAW LOOP
SR2:	CMPB R0,#64.		; ONLY POSITIVE	INDEX 0..63
	BHIS SR4
	MOVB R0,R5		; TAKE INDEX
	; COMPARE WITH RAWH
	ASL R5
	MOV FRBF1(R5),R5
	BIC #177000,R5
	CMP R5,(SP)
	BGE SR4
	; TAKE SPRITE DATA
	MOVB HSCLR+1,R4
	ASL R4
	ADD ANIFR,R4		; ADD OFFSET
	MOV (R4),R4
	BEQ SR4			; IF NOTHING TO	DRAW
	; UPDATE HMSK
	MOVB R0,R5
	ASR R5
	BIS DRMSKH(R5),HMSK
	; UPDATE VMSK&LOAD PRESCALLER
	; (DO NOT MOVE OUTSIDE OF LOOP)
	MOV R2,R5
	ASL R5
	MOV PSCTAB-2.(R5),R3
	MOV R2,-(SP)
	CMP R2,#16.		; VCLIP
	BLOS 100$
	MOV #16.,R2
	MOV #32.,R5
100$:	BIS DRMSKV-2.(R5),VMSK
	; DRAW
	MOV R0,R5		; RELOAD ADDR.
SR0:	MOV #0,PC
SR5:	MOV (SP)+,R2
SR4:	CALL @SNDPR
	INC R0			; UPDATE INDEX (NEXT COLUMN)
	ADD TSCLR,HSCLR
	SUB #256.,R1		; COUNTER -1 IN	MSB
	BPL SR2
SR1:	TST (SP)+
	MOV (SP)+,R5
	RET
	;
	; SCALERS PROCS
SCL1:	BIT (R3)+,R4
	BEQ SR5
	MOVB R1,(R5)
1$:	BR SR5
	;
SCL2:	BIT (R3)+,R4
	BEQ 1$
	MOVB R1,(R5)
1$:	BIT (R3)+,R4
	BEQ 2$
	MOVB R1,64.(R5)
2$:	BR SR5
	;
SCL3:	BIT (R3)+,R4
	BEQ 1$
	MOVB R1,(R5)
1$:	BIT (R3)+,R4
	BEQ 2$
	MOVB R1,64.(R5)
2$:	BIT (R3)+,R4
	BEQ 3$
	MOVB R1,128.(R5)
3$:	BR SR5
	;
SCL4:	BIT (R3)+,R4
	BEQ 1$
	MOVB R1,(R5)
1$:	BIT (R3)+,R4
	BEQ 2$
	MOVB R1,64.(R5)
2$:	BIT (R3)+,R4
	BEQ 3$
	MOVB R1,128.(R5)
3$:	BIT (R3)+,R4
	BEQ 4$
	MOVB R1,192.(R5)
4$:	BR SR5
	;
SCL5:	BIT (R3)+,R4
	BEQ 1$
	MOVB R1,(R5)
1$:	ADD #64.,R5
	;
SCL6:	ASR R2
1$:	BIT (R3)+,R4
	BEQ 3$
	MOVB R1,(R5)
3$:	BIT (R3)+,R4
	BEQ 4$
	MOVB R1,64.(R5)
4$:	ADD #128.,R5
	SOB R2,1$
	BR SR5
	;
SCL7:	BIT (R3)+,R4
	BEQ 1$
	MOVB R1,(R5)
1$:	ADD #64.,R5
	;
SCL8:	ASR R2
1$:	BIT (R3),R4
	BEQ 3$
	MOVB R1,(R5)
	MOVB R1,64.(R5)
3$:	ADD #4,R3
	ADD #128.,R5
	SOB R2,1$
	BR SR5
	;
SHTYPE:	.BYTE 0		; SYNC HUNTERS TYPE
SHCRFR:	.BYTE 0		; SYNC HUNTERS CURRENT FRAME
	.EVEN
DCNT:	.WORD 0
	;
	.END

 E