	;
	; STARTUP INIT
HWINIT:	MOV #161716,@#2		; SET STOP KEY VECTOR
	MOV #2,@#4
	MOV #TN,@#274		; SET KEYBOARD VECTORS
	MOV #TI,@#60
	MOV #1024.,R0		; DETECT BAD PORT BITS
	CLR R1
1$:	BIS @#177714,R1
	SOB R0,1$
	MOV R1,JOYMSK
	CLR CHMSK
	CLR CHUND
	RET
	;
	; KEYBOARD IRQ ROUTINES
TN:	MOV R0,-(SP)
	MOVB @#177662,R0
	CMPB R0,#100
	BLO 1$
	BICB #40,R0
1$:	ADD #200,R0
	MOVB R0,KEYCOD
	MOV (SP)+,R0
	RTI
	;
TI:	MOV R0,-(SP)
	MOVB @#177662,R0
	CMPB R0,#100
	BLO 1$
	BICB #40,R0
1$:	MOVB R0,KEYCOD
	MOV (SP)+,R0
	RTI
	;
	; ANALOG CONTROLS PROCESSING
ANALOG:	DEC ICNT
	BNE 1$
	MOV #4,ICNT
	MOV R0,-(SP)
	MOV R1,-(SP)
	MOV #177714,R0
	MOV (R0),R1
	CLR (R0)
	TST R1
	BEQ 55$
	BIT #117,(R0)	; DETECT MOUSE ACTIVITY
	BNE 55$
	BIS #100000,R1	; SET MOUSE FLAG
55$:	MOV #140010,(R0)+
	BIC JOYMSK,R1
	BIT #100,(R0)	; 177716
	BNE 2$
	; KEY PRESSED->PROCESS KEYBOARD
	; MAP KEYBOARD INTO ANALOG
	MOVB KEYCOD,R0
	BMI 56$		; \
	ASLB R0		;  : ROUTE - FAST SEARCH
	BMI 57$		; /
	; 32->1
	CMPB R0,#64
	BEQ 3$
	; 31->2
	CMPB R0,#62
	BEQ 6$
	; 33->4
	CMPB R0,#66
	BEQ 4$
	; 10->10
	CMPB R0,#20
	BEQ 5$
	BR 2$
57$:	; 103->1
	CMPB R0,#206
	BEQ 3$
	; 131->4
	CMPB R0,#262
	BEQ 4$
	; SLIDE	LEFT 106
	CMPB R0,#214
	BEQ 7$
	; SLIDE	RIGHT 127
	CMPB R0,#256
	BEQ 8$
	BR 2$
56$:	; SLIDE	RIGHT 231
	CMPB R0,#231
	BEQ 8$
	; SLIDE	LEFT 210
	CMPB R0,#210
	BNE 2$		; NO MORE CASES
7$:	DEC SLDV
	BR 2$
8$:	INC SLDV
	BR 2$
3$:	BIS #1,R1
	BR 2$
6$:	BIS #2,R1
	BR 2$
4$:	BIS #4,R1
	BR 2$
5$:	BIS #10,R1
	; NO KEY PRESSED->PROCESS MOUSE	AND JOYSTICK
	; OR PROCESS MAPPED KEYBOARD
2$:	BIS R1,JBMP
	BIT #1,R1
	BEQ 10$
	INC MOVV
10$:	BIT #2,R1
	BEQ 11$
	INC ANGV
11$:	BIT #4,R1
	BEQ 12$
	DEC MOVV
12$:	BIT #10,R1
	BEQ 9$
	DEC ANGV
9$:	MOV (SP)+,R1
	MOV (SP)+,R0
1$:	RET
	;
	; PLAY SND EFFECT
	; R2=POINTER TO	EFFECT
PLEF:	DEC R2		; 1..6->0..5
	ASL R2
	ASL R2
	ADD #EFF1,R2
	MOV (R2)+,(PC)+
TEMPO:	.WORD 0
	MOV (R2),(PC)+
TONE:	.WORD 0
	MOV (R2)+,(PC)+
TONEB:	.WORD 0
	MOV #SNDR,(PC)+
SNDPR:	.WORD SNDN
	RET
	;
SNDR:	BIT #128.,@#177712
	BEQ 1$
	BIC #128.,@#177712
	CALL ANALOG
	DEC TEMPO
	BNE 2$
	MOV #SNDN,SNDPR
	RET
2$:	DEC TONE
	BNE 1$
	MOV TONEB,TONE
	BIS #100,@#177716
	MOV #SNDS,SNDPR
1$:	RET
	;
SNDS:	BIT #128.,@#177712
	BEQ 1$
	BIC #128.,@#177712
	CALL ANALOG
	DEC TEMPO
	BNE 2$
	MOV #SNDN,SNDPR
	RET
2$:	DEC TONE
	BNE 1$
	MOV TONEB,TONE
	BIC #100,@#177716
	MOV #SNDR,SNDPR
1$:	RET
	;
SNDN:	BIT #128.,@#177712
	BEQ 1$
	BIC #128.,@#177712
	CALL ANALOG
1$:	RET
	;
	; PREPARE SOUND	AND INPUT CONTROLS PROCESSING
NOSND:	MOV #SNDN,SNDPR
	MOV #1,@#177712
	MOV #40.,@#177706
	MOV #20.,@#177712
	; INIT CONTROLS	PROCESSING
	CLR ANGV
	CLR MOVV
	CLR SLDV
	MOV #4,ICNT
	CLR JBMP
	RET
	;
	; PROCESS SOUND	EFFECTS	BITMAP
PRCSEF:	MOV (PC)+,R5
SNDBM:	.WORD 0
	MOV #6,R2
1$:	ASR R5
	BCS 2$
	BEQ 3$
	SOB R2,1$
3$:	RET
2$:	CALL PLEF	; R2=1..6
	RET
	;
GLOGIC:	INCB TKCNTR
	CMP #GSPAUS,GSTATE
	BEQ 4$
	CALL MNMOV	; MONSTERS MOVE
4$:	CALL JOY	; INPUT&PLAYER MOVE
	CMP #GSHTWN,GSTATE
	BNE 2$
	CALL SETTA
	MOV MNBF+6.,R1
	MOV MNBF+4.,R0
	CALL SETPL
2$:	RET
	;
	; SHIFT	SPEED BASED ON DELTA
	; INP: R2=DELTA
	; INP/OUT: R0,R1=VALUES	TO SHIFT
SHIFT:	TST R2
	BPL 1$
	NEG R2		; MAKE POSITIVE
1$:	CMP R2,#10.
	BLO 2$
	MOV #9.,R2	; LIMIT	TO 0..9
2$:	ASL R2
	ADD R2,PC
	BR 3$		; 0
	BR 4$		; 1
	BR 5$		; 2
	BR 6$		; 3
	BR 6$		; 4
	BR 7$		; 5
	BR 7$		; 6
	BR 8$		; 7
	BR 8$		; 8
	BR 8$		; 9
3$:	ASR R0
	ASR R1
4$:	ASR R0
	ASR R1
5$:	ASR R0
	ASR R1
6$:	ASR R0
	ASR R1
7$:	ASR R0
	ASR R1
8$:	RET
	;
ANGV:	.WORD 0		; LEFT,RIGHT VEL.
MOVV:	.WORD 0		; UP,DOWN VEL.
SLDV:	.WORD 0		; STEP LEFT,RIGHT VEL.
ICNT:	.WORD 0		; INPUT	CONTROLS COUNTER
JBMP:	.WORD 0		; JOY/MOUSE BITMAP
	;
	; NRV2d	(UCL) FOR BK/PDP
	; INPUT:
	; R0 - SOURCE
	; R1 - DESTINATION
	;
UNPK:	MOV #-1,R4
	XOR R2,R2
	BR DCL
	;
NXDC:	MOVB (R0)+,(R1)+
DCL:	CALL RB
	BCS NXDC
	;
	MOV #1,R3
OFN:	ADD R3,R3
	CALL RB
	ADC R3
	CALL RB
	BCS OFE
	DEC R3
	ADD R3,R3
	CALL RB
	ADC R3
	BR OFN
	;
RB:	ADD R2,R2
	BEQ RBZ
	RET
RBZ:	MOVB (R0)+,R2
	SWAB R2
	BIC #177,R2
	BIS #200,R2
	ADD R2,R2
	RET
	;
OFE:	SUB #3,R3
	BCC OF2
	;
	MOV R4,R3
	XOR R5,R5
	CALL RB
	ADC R5
	BR OF3
	;
OF2:	SWAB R3
	MOVB (R0)+,R5
	BIC #177400,R5
	BIS R5,R3
	COM R3
	BEQ BRK
	XOR R5,R5
	SEC
	ROR R3
	ADC R5
	MOV R3,R4
	;
OF3:	ADD R5,R5
	CALL RB
	ADC R5
	BNE LF1
	;
	INC R5
NXLF:	ADD R5,R5
	CALL RB
	ADC R5
	CALL RB
	BCC NXLF
	ADD #2,R5
	;
LF1:	CMP R3,#175400
	ADC R5
	INC R5
	;
	ADD R1,R3
NXMV:	MOVB (R3)+,(R1)+
	SOB R5,NXMV
	BR DCL
	;
BRK:	RET
	;
	; DRAW SINGLE CHAR
	; INPUT: R0=SCREEN ADDR
	; INPUT: R2=CHAR
	; OUTPUT: R0=NEW SCREEN	ADDR (+2)
TXCH:	MOV R1,-(SP)
	MOV R2,-(SP)
	MOV R3,-(SP)
	ASL R2
	MOV R2,-(SP)
	ASL R2
	ASL R2
	ADD (SP)+,R2
	ADD #FNT-320.,R2
	MOV #10.,R1
1$:	MOVB (R2)+,R3
	;
	MOV #100000,R4
2$:	RORB R3
	ROR R4
	ASR R4
	BCC 2$
	;
	BIC CHMSK,R4		; COLOR
	;
	MOV R4,(R0)
	ADD #64.,R0
	;
	SOB R1,1$
	;
	BIS CHUND,-64.(R0)	; UNDERLINE
	;
	SUB #640.-2.,R0
	;
	MOV (SP)+,R3
	MOV (SP)+,R2
	MOV (SP)+,R1
	RET
	;
CHMSK:	.WORD 0
CHUND:	.WORD 0
	;
	; DRAW TEXT STRING
	; INPUT: R0=SCREEN ADDR
	; INPUT: R1=ADDR OF TEXT STRING
	; OUTPUT: R0=NEW SCREEN	ADDR (+X)
	; OUTPUT: R1=NEXT BYTE ADDR AFTER STR
TXST:	MOV R0,R3
1$:	CLR R2
	BISB (R1)+,R2
	BEQ 2$
	CMPB R2,#12	; NEXT LINE
	BEQ 3$
	CMPB R2,#221	; RED
	BEQ 4$
	CMPB R2,#222	; GREEN
	BEQ 5$
	CMPB R2,#223	; BLUE
	BEQ 6$
	CMPB R2,#237	; UNDERLINE
	BEQ 7$
	TSTB R2		; CORRECT CODE
	BPL 8$
	SUB #32.,R2
8$:	CALL TXCH
	BR 1$
2$:	RET
3$:	ADD #640.,R3
	MOV R3,R0
	BR 1$
4$:	CLR CHMSK
	BR 1$
5$:	MOV #52525,CHMSK
	BR 1$
6$:	MOV #125252,CHMSK
	BR 1$
7$:	COM CHUND
	BR 1$
	;
	; SET TEXT POSITION ADDRESS
	; INPUT: R0=ADDR OF COORDS
	; OUTPUT: R0=SCREEN ADDR
TXPS:	MOV (R0)+,-(SP)	; X
	ASL (SP)	; X*2
	MOV (R0)+,R0	; Y
	ASL R0
	MOV R0,-(SP)
	ASL R0
	ASL R0
	ADD (SP)+,R0	; Y=Y*10
	ASL R0
	ASL R0
	ASL R0
	ASL R0
	ASL R0
	ASL R0		; Y=Y*64
	ADD (SP)+,R0	; Y=Y+X
	ADD #VSCR+2000,R0	; +SCREEN OFFSET
	RET
	;
	.END
 N