	;
	; PREPARE MAP, FORMAT:
	; 7 6 5	4 3 2 1	0
	; W W W	W M M M	R
	; W=WALL CODE
	; M=WALL MATERIAL
	; R=RESERVED
	; R0=MAP NUMBER	0..N
PREPM:	ASL R0
	MOV MAPLST(R0),R0
	; PLAYER SETUP
	MOV (R0)+,PLX
	MOV (R0)+,PLY
	MOV (R0)+,PLA
	; DECOMPRESS MAP
	MOV #MAP,R1
	CALL UNPK
	RET
	;
	; CLEAR	VISIBILITY MAP
CLVIS:	MOV #VIS,R5
	MOV #16.,R4
	MOV #-1.,R3
1$:	MOV R3,(R5)+
	MOV R3,(R5)+
	MOV R3,(R5)+
	MOV R3,(R5)+
	MOV R3,(R5)+
	MOV R3,(R5)+
	MOV R3,(R5)+
	MOV R3,(R5)+
	SOB R4,1$
	RET
	;
	; CALC TARGET ANGLE MONSTER->PLAYER
	; LINEAR APROXIMATION INSTANT OF ARCTAN
	; RESULT IN INTERNAL GRAD.INDEX	0..511
MLDVX:	XOR R2,R4
	XOR R4,R2
	XOR R2,R4
MLDVN:	ASL R2
	ASL R2
	ASL R2
	ASL R2
	ASL R2
	ASL R2	     ; R2=R2*64
	CALL SPDIV   ; R2=R2/R4
	RET
	;
GETANG:	MOV R0,-(SP)
	MOV R1,-(SP)
	MOV R2,-(SP)
	MOV R3,-(SP)
	MOV R4,-(SP)
	MOV PLX,R0
	MOV PLY,R1
	MOV 4.(R4),R2
	MOV 6.(R4),R4
	SUB R0,R2
	BGE 1$
	SUB R1,R4
	BGE 2$
	NEG R2 ; CASE I
	NEG R4
	CMP R2,R4
	BLE 3$
	; R2=(R4*64)/R2
	CALL MLDVX
	BR 99$
3$:	; R2=(R2*64)/R4
	CALL MLDVN
	; R2=128-1-R2
	MOV R2,R0
	MOV #128.-1.,R2
	SUB R0,R2
	BR 99$
2$:	NEG R2 ; CASE IV
	CMP R2,R4
	BLE 4$
	; R2=(R4*64)/R2
	CALL MLDVX
	; R2=64+64+384-1-R2
	MOV R2,R0
	MOV #64.+64.+384.-1.,R2
	SUB R0,R2
	BR 99$
4$:	; R2=(R2*64)/R4
	CALL MLDVN
	; R2=384+R2
	ADD #384.,R2
	BR 99$
1$:	SUB R1,R4
	BGE 5$
	NEG R4 ; CASE II
	CMP R2,R4
	BLE 6$
	; R2=(R4*64)/R2
	CALL MLDVX
	; R2=128+64+64-R2
	MOV R2,R0
	MOV #128.+64.+64.,R2
	SUB R0,R2
	BR 99$
6$:	; R2=(R2*64)/R4
	CALL MLDVN
	; R2=128+R2
	ADD #128.,R2
	BR 99$
5$:	CMP R2,R4 ; CASE III
	BLE 7$
	; R2=(R4*64)/R2
	CALL MLDVX
	; R2=256+R2
	ADD #256.,R2
	BR 99$
7$:	; R2=(R2*64)/R4
	CALL MLDVN
	; R2=256+128-R2
	MOV R2,R0
	MOV #256.+128.,R2
	SUB R0,R2
99$:	MOV (SP)+,R4
	MOV R2,2.(R4)
	MOV (SP)+,R3
	MOV (SP)+,R2
	MOV (SP)+,R1
	MOV (SP)+,R0
	RET
	;
	; CALC SPRITE PRESCALLERS
	; 32 WORD ADDRESSES AS INDEX TABLE
	; 32 BIT SCALLERS FOR EACH HEIGHT
CLPSC:	CLR R0
	MOV #PSCTAB,R3
	MOV #PSCTAB+64.,R5
1$:	MOV SCLR(R0),R1	; R1=TSCLR
	ADD #2,R0
	MOV R1,R2 ; R2=VSCLR
	ASR R2
	MOV R0,-(SP)
	MOV R5,(R3)+
2$:	MOV R2,R4
	BIC #255.,R4
	SWAB R4
	ASL R4
	MOV BTT(R4),(R5)+
	ADD R1,R2
	SUB #2,(SP)
	BNE 2$
	TST (SP)+
	CMP #64.,R0
	BNE 1$
	RET
	;
CLMAP:	MOV #MAPPOS,R3
	CLR R0
	MOV #64.,R1
1$:	MOV R0,(R3)+
	MOV R0,(R3)+
	MOV R0,(R3)+
	MOV R0,(R3)+
	MOV R0,(R3)+
	MOV R0,(R3)+
	MOV R0,(R3)+
	MOV R0,(R3)+
	ADD #64.-16.,R3
	CALL @SNDPR
	SOB R1,1$
	MOV #MAPBF,R3
	MOV #26.,R1
2$:	MOV R0,(R3)+
	SOB R1,2$
	RET
	;
DRMAP:	MOV #MAP,R2
	MOV #MAPPOS,R3
	MOV #16.,R0
3$:	MOV #16.,R1
2$:	CLR R4
	TSTB (R2)+
	BEQ 1$
	MOV #125,R4
1$:	MOVB R4,192.(R3)
	MOVB R4,128.(R3)
	MOVB R4,64.(R3)
	MOVB R4,(R3)+
	SOB R1,2$
	ADD #256.-16.,R3
	CALL @SNDPR
	SOB R0,3$
	RET
	;
PLPNT:	CALL @SNDPR
	ASR R1
	ASR R1
	ASR R1
	ASR R1
	MOV R1,R3
	BIC #177774,R3
	ASR R1
	ASR R1
	ASL R2
	ASL R2
	BIC #63.,R2
	ADD R1,R2
	ADD #MAPPOS,R2
	ADD R0,PC		;0.,6.,12.,18.
	BISB DRMS1(R3),(R2)	;4
	RET			;2
	BICB CLMSK(R3),(R2)	;4
	RET			;2
	BISB DRMS2(R3),(R2)	;4
	RET			;2
	BISB DRMS3(R3),(R2)	;4
	RET			;2
	;
DRALL:	MOV #MAPBF,R3
	MOV R3,R4
	MOV #26.,R1
1$:	MOV (R3)+,R0
	BEQ 2$
	CLRB (R0)
2$:	SOB R1,1$
	; DRAW PLAYER ON MAP
	MOV PLX,R1
	MOV PLY,R2
	CLR R0
	CALL PLPNT
	MOV R2,(R4)+
	; DRAW MONSTERS	ON MAP
	MOV #MNBF,R5
3$:	TSTB (R5)
	BEQ 4$
	MOV 4.(R5),R1
	MOV 6.(R5),R2
	MOV #18.,R0
	CALL PLPNT
	MOV R2,(R4)+
4$:	ADD #MNRS,R5
	CMP #MNBFE,R5
	BNE 3$
	RET
	;
MAPBF:	.BLKW 26.	; 25 MONSTERS+1	PLAYER
	;
	; RETURN CHECK OFFSET
	; IN: R0,R1 X,Y
	; OUT: R2 OFFSET
CHECKP:	MOV R0,R3
	MOV R1,R2
	ASL R3
	ASL R3
	SWAB R3
	ASR R2
	ASR R2
	BIC #15.,R2
	BISB R3,R2
	RET
	;
	; CHECK	COLLISION IN 8 DIRECTIONS
CHECK:	MOV R0,-(SP)
	MOV R1,-(SP)
	MOV R2,-(SP)
	MOV R3,-(SP)
	MOV #DIRS,R4
1$:	ADD (R4)+,R0
	ADD (R4)+,R1
	CALL CHECKP
	TSTB MAP(R2)
	BNE 2$
	CMP R4,#DIRS+32.
	BNE 1$
	CLR R4
2$:	MOV (SP)+,R3
	MOV (SP)+,R2
	MOV (SP)+,R1
	MOV (SP)+,R0
	TST R4
	RET
DIRS:	.WORD -12.,-12.,12.,0.,12.,0.,0.,12.
	.WORD 0.,12.,-12.,0.,-12.,0.,0.,-12.
	;
	; GET RANDOM NUMBER
FRN:	.WORD 327
RAN:	.WORD 0
	INCB RAN
	ROLB FRN+3
MM:	ADD #0,RAN
	ADD #3337,MM+2
	RET
	;
	; PRINT	CHAR
	; R0=CHAR,R1=SCR.ADDR.
PRCH:	MOV R1,-(SP)
	ASL R0
	MOV R0,-(SP)
	ASL R0
	ASL R0
	ADD (SP)+,R0
	ADD #FNT-320.,R0 ; FNT.OFFS.
	MOV #10.,-(SP)
1$:	MOV #4.,R2
	MOVB (R0)+,R3
2$:	CLRB (R1)
	CLRB 128.(R1)
	RORB R3
	BCC 3$
	BISB #15.,(R1)
	BISB #15.,128.(R1)
3$:	RORB R3
	BCC 4$
	BISB #240.,(R1)
	BISB #240.,128.(R1)
4$:	INC R1
	SOB R2,2$
	ADD #256.-4.,R1
	CALL @SNDPR
	DEC (SP)
	BNE 1$
	TST (SP)+
	MOV (SP)+,R1
	ADD #4.,R1
	RET
	;
	; DEC OUT XY (R4)
	; XY <=	30.
	; R1=SCR.ADDR.
DOUT:	CLR R5
	SUB #10.,R4
	BCS 1$
	INC R5
	SUB #10.,R4
	BCS 1$
	INC R5
	SUB #10.,R4
	BCS 1$
	INC R5
	BR 2$
1$:	ADD #10.,R4
2$:	MOV R5,R0
	ADD #'0,R0
	CALL PRCH
	MOV R4,R0
	ADD #'0,R0
	CALL PRCH
	RET
	;
	; RESET	SCORE
INISCR:	CLR SCORE
	MOV #1.,OLDSCR ; MAKE NOT EQUAL
	RET
	;
	; PRINT	SCORE AS 00:00
PRNSCR:	CMP SCORE,OLDSCR
	BEQ 1$ ; DO NOT	PRINT IF EQUAL
	MOV #SCOREP,R1
	MOVB SCORE,R4
	CALL DOUT
	MOVB #':,R0
	CALL PRCH
	MOVB SCORE+1,R4
	CALL DOUT
	MOV SCORE,OLDSCR
1$:	RET
	;
	; RESET	AMMO
INIAM:	MOVB #10.,AMMO
	MOVB #1.,OLDAM ; MAKE NOT EQUAL
	RET
	;
	; PRINT	AMMO XX
PRNAM:	CMPB AMMO,OLDAM
	BEQ 1$
	MOV #AMMOP,R1
	MOVB AMMO,R4
	CALL DOUT
	MOVB AMMO,OLDAM
1$:	RET
	;
	; PRINT	MESSAGE
	; IN: R5=MSG TYPE 0,1,2
PRNMS:	ASL R5
	MOV MSGPTR(R5),R5
	MOV (R5)+,R1
2$:	MOVB (R5)+,R0
	BEQ 1$
	CALL PRCH
	BR 2$
1$:	RET
	;
	; CLEAR	MESSAGE
CLMS:	MOV #MSGLN+20,R5
2$:	MOV #30,R4
1$:	CLR (R5)+
	SOB R4,1$
	ADD #20+64.,R5
	CMP R5,#60000
	BLO 2$
	RET
	;
	; CORRECT PL.ANGLE WHEN	DEMO RUNS
CORRA:	MOV R0,-(SP)
	MOV R1,-(SP)
	MOV R2,-(SP)
	MOV R3,-(SP)
	MOV R4,-(SP)
	MOV R5,-(SP)
	CLR (PC)+
STEPN:	.WORD 0
	MOV MNBF+2.,R5
	SUB PLA,R5	 ; D=MN.A-PL.A
	MOV #STEPC,R4
	MOV #10.,R3
1$:	MOV R5,R0
	MOV (R4)+,R1
	CALL SPMULS
	ASR R2
	ASR R2
	ASR R2
	ASR R2
	ASR R2
	ASR R2
	ADD PLA,R2
	BIC #177000,R2
	MOV R2,20.-2.(R4)
	SOB R3,1$
	MOV (SP)+,R5
	MOV (SP)+,R4
	MOV (SP)+,R3
	MOV (SP)+,R2
	MOV (SP)+,R1
	MOV (SP)+,R0
	RET
STEPC:	.WORD 2.,6.,13.,22.,32.,42.,51.,58.,62.,64.
STEPV:	.BLKW 10.
	;
	; SET PL.ANGLE WHEN DEMO RUNS
SETTA:	MOV STEPN,R0
	CMP R0,#20.
	BEQ 1$
	ADD #2,R0
	MOV R0,STEPN
	MOV STEPV-2(R0),PLA
1$:	RET
	;
	; DR.CROSSHAIR
DRCRH:	MOV #9.,R0
	MOV #60140-320.,R1
1$:	BISB #3,(R1)
	ADD #64.,R1
	SOB R0,1$
	BISB #374,@#60037
	BISB #377,@#60040
	RET
	;
	.END

 	