#version 330 core

//Input Vertex Data
layout(location = 0) in vec3 vertexPosition_modelspace; //Different for all executions
layout(location = 1) in vec2 vertexUV;
layout(location = 2) in uint vertexType;
layout(location = 3) in vec3 vertexNormal;

//Output data, will be interpolated for each fragment
out vec2 UV;
out vec4 Normal;
flat out uint type;

//Model View and projection matricies
uniform mat4 uMVMat;
uniform mat4 uPMat;
out vec3 vPos;

void main() {
	type = vertexType; //Pass type through

	//Transform vertice
	vPos = (uMVMat * vec4(vertexPosition_modelspace, 1)).xyz; // 1 on the end to signify position
	gl_Position = uPMat * vec4(vPos, 1);

	//Normal = MVP * vec4(vertexNormal, 0);
	Normal = vec4(vertexNormal, 0);

	//Pass UV through
	UV = vertexUV;
}
