;
; DEFINES
; 
txtout  equ $bb5a

ROW1 equ %00000010 ; = 2
ROW2 equ %01010001
ROW3 equ %00110000
ROW4 equ %01110010
ROW5 equ %00001001
ROW6 equ %00000100
ROW7 equ %10010010
ROW8 equ %01001001

org BASE ; see Makefile

        db 0 ; this can be stored implicitly
        ; i.e. it does not have to be part of the file/data generator

rows:
        db ROW1,ROW2,ROW3,ROW4,ROW5,ROW6,ROW7,ROW8

;
; IDEAS
;

; Use H and L as indices into the patterns 
; and D and E as offsets to add to HL after
; each row. 

; can we use the RES b,r trick (see dancedance.z80 aka heartbel)
;
; CODE
;
        

; CALL <nnnn> from Basic sets Z80 DE register to <nnnn>.
; i.e. DE=&202a

        ; HL = 68 = 0x0044

; regs:
; A=char, B=column counter, C=pattern bitmap, D=row counter, E=&2a = '*'
; HL=pattern ptr where H=&20 = ' '

; D and H are both $20 here

        ; print upper part
        ld hl, rows-1 ; the byte before "rows" must be zero!
        call print_rows

        call long_line

        ; print lower part
        ld a,$2b ; dec hl
        ld (inc_or_dec),a
        dec hl

print_rows:
        ld d,9
rows_loop: 
        ; load pattern
        ld c,(hl)

        ; print left part with leading space
        ld a,h ; $20
        call print_row_half

        ; inject RR C to print reversed
        ld a,$19
        ld (rotate+1),a

        ; prints middle column: '*'     
        ; and right part (=left part reversed) 
        ld a,e ; star
        call print_row_half

        call crlf
       
        ; inject RL C again
        ld a,$11
        ld (rotate+1),a

        ; next/previous row
inc_or_dec:
        inc hl ; or dec hl

        dec d
        jr nz,rows_loop
        ret

long_line:
        ; print long middle line
        ld a,e ; $2a
        ld b,19 ; = 0x13
middle_line:
        call $bb5a
        djnz middle_line
crlf:
        rst $18
	dw rom_addr_crlf
        ret

; ' ' = 32 = 0x20 = %00100000
; '*' = 42 = 0x2a = %00101010

; prints the pattern once, making half a row (without the middle column)
print_row_half:
        ; print what was in A
        ; A=char, B=loop cnt, C=bitmap, D=outer loop cnt, E='*', H=' ', L=pattern ptr
        ld b,9
print_loop:
        call $bb5a
        ld a,h ; = 32 = 0x20 = %00100000
rotate:
        rl c    ; cb 11
        jr nc,skip
        ld a,e; = 42 = 0x2a = %00101010 = '*'
skip:
        djnz print_loop
        ret

; 
; DATA
;

rom_addr_crlf:
	dw $c3e2 ; = print CRLF
;	db 0 ; this can be stored implicitly, see above