; MEGA65 entry for VCCC 2025 by GeirS, 2025-12-23.
; Size: 68 bytes excl. load address and BASIC stub. Assemble using ACME.

                !cpu m65
                !to "snowflake.prg",cbm

                * = $2001           ; Load address
; BASIC stub
                !word NextLine      ; Address of next line
                !word 1337          ; Line number
                !text $fe,$02,"0:"  ; Bank
                !text $9e,"8210"    ; SYS token and address
                !byte 0             ; End of line
NextLine        !word 0

; Code and data (68 bytes)
RowLoop1        inx
Start           jsr PrintRow
                bcc RowLoop1        ; Loop for upper rows and middle row
                dex
RowLoop2        jsr PrintRow
                dex
                bne RowLoop2        ; Loop for remaining rows except bottom row
PrintRow        lda #13             ; New line char
                jsr $ffd2           ; Call KERNAL routine to print char
                cpx #9              ; Set carry flag if asterisk at start of middle row
                jsr PrintChar       ; Print space or asterisk on screen
                sec                 ; The center column should contain an asterisk
                ldy #$3e            ; Opcode for 'rol abs,x'
                jsr PrintColumns    ; Print remaining left part of row
                dey                 ; Opcode for 'ror abs,x' ($7e)
PrintColumns    sty ColLoop         ; Set rotate instruction (self-modifying code)
                ldy #9+127          ; Number of columns + 127
ColLoop         rol BitPatterns,x   ; Rotate bit of current pattern into carry flag
                php                 ; Save carry flag
                jsr PrintChar       ; Print space or asterisk on screen
                plp                 ; Restore carry flag for next rotate
                dey
                bmi ColLoop         ; Loop for all columns
                cpx #9              ; Affect carry flag for ending 'RowLoop1' or determining char at end of row
                rts
PrintChar       lda #32             ; Space char
                bcc DoChrOut        ; Branch if a space should be printed
                lda #42             ; Asterisk char
DoChrOut        jmp $ffd2           ; Jump to KERNAL routine to print char

BitPatterns     !byte $00,$02,$51,$30,$72,$09,$04,$92,$49,$ff
