*  Draw a snowflake on the Apple II text screen.
*
*  Store one quadrant of the image and mirror it horizontally,
*  and then mirror lines 11-19 as the reverse of lines 1-9
*
*    1  . . . . . . . . . X
*    2  . . . . . . . X . X
*    3  . . X . X . . . X X
*    4  . . . X X . . . . X
*    5  . . X X X . . X . X
*    6  . . . . . X . . X X
*    7  . . . . . . X . . X
*    8  . X . . X . . X . X
*    9  . . X . . X . . X X
*   10  X X X X X X X X X X

*  Logiker 2025 contest entry
*  by Jerry Penner
*  jerry@jpen.ca

                org   $300

cout            =     $fded
crout           =     $fd8e

bits            =     $00
line_delta      =     $01

                lda   #0
                tax
quadrant_loop
                sta   line_delta
line_loop
                txa                        ; some positive value
                pha                        ;  to use as a sentinel on the stack
                sec                        ; first time, ensure LSB is 1 after 1 shift
bytes_loop
                lda   quad_shape,x
                sta   bits
bits_loop       rol   bits
                beq   next_byte

                lda   #" "
                bcc   print_it
                lda   #"*"
print_it        pha
                jsr   cout
                clc
                bcc   bits_loop
next_byte                                  ; we only ever come here for the second byte
                clc
                inx
                txa
                and   #1
                bne   bytes_loop           ; note carry is clear, so we only do two bits

                pla
mirror_print    pla
                bpl   next_line
                jsr   cout
                bra   mirror_print

next_line
                jsr   crout
                txa
                clc
                adc   line_delta
                tax
                bmi   all_done

                cpx   #quad_limit
                bcc   line_loop
                lda   #$fc                 ; new line_delta of -4
                ldx   #quad_limit-4
                bne   quadrant_loop
all_done        rts

quad_shape
                db    %00000000,%01100000
                db    %00000001,%01100000
                db    %00101000,%11100000
                db    %00011000,%01100000
                db    %00111001,%01100000
                db    %00000100,%11100000
                db    %00000010,%01100000
                db    %01001001,%01100000
                db    %00100100,%11100000
                db    %11111111,%11100000
quad_limit      =     *-quad_shape
