org   $7701
bitmap:                 ; prefix the code with bitmap data
        defb   $02,$51,$30,$72,$09,$04,$92,$49
start:			; start = $7709 => BC
        ld e, b		; copy $77 => E
col:
        ld b, 9     	; start each col on the 10th row, immediately
rotate:			; plot an asterisk and its 4 rotations
        push bc     	; save BC as it gets destroyed 
        call $8f5   	; point HL at (col C, row B)
        pop bc      	; retrieve BC
        ld (hl), 23  	; plot one *
        ld a, 18     	; load A with rotation constant
        sub b       	; A = 18-B
        ret z	 	; If col = 0 then exit before plotting bitmap
        ld b,c      	; B = C and
        ld c,a      	; C = 18-B => rotate 90º clockwise around (9,9)
        rrc e		; 8-bit rotate E, exit loop every 4 rotations
check:
        jr c, rotate  	; plot if set / exit loop every 4th time
        ld h, e		; bitmap resides at $7700 + col, load the $77
        ld l, c		; from E and the col from C
        srl (hl)    	; grab 1 bit from bitmap
        djnz check	; use this bit for next row, until we run out
        dec c       	; otherwise, move on to next col
        jp (hl)      	; print the next col and its rotations
end:        		; equivalent to jr col

