//*************************************************************************************************
//
// Snowflake C64 by ssusnic, 20.12.2025.
//
// Commodore C64 entry for Vintage Computing Christmas Challenge 2025 (VCCC2025).
// Programmed in 6502 Assembly by using Kick Assembler.
//
// Instructions for running the program:
//  - start the VICE C64 emulator
//  - drag and drop "snowflake50b.prg" into it
//  - enter SYS 30168
//
// Copyright (C) 2025 by Srdjan Susnic
//
//*************************************************************************************************

// Program starts at $75D8 because it uses Vector($19/$20) to load snowflake data from memory.
// ZP($19) was chosen because its default value is 0A and it can be used nicely as a row counter 
// that goes from 10 to -10, so we can easily identify the middle row at value=0.
// Since ZP($20)=76 by default, then Vector($19/$20) = $760A
// So the Starting Address = $760A - Program Size = $7610 - 50bytes = $75D8

*=$75D8 "Snowflake C64"

init:
    pha                 // push A=0 onto stack so we can quit the program when pull 0 from stack
do_rows:
    jsr $AAD7           // print new line char
    ldy #18             // Y=current output column on the right side
    dec $19             // ZP($19)={10 (to push 0),9,8,...,1,0,-1,...,-8,-9,-10 (to pull 0)}
    beq set_star        // if X=0, we are at the central row so print only stars; here is ZP($60)=0
    bmi pull            // if X<0, get data from stack (lower half) else from memory (upper half)
        lda ($19, x)    // read snowflake data from memory address defined by the Vector($19/$20)
        pha             // push A onto stack to use fetched data in reverse order in lower half
        pha             // since PLA is the next instruction, push A onto stack again
    pull:
        pla             // pull snowflake data from stack into A
        beq quit        // if A=0 (pulled when X=-10), quit the program
        sta quit: $60   // store snowflake data in zeropage ZP($60); note: $60 is also RTS opcode
    set_space:
        lda #' '        // A=' ' (here each row except the central row starts with ' ')
    do_columns:
        jsr $FFD2       // print char in A on the left side
        sta ($D1), y    // print char in A on the right side
        dey             // Y=Y-1 to go one column left so Y={18, 17, 16, ..., 9, 8}
        cpy #9          // if Y<9
        bmi do_rows     // then go to process the next row
        asl $60         // else shift snowflake data in ZP($60) to the left
        bcs set_space   // if shifted bit in carry is set (C=1) then print space
    set_star:           // else print star
        lda #'*'        // A='*'
        bne do_columns  // go to process the next column

// data table of the top-left part of the snowflake (star=0, space=1)
// it is loaded by using ZP($19) as a row pointer from the address defined by the Vector($19/$20)
flake:
    .byte %10110110     // ZP($19)=1 -> Vector=$7601
    .byte %01101101     // ZP($19)=2 -> Vector=$7602
    .byte %11111011     // ZP($19)=3 -> Vector=$7603
    .byte %11110110     // ZP($19)=4 -> Vector=$7604
    .byte %10001101     // ZP($19)=5 -> Vector=$7605
    .byte %11001111     // ZP($19)=6 -> Vector=$7606
    .byte %10101110     // ZP($19)=7 -> Vector=$7607
    .byte %11111101     // ZP($19)=8 -> Vector=$7608
    .byte %11111111     // ZP($19)=9 -> Vector=$7609
