pattern={
    0b0000000001,
    0b0000000101,
    0b0010100011,
    0b0001100001,
    0b0011100101,
    0b0000010011,
    0b0000001001,
    0b0100100101,
    0b0010010011,
    0b1111111111
}

function gb(row, col)
    return (pattern[row+1] >> (9 - col)) & 1
end

function _init()
    t = 0
    wave_height = 1
    wave_speed = 0.1
end

function _update()
    t = t + wave_speed / 3
end

function _draw()
    cls()
    local center_x = 64
    local center_y = 64
    local spacing = 6.5
    for row = 0, 18 do
        for col = 0, 18 do
            local pattern_row, pattern_col
            if row <= 9 then pattern_row = row
            else pattern_row = 18 - row end
            if col <= 9 then pattern_col = col
            else pattern_col = 18 - col end
            if gb(pattern_row, pattern_col) == 1 then
                local x = center_x + (col - 9) * spacing
                local y = center_y + (row - 9) * spacing
                local wave = sin(t + x * 0.02 + y * 0.03) * wave_height
                local wave2= cos(t + x * 0.03 + y * 0.02)
                x = x + wave2
                y = y + wave
                local color = 3
                if wave > wave_height * 0.7 then
                    color = 7
                elseif wave < -wave_height * 0.7 then
                    color = 8
                end
                circfill(x, y, 2, color)
                circfill(x-1, y-1, 1, 7)
            end
        end
    end
end