UNIT UARTINE;
{$R-}
{Range checking must be turned off, so as to permit the little trick with
the array}
{
 ____________     _  ________________________________   /\   ________________
____    __  \     __________      /    ____________ \ /  \__\________      /
.:/     \     \  ____ |:   _/    _/     \/:    \  :\ Y _______/:   _/    _/:
:/      :Y     \_  ____     \    \      \      /    \ /     \_     \    \:
/        |______/   .:|___________/____________/      Y________/___________/:
\________|: [ DA A BOMB CREW PRESENTS YA ] :\_________|: [ A-BOMB UARTiNE ]..

}
INTERFACE

TYPE
  ElementType = Char;

  ElementArray = ARRAY[0..0] OF Char;

  QUEUE   = RECORD
    Front,
    Rear  : Word;
    EL    : ^ElementArray;
    Size  : Word;
    Count : Word;
  END;

PROCEDURE MakeQueueEmpty(VAR Q : Queue;
                         QSize : Word);

FUNCTION  QueueIsEmpty(Q : Queue) : Boolean;

FUNCTION  QueueIsFull(Q : Queue) : Boolean;

PROCEDURE Enqueue(VAR Q   : Queue;
                  Element : ElementType);

PROCEDURE Dequeue(VAR Q       : Queue;
                  VAR Element : ElementType);

IMPLEMENTATION


PROCEDURE MakeQueueEmpty(VAR Q : Queue; QSize : Word);

BEGIN
  GetMem(Q.EL,QSize);
  Q.Front := 1;
  Q.Rear  := 0;
  Q.Size  := QSize;
  Q.Count := 0;
END;

FUNCTION QueueIsEmpty(Q : Queue) : Boolean;

BEGIN
  QueueIsEmpty := (Q.Count = 0);
END;

FUNCTION QueueIsFull(Q : Queue) : Boolean;

BEGIN
  QueueIsFull := (Q.Count = Q.Size);
END;


PROCEDURE Enqueue(VAR Q : Queue; Element : ElementType);

BEGIN
  WITH Q Do BEGIN
    Rear := (Rear + 1) MOD Size;
    EL^[Rear] := Element;
    Inc(Count);
  END;
END;

PROCEDURE Dequeue(VAR Q : Queue; VAR Element : ElementType);

BEGIN
  WITH Q DO BEGIN
    Element := EL^[Front];
    Front := (Front + 1) MOD Size;
    Dec(Count);
  END;
END;

END.
