/*
 *  dd_listmsgs.cpp
 *
 *  DayDream door to list all messages in a messagebase
 *
 *  Copyright (C) 2009 by Niels Haedecke (lodger@gmx.de)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 */

#include <iostream>
#include <fstream>
#include <string> 	// C++ string
#include <algorithm>
using namespace std;

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <dd.h>
#include <ddlib.h>

/*!! DO NOT CHANGE DOOR VERSION !!*/
#define DOOR_VERSION "1.0.2"
#define MAX_DATA_SIZE 512
#define MAX_SUBJECT_LEN 35

#define LIST_HEADER "dd_listmsgs-header"
#define ANSI_CLRINPUT "[2J[1H"

struct DayDream_Conference *conference;
struct DayDream_MsgBase *msgbase;
struct DayDream_MsgPointers mp;
struct DayDream_Message msg_header;
struct dif *d;
struct tm *timeval;

int curr_confno;
int curr_msgbaseno;
int user_account_id;
int user_maxlines;
int linecount=0;
int show_deleted=0;
int tmpval=0;

int highest;
int lowest;

char tmpstr[MAX_DATA_SIZE];
char tmp_subj[MAX_SUBJECT_LEN + 1];  // ensure enough space
char tmp_recv[26];
char promptbuf[3];

int list_msgheaders(void)
{
	int fd;
	int msghandle;
	char fname[PATH_MAX + 1];

	int notauthor=0;
	int notreceiver=0;

	curr_confno = dd_getintval(d, SYS_CONF);
	curr_msgbaseno = dd_getintval(d, SYS_MSGBASE);
	user_account_id = dd_getintval(d, USER_ACCOUNT_ID);
	user_maxlines = dd_getintval(d, USER_SCREENLENGTH);

	conference = dd_getconf(curr_confno);
	msgbase = dd_getbase(curr_confno, curr_msgbaseno);

	dd_getmprs(d, &mp);

	lowest = mp.msp_low;
	highest = mp.msp_high;

	snprintf(fname, PATH_MAX + 1, "%s/messages/base%3.3d/msgbase.dat",
		 conference->CONF_PATH,
		 msgbase->MSGBASE_NUMBER);

	if ((fd = open(fname, O_RDONLY)) == -1)
		return -1;

    /*lseek(fd, sizeof(msg_header), SEEK_SET);*/
    lseek(fd, 0, SEEK_SET);

    dd_sendstring(d, ANSI_CLRINPUT);
    dd_typefile(d, LIST_HEADER, TYPE_MAKE);
    linecount += 7;

    sprintf(tmpstr,"[0;97m     Conf. [[0;33m%d[0;97m]: \"[0;33m%s[0;97m\" - Msg. base [[0;36m%d[0;97m]: \"[0;36m%s[0;97m\"[0;37m\n", conference->CONF_NUMBER, conference->CONF_NAME, msgbase->MSGBASE_NUMBER, msgbase->MSGBASE_NAME);
    dd_sendstring(d, tmpstr);
    linecount++;

    /*
    sprintf(tmpstr,"\n[0;36mNo.:  Date:\t Time:\tFrom:\tTo:\tSubject:\t\t\t Att.:[0;37m\n");
    dd_sendstring(d, tmpstr);
    */

    dd_sendstring(d, "[0;34m------------------------------------------------------------------------------\n[0;37m");
    linecount++;

	for (;;) {

		if (read(fd, &msg_header, sizeof(struct DayDream_Message)) !=
		    sizeof(struct DayDream_Message))
			break;

		if (msg_header.MSG_NUMBER < lowest ||
		    msg_header.MSG_NUMBER > highest)
			continue;
		/*
		dd_sendstring(d, msg_header.MSG_SUBJECT);
		dd_sendstring(d, "\n");*/

		/* no deleted messages */
        snprintf(tmpstr, sizeof tmpstr,
                "%s/messages/base%3.3d/msg%5.5d",
                 conference->CONF_PATH,
                 msgbase->MSGBASE_NUMBER,
                 msg_header.MSG_NUMBER);

       	if ((msghandle = open(tmpstr, O_RDONLY)) == -1)
       	{
       	   close(msghandle);

       	   if (show_deleted)
       	   {
       	      sprintf(tmpstr,"\n[0;31m%04d \t\t\t\tdeleted[0;37m\n", msg_header.MSG_NUMBER);
  	          dd_sendstring(d, tmpstr);
  	       }

		   continue;
        }
        else
        {
           close(msghandle);
        }

        /* no deleted messages
        if (msg_header.MSG_FLAGS & (1L<<1))
        continue;
        */

        memset(tmp_recv, '\0', sizeof(tmp_recv));

        /* keep privacy */
        if (msg_header.MSG_FLAGS & (1L<<0))
        {
           if (dd_findusername(d, msg_header.MSG_RECEIVER) != user_account_id)
	          notreceiver=1;

	       if (dd_findusername(d, msg_header.MSG_AUTHOR) != user_account_id)
	          notauthor=1;

	       if (notreceiver==1 && notauthor==1)
	       {
	          notreceiver=0;
	          notauthor=0;
	          continue;
	       }
	      else
	      {
	         strcpy(tmp_recv, msg_header.MSG_RECEIVER);
	         notreceiver=0;
	         notauthor=0;
	      }
	    }
        else
        {
           if (! strcmp(msg_header.MSG_RECEIVER,""))
           {
              strcpy(tmp_recv, "All");
           }
        }

	if (strlen(msg_header.MSG_SUBJECT) > MAX_SUBJECT_LEN) {
	    strncpy(tmp_subj, msg_header.MSG_SUBJECT, MAX_SUBJECT_LEN);
	    tmp_subj[MAX_SUBJECT_LEN]='\0';
	} else {
    	    strncpy(tmp_subj, msg_header.MSG_SUBJECT, MAX_SUBJECT_LEN);
    	    tmp_subj[MAX_SUBJECT_LEN]='\0';  // Ensure null termination
	}


        timeval = localtime(&msg_header.MSG_CREATION);

        if (linecount >= user_maxlines)
        {
           dd_sendstring(d, "More? Y)es, N)o ");
           dd_prompt(d,promptbuf,2,0);

           switch (*promptbuf) {
             case 'n':
             case 'N':
               exit(0);
               break;
           }
        linecount=0;
       }

        sprintf(tmpstr, "\n[0;36m%04d [0;97m%02d.%02d.%04d [0;97m%02d:%02d", msg_header.MSG_NUMBER, timeval->tm_mday, timeval->tm_mon+1, timeval->tm_year+1900, timeval->tm_hour, timeval->tm_min);
        dd_sendstring(d, tmpstr);
        linecount++;

        sprintf(tmpstr, "  From: [0;33m%s\t\t[0;97mTo: [0;33m%s", msg_header.MSG_AUTHOR, tmp_recv);
        dd_sendstring(d, tmpstr);

	    sprintf(tmpstr, "[0;97m[72GFile:");
	    dd_sendstring(d, tmpstr);

        if (strlen(msg_header.MSG_ATTACH) > 0)
           dd_sendstring(d, "[78G[0;92mY\n");
        else
           dd_sendstring(d, "[78G[0;91mN\n");

        linecount++;

        sprintf(tmpstr, "[0;97m[24GSub.:[0;32m %s[m\n", tmp_subj);
        dd_sendstring(d, tmpstr);

        linecount++;
    }

    dd_sendstring(d, "\n");
    close(fd);
    return 0;
}

int main(int argc, char *argv[])
{
    int opt;
    string tmpnode;

    while((opt = getopt(argc, argv, "dn:")) != -1)
    {
      if(opt == 'd') show_deleted = 1;
      if(opt == 'n' && strcmp(optarg, "") != 0) tmpnode = optarg;
    }

    if (argc==1) {
          printf("Must be run from DayDream BBS!\n");
          printf("Options:\n");
          printf("-n [node#] : use node number (required!)\n");
          printf("-d         : list deleted\n");
          exit(1);
    }

    strcpy(tmpstr, tmpnode.c_str());
    d=dd_initdoor(tmpstr);

    if (d==0) {
       printf("Couldn't find socket!\n");
       exit(1);
    }

    sprintf(tmpstr, "listing messages");
    dd_changestatus(d, tmpstr);
    dd_sendstring(d, "\n");

    list_msgheaders();

    exit(0);

}
