uses user,cfg;

type MLine = record
       C: Char;
       LC: Char;
       X: Byte;
       Y: Byte;
       _Y: Byte;
       L: Byte;
       First: Boolean;
     end;

var
   MLines: array[0..255] of MLine;
   I, MCount, MSpeed: Byte;
   Key: Char;
   chars : string = '!@#$%*)=+DdEeMmoNnIiCc';

procedure clearLine(X, F, T: Byte);
var Y: Byte;
begin

     for Y := F to T do
     begin
          if(Y > 24) then break;
          GotoXY(X, Y);
          Write(' ');
     end;

end;

procedure makeMLine(var Line: MLine);
begin
  Line.C := chr(Random(256));
  Line.X := Random(80)+1;
  Line.Y := Random(24)+1;
  Line._Y := Line.Y;
  Line.L := Random(24)+1;
  Line.First := True;
end;

procedure processMLine(var Line: MLine);
begin

  if(Line.Y - Line._Y >= Line.L) then
  begin
    GotoXY(Line.X, Line.Y - Line.L);
    Write(' ');
    GotoXY(1 ,1);
  end;

  if(Line.Y < 24 + Line.L) then
  begin

    if (not Line.First) and
       (Line.Y - 1 <= 24) and
       (Line.Y - 1 <> Line.Y - Line.L) then
    begin
      TextColor(4);
      GotoXY(Line.X, Line.Y-1);
      Write(Line.LC);
    end;

    if(Line.Y <= 24) then
    begin
      TextColor(12);
      GotoXY(Line.X, Line.Y);
      Write(Line.C);
    end;

    Line.LC := Line.C;
    //Line.C := Chr(Random(256));
    line.c := chars[random(length(chars))+1];

    Line.First := False;

    line.y:=line.y+1;
  end
  else makeMLine(Line);

  GotoXY(1, 1);

end;

begin

     ClrScr;
     Randomize;
     write('|16');

     MCount := 100;
     MSpeed := 100;

     for i := 0 to MCount do
         makeMLine(MLines[i]);

     MLines[0].X := 40;
     MLines[0]._Y := 20;
     MLines[0].Y := 20;
     MLines[0].L := 24;

     while(true) do
     begin
         for i := 0 to MCount do
             processMline(MLines[i]);

         if(KeyPressed) then break;
         Delay(MSpeed);
     end;

     ClrScr;

end.
