;       ͻ
;                         
TITLE    FLI & FLC PLAYER 
;                         
;       ͼ
;
; THIS FLI/FLC PLAYER WAS CODED IN EARLY 1995
;
;                        BY SILVIO TURELLO (FRONTMAN/CREW242)
;
; IT IS BASED ON THE FLI ROUTINES
;
;                        BY ADRIAN STUDER (CHICKEN/S!P)
;
; FEATURES: PLAYS FLI AND FLC ANIMATIONS BY 320*200*256
;
;
.ALPHA
.MODEL MEDIUM
COM_OR_OBJ	= 0
STACKLENGTH     = 0100H
UGROUPFP GROUP CODE_SEGFP, DATA_SEGFP
ASSUME CS:UGROUPFP, DS:UGROUPFP, SS:UGROUPFP
;=============================================================================
SCR_WIDTH	= 320
SCR_HEIGHT	= 200
IRQ1            = 20H
IRQ2		=0A0H
IRQ3		=0A1H
TIMER0		= 40H
TIMER2          = 42H
PIT1            = 43H
KEYB            = 60H
PPI             = 61H
UHR_INDEX	= 70H
UHR_PORT	= 71H
UHR_STATA	= 0AH
UHR_STATB	= 0BH
UHR_STATC	= 0CH
SC_INDEX	= 3C4H		;Indexregister des Sequencer-Ctrl.
SC_SCREEN	= 1		;CLOCKING MODE, SCREEN OFF
DAC_INDEX       = 03C8H
VERT_RETRACE    = 3DAH          ;Input Status-Register #1
VRAM_BASE       =0A000H         ;START-ADRESSE DES VIDEO-RAMS
;=============================================================================

DATA_SEGFP SEGMENT WORD USE16
;=============================================================================
PROG_START_SEG  DW 0
PROG_END_SEG    DW 0
COMP_SPEED2     DW 0106H
COMP_SPEED3     DW 4006H
COMP_SPEED4     DW 0
COMP_SPEED5     DW 1165
GRAFX_BUS       DW 0                    ;0=LOCAL BUS, 1=ISA BUS
SYSTEM		DB 0			;0=REAL TIME CLOCK IRQ, 1=TIMER IRQ
IRQCOUNT	DB 56
GDDHANDLE       DW 0
VIR_SEG		DW 0
TIMER_SYNC      DW 0
FLI_NAME	DB 64 DUP(0)
INFO_TEXT	DB "USAGE: FLCPLAY <FILENAME.FL?>",13,10,"$"
;-----------------------------------------------------------------------------
ALIGN 2
FliCount	DB 1
FliRealSpeed	DB 5
FrameCount      DW 0
FramePtr        DW 0
FliLcCount      DW 0
FliBrunCount    DW 0
FliFirstFrame   DW 0,0

FliSize         DD 0
FliMagic        DW 0            ;should be af11h
FliFrames       DW 0
FliWidth        DW 0
FliHeight       DW 0
FliDepth        DW 0
FliFlags        DW 0
FliSpeed        DW 0
FliNext         DD 0
FliFrit         DD 0
FliExpand       DB 66H DUP(0)

FrameSize       DD 0
FrameMagic      DW 0            ;should be f1fah
FrameChunks     DW 0
FrameExpand     DB 8 DUP(0)
;-----------------------------------------------------------------------------
ALIGN 2
CHAINING	DW 0
FX_PANNING	DW 0
FX_OFFSET	DW 0
FX_SEG		DW 0
FX_CALL		DW 0,0

FLIFX1		DW -1
;		DW FRAME NUMBER, FX HANDLE, FX FREQ, -1 = END
;-----------------------------------------------------------------------------
PROG_END        LABEL   BYTE    ;MUSS LETZE ZEILE IM DATENSEGMENT SEIN!
;-----------------------------------------------------------------------------
DATA_SEGFP ENDS

.386
CODE_SEGFP SEGMENT PAGE USE16
ORG 100H
;=============================================================================
PUBLIC _MAINFP
_MAINFP PROC FAR
	JMP	SHORT MAIN_CONT		;0100
	NOP
	RETF
	CALL	DEVICE_INIT		;0104
	RETF
	CALL	DEVICE_END		;0108
	RETF
	CALL	PLAY_FLI		;010C
	RETF
_MAINFP ENDP
;=============================================================================

IF COM_OR_OBJ
;=============================================================================
MAIN_CONT PROC NEAR
	PUSH	BP DS CS ES
	POP	DS
	SHL	DI,2
	ADD	DI,0100H
	CALL	DI			;FAR CALL
	SETC	DL
	XOR	DH,DH
	POP	DS BP			;BP IS ABSOLUTELY IMPORTANT FOR C
	RETF
MAIN_CONT ENDP
;=============================================================================

ELSE
;=============================================================================
MAIN_CONT PROC NEAR
	MOV	AX,CS
	MOV	DS,AX
	MOV     PROG_START_SEG,ES       ;PROGRAMMANFANG
	MOV     AX,SS                   ;UND -ENDE MERKEN
	MOV     BX,OFFSET PROG_END
	ADD     BX,STACKLENGTH
	MOV     SP,BX
	SHR     BX,4
	INC     BX
	ADD     AX,BX
	MOV     PROG_END_SEG,AX
	CMP	BYTE PTR ES:[80H],0
	JE	SHORT GM2
	XOR	BX,BX
GL1:	MOV	AL,ES:[82H+BX]
	OR	AL,AL
	JZ	SHORT GL2
	CMP	AL,20H
	JE	SHORT GL2
	CMP	AL,0DH
	JE	SHORT GL2
	MOV	[FLI_NAME+BX],AL
	INC	BX
	CMP	BX,40H
	JB	GL1
GL2:	OR	BX,BX
	JZ	SHORT GM2
	MOV     BX,PROG_END_SEG         ;SPEICHER FREI MACHEN
	SUB     BX,PROG_START_SEG
	MOV     ES,PROG_START_SEG
	MOV     AH,4AH                  ;SPEICHERBLOCKGRSSE NDERN
	INT     21H
	MOV	CX,1
	CALL	DEVICE_INIT
	MOV	AL,0			;NO IRQ CHAINING, RTC IRQ, NO FX
	MOV	CL,5			;FLI SPEED
	MOV	CH,1			;FLI LOOP NUMBER
	MOV	DX,OFFSET FLI_NAME	;FLI FILENAME
	CALL	PLAY_FLI
	MOV	CX,1
	CALL	DEVICE_END
	JMP	SHORT GM1
GM2:	MOV	DX,OFFSET INFO_TEXT
	MOV	AH,9
	INT	21H
GM1:	MOV	AX,4C00H
	INT	21H
MAIN_CONT ENDP
;=============================================================================
ENDIF

;=============================================================================
; PLAY FLI-FILE FROM VOL
; DS:DX= FILENAME, CL= SPEED, CH= ANZAHL LOOPS
; AL= STATUS, BIT 0= IRQ CHAINING 0/1= OFF/ON
;             BIT 1= IRQ TYPE 0/1= RTC/TIMER
;             BIT 2= USE FX DATA FROM DEVICE-INIT 0/1= NO/YES
;=============================================================================
PLAY_FLI PROC NEAR
	AND	CL,7FH
	MOV	CS:CHAINING,AX
	SHR	AL,1
	AND	AL,1
	MOV	CS:SYSTEM,AL
	MOV	CS:FliRealSpeed,CL
	MOV	CS:FliCount,CH
	CALL	FliInit
	JC	GFLI6
	MOV	BX,1000H
	MOV	AH,48H
	INT	21H
	MOV	VIR_SEG,AX
	MOV	FrameCount,0FFFFH
	MOV	TIMER_SYNC,0
	MOV	FX_PANNING,224
	CALL	IRQ_INIT
	MOV	AX,VRAM_BASE		;CLEAR SCREEN
	MOV	ES,AX
	XOR     DI,DI
	MOV     CX,(SCR_HEIGHT*SCR_WIDTH)/4
	XOR     EAX,EAX
	CLD
	REP     STOSD
NextLoop:
	MOV	AH,1
	INT	16H
	JZ	SHORT NO_KEY
	XOR	AX,AX
	INT	16H
	CMP	AL,27
	JE	GFLI1
NO_KEY:	CALL	FliNextFrame
	JC	GFLI4
	MOV	CL,FliRealSpeed
	AND	CX,7FH
	MOV	BX,CX
	SHL	BX,4
	MOV	DX,VERT_RETRACE		;Vertical Retrace abwarten
SpeedLoop:
	IN	AL,DX
	TEST	AL,8
	JNZ	SpeedLoop
No_Retrace:
	IN	AL,DX
	TEST	AL,8
	JZ	No_Retrace
	CMP	BX,TIMER_SYNC
	JBE	SHORT GFLI3
	LOOP	SpeedLoop
GFLI3:	MOV	TIMER_SYNC,0
	CALL	FliShowFrame
	JC	SHORT GFLI1
	TEST	CHAINING,4
	JZ	NextLoop
	MOV	BX,FX_OFFSET		;PLAY FX
	MOV	FS,FX_SEG
LFLI1:	MOV	AX,FS:[BX]
	CMP	AX,-1
	JE	NextLoop
	DEC	AX
	CMP	AX,FrameCount
	JNE	SHORT GFLI2
	NOT	FX_PANNING
	PUSHA
	PUSH	DS ES FS GS
	MOV	AX,FX_PANNING
	MOV	CX,FS:[BX+4]
	MOV	BX,FS:[BX+2]
	MOV	DI,7
	CALL	DWORD PTR DS:[FX_CALL]
	POP	GS FS ES DS
	POPA
GFLI2:	ADD	BX,6
	JMP	LFLI1
GFLI4:	CMP	FliCount,0
	JNE	SHORT GFLI1
	CLC
	JMP	SHORT GFLI5
GFLI1:	STC
GFLI5:	PUSHF
	CALL	IRQ_INIT
	MOV	ES,VIR_SEG
	MOV	AH,49H
	INT	21H
	POPF
GFLI6:	PUSHF
	MOV	BX,GDDHANDLE
	MOV	AH,3EH
	INT	21H
	POPF
	RET
;-----------------------------------------------------------------------------
;File DS:DX=FILENAME  ffnen, FliHeader laden und prfen
;-----------------------------------------------------------------------------
FliInit:
	MOV     AX,3D80H
	INT     21H
	MOV	DX,CS
	MOV	DS,DX
	MOV	HOLD70_SEG,DX
	JC      SHORT GLDM1
	MOV     GDDHANDLE,AX
	MOV	BX,AX
	MOV	CX,80H
	MOV	DX,OFFSET FliSize
	MOV	AH,3FH			;READ CX BYTES TO DS:DX
	INT	21H
	JC	SHORT GLDM1
	CMP	FliMagic,0AF11H
	JE	SHORT GLDM2
	CMP	FliMagic,0AF12H
	JE	SHORT GLDM2
	STC
	JMP	SHORT GLDM1
GLDM2:	CLC
GLDM1:	RET
;-----------------------------------------------------------------------------
;holt nchstes Frame in Puffer
;-----------------------------------------------------------------------------
FliNextFrame:
	INC	FrameCount
	MOV	AX,FrameCount
	CMP	AX,FliFrames
	JB	SHORT FliNextOk
	JNE	SHORT FliNext1
	DEC	FliCount
	JNZ	SHORT FliNextOk
	JMP	SHORT FliNextError
FliNext1:
	MOV	FrameCount,1
	MOV	BX,GDDHANDLE
	MOV	DX,FliFirstFrame
	MOV	CX,FliFirstFrame+2
	MOV	AX,4200H		;setzt Pointer in File bx nach cx:dx
	INT	21H
	MOV	AX,FrameCount
	JMP	SHORT FliNextOk2
FliNextOk:
	CMP	AX,1
	JNE	SHORT FliNextOk2
	MOV	BX,GDDHANDLE		
	MOV	AX,4201H		;holt Pointer in File bx nach dx:ax
	XOR	CX,CX
	XOR	DX,DX
	INT	21H
	MOV	FliFirstFrame,AX
	MOV	FliFirstFrame+2,DX
FliNextOk2:
	MOV	BX,GDDHANDLE
	MOV	CX,16
	MOV	DX,OFFSET FrameSize
	MOV	AH,3FH			;READ CX BYTES TO DS:DX
	INT	21H
	JC	SHORT FliNextError
	MOV	BX,GDDHANDLE
	MOV	CX,WORD PTR FrameSize
	SUB	CX,16
	CMP	FrameMagic,0F1FAH
	JE	SHORT FliNextOk3
	MOV	DX,CX
	XOR	CX,CX			;INFO FRAME AUSLASSEN
	MOV	AX,4201H		;setzt Pointer in File bx nach cx:dx
	INT	21H
	JMP	FliNextOk2
FliNextOk3:
	PUSH	DS
	MOV	DS,VIR_SEG
	XOR	DX,DX
	MOV	AH,3FH			;READ CX BYTES TO DS:DX
	INT	21H
	POP	DS
	JC	SHORT FliNextError
	CMP	AX,CX
	JNE	SHORT FliNextError
	CLC
	RET
FliNextError:
	STC
	RET
;-----------------------------------------------------------------------------
;Verarbeitet Frame aus Puffer
;-----------------------------------------------------------------------------
FliShowFrame:
	CMP	FrameChunks,0
	JE	SHORT FliNoChunk
	MOV	FS,VIR_SEG
	XOR	BP,BP
	MOV	FramePtr,BP
FliNextChunk:				;64-LEVEL-COLOR
	CMP	WORD PTR FS:[BP+4],0BH	;CHUNKS OF FORMAT AF11H
	JNE	SHORT ChunkJ1
	XOR	AH,AH
	CALL	FliColorChunk
	JMP	SHORT FliEndChunk
ChunkJ1:				;DELTA-FLI, COMPRESSED, BYTE
	CMP	WORD PTR FS:[BP+4],0CH
	JNE	SHORT ChunkJ2
	CALL	FliLcChunk
	JMP	SHORT FliEndChunk
ChunkJ2:				;BLACK FRAME
	CMP	WORD PTR FS:[BP+4],0DH
	JNE	SHORT ChunkJ3
	CALL	FliBlackChunk
	JMP	SHORT FliEndChunk
ChunkJ3:				;BYTE RUN, COMPRESSED
	CMP	WORD PTR FS:[BP+4],0FH
	JNE	SHORT ChunkJ4
	CALL	FliBrunChunk
	JMP	SHORT FliEndChunk
ChunkJ4:				;LITERAL, UNCOMPRESSED
	CMP	WORD PTR FS:[BP+4],10H
	JNE	SHORT ChunkJ5
	CALL	FliCopyChunk
	JMP	SHORT FliEndChunk
ChunkJ5:				;256-LEVEL-COLOR
	CMP	WORD PTR FS:[BP+4],04H	;CHUNKS OF FORMAT AF12H
	JNE	SHORT ChunkJ6
	MOV	AH,1
	CALL	FliColorChunk
	JMP	SHORT FliEndChunk
ChunkJ6:				;DELTA-FLC, COMPRESSED, WORD
	CMP	WORD PTR FS:[BP+4],07H
	JNE	SHORT ChunkJ7
	CALL	FlcLcChunk
	JMP	SHORT FliEndChunk
ChunkJ7:				;18 PREVIEW STAMP SKIPPED
FliEndChunk:
	MOV	BP,FramePtr
	ADD	BP,FS:[BP]
	MOV	FramePtr,BP
	DEC	FrameChunks
	JNZ	FliNextChunk
FliNoChunk:
	CALL	SCREEN_ON
	CLC
	RET
FliFrameError:
	CALL	SCREEN_ON
	STC
	RET
;-----------------------------------------------------------------------------
;verarbeitet Chunk FLI_Color ab fs:bp
;AH=0 64-LEVEL-COLORS, #0 256-LEVEL-COLORS
;-----------------------------------------------------------------------------
FliColorChunk:
	CALL	SCREEN_OFF
	PUSH	DS FS
	POP	DS
	ADD	BP,6
	XOR	AL,AL
	MOV	BX,FS:[BP]
	ADD	BP,2
FliMoreColor:
	ADD	AL,FS:[BP]
	MOV	DX,DAC_INDEX
	OUT	DX,AL
	INC	DX
	MOV	SI,BP
	ADD	SI,2
	MOVZX	CX,FS:[BP+1]
	OR	CL,CL
	JNZ	SHORT FliNot256
	MOV	CX,100H
FliNot256:
	ADD	AL,CL
	OR	AH,AH
	JZ	SHORT Fli64L
	PUSH	AX
Fli256L:
	MOV	AX,[SI]
	SHR	AL,2
	SHR	AH,2
	OUT	DX,AL
	MOV	AL,AH
	INC	SI
	OUT	DX,AL
	INC	SI
	MOV	AL,[SI]
	INC	SI
	SHR	AL,2
	OUT	DX,AL
	LOOP	Fli256L
	POP	AX
	JMP	SHORT FliGoC
Fli64L:	MOV	DI,CX			; CX * 3
	ADD	CX,DI
	ADD	CX,DI
	REP OUTSB
FliGoC:	MOV	BP,SI
	DEC	BX
	JNZ	FliMoreColor
	POP	DS
	TEST	GRAFX_BUS,1
	JNZ	SHORT FliGoS
	CALL	SCREEN_ON
FliGoS:	CLC
	RET
;-----------------------------------------------------------------------------
;verarbeitet Chunk FLI_LC ab fs:bp
;-----------------------------------------------------------------------------
FliLcChunk:
	PUSH	DS FS
	POP	DS
	ADD	BP,6
	MOV	AX,FS:[BP+2]
	MOV	CS:FliLcCount,AX
	MOV	AX,SCR_HEIGHT
	SUB	AX,CS:FliHeight
	SHR	AX,1
	ADD	AX,FS:[BP]
	MOV	DI,SCR_WIDTH
	MUL	DI
	MOV	DX,AX
	SUB	DI,CS:FliWidth
	SHR	DI,1
	ADD	DX,DI
	ADD	BP,4
FliLcNext2:
	MOVZX	BX,FS:[BP]
	INC	BP
	MOV	DI,DX
	ADD	DX,CS:FliWidth
	OR	BL,BL
	JZ	SHORT FliLcNext3
FliLcNext:
	MOVZX	CX,FS:[BP]
	ADD	DI,CX
	MOV	CL,FS:[BP+1]
	TEST	CL,80H
	JZ	SHORT FliLcSeq
	NEG	CL
	MOV	AL,FS:[BP+2]
	SHR	CL,1
	JNC	SHORT FliLcHalf1
	STOSB
FliLcHalf1:
	JCXZ	SHORT FliLcZero1
	MOV	AH,AL
	REP STOSW
FliLcZero1:
	ADD	BP,3
	DEC	BX
	JNZ	FliLcNext
FliLcNext3:
	DEC	CS:FliLcCount
	JNZ	FliLcNext2
	POP	DS
	CLC
	RET
FliLcSeq:
	ADD	BP,2
	MOV	SI,BP
	SHR	CL,1
	JNC	SHORT FliLcHalf2
	MOVSB
FliLcHalf2:
	JCXZ	SHORT FliLcZero2
	REP MOVSW
FliLcZero2:
	MOV	BP,SI
	DEC	BX
	JNZ	FliLcNext
	DEC	CS:FliLcCount
	JNZ	FliLcNext2
	POP	DS
	CLC
	RET
;-----------------------------------------------------------------------------
;verarbeitet Chunk FLC_LC ab fs:bp
;-----------------------------------------------------------------------------
FlcLcChunk:
	PUSH	DS FS
	POP	DS
	ADD	BP,6
	MOV	AX,FS:[BP]
	MOV	CS:FliLcCount,AX
	MOV	AX,SCR_HEIGHT
	SUB	AX,CS:FliHeight
	SHR	AX,1
	MOV	DX,SCR_WIDTH
	MUL	DX
	MOV	DX,SCR_WIDTH
	SUB	DX,CS:FliWidth
	SHR	DX,1
	ADD	DX,AX
	ADD	BP,2
FlcLcNext2:
	MOV	AX,FS:[BP]
	ADD	BP,2
	TEST	AH,80H
	JZ	SHORT FlcLcNext4
	TEST	AH,40H
	JZ	SHORT FlcLcNext5
	PUSH	DX
	MOV	DI,CS:FliWidth
	NEG	AX
	MUL	DI
	POP	DX
	ADD	DX,AX
	JMP	FlcLcNext2
FlcLcNext5:
	MOV	DI,DX
	ADD	DI,CS:FliWidth
	DEC	DI
	STOSB
	JMP	FlcLcNext2
FlcLcNext4:
	MOV	BX,AX
	MOV	DI,DX
	ADD	DX,CS:FliWidth
	OR	BX,BX
	JZ	SHORT FlcLcNext3
FlcLcNext:
	MOVZX	CX,FS:[BP]
	INC	BP
	ADD	DI,CX
	MOV	CL,FS:[BP]
	INC	BP
	TEST	CL,80H
	JZ	SHORT FlcLcSeq
	NEG	CL
	JCXZ	SHORT FlcLcZero1
	MOV	AX,FS:[BP]
	ADD	BP,2
	REP STOSW
	JMP	SHORT FlcLcZero1
FlcLcSeq:
	MOV	SI,BP
	JCXZ	SHORT FlcLcZero2
	REP MOVSW
FlcLcZero2:
	MOV	BP,SI
FlcLcZero1:
	DEC	BX
	JNZ	FlcLcNext
FlcLcNext3:
	DEC	CS:FliLcCount
	JNZ	FlcLcNext2
	POP	DS
	CLC
	RET
;-----------------------------------------------------------------------------
;verarbeitet Chunk FLI_BLACK ab fs:bp
;-----------------------------------------------------------------------------
FliBlackChunk:
	MOV	AX,CS:FliHeight
	MOV	DI,SCR_WIDTH
	MUL	DI
	MOV	CX,AX
	SHR	CX,2
	MOV	AX,SCR_HEIGHT
	SUB	AX,CS:FliHeight
	SHR	AX,1
	MUL	DI
	MOV	DI,AX
	XOR	EAX,EAX
	REP STOSD
	CLC
	RET
;-----------------------------------------------------------------------------
;verarbeitet Chunk FLI_BRUN ab fs:bp
;-----------------------------------------------------------------------------
FliBrunChunk:
	PUSH	DS FS
	POP	DS
	ADD	BP,6
	MOV	AX,CS:FliHeight
	MOV	CS:FliBrunCount,AX
	MOV	AX,SCR_HEIGHT
	SUB	AX,CS:FliHeight
	SHR	AX,1
	MOV	DI,SCR_WIDTH
	MUL	DI
	SUB	DI,CS:FliWidth
	SHR	DI,1
	ADD	DI,AX
FliBrunNext2:
	MOVZX	BX,FS:[BP]
	INC	BP
FliBrunNext:
	MOVZX	CX,FS:[BP]
	TEST	CL,80H
	JNZ	SHORT FliBrunSeq
	MOV	AL,FS:[BP+1]
	SHR	CL,1
	JNC	SHORT FliBrunHalf1
	STOSB
FliBrunHalf1:
	JCXZ	SHORT FliBrunZero1
	MOV	AH,AL
	REP STOSW
FliBrunZero1:
	ADD	BP,2
	DEC	BX
	JNZ	FliBrunNext
FliBrunNext3:
	DEC	CS:FliBrunCount
	JNZ	FliBrunNext2
	POP	DS
	CLC
	RET
FliBrunSeq:
	NEG	CL
	INC	BP
	MOV	SI,BP
	SHR	CL,1
	JNC	SHORT FliBrunHalf2
	MOVSB
FliBrunHalf2:
	JCXZ	SHORT FliBrunZero2
	REP MOVSW
FliBrunZero2:
	MOV	BP,SI
	DEC	BX
	JNZ	FliBrunNext
	DEC	CS:FliBrunCount
	JNZ	FliBrunNext2
	POP	DS
	CLC
	RET
;-----------------------------------------------------------------------------
;verarbeitet Chunk FLI_COPY ab fs:bp
;-----------------------------------------------------------------------------
FliCopyChunk:
	PUSH	DS FS
	POP	DS
	ADD	BP,6
	MOV	SI,BP
	MOV	AX,CS:FliHeight
	MOV	DI,CS:FliWidth
	MUL	DI
	MOV	CX,AX
	SHR	CX,2
	MOV	AX,SCR_HEIGHT
	SUB	AX,CS:FliHeight
	SHR	AX,1
	MOV	DI,SCR_WIDTH
	MUL	DI
	MOV	DI,AX
	REP MOVSD
	POP	DS
	CLC
	RET
PLAY_FLI ENDP
;=============================================================================
SCREEN_OFF PROC NEAR
	PUSH	AX DX
	MOV	DX,SC_INDEX
	MOV	AL,SC_SCREEN
	OUT	DX,AL
	INC	DX
	IN	AL,DX
	OR	AL,00100000B
	OUT	DX,AL
	OR	FliRealSpeed,80H
	POP	DX AX
	RET
SCREEN_OFF ENDP
;=============================================================================
SCREEN_ON PROC NEAR
	TEST	FliRealSpeed,80H
	JZ	SHORT GSCO1
	PUSH	AX DX
	MOV	DX,SC_INDEX
	MOV	AL,SC_SCREEN
	OUT	DX,AL
	INC	DX
	IN	AL,DX
	AND	AL,11011111B
	OUT	DX,AL
	AND	FliRealSpeed,7FH
	POP	DX AX
GSCO1:	RET
SCREEN_ON ENDP
;=============================================================================


;=============================================================================
; TIMEOUT-HANDLER
;-----------------------------------------------------------------------------
IRQ70_HANDLER PROC FAR
	PUSH	AX DS CS
	POP	DS
	INC     TIMER_SYNC
	TEST	CHAINING,1
	JNZ	SHORT WT5
	CMP	SYSTEM,0
	JE	SHORT WT4
	DEC	IRQCOUNT
	JNZ	SHORT WT3
WT5:	POP	DS AX
	JMP	DWORD PTR CS:[HOLD70]
WT4:	MOV	AL,UHR_STATC
	OUT	UHR_INDEX,AL
	JMP	SHORT WT1
WT1:	JMP	SHORT WT2
WT2:	IN	AL,UHR_PORT
WT3:	MOV     AL,20H
	OUT     IRQ2,AL
	OUT     IRQ1,AL
	POP     DS AX
	IRET
HOLD70		LABEL DWORD
		DW OFFSET IRQ70_HANDLER
HOLD70_SEG	DW 0
IRQ70_HANDLER ENDP
;=============================================================================
; SERVICE IRQ 09H,64H,65H,66H UMLEITUNG
;-----------------------------------------------------------------------------
IRQ_INIT PROC NEAR
	CLI
	XOR     AX,AX
	MOV     ES,AX
	CMP	SYSTEM,0
	JNE	SHORT WU13
	TEST	CHAINING,1
	JNZ	SHORT WU11
	MOV     AX,COMP_SPEED2		;FOR DOS
	MOV     DX,COMP_SPEED3
	MOV     COMP_SPEED2,DX
	MOV     COMP_SPEED3,AX
WU0:	MOV	AL,UHR_STATA		;UHR-IRQ-RATE EINSTELLEN
	OUT	UHR_INDEX,AL
	JMP	SHORT WU1
WU1:	JMP	SHORT WU2
WU2:	XCHG	AL,AH
	IN	AL,UHR_PORT
	AND	AL,0F0H
	OR	AL,DL
	XCHG	AL,AH
	OUT	UHR_INDEX,AL
	JMP	SHORT WU3
WU3:	JMP	SHORT WU4
WU4:	XCHG	AL,AH
	OUT	UHR_PORT,AL
	JMP	SHORT WU5
WU5:	JMP	SHORT WU6
WU6:	MOV	AL,UHR_STATB		;UHR-IRQ-MODUS EINSTELLEN
	OUT	UHR_INDEX,AL
	JMP	SHORT WU7
WU7:	JMP	SHORT WU8
WU8:	XCHG	AL,AH
	IN	AL,UHR_PORT
	AND	AL,08FH
	MOV	DL,DH
	AND	DL,40H
	OR	AL,DL
	XCHG	AL,AH
	OUT	UHR_INDEX,AL
	JMP	SHORT WU9
WU9:	JMP	SHORT WU10
WU10:	XCHG	AL,AH
	OUT	UHR_PORT,AL
	IN	AL,IRQ3			;IRQ8 MASKIEREN
	AND	AL,0FEH
	MOV	DL,DH
	AND	DL,1
	OR	AL,DL
	OUT	IRQ3,AL
WU11:	MOV     BX,4*70H                ;TIMEOUT-IRQ VERBIEGEN
	MOV     EAX,ES:[BX]
	MOV     EDX,CS:HOLD70
	MOV     ES:[BX],EDX
	MOV     CS:HOLD70,EAX
	JMP	SHORT WU16
WU13:	TEST	CHAINING,1
	JNZ	SHORT WU15
	MOV     AX,COMP_SPEED4		;FOR WINDOWS
	MOV     DX,COMP_SPEED5
	MOV     COMP_SPEED4,DX
	MOV     COMP_SPEED5,AX
WU14:	MOV     AL,00110110B            ;TIMER0 AUF 1.024 KHZ EINSTELLEN
	OUT     PIT1,AL                 ;TEILER=1193
	MOV     AL,DL
	OUT     TIMER0,AL
	JMP     SHORT OUT40
OUT40:  MOV     AL,DH
	OUT     TIMER0,AL
WU15:	MOV     BX,4*8H                 ;TIMEOUT-IRQ VERBIEGEN
	MOV     EAX,ES:[BX]
	MOV     EDX,CS:HOLD70
	MOV     ES:[BX],EDX
	MOV     CS:HOLD70,EAX
WU16:	STI
	RET
IRQ_INIT ENDP
;=============================================================================
; EINSTELLEN DES VIDEOMODUS
; DS:DX= POINTER TO FX-LIST, AX:BX= POINTER TO FX-ROUTINE
; CX= 0 DON'T CHANGE VIDEO MODE, 1= INIT VIDEO MODE
;-----------------------------------------------------------------------------
DEVICE_INIT PROC NEAR
	MOV	CS:FX_OFFSET,DX
	MOV	CS:FX_SEG,DS
	MOV	DX,CS
	MOV	DS,DX
	MOV	FX_CALL,BX
	MOV	FX_CALL+2,AX
	JCXZ	SHORT GVID1
DIM1:	MOV	DX,3DAH			;WAIT FOR RETRACE
	IN	AL,DX
	TEST	AL,8
	JZ	SHORT DIM1
	MOV	DX,DAC_INDEX
	XOR	AL,AL
	OUT	DX,AL
	INC	DX
	MOV	CX,256*3
DIM2:	OUT	DX,AL
	LOOP	DIM2
	MOV     AX,13H                  ;320*200 256-FARBEN-MODUS
	INT     10H
	MOV     AX,VRAM_BASE            ;VIDEORAM FLLEN (HORIZONTALE LIN.)
	MOV     ES,AX
	XOR     DI,DI
	MOV     CX,16000
	XOR     EAX,EAX
	CLD
	REP     STOSD
GVID1:	RET
DEVICE_INIT ENDP
;=============================================================================
; CX= 0 DON'T CHANGE VIDEO MODE, 1= END VIDEO MODE
;-----------------------------------------------------------------------------
DEVICE_END PROC NEAR
	JCXZ	SHORT GDE1
	MOV	AX,3
	INT	10H
GDE1:	RET
DEVICE_END ENDP
;=============================================================================
CODE_SEGFP ENDS

END _MAINFP
