TITLE MULTIMEDIA-INTERFACE FOR SOUNDSYS 
;======================================

STACKL= 0200H
DOSSEG
.MODEL SMALL
.STACK STACKL
.DATA

;=============================================================================
B		EQU BYTE PTR
W		EQU WORD PTR
D		EQU DWORD PTR
PROG_START_SEG	DW 0
PROG_END_SEG	DW 0
PARM_BLOCK	DW 0
		DW OFFSET COMMANDLINE
		DW SEG COMMANDLINE
		DW 0,0,0,0
COMMANDLINE	DB 0," ",13
MUSIC_SEG	DW 0
FX_HANDLE	DW 0
FX_LIST		DW  12,0,18000,   14,0,19000,   16,0,20000,   18,0,21000
		DW  20,0,22000,   22,0,23000,   24,0,24000,   26,0,25000

		DW  55,0,16000,   60,0,17000,   65,0,18000,   70,0,19000
		DW  75,0,20000,   80,0,21000,   85,0,22000,   90,0,23000

		DW -1
;		DW FRAME NUMBER, FX HANDLE, FX FREQ, -1 = END

AUTO_BLOCK	DB 16 DUP(0)
NAME1		DB "MMI.EXE",0
NAME2		DB "KNULLA.MOD",0
NAME3		DB "SAMPLE.FXP",0
NAME4		DB "DEMO.FLI",0
NAME5		DB "Hit a key...",13,10,"$"
;=============================================================================

.386
.CODE
;=============================================================================
MAIN PROC NEAR
        MOV     AX,@DATA                ;SET DS
        MOV     DS,AX
	MOV	AX,CS
	MOV     PROG_START_SEG,ES       ;HOLD PROG START & END
        MOV     AX,SS
        ADD     AX,(STACKL/16)+1
        MOV     PROG_END_SEG,AX
        MOV     AX,ES:[2CH]             ;GET SEG OF ENVIRONMENT-BLOCK
        MOV     PARM_BLOCK,AX
	MOV     BX,WORD PTR PROG_END_SEG;FREE MEM
        SUB     BX,WORD PTR PROG_START_SEG
        MOV     ES,PROG_START_SEG
        MOV     AH,4AH
        INT     21H

	PUSH	DS			;CALL MMI.EXE
	POP	ES
	MOV	BX,OFFSET PARM_BLOCK
	MOV	DX,OFFSET NAME1
	MOV	AX,4B00H
	INT	21H
	CALL	KWAIT

	PUSH	DS			;AUTO-DETECT
	POP	ES
	MOV	BX,OFFSET AUTO_BLOCK
	MOV	BP,2
	INT	66H
	TEST	AX,AX
	JZ	GM1

	MOV	BP,3			;LOAD PLAYER
	INT	66H
	JC	GM1

	PUSH	DS			;INIT PLAYER
	POP	ES
	MOV	BX,OFFSET AUTO_BLOCK
	MOV	CX,0C242H
	MOV	BP,41H
	INT	66H
	MOV	MUSIC_SEG,AX
	JC	GM2

	PUSH	DS			;LOAD MOD
	POP	ES
	MOV	DX,OFFSET NAME2
	MOV	BP,42H
	INT	66H
	JC	GM2

	PUSH	DS			;LOAD FX
	POP	ES
	MOV	DX,OFFSET NAME3
	MOV	CL,80H
	MOV	BP,46H
	INT	66H
	MOV	FX_HANDLE,AX
	JC	SHORT GM3

	MOV	BP,43H			;PLAY MOD
	INT	66H
	JC	SHORT GM3
	CALL	KWAIT

	MOV	BP,44H			;STOP MOD
	INT	66H
	CALL	KWAIT

	MOV	BP,43H			;PLAY MOD
	INT	66H
	JC	SHORT GM3

	MOV	AL,12			;SET SONGPOSITION
	MOV	BP,4EH
	INT	66H
	CALL	KWAIT

	MOV	BX,FX_HANDLE		;PLAY FX
	MOV	CX,20000		;FX FREQUENCY
	MOV	AL,0			;PANNING TOTAL LEFT
	MOV	BP,47H
	INT	66H
	CALL	KWAIT

	MOV	BX,FX_HANDLE		;PLAY FX
	MOV	CX,24000		;FX FREQUENCY
	MOV	AL,255			;PANNING TOTAL RIGHT
	MOV	BP,47H
	INT	66H
	CALL	KWAIT
	
	PUSH	DS			;INIT FLI ANIMATION (WITH FX)
	POP	ES
	MOV	DX,OFFSET FX_LIST
	MOV	AX,MUSIC_SEG
	MOV	BX,011CH	
	MOV	CX,1
	MOV	BP,0C1H
	INT	66H

	PUSH	DS			;PLAY FLI (WITH FX)
	POP	ES
	MOV	DX,OFFSET NAME4
	MOV	CL,2
	MOV	CH,3
	MOV	AL,4
	MOV	BP,0C3H
	INT	66H

	MOV	CX,1			;END FLI
	MOV	BP,0C2H
	INT	66H
	CALL	KWAIT

	MOV	BP,44H			;STOP MOD
	INT	66H

GM3:	MOV	BP,48H			;UNLOAD FX
	INT	66H

	MOV	BP,45H			;UNLOAD MOD
	INT	66H

GM2:	MOV	BP,4			;UNLOAD PLAYER
	INT	66H
	CALL	KWAIT

GM1:	MOV	BP,81H			;INIT CD
	INT	66H
	JC	SHORT GM4

	MOV	AL,2			;PLAY CD
	MOV	AH,1
	MOV	CX,0
	MOV	BP,83H
	INT	66H
	CALL	KWAIT

	MOV	CX,1			;INIT FLI ANIMATION (NO FX)
	MOV	BP,0C1H
	INT	66H

	PUSH	DS			;PLAY FLI (NO FX)
	POP	ES
	MOV	DX,OFFSET NAME4
	MOV	CL,1
	MOV	CH,15
	MOV	AL,0
	MOV	BP,0C3H
	INT	66H

	MOV	CX,1			;END FLI
	MOV	BP,0C2H
	INT	66H
	CALL	KWAIT

	MOV	BP,85H			;PAUSE CD
	INT	66H
	CALL	KWAIT

	MOV	BP,86H			;RESUME CD
	INT	66H
	CALL	KWAIT

	MOV	BP,84H			;STOP CD
	INT	66H

GM4:	MOV	BP,1			;UNLOAD MMI.EXE
	INT	66H

	MOV	AX,4C00H
	INT	21H
MAIN ENDP
;-----------------------------------------------------------------------------
KWAIT:	MOV	AH,9
	MOV	DX,OFFSET NAME5
	INT	21H
	XOR	AX,AX
	INT	16H
	RET
;=============================================================================


END MAIN