
// ------------------------------------------------------------------------------------------------
//    SphereBack.cpp - Sphere Background code.
//    Copyright  2001. Remage / Fresh!mindworkz.
// ------------------------------------------------------------------------------------------------

#include <Windows.h>
#include <D3D8.h>

#include "Main.h"
#include "Fmath.h"
#include "TxGen.h"
#include "D3DU8.h"

extern int ExportTGA;

#define D3DFVF_SPHEREBACK_VERTEX1 (D3DFVF_XYZ|D3DFVF_DIFFUSE|D3DFVF_TEX2|D3DFVF_TEXCOORDSIZE2(0)|D3DFVF_TEXCOORDSIZE2(1))
struct SPHEREBACK_VERTEX1
  {
    D3DVECTOR Vertex;
    // float RHW;
    DWORD Diffuse;
    float TexU1, TexV1;
    float TexU2, TexV2;
    // float TexU3, TexV3;
   };

// ------------------------------------------------------------------------------------------------

LPDIRECT3DVERTEXBUFFER8 SphereBack_VertexBuffer1 = NULL;
SPHEREBACK_VERTEX1 *SphereBack_LockedVertexBuffer1;

LPDIRECT3DINDEXBUFFER8 SphereBack_IndexBuffer1 = NULL;
WORD *SphereBack_LockedIndexBuffer1;

LPDIRECT3DTEXTURE8 SphereBack_Texture1 = NULL, SphereBack_Texture2 = NULL, SphereBack_Texture3 = NULL, SphereBack_Texture4= NULL;

D3DMATERIAL8 SphereBack_Material1;
D3DLIGHT8 SphereBack_Light1;

static TXGEN_LAYER *TxLayer1, *TxLayer2;

// ------------------------------------------------------------------------------------------------
//    SphereBack_Initialize();
// ------------------------------------------------------------------------------------------------

int SphereBack_Initialize( void )
  {
    int X, Y, Col;
    float DX, DY, DC;

    // --- Create VertexBuffer1.
    if ( Direct3DDevice->CreateVertexBuffer( 65*37*sizeof( SPHEREBACK_VERTEX1 ), 0, D3DFVF_SPHEREBACK_VERTEX1,
      D3DPOOL_DEFAULT, &SphereBack_VertexBuffer1 ) != D3D_OK ) return 0;
    if ( SphereBack_VertexBuffer1->Lock( 0, 65*37*sizeof( SPHEREBACK_VERTEX1 ), (BYTE**) &SphereBack_LockedVertexBuffer1, 0 ) != D3D_OK ) return 0;

    for ( Y=0; Y<37; Y++ )
      for ( X=0; X<65; X++ )
        {
          D3DUVec3Create( &SphereBack_LockedVertexBuffer1[ Y*65+X ].Vertex, 10.0f*X, 10.0f*Y + 60.0f, 1.0f );
          // SphereBack_LockedVertexBuffer1[ Y*65+X ].RHW = 1.0f;

          DX = X - 22.0f;
          DY = Y - 12.0f;
          DC = Fsqrt( Fsqr( DX ) + Fsqr( DY ));
/*
          SphereBack_LockedVertexBuffer1[ Y*65+X ].TexU1= 
            SphereBack_LockedVertexBuffer1[ Y*65+X ].TexU2 = 0.6f * DX / ( DC + 6.0f );
            // SphereBack_LockedVertexBuffer1[ Y*65+X ].TexU3 = 0.6f * DX / ( DC + 6.0f );
*/            
          SphereBack_LockedVertexBuffer1[ Y*65+X ].TexU1= 
            SphereBack_LockedVertexBuffer1[ Y*65+X ].TexU2 = 1.6f * DX / ( DC + 6.0f );
/*
          SphereBack_LockedVertexBuffer1[ Y*65+X ].TexV1 = 
            SphereBack_LockedVertexBuffer1[ Y*65+X ].TexV2 = 0.6f * DY / ( DC + 6.0f );
            // SphereBack_LockedVertexBuffer1[ Y*65+X ].TexV3 = 0.6f * DY / ( DC + 6.0f );
*/
          SphereBack_LockedVertexBuffer1[ Y*65+X ].TexV1 = 
            SphereBack_LockedVertexBuffer1[ Y*65+X ].TexV2 = 1.6f * DY / ( DC + 6.0f );

          Col = Fround( 40.0f + Fsqr( DC + 38.0f ) / 20.0f );
          if ( Col > 255 ) Col = 255;

          SphereBack_LockedVertexBuffer1[ Y*65+X ].Diffuse = 0x00010101 * Col;
         }

    SphereBack_VertexBuffer1->Unlock();

    // --- Create IndexBuffer1.
    if ( Direct3DDevice->CreateIndexBuffer( 13824*sizeof( WORD ), 0, D3DFMT_INDEX16, D3DPOOL_DEFAULT, &SphereBack_IndexBuffer1 ) != D3D_OK ) return 0;
    if ( SphereBack_IndexBuffer1->Lock( 0, 13824*sizeof( WORD ), (BYTE**) &SphereBack_LockedIndexBuffer1, 0 ) != D3D_OK ) return 0;

    for ( Y=0; Y<36; Y++ )
      for ( X=0; X<64; X++ )
        {
          SphereBack_LockedIndexBuffer1[ (Y*64+X)*6+0 ] = Y*65+X;
          SphereBack_LockedIndexBuffer1[ (Y*64+X)*6+1 ] = Y*65+X+1;
          SphereBack_LockedIndexBuffer1[ (Y*64+X)*6+2 ] = Y*65+X+65;
          SphereBack_LockedIndexBuffer1[ (Y*64+X)*6+3 ] = Y*65+X+1;
          SphereBack_LockedIndexBuffer1[ (Y*64+X)*6+4 ] = Y*65+X+66;
          SphereBack_LockedIndexBuffer1[ (Y*64+X)*6+5 ] = Y*65+X+65;
         }

    SphereBack_IndexBuffer1->Unlock();

    // --- Create Textures.
    TxLayer1 = TxGen_LayerInitialize( 512, 512 );
    TxLayer2 = TxGen_LayerInitialize( 512, 512 );

    Direct3DDevice->CreateTexture( 512, 512, 1, 0, D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, &SphereBack_Texture1 );
    if ( !TxGen_LoadTGA( SphereBack_Texture1, "Dreams06.tga" ))
      {
        TxGen_SubPlasma( TxLayer1, 0x323F47, 0x749383, 30, 5 );
        TxGen_SubPlasma( TxLayer2, 0x323F47, 0x749383, 31, 12 );
        TxGen_LayerBlend( TxLayer1, TxLayer1, TxLayer2, 30, TXGEN_BLEND_ADD );
        TxGen_SubPlasma( TxLayer2, 0x323F47, 0x749383, 32, 23 );
        TxGen_LayerBlend( TxLayer1, TxLayer1, TxLayer2, 10, TXGEN_BLEND_ADD );
        TxGen_Cells( TxLayer2, 0x000000, 0xFFFFFF, 0, 100, 80 );
        TxGen_DistortSine( TxLayer2, 8, 0, 2, 7, 0, 3 );
        TxGen_LayerBlend( TxLayer1, TxLayer1, TxLayer2, 80, TXGEN_BLEND_MULTIPLY );
        TxGen_SetTexture( SphereBack_Texture1, TxLayer1 );
        if ( ExportTGA ) TxGen_SaveLayerTGA( TxLayer1, "Dreams06.tga" );
       }

    Direct3DDevice->CreateTexture( 512, 512, 1, 0, D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, &SphereBack_Texture2 );
    if ( !TxGen_LoadTGA( SphereBack_Texture2, "Dreams07.tga" ))
      {
        TxGen_SubPlasma( TxLayer1, 0x1B2830, 0x6A808B, 33, 4 );
        TxGen_SubPlasma( TxLayer2, 0x1B2830, 0x6A808B, 34, 13 );
        TxGen_LayerBlend( TxLayer1, TxLayer1, TxLayer2, 30, TXGEN_BLEND_ADD );
        TxGen_SubPlasma( TxLayer2, 0x1B2830, 0x6A808B, 35, 21 );
        TxGen_LayerBlend( TxLayer1, TxLayer1, TxLayer2, 10, TXGEN_BLEND_ADD );
        TxGen_Cells( TxLayer2, 0x000000, 0xFFFFFF, 1, 64, 64 );
        TxGen_DistortSine( TxLayer1, 7, 20, 3, 8, 90, 3 );
        TxGen_LayerBlend( TxLayer1, TxLayer1, TxLayer2, 80, TXGEN_BLEND_MULTIPLY );
        TxGen_SetTexture( SphereBack_Texture2, TxLayer1 );
        if ( ExportTGA ) TxGen_SaveLayerTGA( TxLayer1, "Dreams07.tga" );
       }

    Direct3DDevice->CreateTexture( 512, 512, 1, 0, D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, &SphereBack_Texture3 );
    if ( !TxGen_LoadTGA( SphereBack_Texture3, "Dreams08.tga" ))
      {
        TxGen_SubPlasma( TxLayer1, 0x2D4368, 0x011224, 36, 7 );
        TxGen_SubPlasma( TxLayer2, 0x2D4368, 0x011224, 37, 11 );
        TxGen_LayerBlend( TxLayer1, TxLayer1, TxLayer2, 20, TXGEN_BLEND_NORMAL );
        TxGen_SubPlasma( TxLayer2, 0x2D4368, 0x011224, 38, 24 );
        TxGen_LayerBlend( TxLayer1, TxLayer1, TxLayer2, 11, TXGEN_BLEND_NORMAL );
        TxGen_SubPlasma( TxLayer2, 0x93A4B6, 0x011224, 38, 47 );
        TxGen_LayerBlend( TxLayer1, TxLayer1, TxLayer2, 4, TXGEN_BLEND_NORMAL );
        TxGen_SetTexture( SphereBack_Texture3, TxLayer1 );
        if ( ExportTGA ) TxGen_SaveLayerTGA( TxLayer1, "Dreams08.tga" );
       }

    Direct3DDevice->CreateTexture( 512, 512, 1, 0, D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, &SphereBack_Texture4 );
    if ( !TxGen_LoadTGA( SphereBack_Texture4, "Dreams09.tga" ))
      {
        TxGen_SubPlasma( TxLayer1, 0x4D5348, 0x3F463C, 39, 7 );
        TxGen_SubPlasma( TxLayer2, 0x4D5348, 0x283224, 40, 11 );
        TxGen_LayerBlend( TxLayer1, TxLayer1, TxLayer2, 20, TXGEN_BLEND_NORMAL );
        TxGen_SubPlasma( TxLayer2, 0x5D4368, 0x111214, 41, 24 );
        TxGen_LayerBlend( TxLayer1, TxLayer1, TxLayer2, 11, TXGEN_BLEND_NORMAL );
        TxGen_SubPlasma( TxLayer2, 0x635A56, 0x111214, 42, 47 );
        TxGen_LayerBlend( TxLayer1, TxLayer1, TxLayer2, 4, TXGEN_BLEND_NORMAL );
        TxGen_SetTexture( SphereBack_Texture4, TxLayer1 );
        if ( ExportTGA ) TxGen_SaveLayerTGA( TxLayer1, "Dreams09.tga" );
       }

    TxGen_LayerCleanup( TxLayer1 );
    TxGen_LayerCleanup( TxLayer2 );

    return 1;
   }

// ------------------------------------------------------------------------------------------------
//    SphereBack_Cleanup();
// ------------------------------------------------------------------------------------------------

void SphereBack_Cleanup( void )
  {
    if ( SphereBack_VertexBuffer1 != NULL ) SphereBack_VertexBuffer1->Release();
    if ( SphereBack_IndexBuffer1 != NULL ) SphereBack_IndexBuffer1->Release();
    if ( SphereBack_Texture1 != NULL ) SphereBack_Texture1->Release();
    if ( SphereBack_Texture2 != NULL ) SphereBack_Texture2->Release();
    if ( SphereBack_Texture3 != NULL ) SphereBack_Texture3->Release();
    if ( SphereBack_Texture4 != NULL ) SphereBack_Texture4->Release();
   }

// ------------------------------------------------------------------------------------------------
//    SphereBack_Render1();
// ------------------------------------------------------------------------------------------------

void SphereBack_Render1( float Time )
  {
    float Light, Light2, Time2;
/*
    // --- Setup Material.
    memclear( &SphereBack_Material1, sizeof( D3DMATERIAL8 ));
    SphereBack_Material1.Diffuse.r = SphereBack_Material1.Ambient.r = Fsin( Time * 0.2f );
    SphereBack_Material1.Diffuse.g = SphereBack_Material1.Ambient.g = Fsin( Time * 0.2f );
    SphereBack_Material1.Diffuse.b = SphereBack_Material1.Ambient.b = Fsin( Time * 0.2f );
    Direct3DDevice->SetMaterial( &SphereBack_Material1 );
//*/
    // --- Setup Light.
    Direct3DDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
//    Direct3DDevice->SetRenderState( D3DRS_AMBIENT, 0x00FFFFFF );
    Direct3DDevice->LightEnable( 0, FALSE );

    Light = 0.5f;
    if ( Time < 128.0f ) Light = Time / 256.0f;
    if ( Time > 256.0f ) Light = 0.5f - ( Time - 256.0f ) / 256.0f;
    if ( Time > 384.0f ) Light = 0.0f;

    // --- Setup Texture Stage0.
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_DISABLE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MIPFILTER, D3DTEXF_NONE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_COUNT2 );
//*
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_MODULATE );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLORARG1, D3DTA_CURRENT );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLORARG2, D3DTA_TFACTOR );
//*/
    Direct3DDevice->SetTextureStageState( 2, D3DTSS_COLOROP, D3DTOP_DISABLE );

    // --- Blending.
    Direct3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );

    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, FALSE );
    Direct3DDevice->SetVertexShader( D3DFVF_SPHEREBACK_VERTEX1 );

    Direct3DDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );

    // --- Setup Matrices.
    D3DUMatrixTranslation( &D3DMatrix_World0, 640.0f, 0.0f, 0.0f );
//    D3DUMatrixRotationZ( &D3DMatrix_Temp, 0.2f );
    D3DUMatrixScaling( &D3DMatrix_Temp, -1.0f, 1.0f, 1.0f );
    D3DUMatrixMultiply( &D3DMatrix_World0, &D3DMatrix_World0, &D3DMatrix_Temp );
//  D3DUMatrixTranslation( &D3DMatrix_Temp, 320.0f, 240.0f, 0.0f );
//  D3DUMatrixMultiply( &D3DMatrix_World0, &D3DMatrix_World0, &D3DMatrix_Temp );
    Direct3DDevice->SetTransform( D3DTS_WORLD, &D3DMatrix_World0 );

    D3DUVec3Create( &D3DVector_CameraPosition, 319.5f, 240.5f, -1.0f );
    D3DUVec3Create( &D3DVector_CameraTarget, 319.5f, 240.5f, 0.0f );
    D3DUVec3Create( &D3DVector_Up, 0.0f, -1.0f, 0.0f );
    D3DUMatrixLookAtLH( &D3DMatrix_View, &D3DVector_CameraPosition, &D3DVector_CameraTarget, &D3DVector_Up );
    Direct3DDevice->SetTransform( D3DTS_VIEW, &D3DMatrix_View );

    D3DUMatrixOrthoLH( &D3DMatrix_Projection, 640.0f, 360.0f, 0.1f, 10.0f );
    Direct3DDevice->SetTransform( D3DTS_PROJECTION, &D3DMatrix_Projection );

    // --- Setup Texture Matrix.
    D3DUMatrixTranslation( &D3DMatrix_Texture0, Time/35.0f, Time/29.0f, Time/54.0f );
    D3DUMatrixRotationZ( &D3DMatrix_Temp, Time/65.0f );
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationY( &D3DMatrix_Temp, 0.4f * Fsin( Time/55.4f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationX( &D3DMatrix_Temp, 0.4f * Fsin( Time/57.0f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    Direct3DDevice->SetTransform( D3DTS_TEXTURE0, &D3DMatrix_Texture0 );

    Direct3DDevice->SetTexture( 0, SphereBack_Texture1 );

    // --- Setup Light.
    Light2 = Light * 0.6f;
    if ( Time < 6.0f * 64.0f + 9.0f )
      {
        Time2 = ( Time - 10.0f ) / 12.0f;
        if ( Frac( Time2 ) < 0.25f )
          Light2 = Light * ( 0.6f + 0.3f * ( 1.0f - Fcos ( Fsqrt( 4.0f * Frac( Time2 )) * Fmath_2Pi )));
        if ( Light2 > 1.0f ) Light2 = 1.0f;
       }
    Direct3DDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x010101 * Fround( 255.0f * Light2 ));

    // --- Render.
    Direct3DDevice->SetStreamSource( 0, SphereBack_VertexBuffer1, sizeof( SPHEREBACK_VERTEX1 ));
    Direct3DDevice->SetIndices( SphereBack_IndexBuffer1, 0 );
    Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 65*37, 0, 64*36*2 );
  
    // --- Setup Texture Matrix.
    D3DUMatrixTranslation( &D3DMatrix_Texture0, Time/41.0f, Time/25.0f, Time/43.0f );
    D3DUMatrixRotationZ( &D3DMatrix_Temp, Time/95.2f );
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationY( &D3DMatrix_Temp, 0.4f * Fcos( Time/56.0f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationX( &D3DMatrix_Temp, 0.4f * Fcos( Time/58.0f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    Direct3DDevice->SetTransform( D3DTS_TEXTURE0, &D3DMatrix_Texture0 );

    Direct3DDevice->SetTexture( 0, SphereBack_Texture2 );

    // --- Setup Light.
    Light2 = Light * 0.7f;
    if ( Time < 6.0f * 64.0f + 9.0f )
      {
        Time2 = ( Time - 12.0f ) / 12.0f;
        if ( Frac( Time2 ) < 0.25f )
          Light2 = Light * ( 0.7f + 0.3f * ( 1.0f - Fcos ( Fsqrt( 4.0f * Frac( Time2 )) * Fmath_2Pi )));
        if ( Light2 > 1.0f ) Light2 = 1.0f;
       }
    Direct3DDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x010101 * Fround( 255.0f * Light2 ));

    // --- Render.
    Direct3DDevice->SetStreamSource( 0, SphereBack_VertexBuffer1, sizeof( SPHEREBACK_VERTEX1 ));
    Direct3DDevice->SetIndices( SphereBack_IndexBuffer1, 0 );
    Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 65*37, 0, 64*36*2 );

    // --- Setup Texture Matrix.
    D3DUMatrixScaling( &D3DMatrix_Texture0, 0.6f, 0.6f, 0.6f );
    D3DUMatrixTranslation( &D3DMatrix_Texture0, Time/36.0f, Time/28.0f, Time/49.0f );
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationZ( &D3DMatrix_Temp, -Time/195.2f );
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationY( &D3DMatrix_Temp, 0.2f * Fcos( Time/86.0f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationX( &D3DMatrix_Temp, 0.2f * Fsin( Time/98.0f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    Direct3DDevice->SetTransform( D3DTS_TEXTURE0, &D3DMatrix_Texture0 );

    Direct3DDevice->SetTexture( 0, SphereBack_Texture3 );

    // --- Setup Light.
    Direct3DDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x010101 * Fround( 255.0f * Light ));

    // --- Render.
    Direct3DDevice->SetStreamSource( 0, SphereBack_VertexBuffer1, sizeof( SPHEREBACK_VERTEX1 ));
    Direct3DDevice->SetIndices( SphereBack_IndexBuffer1, 0 );
    Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 65*37, 0, 64*36*2 );

    // --- Setup Texture Matrix.
    D3DUMatrixScaling( &D3DMatrix_Texture0, 0.4f, 0.4f, 0.4f );
    D3DUMatrixTranslation( &D3DMatrix_Texture0, Time/24.0f, Time/31.0f, Time/37.0f );
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationZ( &D3DMatrix_Temp, Time/695.2f );
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationY( &D3DMatrix_Temp, 0.2f * Fcos( Time/94.0f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationX( &D3DMatrix_Temp, 0.2f * Fsin( Time/83.0f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    Direct3DDevice->SetTransform( D3DTS_TEXTURE0, &D3DMatrix_Texture0 );

    // --- Render.
    Direct3DDevice->SetStreamSource( 0, SphereBack_VertexBuffer1, sizeof( SPHEREBACK_VERTEX1 ));
    Direct3DDevice->SetIndices( SphereBack_IndexBuffer1, 0 );
    Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 65*37, 0, 64*36*2 );

    // --- Cleanup.
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_DISABLE ); // MODULATEALPHA_ADDCOLOR );
    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, TRUE );
   }

// ------------------------------------------------------------------------------------------------
//    SphereBack_Render2();
// ------------------------------------------------------------------------------------------------

void SphereBack_Render2( float Time )
  {
    float Light;
    // --- STENCILBUFFER.
/*
    Direct3DDevice->SetRenderState( D3DRS_STENCILENABLE, TRUE );
    Direct3DDevice->SetRenderState( D3DRS_STENCILFUNC, D3DCMP_NOTEQUAL );
//*/
    Direct3DDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );
    
    if ( Time <= 11.0f * 64.0f ) Light = 0.0f;
    if (( Time > 11.0f * 64.0f ) && ( Time <= 12.0f * 64.0f )) Light = ( Time - 11.0f * 64.0f ) / 64.0f;
    if (( Time > 12.0f * 64.0f ) && ( Time <= 14.5f * 64.0f )) Light = 1.0f;
    if (( Time > 14.5f * 64.0f ) && ( Time <= 15.5f * 64.0f )) Light = ( 15.5f * 64.0f - Time ) / 64.0f;
    if ( Time > 15.5f * 64.0f ) Light = 0.0f;

    // --- Setup Light.
    Direct3DDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
    Direct3DDevice->SetRenderState( D3DRS_AMBIENT, 0x00FFFFFF );
    Direct3DDevice->LightEnable( 0, FALSE );

    // --- Setup Texture Stage0.
    Direct3DDevice->SetTexture( 0, SphereBack_Texture4 );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_DISABLE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MIPFILTER, D3DTEXF_NONE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_COUNT2 );

    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_MODULATE );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLORARG1, D3DTA_CURRENT );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLORARG2, D3DTA_TFACTOR );

    Direct3DDevice->SetTextureStageState( 2, D3DTSS_COLOROP, D3DTOP_DISABLE );
    
    // --- Blending.
    Direct3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );

    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, FALSE );

    Direct3DDevice->SetVertexShader( D3DFVF_SPHEREBACK_VERTEX1 );

    // --- Setup Matrices.
    Direct3DDevice->SetTransform( D3DTS_WORLD, &D3DUMatrixIdentity );

    D3DUVec3Create( &D3DVector_CameraPosition, 319.5f, 240.5f, -1.0f );
    D3DUVec3Create( &D3DVector_CameraTarget, 319.5f, 240.5f, 0.0f );
    D3DUVec3Create( &D3DVector_Up, 0.0f, -1.0f, 0.0f );
    D3DUMatrixLookAtLH( &D3DMatrix_View, &D3DVector_CameraPosition, &D3DVector_CameraTarget, &D3DVector_Up );
    Direct3DDevice->SetTransform( D3DTS_VIEW, &D3DMatrix_View );

    D3DUMatrixOrthoLH( &D3DMatrix_Projection, 640.0f, 360.0f, 0.1f, 10.0f );
    Direct3DDevice->SetTransform( D3DTS_PROJECTION, &D3DMatrix_Projection );

    D3DUMatrixRotationZ( &D3DMatrix_Texture0, Time/350.0f );
    D3DUMatrixRotationY( &D3DMatrix_Temp, 0.4f * Fsin( Time/454.0f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationX( &D3DMatrix_Temp, 0.4f * Fsin( Time/477.0f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    Direct3DDevice->SetTransform( D3DTS_TEXTURE0, &D3DMatrix_Texture0 );

    // --- Setup Light.
    Direct3DDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x010101 * Fround( 255.0f * Light ));

    // --- Render.
    Direct3DDevice->SetStreamSource( 0, SphereBack_VertexBuffer1, sizeof( SPHEREBACK_VERTEX1 ));
    Direct3DDevice->SetIndices( SphereBack_IndexBuffer1, 0 );
    Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 65*37, 0, 64*36*2 );

    // --- Setup Light.
    Direct3DDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x010101 * Fround( 127.0f * Light ));

    // --- Render.
    Direct3DDevice->SetTexture( 0, SphereBack_Texture1 );
//    Direct3DDevice->SetStreamSource( 0, SphereBack_VertexBuffer1, sizeof( SPHEREBACK_VERTEX1 ));
//    Direct3DDevice->SetIndices( SphereBack_IndexBuffer1, 0 );
    Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 65*37, 0, 64*36*2 );

    // --- Render.
    Direct3DDevice->SetTexture( 0, SphereBack_Texture2 );
//    Direct3DDevice->SetStreamSource( 0, SphereBack_VertexBuffer1, sizeof( SPHEREBACK_VERTEX1 ));
//    Direct3DDevice->SetIndices( SphereBack_IndexBuffer1, 0 );
    Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 65*37, 0, 64*36*2 );

    Direct3DDevice->SetTexture( 0, NULL );

    // --- Cleanup.
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_DISABLE ); // MODULATEALPHA_ADDCOLOR );
    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, TRUE );
   }
