
// ------------------------------------------------------------------------------------------------
//    Stencil.cpp - StencilBuffer code. 
//    Copyright  2001. Remage / Fresh!mindworkz.
// ------------------------------------------------------------------------------------------------

#include <Windows.h>
#include <D3D8.h>

#include "Main.h"
#include "Fmath.h"
#include "D3DU8.h"

#define D3DFVF_STENCIL_VERTEX1 (D3DFVF_XYZRHW|D3DFVF_DIFFUSE)
typedef struct _STENCIL_VERTEX1
  {
    D3DVECTOR Vertex;
    FLOAT RHW;
    DWORD Diffuse;
   } STENCIL_VERTEX1;

// ------------------------------------------------------------------------------------------------

LPDIRECT3DVERTEXBUFFER8 Stencil_VertexBuffer1 = NULL;
STENCIL_VERTEX1 *Stencil_LockedVertexBuffer1;

LPDIRECT3DINDEXBUFFER8 Stencil_IndexBuffer1 = NULL;
WORD *Stencil_LockedIndexBuffer1;

// ------------------------------------------------------------------------------------------------
//    int Stencil_Initialize( void );
// ------------------------------------------------------------------------------------------------

int Stencil_Initialize( void )
  {
    int I;

    // --- Create VertexBuffer1.
    
    if ( Direct3DDevice->CreateVertexBuffer( 20 * sizeof( STENCIL_VERTEX1 ), 0, D3DFVF_STENCIL_VERTEX1,
      D3DPOOL_DEFAULT, &Stencil_VertexBuffer1 ) != D3D_OK ) return 0;
    if ( Stencil_VertexBuffer1->Lock( 0, 20 * sizeof( STENCIL_VERTEX1 ), (BYTE**) &Stencil_LockedVertexBuffer1, 0 ) != D3D_OK ) return 0;

    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 0 ].Vertex), -1.0f, 314.0f, 0.0f );
    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 1 ].Vertex), -1.0f, 373.0f, 0.0f );
    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 2 ].Vertex), 320.0f, 314.0f, 0.0f );
    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 3 ].Vertex), 476.0f, 373.0f, 0.0f );
    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 4 ].Vertex), 386.0f, 248.0f, 0.0f );
    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 5 ].Vertex), 516.0f, 333.0f, 0.0f );
    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 6 ].Vertex), 641.0f, 248.0f, 0.0f );
    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 7 ].Vertex), 641.0f, 333.0f, 0.0f );

    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 8 ].Vertex), 490.0f, 366.0f, 0.0f );
    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 9 ].Vertex), 518.0f, 338.0f, 0.0f );
    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 10 ].Vertex), 520.0f, 366.0f, 0.0f );
    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 11 ].Vertex), 548.0f, 338.0f, 0.0f );

    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 12 ].Vertex), 526.0f, 366.0f, 0.0f );
    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 13 ].Vertex), 554.0f, 338.0f, 0.0f );
    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 14 ].Vertex), 541.0f, 366.0f, 0.0f );
    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 15 ].Vertex), 569.0f, 338.0f, 0.0f );

    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 16 ].Vertex), 547.0f, 366.0f, 0.0f );
    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 17 ].Vertex), 575.0f, 338.0f, 0.0f );
    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 18 ].Vertex), 555.0f, 366.0f, 0.0f );
    D3DUVec3Create( &(Stencil_LockedVertexBuffer1[ 19 ].Vertex), 583.0f, 338.0f, 0.0f );

    for ( I=0; I<20; I++ )
      {
        Stencil_LockedVertexBuffer1[ I ].RHW = 1.0f;
        Stencil_LockedVertexBuffer1[ I ].Diffuse = 0x30808080;
       }

    Stencil_VertexBuffer1->Unlock();

    // --- Create IndexBuffer1.

    if ( Direct3DDevice->CreateIndexBuffer( 27 * sizeof( WORD ), 0, D3DFMT_INDEX16, D3DPOOL_DEFAULT, &Stencil_IndexBuffer1 ) != D3D_OK ) return 0;
    if ( Stencil_IndexBuffer1->Lock( 0, 27 * sizeof( WORD ), (BYTE**) &Stencil_LockedIndexBuffer1, 0 ) != D3D_OK ) return 0;

    Stencil_LockedIndexBuffer1[ 0 ] = 0;
    Stencil_LockedIndexBuffer1[ 1 ] = 2;
    Stencil_LockedIndexBuffer1[ 2 ] = 2;
    Stencil_LockedIndexBuffer1[ 3 ] = 4;
    Stencil_LockedIndexBuffer1[ 4 ] = 4;
    Stencil_LockedIndexBuffer1[ 5 ] = 6;
    Stencil_LockedIndexBuffer1[ 6 ] = 1;
    Stencil_LockedIndexBuffer1[ 7 ] = 3;
    Stencil_LockedIndexBuffer1[ 8 ] = 3;
    Stencil_LockedIndexBuffer1[ 9 ] = 5;
    Stencil_LockedIndexBuffer1[ 10 ] = 5;
    Stencil_LockedIndexBuffer1[ 11 ] = 7;

    Stencil_LockedIndexBuffer1[ 12 ] = 8;
    Stencil_LockedIndexBuffer1[ 13 ] = 9;
    Stencil_LockedIndexBuffer1[ 14 ] = 11;
    Stencil_LockedIndexBuffer1[ 15 ] = 10;
    Stencil_LockedIndexBuffer1[ 16 ] = 8;

    Stencil_LockedIndexBuffer1[ 17 ] = 12;
    Stencil_LockedIndexBuffer1[ 18 ] = 13;
    Stencil_LockedIndexBuffer1[ 19 ] = 15;
    Stencil_LockedIndexBuffer1[ 20 ] = 14;
    Stencil_LockedIndexBuffer1[ 21 ] = 12;
    
    Stencil_LockedIndexBuffer1[ 22 ] = 16;
    Stencil_LockedIndexBuffer1[ 23 ] = 17;
    Stencil_LockedIndexBuffer1[ 24 ] = 19;
    Stencil_LockedIndexBuffer1[ 25 ] = 18;
    Stencil_LockedIndexBuffer1[ 26 ] = 16;
    
    Stencil_IndexBuffer1->Unlock();

    return 1;
   }

// ------------------------------------------------------------------------------------------------
//    void Stencil_Render( float Time );
// ------------------------------------------------------------------------------------------------

void Stencil_Render( float Time )
  {
    Direct3DDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
    Direct3DDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );
    
    // --- Setup StencilBuffer.
    Direct3DDevice->SetRenderState( D3DRS_STENCILENABLE, TRUE );
    Direct3DDevice->SetRenderState( D3DRS_STENCILFUNC, D3DCMP_ALWAYS );
    Direct3DDevice->SetRenderState( D3DRS_STENCILMASK, 0xFF );
    Direct3DDevice->SetRenderState( D3DRS_STENCILREF, 1 );
    Direct3DDevice->SetRenderState( D3DRS_STENCILFAIL, D3DSTENCILOP_REPLACE );
    Direct3DDevice->SetRenderState( D3DRS_STENCILZFAIL, D3DSTENCILOP_REPLACE );
    Direct3DDevice->SetRenderState( D3DRS_STENCILPASS, D3DSTENCILOP_REPLACE );

    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
    Direct3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
    Direct3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );

    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, FALSE );

    Direct3DDevice->SetVertexShader( D3DFVF_STENCIL_VERTEX1 );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_SELECTARG1 );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_DIFFUSE );
//*
    Direct3DDevice->SetStreamSource( 0, Stencil_VertexBuffer1, sizeof( STENCIL_VERTEX1 ));
    Direct3DDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 6 );
    Direct3DDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 8, 2 );
    Direct3DDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 12, 2 );
    Direct3DDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 16, 2 );
//*/
    Direct3DDevice->SetRenderState( D3DRS_STENCILFAIL, D3DSTENCILOP_KEEP );
    Direct3DDevice->SetRenderState( D3DRS_STENCILZFAIL, D3DSTENCILOP_KEEP );
    Direct3DDevice->SetRenderState( D3DRS_STENCILPASS, D3DSTENCILOP_KEEP );

    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
    Direct3DDevice->SetRenderState( D3DRS_STENCILENABLE, FALSE );
    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, TRUE );
   }

// ------------------------------------------------------------------------------------------------
//    void Stencil_RenderWire( float Time );
// ------------------------------------------------------------------------------------------------

void Stencil_RenderWire( float Time )
  {
    Direct3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCCOLOR );
    Direct3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, FALSE );

    Direct3DDevice->SetVertexShader( D3DFVF_STENCIL_VERTEX1 );

    Direct3DDevice->SetStreamSource( 0, Stencil_VertexBuffer1, sizeof( STENCIL_VERTEX1 ));
    Direct3DDevice->SetIndices( Stencil_IndexBuffer1, 0 );
    Direct3DDevice->DrawIndexedPrimitive( D3DPT_LINELIST, 0, 20, 0, 6 );
    Direct3DDevice->DrawIndexedPrimitive( D3DPT_LINESTRIP, 0, 20, 12, 4 );
    Direct3DDevice->DrawIndexedPrimitive( D3DPT_LINESTRIP, 0, 20, 17, 4 );
    Direct3DDevice->DrawIndexedPrimitive( D3DPT_LINESTRIP, 0, 20, 22, 4 );

    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, TRUE );
   }

// ------------------------------------------------------------------------------------------------
//    void Stencil_Cleanup( void );
// ------------------------------------------------------------------------------------------------

void Stencil_Cleanup( void )
  {
    if ( Stencil_VertexBuffer1 != NULL ) Stencil_VertexBuffer1->Release();
    if ( Stencil_IndexBuffer1 != NULL ) Stencil_IndexBuffer1->Release();
   }