
#include <Windows.h>
#include <D3D8.h>

#include "Main.h"
#include "Fmath.h"
#include "TxGen.h"
#include "D3DU8.h"
#include "Rand.h"

// ------------------------------------------------------------------------------------------------

#define D3DFVF_WAVEBACK_VERTEX1 (D3DFVF_XYZ|D3DFVF_DIFFUSE|D3DFVF_TEX1|D3DFVF_TEXCOORDSIZE2(0))
typedef struct _WAVEBACK_VERTEX1
  {
    D3DVECTOR Vertex;
    DWORD Diffuse;
    float TexU1, TexV1;
   } WAVEBACK_VERTEX1;

LPDIRECT3DVERTEXBUFFER8 WaveBack_VertexBuffer1 = NULL;
WAVEBACK_VERTEX1 *WaveBack_LockedVertexBuffer1;

LPDIRECT3DINDEXBUFFER8 WaveBack_IndexBuffer1 = NULL;
WORD *WaveBack_LockedIndexBuffer1;

extern LPDIRECT3DTEXTURE8 SphereBack_Texture1;
extern LPDIRECT3DTEXTURE8 SphereBack_Texture2;
extern LPDIRECT3DTEXTURE8 SphereBack_Texture3;
extern LPDIRECT3DTEXTURE8 MetaBalls_Texture4;

#define WAVENUM 7
float Waves[WAVENUM][6];

// ------------------------------------------------------------------------------------------------

int WaveBack_Initialize( void )
  {
    int I, X, Y;

    for ( I=0; I<WAVENUM; I++ )
      {
        Waves[ I ][0] = (float) ( Rand() & 511 ) / 511.0f;
        Waves[ I ][1] = (float) ( Rand() & 511 ) / 511.0f;
        Waves[ I ][2] = (float) ( Rand() & 511 ) / 511.0f;
        Waves[ I ][3] = (float) ( Rand() & 511 ) / 511.0f;
       }

    if ( Direct3DDevice->CreateVertexBuffer( 65*37*sizeof( WAVEBACK_VERTEX1 ), 0, D3DFVF_WAVEBACK_VERTEX1,
      D3DPOOL_DEFAULT, &WaveBack_VertexBuffer1 ) != D3D_OK ) return 0;

    // --- Create IndexBuffer1.
    if ( Direct3DDevice->CreateIndexBuffer( 13824*sizeof( WORD ), 0, D3DFMT_INDEX16, D3DPOOL_DEFAULT, &WaveBack_IndexBuffer1 ) != D3D_OK ) return 0;
    if ( WaveBack_IndexBuffer1->Lock( 0, 13824*sizeof( WORD ), (BYTE**) &WaveBack_LockedIndexBuffer1, 0 ) != D3D_OK ) return 0;

    for ( Y=0; Y<36; Y++ )
      for ( X=0; X<64; X++ )
        {
          WaveBack_LockedIndexBuffer1[ (Y*64+X)*6+0 ] = Y*65+X;
          WaveBack_LockedIndexBuffer1[ (Y*64+X)*6+1 ] = Y*65+X+1;
          WaveBack_LockedIndexBuffer1[ (Y*64+X)*6+2 ] = Y*65+X+65;
          WaveBack_LockedIndexBuffer1[ (Y*64+X)*6+3 ] = Y*65+X+1;
          WaveBack_LockedIndexBuffer1[ (Y*64+X)*6+4 ] = Y*65+X+66;
          WaveBack_LockedIndexBuffer1[ (Y*64+X)*6+5 ] = Y*65+X+65;
         }

    WaveBack_IndexBuffer1->Unlock();

    return 1;
   }

// ------------------------------------------------------------------------------------------------

void WaveBack_Cleanup( void )
  {
    if ( WaveBack_VertexBuffer1 ) WaveBack_VertexBuffer1->Release();
    if ( WaveBack_IndexBuffer1 ) WaveBack_IndexBuffer1->Release();
   }

// ------------------------------------------------------------------------------------------------

void WaveBack_Render1( float Time )
  {
    float DX, DY, Dist, DispX, DispY, Col, Max, Max1, Max2, Scale, Light, Light2;
    int I, X, Y;

    for ( I=0; I<WAVENUM; I++ )
      {
        Waves[ I ][4] = 32.0f + 24.0f * Fsin(( Waves[ I ][0] + ( 1.0f + Waves[ I ][1] ) * Time * 0.0031f ) * Fmath_Pi );
        Waves[ I ][5] = 24.0f + 16.0f * Fsin(( Waves[ I ][1] + ( 1.0f + Waves[ I ][2] ) * Time * 0.0027f ) * Fmath_Pi );
       }

    Max = 18.0f;
    Max1 = Fsqr( Max );
    Max2 = 1.0f / Max1;

    if ( WaveBack_VertexBuffer1->Lock( 0, 65*37*sizeof( WAVEBACK_VERTEX1 ), (BYTE**) &WaveBack_LockedVertexBuffer1, 0 ) != D3D_OK ) return;

    for ( Y=0; Y<37; Y++ )
      for ( X=0; X<65; X++ )
       {
          DispX = 0.0f;
          DispY = 0.0f;
          Col = 0.2f;
          for ( I=0; I<WAVENUM; I++ )
            {
              DX = (float) X - Waves[ I ][4];
              DY = (float) Y - Waves[ I ][5];
        
              Dist = Fsqr( DX ) + Fsqr( DY );
              if ( Dist < Max1 )
                {
                  Dist = Fsqr( 1.0f - Dist * Max2 );
                  DispX += 0.4f * DX * Dist;
                  DispY += 0.4f * DY * Dist;
                  Col += 0.1f * Dist;
                 }
             }
          
          if ( Col > 1.0f ) Col = 1.0f;

          D3DUVec3Create( &WaveBack_LockedVertexBuffer1[ Y*65+X ].Vertex, 10.0f*X, 10.0f*Y + 60.0f, 1.0f );
          WaveBack_LockedVertexBuffer1[ Y*65+X ].TexU1 = 0.02f * ( X + DispX );
          WaveBack_LockedVertexBuffer1[ Y*65+X ].TexV1 = 0.02f * ( Y + DispY );
          WaveBack_LockedVertexBuffer1[ Y*65+X ].Diffuse = 0x010101 * Fround( 255.0f * Col );
         }

    WaveBack_VertexBuffer1->Unlock();

    // --- Timing.
    if ( Time <= 4.0f * 64.0f ) Light = 0.0f;
    if (( Time > 4.0f * 64.0f ) && ( Time <= 6.0f * 64.0f )) Light = ( Time - 4.0f * 64.0f ) / 128.0f;
    if (( Time > 6.0f * 64.0f ) && ( Time <= 10.5f * 64.0f )) Light = 1.0f;
    if (( Time > 10.5f * 64.0f ) && ( Time <= 11.5f * 64.0f )) Light = ( 11.5f * 64.0f - Time ) / 64.0f;
    if ( Time > 11.5f * 64.0f ) Light = 0.0f;

    // --- Setup Lighting.
    Direct3DDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
    Direct3DDevice->LightEnable( 0, FALSE );

    // --- Setup Texture Stage0.
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_DISABLE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MIPFILTER, D3DTEXF_NONE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_COUNT2 );

    // --- Setup Texture Stage1.
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_MODULATE );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLORARG1, D3DTA_CURRENT );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLORARG2, D3DTA_TFACTOR );

    Direct3DDevice->SetTextureStageState( 2, D3DTSS_COLOROP, D3DTOP_DISABLE );

    // --- Blending.
    Direct3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );

    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, FALSE );
    Direct3DDevice->SetVertexShader( D3DFVF_WAVEBACK_VERTEX1 );

    Direct3DDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );

    // --- Setup Matrices.
    D3DUVec3Create( &D3DVector_CameraPosition, 319.5f, 240.5f, -1.0f );
    D3DUVec3Create( &D3DVector_CameraTarget, 319.5f, 240.5f, 0.0f );
    D3DUVec3Create( &D3DVector_Up, 0.0f, -1.0f, 0.0f );
    D3DUMatrixLookAtLH( &D3DMatrix_View, &D3DVector_CameraPosition, &D3DVector_CameraTarget, &D3DVector_Up );
    Direct3DDevice->SetTransform( D3DTS_VIEW, &D3DMatrix_View );

    D3DUMatrixOrthoLH( &D3DMatrix_Projection, 640.0f, 360.0f, 0.1f, 10.0f );
    Direct3DDevice->SetTransform( D3DTS_PROJECTION, &D3DMatrix_Projection );

    // --- Setup Texture Matrix.
    D3DUMatrixTranslation( &D3DMatrix_Texture0, Time/35.0f, -Time/29.0f, Time/54.0f );
    D3DUMatrixRotationZ( &D3DMatrix_Temp, Time/65.0f );
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationY( &D3DMatrix_Temp, 0.4f * Fsin( Time/55.4f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationX( &D3DMatrix_Temp, 0.4f * Fsin( Time/57.0f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    Direct3DDevice->SetTransform( D3DTS_TEXTURE0, &D3DMatrix_Texture0 );

//    Direct3DDevice->SetTexture( 0, SphereBack_Texture3 );

    Light2 = 0.5f;
    if (( Time > 512.0f ) && ( Time < 512.0f + 64.0f ))
      {
        Light2 = 0.3f + 0.2f * Fcos( Time / 64.0f * Fmath_2Pi );
       }

    I = 0;
    Scale = 1.0f;
    while ( Scale < 1.7f )
      {
        if (( ++I ) & 1 )
          Direct3DDevice->SetTexture( 0, MetaBalls_Texture4 ); else
          Direct3DDevice->SetTexture( 0, SphereBack_Texture3 );
          
        D3DUMatrixScaling( &D3DMatrix_World0, Scale, 1.0f, 1.0f );
        Direct3DDevice->SetTransform( D3DTS_WORLD, &D3DMatrix_World0 );
        
        float Light3 = Light * ( Scale - Light2 ) / ( 1.7f - 1.0f );
        if ( Light3 > 1.0f ) Light3 = 1.0f;

        Direct3DDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x010101 * Fround( 255.0f * Light3 ));

        // --- Render.
        Direct3DDevice->SetStreamSource( 0, WaveBack_VertexBuffer1, sizeof( WAVEBACK_VERTEX1 ));
        Direct3DDevice->SetIndices( WaveBack_IndexBuffer1, 0 );
        Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 65*37, 0, 64*36*2 );
        
        Scale *= 1.23f;
       }
    Direct3DDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x010101 * Fround( 255.0f * Light ));
   }

// ------------------------------------------------------------------------------------------------

void WaveBack_Render2( float Time )
  {
    float DX, DY, Dist, DispX, DispY, Col, Max, Max1, Max2, Light, Light2, Light3, Time2;
    int I, X, Y;

    for ( I=0; I<WAVENUM; I++ )
      {
        Waves[ I ][4] = 32.0f + 24.0f * Fsin(( Waves[ I ][0] + ( 1.0f + Waves[ I ][1] ) * Time * 0.0031f ) * Fmath_Pi );
        Waves[ I ][5] = 24.0f + 16.0f * Fsin(( Waves[ I ][1] + ( 1.0f + Waves[ I ][2] ) * Time * 0.0027f ) * Fmath_Pi );
       }

    Max = 18.0f;
    Max1 = Fsqr( Max );
    Max2 = 1.0f / Max1;

    if ( WaveBack_VertexBuffer1->Lock( 0, 65*37*sizeof( WAVEBACK_VERTEX1 ), (BYTE**) &WaveBack_LockedVertexBuffer1, 0 ) != D3D_OK ) return;

    for ( Y=0; Y<37; Y++ )
      for ( X=0; X<65; X++ )
       {
          DispX = 0.0f;
          DispY = 0.0f;
          Col = 0.3f;
          for ( I=0; I<WAVENUM; I++ )
            {
              DX = (float) X - Waves[ I ][4];
              DY = (float) Y - Waves[ I ][5];
        
              Dist = Fsqr( DX ) + Fsqr( DY );
              if ( Dist < Max1 )
                {
                  Dist = Fsqr( 1.0f - Dist * Max2 );
                  DispX += 0.4f * DX * Dist;
                  DispY += 0.4f * DY * Dist;
                  Col += 0.1f * Dist;
                 }
             }
          
          if ( Col > 1.0f ) Col = 1.0f;

          D3DUVec3Create( &WaveBack_LockedVertexBuffer1[ Y*65+X ].Vertex, 10.0f*X, 10.0f*Y + 60.0f, 1.0f );
          WaveBack_LockedVertexBuffer1[ Y*65+X ].TexU1 = 0.02f * ( X + DispX );
          WaveBack_LockedVertexBuffer1[ Y*65+X ].TexV1 = 0.02f * ( Y + DispY );
          WaveBack_LockedVertexBuffer1[ Y*65+X ].Diffuse = 0x010101 * Fround( 255.0f * Col );
         }

    WaveBack_VertexBuffer1->Unlock();

    // --- Timing.
    if ( Time <= 20.0f * 64.0f ) Light = 0.0f;
    if (( Time > 20.0f * 64.0f ) && ( Time <= 21.0f * 64.0f )) Light = ( Time - 20.0f * 64.0f ) / 64.0f;
    if (( Time > 21.0f * 64.0f ) && ( Time <= 29.0f * 64.0f )) Light = 1.0f;
    if (( Time > 29.0f * 64.0f ) && ( Time <= 30.0f * 64.0f )) Light = ( 30.0f * 64.0f - Time ) / 64.0f;
    if ( Time > 30.0f * 64.0f ) Light = 0.0f;

    // --- Setup Lighting.
    Direct3DDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
    Direct3DDevice->LightEnable( 0, FALSE );

    // --- Setup Texture Stage0.
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_DISABLE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MIPFILTER, D3DTEXF_NONE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_COUNT2 );

    // --- Setup Texture Stage1.
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_MODULATE );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLORARG1, D3DTA_CURRENT );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLORARG2, D3DTA_TFACTOR );

    Direct3DDevice->SetTextureStageState( 2, D3DTSS_COLOROP, D3DTOP_DISABLE );

    // --- Blending.
    Direct3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );

    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, FALSE );
    Direct3DDevice->SetVertexShader( D3DFVF_WAVEBACK_VERTEX1 );

    Direct3DDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );

    // --- Setup Matrices.
    D3DUVec3Create( &D3DVector_CameraPosition, 319.5f, 240.5f, -1.0f );
    D3DUVec3Create( &D3DVector_CameraTarget, 319.5f, 240.5f, 0.0f );
    D3DUVec3Create( &D3DVector_Up, 0.0f, -1.0f, 0.0f );
    D3DUMatrixLookAtLH( &D3DMatrix_View, &D3DVector_CameraPosition, &D3DVector_CameraTarget, &D3DVector_Up );
    Direct3DDevice->SetTransform( D3DTS_VIEW, &D3DMatrix_View );

    D3DUMatrixOrthoLH( &D3DMatrix_Projection, 640.0f, 360.0f, 0.1f, 10.0f );
    Direct3DDevice->SetTransform( D3DTS_PROJECTION, &D3DMatrix_Projection );

//    Direct3DDevice->SetTexture( 0, SphereBack_Texture3 );

    if ( Time > 23.0f * 64.0f ) 
      { 
        if ( Time <= 24.0 * 64.0f ) Light3 = Light * ( Time - 23.0f * 64.0f ) / 64.0f;
        if (( Time > 24.0f * 64.0f ) && ( Time <= 26.0f * 64.0f )) Light3 = Light;
        if (( Time > 26.0f * 64.0f ) && ( Time <= 29.0f * 64.0f )) Light3 = Light * ( 29.0f * 64.0f - Time ) / ( 3*64.0f );
        if ( Time > 29.0f * 64.0f ) Light3 = 0.0f;
        
        Time2 = ( Time - 23.0f * 64.0f ) / 12.0f;
        if ( Frac( Time2 ) < 0.25f ) 
          Light2 = 0.16f * Light3 * ( 1.0f -  Fcos( Fsqrt( 4.0f * Frac( Time2 )) * Fmath_2Pi ));

        // --- Setup Texture Matrix.
//      D3DUMatrixTranslation( &D3DMatrix_Texture0, -Time/35.0f, Time/49.0f, Time/51.0f );
        D3DUMatrixScaling( &D3DMatrix_Texture0, 2.0f, 2.0f, 2.0f );
        D3DUMatrixRotationZ( &D3DMatrix_Temp, Time/53.0f );
        D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
        D3DUMatrixRotationY( &D3DMatrix_Temp, 0.4f * Fsin( Time/57.4f ));
        D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
        D3DUMatrixRotationX( &D3DMatrix_Temp, 0.4f * Fsin( Time/54.0f ));
        D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
        Direct3DDevice->SetTransform( D3DTS_TEXTURE0, &D3DMatrix_Texture0 );

        Direct3DDevice->SetTexture( 0, SphereBack_Texture1 );
        D3DUMatrixScaling( &D3DMatrix_World0, 1.1f, 1.0f, 1.0f );
        Direct3DDevice->SetTransform( D3DTS_WORLD, &D3DMatrix_World0 );
        Direct3DDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x010101 * Fround( 192.0f * Light2 ));

        // --- Render.
        Direct3DDevice->SetStreamSource( 0, WaveBack_VertexBuffer1, sizeof( WAVEBACK_VERTEX1 ));
        Direct3DDevice->SetIndices( WaveBack_IndexBuffer1, 0 );
        Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 65*37, 0, 64*36*2 );

        Time2 = ( Time - 23.0f * 64.0f - 2.0f ) / 12.0f;
        if ( Frac( Time2 ) < 0.25f ) 
          Light2 = 0.16f * Light3 * ( 1.0f -  Fcos( Fsqrt( 4.0f * Frac( Time2 )) * Fmath_2Pi ));

        // --- Setup Texture Matrix.
//      D3DUMatrixTranslation( &D3DMatrix_Texture0, -Time/35.0f, Time/49.0f, Time/51.0f );
        D3DUMatrixScaling( &D3DMatrix_Texture0, 2.0f, 2.0f, 2.0f );
        D3DUMatrixRotationZ( &D3DMatrix_Temp, Time/53.0f );
        D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
        D3DUMatrixRotationY( &D3DMatrix_Temp, 0.4f * Fsin( Time/57.4f ));
        D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
        D3DUMatrixRotationX( &D3DMatrix_Temp, 0.4f * Fsin( Time/54.0f ));
        D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
        Direct3DDevice->SetTransform( D3DTS_TEXTURE0, &D3DMatrix_Texture0 );

        Direct3DDevice->SetTexture( 0, SphereBack_Texture2 );
        D3DUMatrixScaling( &D3DMatrix_World0, 1.1f, 1.0f, 1.0f );
        Direct3DDevice->SetTransform( D3DTS_WORLD, &D3DMatrix_World0 );
        Direct3DDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x010101 * Fround( 228.0f * Light2 ));

        // --- Render.
        Direct3DDevice->SetStreamSource( 0, WaveBack_VertexBuffer1, sizeof( WAVEBACK_VERTEX1 ));
        Direct3DDevice->SetIndices( WaveBack_IndexBuffer1, 0 );
        Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 65*37, 0, 64*36*2 );


       }

    // --- Setup Texture Matrix.
    D3DUMatrixTranslation( &D3DMatrix_Texture0, Time/35.0f, -Time/29.0f, Time/54.0f );
    D3DUMatrixRotationZ( &D3DMatrix_Temp, Time/65.0f );
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationY( &D3DMatrix_Temp, 0.4f * Fsin( Time/55.4f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    D3DUMatrixRotationX( &D3DMatrix_Temp, 0.4f * Fsin( Time/57.0f ));
    D3DUMatrixMultiply( &D3DMatrix_Texture0, &D3DMatrix_Texture0, &D3DMatrix_Temp );
    Direct3DDevice->SetTransform( D3DTS_TEXTURE0, &D3DMatrix_Texture0 );

    Direct3DDevice->SetTexture( 0, MetaBalls_Texture4 );
    D3DUMatrixScaling( &D3DMatrix_World0, 1.0f, 1.0f, 1.0f );
    Direct3DDevice->SetTransform( D3DTS_WORLD, &D3DMatrix_World0 );
    Direct3DDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x010101 * Fround( 255.0f * Light ));

    // --- Render.
    Direct3DDevice->SetStreamSource( 0, WaveBack_VertexBuffer1, sizeof( WAVEBACK_VERTEX1 ));
    Direct3DDevice->SetIndices( WaveBack_IndexBuffer1, 0 );
    Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 65*37, 0, 64*36*2 );

    Direct3DDevice->SetTexture( 0, SphereBack_Texture3 );
    D3DUMatrixScaling( &D3DMatrix_World0, 1.1f, 1.0f, 1.0f );
    Direct3DDevice->SetTransform( D3DTS_WORLD, &D3DMatrix_World0 );
    Direct3DDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x010101 * Fround( 255.0f * Light ));

    // --- Render.
    Direct3DDevice->SetStreamSource( 0, WaveBack_VertexBuffer1, sizeof( WAVEBACK_VERTEX1 ));
    Direct3DDevice->SetIndices( WaveBack_IndexBuffer1, 0 );
    Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 65*37, 0, 64*36*2 );

    Direct3DDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x010101 * Fround( 255.0f * Light ));
   }