/*
** El Barto's ADX player plugin
** Copyright (c) 2001 bero, El Barto
*/

#include <windows.h>
#include <mmreg.h>
#include <msacm.h>
#include <math.h>

#include "in2.h"


void conv1block(void* arg_0_dst, void* arg_4_src, void* arg_8)
{
	int var_14, var_C, var_8_cnt, var_4;

	__asm {
		mov	edx, [arg_4_src]
		movzx	eax, byte ptr [edx]
		shl	eax, 8
		mov	[var_4], eax
		movzx	eax, byte ptr [edx+1]
		or	[var_4], eax
		add	edx, 2
		mov	[arg_4_src], edx
		mov	ecx, [arg_8]
		mov	edi, [ecx]
		mov	esi, [ecx+4]
		mov	[var_8_cnt], 0
		mov	ebx, [var_4]
		lea	ebx, [ebx+ebx*8]
		shl	ebx, 4
		mov	eax, [var_4]
		sub	ebx, eax
		shl	ebx, 5
		mov	[var_C], ebx

loc_401275:				; CODE XREF: conv1block+154.j
		mov	edx, [arg_4_src]
		mov	ecx, [var_8_cnt]
		mov	al, [ecx+edx]
		shr	al, 4
		movzx	ebx, al
		test	bl, 8
		jz	short loc_40128C
		add	ebx, 0FFFFFFF0h

loc_40128C:				; CODE XREF: conv1block+57.j
		imul	ebx, [var_C]
		mov	edx, edi
		shl	edx, 6
		add	edx, edi
		lea	edx, [edi+edx*2]
		lea	eax, ds:0[edx*8]
		sub	eax, edx
		shl	eax, 2
		sub	eax, edi
		lea	ecx, [ebx+eax*8]
		lea	eax, [esi+esi*4]
		lea	eax, [esi+eax*8]
		lea	eax, [eax+eax*4]
		lea	eax, [esi+eax*4]
		shl	eax, 4
		sub	ecx, eax
		sar	ecx, 0Eh
		mov	ebx, [var_4]
		shl	ebx, 3
		mov	[var_14], ebx
		cmp	ecx, 7FFFh
		jle	short loc_4012D7
		mov	ecx, 7FFFh
		jmp	short loc_4012E4
; 

loc_4012D7:				; CODE XREF: conv1block+9E.j
		cmp	ecx, 0FFFF8000h
		jge	short loc_4012E4
		mov	ecx, 0FFFF8000h

loc_4012E4:				; CODE XREF: conv1block+A5.j
					; conv1block+AD.j
		mov	eax, [arg_0_dst]
		mov	[eax], cx
		add	eax, 2
		mov	[arg_0_dst], eax
		mov	esi, edi
		mov	edi, ecx
		mov	edx, [arg_4_src]
		mov	ebx, [var_8_cnt]
		mov	al, [ebx+edx]
		and	al, 0Fh
		movzx	ebx, al
		test	bl, 8
		jz	short loc_40130A
		add	ebx, 0FFFFFFF0h

loc_40130A:				; CODE XREF: conv1block+D5.j
		mov	eax, [var_14]
		add	eax, [var_4]
		shl	eax, 4
		sub	eax, [var_4]
		shl	eax, 5
		imul	ebx, eax
		mov	edx, ecx
		shl	edx, 6
		add	edx, ecx
		lea	edx, [ecx+edx*2]
		lea	eax, ds:0[edx*8]
		sub	eax, edx
		shl	eax, 2
		sub	eax, ecx
		lea	ecx, [ebx+eax*8]
		lea	eax, [esi+esi*4]
		lea	eax, [esi+eax*8]
		lea	eax, [eax+eax*4]
		lea	eax, [esi+eax*4]
		shl	eax, 4
		sub	ecx, eax
		sar	ecx, 0Eh
		cmp	ecx, 7FFFh
		jle	short loc_401360
		mov	ecx, 7FFFh
		jmp	short loc_40136D
; 
		align 8

loc_401360:				; CODE XREF: conv1block+121.j
		cmp	ecx, 0FFFF8000h
		jge	short loc_40136D
		mov	ecx, 0FFFF8000h

loc_40136D:				; CODE XREF: conv1block+128.j
					; conv1block+136.j
		mov	eax, [arg_0_dst]
		mov	[eax], cx
		add	eax, 2
		mov	[arg_0_dst], eax
		mov	esi, edi
		mov	edi, ecx
		inc	[var_8_cnt]
		cmp	[var_8_cnt], 15
		jle	loc_401275
		mov	edx, [arg_8]
		mov	[edx], ecx
		mov	[edx+4], esi
	}
}

// avoid CRT. Evil. Big. Bloated.
BOOL WINAPI _DllMainCRTStartup(HANDLE hInst, ULONG ul_reason_for_call, LPVOID lpReserved)
{
	return TRUE;
}

// post this to the main window at end of file (after playback as stopped)
#define WM_WA_MPEG_EOF WM_USER+2

// raw configuration

int NCH = 2;
int SAMPLERATE = 44100;
#define BPS 16


In_Module mod; // the output module (declared near the bottom of this file)
char lastfn[MAX_PATH]; // currently playing file (used for getting info on the current file)
int file_length; // file length, in bytes
int decode_pos_ms; // current decoding position, in milliseconds
int paused; // are we paused?
int seek_needed; // if != -1, it is the point that the decode thread should seek to, in ms.
char sample_buffer[576*2 /*NCH*/ *(BPS/8)*2]; // sample buffer

HANDLE input_file=INVALID_HANDLE_VALUE; // input file handle

int killDecodeThread=0;					// the kill switch for the decode thread
HANDLE thread_handle=INVALID_HANDLE_VALUE;	// the handle to the decode thread

DWORD WINAPI __stdcall DecodeThread(void *b); // the decode thread procedure

void config(HWND hwndParent)
{
	MessageBox(hwndParent,
		"No configuration.",
		"Configuration",MB_OK);
	// if we had a configuration we'd want to write it here :)
}
void about(HWND hwndParent)
{
	MessageBox(hwndParent,"El Barto's ADX player.\n\nPlays Dreamcast ADX files.\nBased on bero's adx2wav converter (http://www.geocities.co.jp/Playtown/2004/)\n\nyes, it's a little buggy, but what the hell...","About El Barto's ADX Player",MB_OK);
}

void init() { /* any one-time initialization goes here (configuration reading, etc) */ }

void quit() { /* one-time deinit, such as memory freeing */ }

int isourfile(char *fn) { return 0; } 
// used for detecting URL streams.. unused here. strncmp(fn,"http://",7) to detect HTTP streams, etc


int get16bit(unsigned char* p)
{
	return (p[0] << 8) | p[1];
}

int get32bit(unsigned char* p)
{
	return (p[0] << 24) | (p[1] << 16) | (p[2] << 8) | p[3];
}

int nrsamples;

int workmem[4];
int cri_ofs;

int play(char *fn) 
{ 
	int maxlatency;
	int thread_id;
	unsigned char readbuf[36];
	int l;

	input_file = CreateFile(fn,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,
		OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (input_file == INVALID_HANDLE_VALUE) // error opening file
	{
		return 1;
	}

	ReadFile(input_file, readbuf, 36, &l, NULL);

	if(readbuf[0] != 0x80) {
		CloseHandle(input_file);
		input_file=INVALID_HANDLE_VALUE;
		return 1;
	}

	cri_ofs = get16bit(&readbuf[2]);

	if(readbuf[cri_ofs+0-2] != '(' || readbuf[cri_ofs+1-2] != 'c' || readbuf[cri_ofs+2-2] != ')' ||
	   readbuf[cri_ofs+3-2] != 'C' || readbuf[cri_ofs+4-2] != 'R' || readbuf[cri_ofs+5-2] != 'I') {
		MessageBox(NULL, "no ADX file!", "ADX error", MB_OK);
		CloseHandle(input_file);
		input_file=INVALID_HANDLE_VALUE;
		return 1;
	}

	NCH = (int)readbuf[7];
	SAMPLERATE = get32bit(&readbuf[8]);
	nrsamples = get32bit(&readbuf[12]);

	for(l = 0; l < 4; l++) workmem[l] = 0;

	SetFilePointer(input_file, cri_ofs+4, NULL, FILE_BEGIN);

	file_length=GetFileSize(input_file,NULL);

	lstrcpy(lastfn,fn);
	paused=0;
	decode_pos_ms=0;
	seek_needed=-1;

	maxlatency = mod.outMod->Open(SAMPLERATE,NCH,BPS, -1,-1);
	if (maxlatency < 0) // error opening device
	{
		CloseHandle(input_file);
		input_file=INVALID_HANDLE_VALUE;
		return 1;
	}
	// dividing by 1000 for the first parameter of setinfo makes it
	// display 'H'... for hundred.. i.e. 14H Kbps.
	mod.SetInfo((SAMPLERATE*BPS*NCH*18/64)/1000,SAMPLERATE/1000,NCH,1);

	// initialize vis stuff
	mod.SAVSAInit(maxlatency,SAMPLERATE);
	mod.VSASetInfo(SAMPLERATE,NCH);

	mod.outMod->SetVolume(-666); // set the output plug-ins default volume

	killDecodeThread=0;
	thread_handle = (HANDLE) CreateThread(NULL,0,(LPTHREAD_START_ROUTINE) DecodeThread,(void *) &killDecodeThread,0,&thread_id);
	
	return 0; 
}

void pause() { paused=1; mod.outMod->Pause(1); }
void unpause() { paused=0; mod.outMod->Pause(0); }
int ispaused() { return paused; }

void stop() { 
	if (thread_handle != INVALID_HANDLE_VALUE)
	{
		killDecodeThread=1;
		if (WaitForSingleObject(thread_handle,INFINITE) == WAIT_TIMEOUT)
		{
			MessageBox(mod.hMainWindow,"error asking thread to die!\n","error killing decode thread",0);
			TerminateThread(thread_handle,0);
		}
		CloseHandle(thread_handle);
		thread_handle = INVALID_HANDLE_VALUE;
	}
	if (input_file != INVALID_HANDLE_VALUE)
	{
		CloseHandle(input_file);
		input_file=INVALID_HANDLE_VALUE;
	}

	mod.outMod->Close();

	mod.SAVSADeInit();
}

int getlength() { 
	return nrsamples/SAMPLERATE*1000;
}

int getoutputtime() { 
	return decode_pos_ms+(mod.outMod->GetOutputTime()-mod.outMod->GetWrittenTime()); 
}

void setoutputtime(int time_in_ms) { 
	seek_needed=time_in_ms; 
}

void setvolume(int volume) { mod.outMod->SetVolume(volume); }
void setpan(int pan) { mod.outMod->SetPan(pan); }

int infoDlg(char *fn, HWND hwnd)
{
	// TODO: implement info dialog. 
	return 0;
}

void getfileinfo(char *filename, char *title, int *length_in_ms)
{
	if (!filename || !*filename)  // currently playing file
	{
		if (length_in_ms) *length_in_ms=getlength();
		if (title) 
		{
			char *p=lastfn+lstrlen(lastfn);
			while (*p != '\\' && p >= lastfn) p--;
			lstrcpy(title,++p);
		}
	}
	else // some other file
	{
		if (length_in_ms) 
		{
			HANDLE hFile;
			*length_in_ms=-1000;
			hFile = CreateFile(filename,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,
				OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
			if (hFile != INVALID_HANDLE_VALUE)
			{
				*length_in_ms = (GetFileSize(hFile,NULL)*10)/(SAMPLERATE/100*NCH*(BPS/8));
			}
			CloseHandle(hFile);
		}
		if (title) 
		{
			char *p=filename+lstrlen(filename);
			while (*p != '\\' && p >= filename) p--;
			lstrcpy(title,++p);
		}
	}
}

void eq_set(int on, char data[10], int preamp) 
{ 
	// most plug-ins can't even do an EQ anyhow.. I'm working on writing
	// a generic PCM EQ, but it looks like it'll be a little too CPU 
	// consuming to be useful :)
}


// render 576 samples into buf. 
// note that if you adjust the size of sample_buffer, for say, 1024
// sample blocks, it will still work, but some of the visualization 
// might not look as good as it could. Stick with 576 sample blocks
// if you can, and have an additional auxiliary (overflow) buffer if 
// necessary.. 

// only 1 channel ATM
int get_576_samples(char *buf)
{
	int i, l, j;
	unsigned char readbuf[18];
	for(i = 0; i < 576*2*NCH; i++) buf[i] = 0;

	if(NCH == 1) {
		for(i = 0; i < 18; i++) {
			l = 0;
			ReadFile(input_file, readbuf, 18, &l, NULL);
			conv1block(&buf[i * 32 * 2], readbuf, workmem);
			if(l < 18) return 0;
		}
	} else {
		for(i = 0; i < 18; i++) {
			unsigned char outbuf1[64], outbuf2[64];
			l = 0; ReadFile(input_file, readbuf, 18, &l, NULL); if(l < 18) return 0;
			conv1block(outbuf1, readbuf, workmem);
			l = 0; ReadFile(input_file, readbuf, 18, &l, NULL); if(l < 18) return 0;
			conv1block(outbuf2, readbuf, &workmem[2]);
			for(j = 0; j < 32; j++) {
				buf[i*64*2 + j*4] = outbuf1[j*2];
				buf[i*64*2 + j*4+1] = outbuf1[j*2+1];
				buf[i*64*2 + j*4+2] = outbuf2[j*2];
				buf[i*64*2 + j*4+3] = outbuf2[j*2+1];
			}
		}
	}
	return i*32;
}

DWORD WINAPI __stdcall DecodeThread(void *b)
{
	int done=0;
	while (! *((int *)b) ) 
	{
		if (seek_needed != -1)
		{
			int offs;
			decode_pos_ms = seek_needed-(seek_needed%1000);
			seek_needed=-1;
			done=0;
			mod.outMod->Flush(decode_pos_ms);
			offs = (decode_pos_ms/1000) * SAMPLERATE;
			SetFilePointer(input_file,cri_ofs+4 + (offs*NCH/32*18),NULL,FILE_BEGIN);
		}
		if (done)
		{
			mod.outMod->CanWrite();
			if (!mod.outMod->IsPlaying())
			{
				PostMessage(mod.hMainWindow,WM_WA_MPEG_EOF,0,0);
				return 0;
			}
			Sleep(10);
		}
		else if (mod.outMod->CanWrite() >= ((576*NCH*(BPS/8))<<(mod.dsp_isactive()?1:0)))
		{	
			int l=576;
			l=get_576_samples(sample_buffer);
			if (!l) 
			{
				done=1;
			}
			else
			{
				mod.SAAddPCMData((char *)sample_buffer,NCH,BPS,decode_pos_ms);
				mod.VSAAddPCMData((char *)sample_buffer,NCH,BPS,decode_pos_ms);
				decode_pos_ms+=(576*1000)/SAMPLERATE;
				if (mod.dsp_isactive()) 
					l = mod.dsp_dosamples((short *)sample_buffer, l, BPS, NCH, SAMPLERATE);
				mod.outMod->Write(sample_buffer, l *(NCH*(BPS/8)));
			}
		}
		else Sleep(20);
	}
	return 0;
}



In_Module mod = 
{
	IN_VER,
	"El Barto's ADX Player v1.0 "
#ifdef _DEBUG
	"(DEBUG)"
#endif
	,
	0,	// hMainWindow
	0,  // hDllInstance
	"ADX\0ADX Audio File (*.ADX)\0"
	,
	1,	// is_seekable
	1, // uses output
	config,
	about,
	init,
	quit,
	getfileinfo,
	infoDlg,
	isourfile,
	play,
	pause,
	unpause,
	ispaused,
	stop,
	
	getlength,
	getoutputtime,
	setoutputtime,

	setvolume,
	setpan,

	0,0,0,0,0,0,0,0,0, // vis stuff


	0,0, // dsp

	eq_set,

	NULL,		// setinfo

	0 // out_mod

};

__declspec( dllexport ) In_Module * winampGetInModule2()
{
	return &mod;
}
