{Command line parsing unit.                                                  }
{v1.0.2 (c) 26.12.1999 by Flying/Digital Reality                             }
Unit CLParser;

Interface

Uses
  List,
  StringsUnit;

Type
  TArgType = (at_Nothing, at_String, at_Number);

  PCLParam = ^TCLParam;
  TCLParam = record
{ ࠬ. ।   䨪 /  -. ࠭  upper case}
    Key : string;
{㬥 -  ࠬ ⤥   ࠧ⥫ :  楫
ࠬ ᫨    祬 ( 䨪 )}
    case ArgType:TArgType of
      at_Nothing: ();
      at_String : (StrParam:string);
      at_Number : (NumParam:longint);
  end;

  PCLParamList = ^TCLParamList;
  TCLParamList = object(TList)
    Constructor Init;

{頥 ⢮ ࠬ஢   ப}
    Function  GetParamCount:byte;
{஢   ࠬ   ஬ 祬}
    Function  isKey(Num:byte):boolean;
{஢ ⢮ ࠬ   }
    Function  isParamExist(Num:byte):boolean;
{஢ ⢮ }
    Function  isKeyExist(Key:string):boolean;

{***    㭪樨  TRUE  砥 ᯥ譮   ***}
{*** 믮  FALSE  砥 ⢨ ࠬ ***}

{஢ઠ ⢮ ࠬ   .}
    Function  CheckParamNum(Num:byte):boolean;
{஢ઠ ⢮ ࠬ  .}
    Function  CheckParamKey(Key:string):boolean;

{頥 ࠬ   . ᫨ ࠬ -頥 NIL}
    Function  GetParamNum(Num:byte;var Param:PCLParam):boolean;
{頥 ࠬ  . ᫨ ࠬ  - 頥 NIL}
    Function  GetParamKey(Key:string;var Param:PCLParam):boolean;

{஢ઠ ⨯ ࠬ   .}
    Function  GetParamTypeNum(Num:byte;var ArgType:TArgType):boolean;
{஢ઠ ⨯ ࠬ  .}
    Function  GetParamTypeKey(Key:string;var ArgType:TArgType):boolean;

{頥 ப ࠬ   . ᫨ ࠬ  -
頥  ப}
    Function  GetStringParamNum(Num:byte;var Param:string):boolean;
{頥 ᫮ ࠬ ⨯ byte   . ᫨ ࠬ
 - 頥 0}
    Function  GetByteParamNum(Num:byte;var Param:byte):boolean;
{頥 ᫮ ࠬ ⨯ integer   . ᫨ ࠬ
 - 頥 0}
    Function  GetIntParamNum(Num:byte;var Param:integer):boolean;
{頥 ᫮ ࠬ ⨯ word   . ᫨ ࠬ
 - 頥 0}
    Function  GetWordParamNum(Num:byte;var Param:word):boolean;

{頥 ப ࠬ  . ᫨ ࠬ  -
頥  ப}
    Function  GetStringParamKey(Key:string;var Param:string):boolean;
{頥 ᫮ ࠬ ⨯ byte  . ᫨ ࠬ
 - 頥 0}
    Function  GetByteParamKey(Key:string;var Param:byte):boolean;
{頥 ᫮ ࠬ ⨯ integer  . ᫨ ࠬ
 - 頥 0}
    Function  GetIntParamKey(Key:string;var Param:integer):boolean;
{頥 ᫮ ࠬ ⨯ word  . ᫨ ࠬ
 - 頥 0}
    Function  GetWordParamKey(Key:string;var Param:word):boolean;

    Procedure DisposeItem(Item:Pointer);virtual;
  end;

{樠 }
Procedure InitCLParser;
{樠 }
Procedure DoneCLParser;

Var
  CLParam : PCLParamList;

Implementation

Procedure InitCLParser;
begin
  New(CLParam,Init);
end; {InitCLParser}

Procedure DoneCLParser;
begin
  Dispose(CLParam,Done);
end; {DoneCLParser}

Constructor TCLParamList.Init;
var
  i,n:integer;
  l:longint;
  Param:PCLParam;
  s:string;
begin
  Inherited Init;
  for i:=1 to ParamCount do
  begin
    New(Param);
    s:=ParamStr(i);
    if (s[1]='-') or (s[1]='/') then
      begin
        n:=Pos(':',s);
        if n<>0 then
          begin
            Param^.Key:=StrUpCase(Copy(ParamStr(i),2,n-2));
            s:=Copy(ParamStr(i),n+1,length(ParamStr(i))-n);
          end
        else
          begin
            Param^.Key:=StrUpCase(Copy(ParamStr(i),2,length(ParamStr(i))-1));
            Param^.ArgType:=at_Nothing;
            Insert(Param);
            continue;
          end;
      end
    else
      Param^.Key:='';
    Val(s,l,n);
    if n<>0 then
      begin
        Param^.ArgType:=at_String;
        Param^.StrParam:=s;
        Insert(Param);
      end
    else
      begin
        Param^.ArgType:=at_Number;
        Param^.NumParam:=l;
        Insert(Param);
      end;
  end;
end; {TCLParamList.Init}

Function TCLParamList.GetParamCount:byte;
begin
  GetParamCount:=QItems;
end; {TCLParamList.GetParamCount}

Function TCLParamList.isKey(Num:byte):boolean;
var
  Param:PCLParam;
begin
  if not GetParamNum(Num,Param) then
  begin
    isKey:=false;
    exit;
  end;
  if Param^.Key='' then
    isKey:=false
  else
    isKey:=true;
end; {TCLParamList.isKey}

Function TCLParamList.isParamExist(Num:byte):boolean;
var
  Param:PCLParam;
begin
  if GetParamNum(Num,Param) then
    isParamExist:=true
  else
    isParamExist:=false;
end; {TCLParamList.isParamExist}

Function TCLParamList.isKeyExist(Key:string):boolean;
var
  Param:PCLParam;
begin
  if GetParamKey(Key,Param) then
    isKeyExist:=true
  else
    isKeyExist:=false;
end; {TCLParamList.isKeyExist}

Function TCLParamList.CheckParamNum(Num:byte):boolean;
begin
  if GetParamCount<Num then
  begin
    CheckParamNum:=false;
    exit;
  end;
  CheckParamNum:=true;
end; {TCLParamList.CheckParamNum}

Function TCLParamList.CheckParamKey(Key:string):boolean;
var
  Param:PCLParam;
  i:integer;
begin
  Key:=StrUpCase(Key);
  SetCurrent(0);
  Param:=GetItem;
  for i:=1 to GetSize do
  begin
    if Param^.Key=Key then
    begin
      CheckParamKey:=true;
      exit;
    end;
    Param:=GetNext;
  end;
  CheckParamKey:=false;
end; {TCLParamList.CheckParamKey}

Function TCLParamList.GetParamNum(Num:byte;var Param:PCLParam):boolean;
begin
  if not CheckParamNum(Num) then
  begin
    GetParamNum:=false;
    Param:=nil;
    exit;
  end;
  Param:=GetItemAt(Num-1);
  GetParamNum:=true;
end; {TCLParamList.GetParamNum}

Function TCLParamList.GetParamKey(Key:string;var Param:PCLParam):boolean;
var
  i:integer;
begin
  if not CheckParamKey(Key) then
  begin
    GetParamKey:=false;
    Param:=nil;
    exit;
  end;
  Key:=StrUpCase(Key);
  SetCurrent(0);
  Param:=GetItem;
  for i:=1 to GetSize do
  begin
    if Param^.Key=Key then
    begin
      GetParamKey:=true;
      exit;
    end;
    Param:=GetNext;
  end;
  GetParamKey:=false;
end; {TCLParamList.GetParamKey}

Function TCLParamList.GetParamTypeNum(Num:byte;var ArgType:TArgType):boolean;
var
  Param:PCLParam;
begin
  if not GetParamNum(Num,Param) then
  begin
    GetParamTypeNum:=false;
    exit;
  end;
  ArgType:=Param^.ArgType;
  GetParamTypeNum:=true;
end; {TCLParamList.GetParamTypeNum}

Function TCLParamList.GetParamTypeKey(Key:string;var ArgType:TArgType):boolean;
var
  Param:PCLParam;
begin
  if not GetParamKey(Key,Param) then
  begin
    GetParamTypeKey:=false;
    exit;
  end;
  ArgType:=Param^.ArgType;
  GetParamTypeKey:=true;
end; {TCLParamList.GetParamTypeKey}

Function TCLParamList.GetStringParamNum(Num:byte;var Param:string):boolean;
var
  _Param:PCLParam;
begin
  if not GetParamNum(Num,_Param) then
  begin
    GetStringParamNum:=false;
    Param:='';
    exit;
  end;
  if _Param^.ArgType<>at_String then
  begin
    GetStringParamNum:=true;
    Str(_Param^.NumParam,Param);
    exit;
  end;
  Param:=_Param^.StrParam;
  GetStringParamNum:=true;
end; {TCLParamList.GetStringParamNum}

Function TCLParamList.GetByteParamNum(Num:byte;var Param:byte):boolean;
var
  _Param:PCLParam;
begin
  if not GetParamNum(Num,_Param) then
  begin
    GetByteParamNum:=false;
    Param:=0;
    exit;
  end;
  if _Param^.ArgType<>at_Number then
  begin
    GetByteParamNum:=true;
    Param:=0;
    exit;
  end;
  Param:=byte(_Param^.NumParam);
  GetByteParamNum:=true;
end; {TCLParamList.GetByteParamNum}

Function TCLParamList.GetIntParamNum(Num:byte;var Param:integer):boolean;
var
  _Param:PCLParam;
begin
  if not GetParamNum(Num,_Param) then
  begin
    GetIntParamNum:=false;
    Param:=0;
    exit;
  end;
  if _Param^.ArgType<>at_Number then
  begin
    GetIntParamNum:=true;
    Param:=0;
    exit;
  end;
  Param:=integer(_Param^.NumParam);
  GetIntParamNum:=true;
end; {TCLParamList.GetIntParamNum}

Function TCLParamList.GetWordParamNum(Num:byte;var Param:word):boolean;
var
  _Param:PCLParam;
begin
  if not GetParamNum(Num,_Param) then
  begin
    GetWordParamNum:=false;
    Param:=0;
    exit;
  end;
  if _Param^.ArgType<>at_Number then
  begin
    GetWordParamNum:=true;
    Param:=0;
    exit;
  end;
  Param:=word(_Param^.NumParam);
  GetWordParamNum:=true;
end; {TCLParamList.GetWordParamNum}

Function TCLParamList.GetStringParamKey(Key:string;var Param:string):boolean;
var
  _Param:PCLParam;
begin
  if not GetParamKey(Key,_Param) then
  begin
    GetStringParamKey:=false;
    Param:='';
    exit;
  end;
  if _Param^.ArgType<>at_String then
  begin
    GetStringParamKey:=true;
    Str(_Param^.NumParam,Param);
    exit;
  end;
  Param:=_Param^.StrParam;
  GetStringParamKey:=true;
end; {TCLParamList.GetStringParamKey}

Function TCLParamList.GetByteParamKey(Key:string;var Param:byte):boolean;
var
  _Param:PCLParam;
begin
  if not GetParamKey(Key,_Param) then
  begin
    GetByteParamKey:=false;
    Param:=0;
    exit;
  end;
  if _Param^.ArgType<>at_Number then
  begin
    GetByteParamKey:=true;
    Param:=0;
    exit;
  end;
  Param:=byte(_Param^.NumParam);
  GetByteParamKey:=true;
end; {TCLParamList.GetByteParamKey}

Function TCLParamList.GetIntParamKey(Key:string;var Param:integer):boolean;
var
  _Param:PCLParam;
begin
  if not GetParamKey(Key,_Param) then
  begin
    GetIntParamKey:=false;
    Param:=0;
    exit;
  end;
  if _Param^.ArgType<>at_Number then
  begin
    GetIntParamKey:=true;
    Param:=0;
    exit;
  end;
  Param:=integer(_Param^.NumParam);
  GetIntParamKey:=true;
end; {TCLParamList.GetIntParamKey}

Function TCLParamList.GetWordParamKey(Key:string;var Param:word):boolean;
var
  _Param:PCLParam;
begin
  if not GetParamKey(Key,_Param) then
  begin
    GetWordParamKey:=false;
    Param:=0;
    exit;
  end;
  if _Param^.ArgType<>at_Number then
  begin
    GetWordParamKey:=true;
    Param:=0;
    exit;
  end;
  Param:=word(_Param^.NumParam);
  GetWordParamKey:=true;
end; {TCLParamList.GetWordParamKey}

Procedure TCLParamList.DisposeItem(Item:Pointer);
begin
  Dispose(PCLParam(Item));
end; {TCLParamList.DisposeItem}

END.
