{Pascal error handling unit.                                                 }
{v1.0.0 (c) 19.05.1999 by Flying/Digital Reality                             }
Unit ExitUnit;

Interface

Const
  exit_Ok             = 0;   {Correct exit}
  exit_ErrorOpenFile  = 32;  {訡  PCX 䠩}
  exit_InvalidPCX     = 33;  { ଠ PCX 䠩}
  exit_InvalidPalette = 34;  {४⭠  PCX 䠩}
  exit_NoMemory       = 35;  {No enough memory}
  exit_NoParam        = 36;  {Required parameter missed}
  exit_InvalidTRD     = 37;  {Invalid TRD file size}
  exit_InvalidRAW     = 38;  { ଠ RAW 䠩}
  exit_CustomError    = 255; {Exit with custom error message}

Var
  Error:integer;
  ErrorMessage:string;
  DoneMemProc:procedure;

Implementation

Var
  ExitSave:Pointer;

Function GetVideoMode:Byte;
var
  tempVMode:Byte;
begin
  asm
    mov ah,$0f
    int $10
    mov tempvmode,al
  end;
  GetVideoMode:=tempVMode;
end;

Procedure SetVideoMode(Mode:Byte);
begin
  asm
    mov ah,0
    mov al,Mode;
    int $10
  end;
end;

Procedure DoneMem;far;
begin
end;

Procedure MyExitProc;far;
begin
  ExitProc:=ExitSave;
  if (Error<>0) and (ExitCode=0) then ExitCode:=Error;
{Set text mode}
  if GetVideoMode<>3 then SetVideoMode(3);
  if ExitCode<>exit_Ok then
  begin
    writeln;
    write('Error');
    if ExitCode=exit_CustomError then
      write(': ')
    else
      write(' ',ExitCode,': ');
  end;
  case ExitCode of
{Custom error codes}
    exit_ErrorOpenFile  : write('Error opening file');
    exit_InvalidPCX     : write('Invalid PCX file format');
    exit_InvalidPalette : write('Invalid PCX file palette');
    exit_NoMemory       : write('No enough memory');
    exit_NoParam        : write('Required parameter missed');
    exit_InvalidTRD     : write('Invalid TRD file (different size)');
    exit_CustomError    : writeln(ErrorMessage);
{Standart Pascal's run-time errors}
          1 : write('Invalid function number');
          2 : write('File not found');
          3 : write('Path not found');
          4 : write('Too many open files');
          5 : write('File access denied');
          6 : write('Invalid file handle');
         12 : write('Invalid file access code');
         15 : write('Invalid drive number');
         16 : write('Cannot remove current directory');
         17 : write('Cannot rename across drives');
         18 : write('No more files');
        100 : write('Disk read error');
        101 : write('Disk write error');
        102 : write('File not assigned');
        103 : write('File not open');
        104 : write('File not open for input');
        105 : write('File not open for output');
        106 : write('Invalid numeric format');
        150 : write('Disk is write-protected');
        151 : write('Bad drive request struct length');
        152 : write('Drive not ready');
        154 : write('CRC error in data');
        156 : write('Disk seek error');
        157 : write('Unknown media type');
        158 : write('Sector Not Found');
        159 : write('Printer out of paper');
        160 : write('Device write fault');
        161 : write('Device read fault');
        162 : write('Hardware failure');
        200 : write('Division by zero');
        201 : write('Range check error');
        202 : write('Stack overflow error');
        203 : write('Heap overflow error');
        204 : write('Invalid pointer operation');
        205 : write('Floating point overflow');
        206 : write('Floating point underflow');
        207 : write('Invalid floating point operation');
        208 : write('Overlay manager not installed');
        209 : write('Overlay file read error');
        210 : write('Object not initialized');
        211 : write('Call to abstract method');
        212 : write('Stream registration error');
        213 : write('Collection index out of range');
        214 : write('Collection overflow error');
        215 : write('Arithmetic overflow error');
        216 : write('General Protection fault');
  end;
  if (ExitCode<>exit_CustomError) and
     (ErrorMessage<>'') then
     writeln(' (',ErrorMessage,')')
  else
     writeln;
  DoneMemProc;
end;

BEGIN
  ExitSave:=ExitProc;
  ExitProc:=@MyExitProc;
  ErrorMessage:='';
  DoneMemProc:=DoneMem;
  ExitCode:=0;
  Error:=0;
END.
