/********************************************************************************************/
//Program name:
//Date:
/********************************************************************************************/
//Author: Richard van der Brugge,/Email: rvdbrugge@yahoo.com
//Copyright 2000, All rights reserved
/***********************************************/
//Description:
//
//
/***********************************************/
//Revision history:
//
//
/***********************************************/

/***********************************************/
/* Starfield                                                             */
/*                                                                        */
/* An attempt to recreate an old asm starfield              */
/* in GBDK C for the gameboy                                  */
/*                                                                        */
/* Yes this must be the most trivial demoeffect             */
/* in the book, but still fun...                                      */
/*                              */
/* You can use this freely in whatever way you  */
/* want.                            */
/*                              */
/* All rights reserved                  */
/* Code: Richard van der Brugge,Jan 2000        */
/*                              */
/* Email: rvdbrugge@yahoo.com           */
/*                              */
/***********************************************/

//version2 - trying some speed optimizing...

//this version is slightly different from the first.
//i've tried some loop unrolling by removing the procedures
//and putting them into the main code loop
//also removed the randomize functions now using
//precalculated values from the xarray.c file
//so what did we gain in speed? basicly nothing...... :-)

//standard GBDK includes
#include <gb.h>
//arrays holding precalc. "random" numbers
#include "xarray.c"

//include the sprite data from GBTD
// sprite 0 smallest star
// sprite 1 a bit bigger
// sprite 2 biggest star
#include "sprite_t.c"
#include "sprite_t.h"

//array to hold all star positions
long  starx[40];
long  stary[40];
long  starz[40];

UBYTE rndcounter;


UBYTE i;
long  posx;
long  posy;

void init();

void main()
{

disable_interrupts();
cpu_fast();
enable_interrupts();

//setup all sprites
init();



//keep doing this forever
while(1){
    for (i=0;i<40;i++){
        posx=starx[i]<<5;
        posx=posx/starz[i];
        posx+=72;

        posy=stary[i]<<5;
        posy=posy/starz[i];
        posy+=80;

        starz[i]--;

        if (starz[i]==0||posx>160||posx<0||posy>144||posy<0){
            starx[i]=xarray[rndcounter];
            stary[i]=yarray[rndcounter];
            rndcounter++;
            if(rndcounter==160){rndcounter=0;}
            starz[i]=32;
            set_sprite_tile(i,0);
        }

        if (starz[i]==7){   set_sprite_tile(i,2);}
        if (starz[i]==15){set_sprite_tile(i,1);}

        move_sprite(i,posx,posy);
    }
}

}//end main

void init()
{
UBYTE i;
UBYTE r;
HIDE_SPRITES;
//load sprite data from include file sprite_t.c
set_sprite_data(0,4,StarSprite);


//setup all star x/y/z data
for (i=0;i<40;i++){
        starx[i]=xarray[rndcounter];
        stary[i]=yarray[rndcounter];
        rndcounter++;
        starz[i]=32;
        set_sprite_tile(i,0);
}

SHOW_SPRITES;

}//end init

