! Two-way cache test for Saturn
! Mic, 2009
!
! Puts the main SH2's cache in two-way mode, copies some code to 2kB internal RAM
! at 0xC0000000, then executes that code.
! Should fill the screen with green.


	.text
	.global	_start

_start:
	bra	_main
	nop


! r11 should point to TVSTAT
_wait_vbl:
1:
	mov.w	@r11,r0
	tst	#8,r0	
	bf	1b
2:
	mov.w	@r11,r0
	tst	#8,r0
	bt	2b
	rts
	nop

	
_main:
	! Enable cache, purge cache and set two-way mode
        mov.l   CACHECTL,r0
        mov     #0x19,r1
        mov.b   r1,@r0
 

 
	mov.l	RAMCTL,r11
	mov.l	RAMCTL_mask,r6
	mov.w	@r11,r0
	and	r0,r6
	mov.w	r6,@r11

	! Set up VDP2
	mov.w	BIT15,r12
	mov	#0x40,r8
	shll2	r8
	add 	#0x2e,r11	!Point to MPOFN
	mov	#0,r2
	mov.w	r2,@r11
	add 	#0x3c,r11	! Point to ZMXIN0
	mov.w 	r2,@-r11	! Clear SCYDN0
	mov.w 	r2,@-r11	! SCYIN0
	mov.w 	r2,@-r11	! SCXDN0
	mov.w 	r2,@-r11	! SCXIN0
	add 	#-72,r11	! Point to CHCTLA
	mov	#0x12,r2
	mov.w	r2,@r11
	add	#-8,r11		! Point to BGON
	add	#1,r8
	mov.w	r8,@r11
	add	#-32,r11	! Point to TVMD
	mov.w	r12,@r11
	add 	#4,r11		! Point to TVSTAT
	
	! Set up the palette
	mov.l	VDP2_CRAM,r0
	mov	#0,r1
	or	r12,r1
	mov.w	r1,@r0	! Color 0 = black
	add	#2,r0
	mov	#31,r1
	or	r12,r1
	mov.w	r1,@r0	! Color 1 = red
	add	#2,r0
	mov	#31,r1
	shll2	r1
	shll2	r1
	shll	r1
	or	r12,r1
	mov.w	r1,@r0	! Color 2 = green
	

	mov.l	fill_screen_c,r0
	mov.l	fill_screen,r1
	mov.l	block_size,r2
_copy_to_cache:
	mov.b	@r1,r3
	add	#1,r1
	mov.b	r3,@r0
	dt	r2
	bf/s	_copy_to_cache
	add	#1,r0	

	bsr	_wait_vbl
	nop
	
	! Fill the screen with color 1 (this executes the function in WorkRAM)
	mov.l	fill_screen,r0
	jsr	@r0
	mov	#1,r1
	
_main_loop:
	bsr	_wait_vbl
	nop

	! Fill the screen with color 2 (this executes the function in internal RAM (cache))
	mov.l	fill_screen_c,r0
	jsr	@r0
	mov	#2,r1
	
	bra	_main_loop
	nop

	
! Color in r1
_fill_screen:
	mov	r1,r2
	shll8	r2
	or	r2,r1
	mov.l	VDP2_VRAM,r8
	mov	#224,r6
	extu.b	r6,r6
	mov	#192,r7
	extu.b	r7,r7
_fill_vram_y:
	mov	#80,r2
	shll	r2
_fill_vram_x:
	mov.w	r1,@r8
	dt	r2	
	bf/s	_fill_vram_x
	add	#2,r8
	dt	r6
	bf/s	_fill_vram_y
	add	r7,r8
	rts
	nop

BIT15:
	.short	0x8000
	
	.align 2
CACHECTL:
        .long 	0xFFFFFE92	
RAMCTL:
	.long	0x25f8000e
RAMCTL_mask:
	.long	0xcfff
VDP2_CRAM:
	.long	0x25f00000
VDP2_VRAM:
	.long	0x25e00000
fill_screen:
	.long	_fill_screen
fill_screen_c:
	.long	0xC0000000
block_size:
	.long	_fill_screen_end-_fill_screen

_fill_screen_end:

