; SNES I/O registers

.equ REG_DISPCNT 	$2100
.equ REG_OBSEL		$2101
.equ REG_DISPMODE	$2105

.equ REG_BG0MAP 	$2107
.equ REG_BG1MAP 	$2108
.equ REG_BG2MAP 	$2109
.equ REG_BG3MAP 	$210A

.equ REG_CHRBASE_L 	$210B
.equ REG_CHRBASE_H 	$210C

.equ REG_BG0HOFS	$210D
.equ REG_BG0VOFS	$210E

.equ REG_VRAM_INC 	$2115
.equ REG_VRAM_ADDR_L 	$2116
.equ REG_VRAM_ADDR_H 	$2117
.equ REG_VRAM_DATAW1 	$2118
.equ REG_VRAM_DATAW2 	$2119
.equ REG_VRAM_DATAR1 	$2139
.equ REG_VRAM_DATAR2 	$213A

.equ REG_CGRAM_ADDR 	$2121
.equ REG_CGRAM_DATAW 	$2122

.equ REG_BGCNT 		$212C

.equ REG_COLDATA	$2132

.equ REG_STAT78		$213F

.equ REG_APUI00		$2140
.equ REG_APUI01		$2141
.equ REG_APUI02		$2142
.equ REG_APUI03		$2143

.equ REG_NMI_TIMEN	$4200

; Multiplier
.equ REG_WRMPYA		$4202
.equ REG_WRMPYB		$4203
.equ REG_RDMPYL		$4216
.equ REG_RDMPYH		$4217

.equ REG_RDNMI		$4210

.equ REG_HVB_JOY	$4212
.equ REG_JOY1L		$4218
.equ REG_JOY1H		$4219
.equ REG_JOY2L		$421A
.equ REG_JOY2H		$421B

.equ REG_MDMAEN		$420B
.equ REG_HDMAEN		$420C

; DMA channel 0
.equ REG_DMAP0		$4300
.equ REG_BBAD0		$4301
.equ REG_A1T0L		$4302
.equ REG_A1T0H		$4303
.equ REG_A1B0		$4304
.equ REG_DAS0L		$4305
.equ REG_DAS0H		$4306
.equ REG_DASB0		$4307

; DMA channel 1
.equ REG_DMAP1		$4310
.equ REG_BBAD1		$4311
.equ REG_A1T1L		$4312
.equ REG_A1T1H		$4313
.equ REG_A1B1		$4314
.equ REG_DAS1L		$4315
.equ REG_DAS1H		$4316
.equ REG_DASB1		$4317

;********************************************************************************************


; For DISPCNT
.equ ENABLE_SCREEN	$00
.equ BLANK_SCREEN 	$80
.equ BRIGHTNESS_0	$00
.equ BRIGHTNESS_1	$01
.equ BRIGHTNESS_2	$02
.equ BRIGHTNESS_3	$03
.equ BRIGHTNESS_4	$04
.equ BRIGHTNESS_5	$05
.equ BRIGHTNESS_6	$06
.equ BRIGHTNESS_7	$07
.equ BRIGHTNESS_8	$08
.equ BRIGHTNESS_9	$09
.equ BRIGHTNESS_10	$0A
.equ BRIGHTNESS_11	$0B
.equ BRIGHTNESS_12	$0C
.equ BRIGHTNESS_13	$0D
.equ BRIGHTNESS_14	$0E
.equ BRIGHTNESS_15	$0F

; For VRAM_INC
.equ VRAM_BYTE_ACCESS	$00
.equ VRAM_WORD_ACCESS	$80

; For BGCNT
.equ BG0_ENABLE 	$01
.equ BG1_ENABLE 	$02
.equ BG2_ENABLE 	$04
.equ BG3_ENABLE 	$08
.equ OBJ_ENABLE 	$10

; For NMI_TIMEN
.equ JOY_MANUAL_READ	$00
.equ JOY_AUTO_READ	$01

; For HVB_JOY
.equ JOY_DISABLE	$00
.equ JOY_ENABLE		$01

; For STAT78
.equ PPU_VERSION	$0F
.equ PPU_MODE		$10
.equ PPU_FIELD		$40
