! gui.s
! shuboy 32x gui
! sh2 assembly version
! /mic 2009


.section .data

.global _gui_init
.global _gui_process
.global _gui_present
.global __GUI_COPY_TO_IWRAM_START__
.global __GUI_COPY_TO_IWRAM_END__


! ###########################################################################################################

.include "shuboy.inc"

.equ MARS_224_LINES,	0x0000
.equ MARS_240_LINES,	0x0040

.equ MARS_VDP_MODE_OFF,	0x0000
.equ MARS_VDP_MODE_256,	0x0001
.equ MARS_VDP_MODE_32K,	0x0002
.equ MARS_VDP_MODE_RLE,	0x0003

! ###########################################################################################################

.align 1

_gui_init:
	! Wait for the SH2 to gain access to the VDP
	mov.l	MARS_SYS_INTMSK,r1
	mov.w	BIT15,r12
_wait_for_VDP_access:
	mov.w	@r1,r0
	tst	r12,r0
	bt	_wait_for_VDP_access

	! Set 8-bit paletted mode, 224 lines
	mov.l	MARS_VDP_DISPMODE,r1
	mov	#MARS_224_LINES+MARS_VDP_MODE_256,r0
	mov.w	r0,@r1
	
	mov.l	_currentFB,r0
	mov.l	MARS_VDP_FBCTL,r1
	mov	#0,r2
	mov.w	r2,@r0
	mov.w	r2,@r1
	
	! Set up the palette
	mova	dmg_colors,r0
	mov.l	MARS_CRAM,r1
	add	#2,r1
	mov.w	@r0+,r2
	mov.w	r2,@r1
	add	#2,r1
	mov.w	@r0+,r2
	mov.w	r2,@r1
	add	#2,r1
	mov.w	@r0+,r2
	mov.w	r2,@r1
	add	#2,r1
	mov.w	@r0+,r2
	mov.w	r2,@r1

	rts
	nop
	

_gui_process:
	mov.l	MARS_SYS_COMM10,r0
	mov.w	@r0,r1
	mov	#0xFF,r2
	extu.w	r1,r1
	extu.b	r2,r2
	xor	r2,r1
	mov	r1,r0
	shlr2 	r0
	shlr2 	r0
	mov.l 	_keys,r2
	add 	#1,r2
	and 	#0x0F,r0
	mov.b 	r0,@r2
	mov	r1,r0
	and	#3,r0
	shll2	r0
	mov	#0,r2
	or	r0,r2
	mov	r1,r0
	and	#4,r0
	shlr	r0
	or	r0,r2
	mov	r1,r0
	and	#8,r0
	shlr2	r0
	shlr	r0
	or	r0,r2
	mov.l	_keys,r0
	mov.b	r2,@r0
	
!	cpu.stopped = false;
!	REG_IF |= 0x10;
!	if ((IME!=0)&&((REG_IE&0x10)!=0)) {
!		REG_IF &= ~0x10;
!		cpu_rst(0x60);
!		IME = 0;
!	}
	
	rts
	nop

.align 2
_keys:	.long keys


.align 2
__GUI_COPY_TO_IWRAM_START__:

_gui_present:
	mov.l	MARS_VDP_FBCTL,r1
	mov.w 	@r1,r2
	mov.l	_currentFB,r3
	mov.w	@r3,r0
	xor	#1,r0
	mov.w	r0,@r1
	mov.w	r0,@r3
_wait_FS:
	nop
	nop
	mov.w	@r1,r0
	nop

	nop
	xor	r2,r0
	tst	#1,r0
	bt	_wait_FS

! Initialize the line table in the first 512 bytes of the current framebuffer
	mov	#64,r0
	shll2	r0
	mov	#160,r4
	extu.b	r4,r4
	mov	r0,r2
	mov.l	FRAMEBUFFER2,r5	
_init_lt:
	mov.w	r0,@r5
	add	r4,r0
	dt	r2
	bf/s	_init_lt
	add	#2,r5
	
	rts
	nop

	
.align 2
dmg_colors:
	.short 0xE7DF,0xBF10,0xB1A2,0x8061
.long 0	
BIT15:
	.short 0x8000,0
currentFB:
	.short 0,0
	
	.align 2	
_currentFB:
	.long currentFB + UNCACHED_ADDRESS
FRAMEBUFFER2:
	.long 0x24000000	
MARS_VDP_FBCTL:
	.long 0x2000410A

__GUI_COPY_TO_IWRAM_END__:

MARS_SYS_INTMSK:
	.long 0x20004000
MARS_SYS_COMM10:
	.long 0x2000402A	
MARS_VDP_DISPMODE:
	.long 0x20004100
MARS_CRAM:
	.long 0x20004200
	