! shuboy.inc
! common definitions
! /mic, 2009


! Various emulation flags kept in R13
.equ CPU_HALTED, 0x01
.equ CPU_STOPPED,0x02
.equ CPU_EI_PENDING, 0x04
.equ CPU_DI_PENDING, 0x08
.equ CPU_IME, 0x10


! Cache-through addresses are used to access the GB I/O registers, VRAM and OAM
! since they are needed by both the Master and Slave SH2.
.equ UNCACHED_ADDRESS,0x20000000


! Code/data from cpu.s gets copied to this address in main SH2 cache
.equ CPU_CACHE_COPY_ADR,0xC0000000


! Code/data from memory.s gets copied to this address in main SH2 cache
.equ MEM_CACHE_COPY_ADR,0xC0000400


! Code/data from slave.s gets copied to this address in main SH2 cache
.equ SLAVECTL_CACHE_COPY_ADR,0xC0000780


! Code/data from slave.s gets copied to this address in slave SH2 cache
.equ SLAVE_CACHE_COPY_ADR,0xC0000000


! Code/data from gui.s gets copied to this address in slave SH2 cache
.equ GUI_CACHE_COPY_ADR,0xC0000700


! Code/data from ppu.s gets copied to this address in slave SH2 cache
.equ PPU_CACHE_COPY_ADR,0xC00000A0


.equ SLAVE_CMD_NULL,0
.equ SLAVE_CMD_DRAW_SCANLINE,1
.equ SLAVE_CMD_SWITCH_FRAMEBUFFER,2


.equ SLAVE_READY,0
.equ SLAVE_BUSY,1


.equ EVENT_NULL,0
.equ EVENT_PPU_MODE_CHANGE,1
.equ EVENT_SCANLINE_END,2
.equ EVENT_INCREASE_DIV,3
.equ EVENT_TIMER_UNDERFLOW,4
