// Scroll_text.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "resource.h"

#define MAX_LOADSTRING 100

// radians to degrees
#define TODEGREES(x) ((x) * 180.0 / M_PI)


struct Coordinate
{
	float x, y, z;
	float rota;
};


typedef struct _tagVECTOR
{
	float x;
	float y;
	float z;
} VECTOR, *LPVECTOR;

typedef struct _tagTDPOINT
{
	float x;
	float y;
	float z;
} TDPOINT, *LPTDPOINT;

typedef struct _tagSTAR
{
	TDPOINT m_start;
	VECTOR speed;
	float m_curPos[3]; // a float[], so we can call glVertex3fv
	float m_fColor[3];
	float timeOffset;
} STAR, *LPSTAR;

// Global Variables:
typedef std::vector<Coordinate> g_charPos;

HDC			hDC = NULL;		// Private GDI Device Context
HGLRC		hRC = NULL;		// Permanent Rendering Context
HWND		hWnd = NULL;		// Holds Our Window Handle
HINSTANCE	hInstance;		// Holds The Instance Of The Application

bool	keys[256];			// Array Used For The Keyboard Routine
bool	active = TRUE;		// Window Active Flag Set To TRUE By Default
bool	fullscreen = TRUE;	// Fullscreen Flag Set To Fullscreen Mode By Default
bool    m_bPointStars;
bool     playmusic = FALSE;


// =============================================================

miniF fMod;
bool bIsMusicPaused = false;
// =============================================================



GLuint g_sTexture = 0;			// One Texture Map For The Font
GLuint g_LTexture[3] = { 0, 0, 0 };			// three Texture Map for messages
GLuint	base;				// Base Display List For The Font Set

GLfloat	rot;				// Used To Rotate The Text

float Centroide[3];
float dstentchar = 2.f* 0.255f + 2.f*0.0375f;
GLfloat	xtrs = 0.f;			// X Traslation ( NEW )
GLfloat xspeed = 0.31f;				// Transformation Speed
int nchar = 0;
int pri, prf;
int m_iNumStars = 100;
float m_fStarSpeed = 10;
int g_msgA = 0;

//std::vector<Coordinate> g_charPos;
std::vector<g_charPos> vg_charPos;

char sT[5][400] = { { "HEEYYYYAAAA                              THIS IS MY FIRST 'LOOKABLE' PROD, THIS SCROLLER IS INSPIRED FROM A BBSTRO I'VE SEE ON DEFACTO2 'ASYLUM BBS' SO VOILA. :) FEEL FREE TO USE THE INCLUDED SOURCE CODE IN YOUR OWN PROD, THE GFX WAS MADE BY XSPIDER/RED AND THE MUSIC IS COMPOSED BY ALEX'2000, MENU: [F1] TO SWITCH WINDOWED/FULL SCREEN - [M] TO PLAY/STOP THE MUSIC - [K] MORE TEXT - [ESC] QUIT" },
{ "TEMARI.FR CALL NOW !!! THIS IS MY SITE, WITH SPECIAL CHALLENGE TO PASS THE GATE, CONTENT MOSTLY IN FRENCH: REVERSE ENGINEERING, VX, DIY, HACKING, EZINES, VIDEOS, 3D, ELECTRONIC, C/C++/ASM AND MOAR!" },
{ "FRIENDLY BBS AND HIDDEN REPOSITORIUM, ARCHIVING THE FRENCH CRACKING SCENE AND COLLECTING FRENCH UNDERGROUND FANZINES." },
{ "ALSO MY WAIFU CAN BEAT UP YOUR WAIFU" },
{ "OK I STOP PLAYING WITH THE ARRAY... :)           SEE YOU LATERZZZZZZZZZZZ.   -Xyl" } };
//char sTp[64] = { "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890?<>" };

LPSTAR m_pStars;                  //
LARGE_INTEGER m_start;           //     Variables used for the starfield
LARGE_INTEGER m_starStart;       //
LARGE_INTEGER m_freq;           //

std::clock_t g_PreviousTicks;       // Variables used for the animation speed function
std::clock_t g_CurrentTicks;

WCHAR szTitle[MAX_LOADSTRING];                  // The title bar text
WCHAR szWindowClass[MAX_LOADSTRING];            // the main window class name

												// Forward declarations of functions included in this code module:
LRESULT CALLBACK    WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK    About(HWND, UINT, WPARAM, LPARAM);
GLvoid              BuildFont(GLvoid);								// Build Our Bitmap Font
GLvoid              glPrint(char *text);								// Custom GL "Print" Routine
int                 LoadGLTextures();									// Load Bitmaps And Convert To Textures
GLvoid              ReSizeGLScene(GLsizei, GLsizei);		// Resize And Initialize The GL Window
int                 InitGL(GLvoid);										// All Setup For OpenGL Goes Here
int                 DrawGLScene(GLvoid);									// Here's Where We Do All The Drawing
GLvoid              KillGLWindow(GLvoid);								// Properly Kill The Window
BOOL                CreateGLWindow(char*, int, int, int, bool);
void                Idle();
void                InitStars();


HWND GetConsoleHwnd(void)
{
#define MY_BUFSIZE 256 // Buffer size for console window titles.
	HWND hwndFound;         // This is what is returned to the caller.

	char pszOldWindowTitle[MY_BUFSIZE]; // Contains original
										// WindowTitle.

										// Fetch current window title.

	GetConsoleTitle(pszOldWindowTitle, MY_BUFSIZE);

	// Look for WindowTitle.

	hwndFound = FindWindow(NULL, pszOldWindowTitle);

	// Change current window title.

	SetConsoleTitle("Windows Console");


	return(hwndFound);
}


int WinEntryPoint(void)
{
	HWND        hwndConsole;     /* This is the handle for our console */
	hInstance = GetModuleHandle(NULL);

	// TODO: Place code here.

	MSG		msg;									// Windows Message Structure
	BOOL	done = FALSE;								// Bool Variable To Exit Loop


														//	RedirectIOToConsole();
	hwndConsole = GetConsoleHwnd();
	MoveWindow(hwndConsole, 5, 5, 640, 480, true);  // test hwnd
	ShowWindow(hwndConsole, SW_HIDE);

	// Ask The User Which Screen Mode They Prefer
	if (MessageBox(NULL, "Would You Like To Run In Fullscreen Mode?", "Start FullScreen?", MB_YESNO | MB_ICONQUESTION) == IDNO)
	{
		fullscreen = FALSE;							// Windowed Mode
	}

	// Create Our OpenGL Window
	if (!CreateGLWindow("TEMARi.FR iNTRO - Xyl/RED", 1024, 768, 32, fullscreen))
	{
		return 0;									// Quit If Window Was Not Created
	}


	// Load The XM File For Tunez
	if (!fMod.LoadMusic(IDR_MODFILE1))
		printf("\n Error load File .xm\n");

	//**************************************
	QueryPerformanceFrequency(&m_freq);

	QueryPerformanceCounter(&m_start);

	m_starStart = m_start;
	m_pStars = new STAR[m_iNumStars];
	InitStars();

	m_bPointStars = FALSE;
	//**************************************

	g_PreviousTicks = std::clock();

	while (!done)									// Loop That Runs While done=FALSE
	{
		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))	// Is There A Message Waiting?
		{
			if (msg.message == WM_QUIT)				// Have We Received A Quit Message?
			{
				done = TRUE;							// If So done=TRUE
			}
			else									// If Not, Deal With Window Messages
			{
				TranslateMessage(&msg);				// Translate The Message
				DispatchMessage(&msg);				// Dispatch The Message
			}
		}
		else										// If There Are No Messages
		{
			// Draw The Scene.  Watch For ESC Key And Quit Messages From DrawGLScene()
			if ((active && !DrawGLScene()) || keys[VK_ESCAPE])	// Active?  Was There A Quit Received?
			{
				done = TRUE;							// ESC or DrawGLScene Signalled A Quit
			}
			else									// Not Time To Quit, Update Screen
			{
				SwapBuffers(hDC);					// Swap Buffers (Double Buffering)
			}

			if (keys[VK_F1])						// Is F1 Being Pressed?
			{
				keys[VK_F1] = FALSE;					// If So Make Key FALSE
				KillGLWindow();						// Kill Our Current Window
				fullscreen = !fullscreen;				// Toggle Fullscreen / Windowed Mode

				if (fullscreen) {
					// Recreate Our OpenGL Window
					if (!CreateGLWindow("TEMARi.FR iNTRO - Xyl/RED", 1024, 768, 32, fullscreen))
					{
						return 0;						// Quit If Window Was Not Created
					}
				}
				else
				{
					// Recreate Our OpenGL Window
					if (!CreateGLWindow("TEMARi.FR iNTRO - Xyl/RED", 1024, 768, 32, fullscreen))
					{
						return 0;						// Quit If Window Was Not Created
					}

				}
			}

			if (keys['s'] || keys['S'])						// Is S Being Pressed?
			{
				m_bPointStars = !m_bPointStars;
				keys['s'] = FALSE;					// If So Make Key FALSE
				keys['S'] = FALSE;					// If So Make Key FALSE
			}

			if (keys['k'] || keys['K'])						// Is K Being Pressed?
			{
				g_msgA++;
				if (g_msgA > 4)
					g_msgA = 0;
				keys['k'] = FALSE;					// If So Make Key FALSE
				keys['K'] = FALSE;					// If So Make Key FALSE
			}

			if (keys['m'] || keys['M'])						// Is K Being Pressed?
			{
				bIsMusicPaused = !bIsMusicPaused;
				if (bIsMusicPaused == true) {
					fMod.Stop();
				}
				else
					fMod.Play();
				keys['m'] = FALSE;					// If So Make Key FALSE
				keys['M'] = FALSE;					// If So Make Key FALSE
			}


		}
	}  // while

	   // Shutdown
	KillGLWindow();									// Kill The Window
	return (msg.wParam);							// Exit The Program
}



GLvoid BuildFont(GLvoid)								// Build Our Bitmap Font
{
	GLYPHMETRICSFLOAT	gmf[256];						// Address Buffer For Font Storage
	HFONT	font;										// Windows Font ID

	base = glGenLists(256);								// Storage For 256 Characters

	font = CreateFont(-12,							// Height Of Font
		0,								// Width Of Font
		0,								// Angle Of Escapement
		0,								// Orientation Angle
		FW_BOLD,						// Font Weight
		FALSE,							// Italic
		FALSE,							// Underline
		FALSE,							// Strikeout
		DEFAULT_CHARSET,				// Character Set Identifier
		OUT_TT_PRECIS,					// Output Precision
		CLIP_DEFAULT_PRECIS,			// Clipping Precision
		ANTIALIASED_QUALITY,			// Output Quality
		FF_DONTCARE | DEFAULT_PITCH,		// Family And Pitch
		"ARIAL");					    // Font Name

	SelectObject(hDC, font);							// Selects The Font We Created

	wglUseFontOutlines(hDC,							// Select The Current DC
		0,								// Starting Character
		255,							// Number Of Display Lists To Build
		base,							// Starting Display Lists
		0.1f,							// Deviation From The True Outlines
		0.05f,							// Font Thickness In The Z Direction
		WGL_FONT_POLYGONS,				// Use Polygons, Not Lines
		gmf);							// Address Of Buffer To Recieve Data
}

GLvoid KillFont(GLvoid)									// Delete The Font
{
	glDeleteLists(base, 256);								// Delete All 256 Characters
}

GLvoid glPrint(char *text)								// Custom GL "Print" Routine
{
	if (text == NULL)										// If There's No Text
		return;												// Do Nothing

	glPushAttrib(GL_LIST_BIT);							// Pushes The Display List Bits
	glListBase(base);									// Sets The Base Character to 32
	glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);	// Draws The Display List Text
	glPopAttrib();										// Pops The Display List Bits
}


GLuint LoadTextureMN(const int x, const int y, LPVOID pData)
{
	GLuint textureID; // = SOIL_load_OGL_texture(file.c_str(), SOIL_LOAD_AUTO, SOIL_CREATE_NEW_ID, SOIL_FLAG_MIPMAPS);
	glGenTextures(1, &textureID);
	glBindTexture(GL_TEXTURE_2D, textureID);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	//	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	gluBuild2DMipmaps(GL_TEXTURE_2D, 4, x, y, GL_RGBA, GL_UNSIGNED_BYTE, pData);
	glBindTexture(GL_TEXTURE_2D, 0);

	return textureID;
}


// Load the texture of the font
GLuint LoadTexture(const std::string& file, LPVOID pData)
{
	GLuint textureID; // = SOIL_load_OGL_texture(file.c_str(), SOIL_LOAD_AUTO, SOIL_CREATE_NEW_ID, SOIL_FLAG_MIPMAPS);
	glGenTextures(1, &textureID);
	glBindTexture(GL_TEXTURE_2D, textureID);
	gluBuild2DMipmaps(GL_TEXTURE_2D, 3, 128, 128, GL_RGB, GL_UNSIGNED_BYTE, pData);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_NEAREST);
	glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
	glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);

	//	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	//	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glBindTexture(GL_TEXTURE_2D, 0);

	return textureID;
}

// Load the texture of the Resource
int LoadGLTextures()									// Load Bitmaps And Convert To Textures
{
	int Status = FALSE;									// Status Indicator
	hInstance = GetModuleHandle(NULL);

	if (g_LTexture[0])
		glDeleteTextures(1, &g_LTexture[0]);
	HRSRC hrsrc = FindResource(hInstance, MAKEINTRESOURCE(IDR_RAW2), "RAW");
	HGLOBAL hGlob = LoadResource(hInstance, hrsrc);
	LPVOID pData = LockResource(hGlob);
	if (!pData)
		Status = FALSE;

	if (g_LTexture[0] = LoadTextureMN(619, 117, pData)) {
		Status = TRUE;									// Set The Status To TRUE
	}


	if (g_LTexture[1])
		glDeleteTextures(1, &g_LTexture[1]);
	hrsrc = FindResource(hInstance, MAKEINTRESOURCE(IDR_RAW3), "RAW");
	hGlob = LoadResource(hInstance, hrsrc);
	LPVOID pData1 = LockResource(hGlob);
	if (!pData)
		Status = FALSE;

	if (g_LTexture[1] = LoadTextureMN(735, 128, pData1)) {
		Status = TRUE;									// Set The Status To TRUE
	}


	if (g_LTexture[2])
		glDeleteTextures(1, &g_LTexture[2]);
	hrsrc = FindResource(hInstance, MAKEINTRESOURCE(IDR_RAW4), "RAW");
	hGlob = LoadResource(hInstance, hrsrc);
	LPVOID pData2 = LockResource(hGlob);
	if (!pData)
		Status = FALSE;

	if (g_LTexture[2] = LoadTextureMN(723, 95, pData2)) {
		Status = TRUE;									// Set The Status To TRUE
	}


	if (g_sTexture)
		glDeleteTextures(1, &g_sTexture);
	hrsrc = FindResource(hInstance, MAKEINTRESOURCE(IDR_RAW1), _T("RAW"));
	hGlob = LoadResource(hInstance, hrsrc);
	LPVOID pData3 = LockResource(hGlob);
	if (!pData)
		Status = FALSE;

	if (g_sTexture = LoadTexture("Data/Lights.jpg", pData3)) {
		Status = TRUE;									// Set The Status To TRUE
	}

	return Status;										// Return The Status
}

GLvoid ReSizeGLScene(GLsizei width, GLsizei height)		// Resize And Initialize The GL Window
{
	if (height == 0)										// Prevent A Divide By Zero By
	{
		height = 1;										// Making Height Equal One
	}

	glViewport(0, 0, width, height);						// Reset The Current Viewport

	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glLoadIdentity();									// Reset The Projection Matrix

														// Calculate The Aspect Ratio Of The Window
	gluPerspective(45.0f, (GLfloat)width / (GLfloat)height, 0.1f, 100.0f);

	glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix
	glLoadIdentity();									// Reset The Modelview Matrix
}

// Returns a random number between min and max
float GetRandom(float min, float max)
{
	float random = float(rand()) / float(RAND_MAX);
	return (min + ((max - min)*random));
}

//Initialize the starfield
void InitStars()
{
	srand(GetTickCount());
	srand(GetTickCount());

	for (int i = 0; i<m_iNumStars; ++i)
	{
		m_pStars[i].m_start.x = GetRandom(-5.0, 5.0);
		m_pStars[i].m_start.y = GetRandom(-5.0, 5.0);
		m_pStars[i].m_start.z = GetRandom(-10.0, 0.5);

		m_pStars[i].speed.x = 0.0;
		m_pStars[i].speed.y = 0.0;
		m_pStars[i].speed.z = m_fStarSpeed;

		// 80% of the stars are white.  The rest are yellowish - redish
#define PERCENTAGE_WHITE 0.8f
		m_pStars[i].m_fColor[0] = 1.0;
		if (GetRandom(0.0, 1.0) > PERCENTAGE_WHITE)
		{
			// make it a colorful star
			m_pStars[i].m_fColor[1] = GetRandom(0.5, 1.0);
			m_pStars[i].m_fColor[2] = 0.0;
		}
		else
		{
			// make it white
			m_pStars[i].m_fColor[1] = 1.0;
			m_pStars[i].m_fColor[2] = 1.0;
		}

		m_pStars[i].timeOffset = 0.0f;
	}
}


float Gaussian_Func(float x)
{
	float param = -1 * (x*x) / 4.5f;
	return (9 * expf(param));
}

float DerGaussian_Func(float x)
{
	float param = -1 * (2.f*x / 4.5f);
	float param1 = -1 * (x*x) / 4.5f;
	return (4 * expf(param1)*param);
}

//Initialize the character string
void InitCharS()
{

	for (int j = 0; j < 5; j++)
	{

		bool fpc1 = false;
		bool fpc2 = false;
		g_charPos charPos;
		Coordinate p;
		nchar = strlen(sT[j]);

		for (int i = 0; i < nchar; i++)
		{
			char lt = sT[j][i];

			if (i == 0)
			{
				p.x = 8.f;
			}
			else
				switch (lt)
				{

				case '1':							// Is A Key Being Held Down?
					if (fpc1 || fpc2)
					{
						if (fpc1) {
							p.x = charPos.back().x + dstentchar + 0.6f*0.255f + (3.f / 4.f)* 0.255f;
							fpc1 = FALSE;
						}
						else
						{
							p.x = charPos.back().x + dstentchar - 0.255f;
							fpc2 = FALSE;

						}
					}
					else
					{
						p.x = charPos.back().x + dstentchar + 0.255f;
					}
					break;								// Jump Back

				case 'I':							// Is A Key Being Held Down?
					if (fpc1)
					{
						p.x = charPos.back().x + dstentchar + (0.8)* 0.255f;
						fpc1 = FALSE;
						fpc2 = TRUE;
					}
					else
					{
						p.x = charPos.back().x + dstentchar + 0.6f * 0.255f;
						fpc2 = TRUE;
					}
					break;								// Jump Back

				case 'M':							// Is A Key Being Held Down?
				case 'W':							// Is A Key Being Held Down?
					if (fpc2)
					{
						p.x = charPos.back().x + dstentchar - 0.255f;
						fpc2 = FALSE;
						fpc1 = TRUE;
					}
					else
					{
						fpc1 = TRUE;
						p.x = charPos.back().x + dstentchar;
					}
					break;								// Jump Back

				case 'O':							// Is A Key Being Held Down?
					if (fpc1 || fpc2)
					{
						if (fpc1) {
							p.x = charPos.back().x + dstentchar - 0.0375f + (3.f / 4.f) * 0.255f;
							fpc1 = FALSE;
						}
						else
						{
							p.x = charPos.back().x + dstentchar - 0.255f - (1.f / 2.f) * 0.255f;
							fpc2 = FALSE;

						}
					}
					else
					{
						p.x = charPos.back().x + dstentchar - 0.0375f;
					}
					break;								// Jump Back

				default:
					if (fpc1 || fpc2)
					{
						if (fpc1) {
							p.x = charPos.back().x + dstentchar + (3.f / 4.f) * 0.255f;
							fpc1 = FALSE;
						}
						else
						{
							p.x = charPos.back().x + dstentchar - 0.255f;
							fpc2 = FALSE;
						}
					}
					else
					{
						p.x = charPos.back().x + dstentchar;
					}
					break;
				}


			p.y = 0.f;
			p.z = Gaussian_Func(p.x);
			charPos.push_back(p);
		}

		vg_charPos.push_back(charPos);
	}

}

int InitGL(GLvoid)										// All Setup For OpenGL Goes Here
{
	if (!LoadGLTextures())								// Jump To Texture Loading Routine
	{
		return FALSE;									// If Texture Didn't Load Return FALSE
	}


	BuildFont();										// Build The Font

	float points[24] = { -0.255f + 0.0655f + 0.255f, -0.32f + 0.32f, 0.0077f,
		0.255f + 0.0655f + 0.255f, -0.32f + 0.32f, 0.0077f,
		0.255f + 0.0655f + 0.255f,  0.32f + 0.32f, 0.0077f,
		-0.255f + 0.0655f + 0.255f,  0.32f + 0.32f, 0.0077f,
		-0.255f + 0.0655f + 0.255f, -0.32f + 0.32f, -0.0077f,
		-0.255f + 0.0655f + 0.255f,  0.32f + 0.32f, -0.0077f,
		0.255f + 0.0655f + 0.255f,  0.32f + 0.32f, -0.0077f,
		0.255f + 0.0655f + 0.255f, -0.32f + 0.32f, -0.0077f };

	Centroide[0] = Centroide[1] = Centroide[2] = 0.f;


	for (int i = 0; i < 24; i += 3)
	{
		Centroide[0] += points[i];
		Centroide[1] += points[i + 1];
		Centroide[2] += points[i + 2];
	}


	Centroide[0] /= 8;
	Centroide[1] /= 8;
	Centroide[2] /= 8;

	InitCharS();

	glShadeModel(GL_SMOOTH);							// Enable Smooth Shading
	glClearDepth(1.0f);									// Depth Buffer Setup
	glEnable(GL_DEPTH_TEST);							// Enables Depth Testing
	glDepthFunc(GL_LEQUAL);								// The Type Of Depth Testing To Do
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	// Really Nice Perspective Calculations
	glEnable(GL_TEXTURE_2D);							// Enable Texture Mapping
	return TRUE;										// Initialization Went OK
}


void DrawStars(GLvoid)
{
	glCullFace(GL_BACK);
	glEnable(GL_CULL_FACE);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glPushMatrix();


	// now draw stars - as points
	if (m_bPointStars)
	{
		glPointSize(1.25f);
		glBegin(GL_POINTS);
		for (int i = 0; i<m_iNumStars; ++i)
		{
			glColor3fv(m_pStars[i].m_fColor);
			glVertex3fv(m_pStars[i].m_curPos);
		}
		glEnd();
		glPointSize(1.f);
	}
	else // draw stars as quads
	{
		glBegin(GL_QUADS);
		for (int i = 0; i<m_iNumStars; ++i)
		{
#define LENGTH 0.005f
			glColor3fv(m_pStars[i].m_fColor);
			glVertex3f(m_pStars[i].m_curPos[0] - LENGTH, m_pStars[i].m_curPos[1] - LENGTH, m_pStars[i].m_curPos[2]);
			glVertex3f(m_pStars[i].m_curPos[0] - LENGTH, m_pStars[i].m_curPos[1] + LENGTH, m_pStars[i].m_curPos[2]);
			glVertex3f(m_pStars[i].m_curPos[0] + LENGTH, m_pStars[i].m_curPos[1] + LENGTH, m_pStars[i].m_curPos[2]);
			glVertex3f(m_pStars[i].m_curPos[0] + LENGTH, m_pStars[i].m_curPos[1] - LENGTH, m_pStars[i].m_curPos[2]);
		}
		glEnd();
	}

	glPopMatrix();
	glDisable(GL_CULL_FACE);

}

int DrawGLScene(GLvoid)									// Here's Where We Do All The Drawing
{
	static int mcnt = 0;
	static GLfloat chvelocity = 1.f;
	GLfloat pmatrix[16];
	GLfloat LightPos[4] = { 0.0,0.0,0.0,1.0 };
	GLfloat LightPos1[4] = { 0.0,0.0,0.0,1.0 };
	GLfloat diffuse[4] = { 1.0f, 1.0f, 1.0f, 1.0f };
	GLfloat ambient[4] = { 0.3f, 0.3f, 0.3f, 1.0f };
	GLfloat specular[4] = { 1.f, 1.f, 1.f, 1.0f };

	g_CurrentTicks = std::clock();
	float deltaTicks = (float)(g_CurrentTicks - g_PreviousTicks);
	g_PreviousTicks = g_CurrentTicks;

	float fDeltaTime = deltaTicks / (float)CLOCKS_PER_SEC;
	GLfloat velocity = xspeed * fDeltaTime;

	xtrs -= 7.f*velocity;								// 4.f* for less speed scroller
	if (vg_charPos[g_msgA].back().x + xtrs < -(10.f))
		xtrs = 0.f;

	// black color buffer by default
	glClearColor(0.0f, 0.0f, 0.0f, 0.5f);
	/* Clear; default stencil clears to zero. */
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);

	Idle();
	DrawStars();

	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glGetFloatv(GL_PROJECTION_MATRIX, pmatrix);
	glPushMatrix();
	glLoadIdentity();									// Reset The Projection Matrix

	glTranslatef(0.f, -0.7f, 0.f);                      // adjust message position at the bottom ...
	glMultMatrixf(pmatrix);

	glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix
	glLoadIdentity();									// Reset The Modelview Matrix


	glEnable(GL_LIGHTING);								// Enable Lighting
	glEnable(GL_LIGHT0);								// Quick And Dirty Lighting (Assumes Light0 Is Set Up)
	LightPos[1] = 0.0; LightPos[0] = 10.0; LightPos[2] = -1.f;
	LightPos1[1] = 200.0; LightPos1[0] = 0.0; LightPos1[2] = 0.0;
	glLightfv(GL_LIGHT0, GL_AMBIENT, ambient);
	glLightfv(GL_LIGHT0, GL_SPECULAR, specular);


	int lng = vg_charPos[g_msgA].size();

	glBindTexture(GL_TEXTURE_2D, g_sTexture);			// Select The Texture
	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);


	for (int i = 0; i < lng; i++)
	{
		Coordinate p;
		p.y = vg_charPos[g_msgA][i].y;
		p.x = vg_charPos[g_msgA][i].x + xtrs;
		p.z = Gaussian_Func(p.x);
		float param = DerGaussian_Func(p.x);
		float result = atan(param) * 180 / M_PI;
		vg_charPos[g_msgA][i].rota = result;

		glPushMatrix();

		glLightfv(GL_LIGHT0, GL_POSITION, LightPos);

		glTranslatef(0.f, 0.f, -15.f);

		glTranslatef(p.x, p.y, p.z);
		glRotatef(-result, 0.0f, 1.0f, 0.0f);					                        // Rotate On The Y Axis
		glTranslatef(-Centroide[0], -Centroide[1], -Centroide[2]);					// Center On X, Y, Z Axis

		char text[2] = { sT[g_msgA][i], '\0' };
		glPrint(text);										    // Draw A character Symbol
		rot += 0.1f;											// Increase The transformation Variable
		glPopMatrix();

		//		if ((i == lng - 1) && (p.x < -6.f))
		//			printf("\nxtrs: %f\n", xtrs);
	}


	glBindTexture(GL_TEXTURE_2D, 0);
	glDisable(GL_LIGHTING);
	//	glDisable(GL_NORMALIZE);

	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glPopMatrix();


	glGetFloatv(GL_PROJECTION_MATRIX, pmatrix);
	glPushMatrix();
	glLoadIdentity();									// Reset The Projection Matrix

	glTranslatef(0.f, 0.78f, 0.f);                     // adjust message position at the top ...
	glMultMatrixf(pmatrix);

	glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix

	chvelocity -= fDeltaTime / 3.f;
	if (chvelocity <= 0.001f) {
		mcnt++;
		if (mcnt > 2)
			mcnt = 0;
		chvelocity = 1.15f;
	}

	int ms1, ms2;
	if (mcnt <= 1) {
		ms1 = mcnt; ms2 = mcnt + 1;
	}
	else
	{
		ms1 = mcnt; ms2 = 0;
	}


	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);
	//	glBlendFunc(GL_ONE_MINUS_DST_ALPHA, GL_DST_ALPHA);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	glColor4f(1.0, 1.0, 1.0, chvelocity);
	glBindTexture(GL_TEXTURE_2D, g_LTexture[ms1]);
	glDisable(GL_TEXTURE_GEN_S);
	glDisable(GL_TEXTURE_GEN_T);

	glPushMatrix();
	glTranslatef(0.f, 0.0f, -1.81f);

	glBegin(GL_QUADS);								// Drawing Using QUADS
	glTexCoord2f(0.f, 1.f);
	glVertex3f(-0.5f, -0.1f, -0.f);
	glTexCoord2f(1.f, 1.f);
	glVertex3f(0.5f, -0.1f, -0.f);
	glTexCoord2f(1.f, 0.f);
	glVertex3f(0.5f, 0.1f, -0.f);
	glTexCoord2f(0.f, 0.f);
	glVertex3f(-0.5f, 0.1f, -0.f);
	glEnd();									    // Finished Drawing The QUADS


	glColor4f(1.0, 1.0, 1.0, 1.f - chvelocity);
	glBindTexture(GL_TEXTURE_2D, g_LTexture[ms2]);
	glBegin(GL_QUADS);								// Drawing Using QUADS
	glTexCoord2f(0.f, 1.f);
	glVertex3f(-0.5f, -0.1f, -0.f);
	glTexCoord2f(1.f, 1.f);
	glVertex3f(0.5f, -0.1f, -0.f);
	glTexCoord2f(1.f, 0.f);
	glVertex3f(0.5f, 0.1f, -0.f);
	glTexCoord2f(0.f, 0.f);
	glVertex3f(-0.5f, 0.1f, -0.f);
	glEnd();									    // Finished Drawing The QUADS

	glPopMatrix();

	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);
	glBindTexture(GL_TEXTURE_2D, 0);

	glColor4f(1.0, 1.0, 1.0, 1.f);
	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix

	if (!playmusic)
	{
		playmusic = TRUE;
		fMod.Play();

	}

	return TRUE;										// Keep Going

}

/* Idle function.  Moves the text/stars using the current time */
void Idle()
{
#define EYE_Z 0.1f
	LARGE_INTEGER now;

	// get current time
	QueryPerformanceCounter(&now);

	float m_fTimeElapsed = ((float)(now.QuadPart - m_start.QuadPart) / (float)m_freq.QuadPart);

	// move the stars, calculate new time based on star m_start time
	m_fTimeElapsed = ((float)(now.QuadPart - m_starStart.QuadPart) / (float)m_freq.QuadPart);
	for (int i = 0; i<m_iNumStars; ++i)
	{
		// update their z position
		m_pStars[i].m_curPos[2] = m_pStars[i].m_start.z + m_pStars[i].speed.z * (m_fTimeElapsed - m_pStars[i].timeOffset);
		// ok they're out of view, respawn a new star
		if (m_pStars[i].m_curPos[2] >= EYE_Z)
		{
			m_pStars[i].m_start.x = GetRandom(-5.0, 5.0);
			m_pStars[i].m_start.y = GetRandom(-5.0, 5.0);
			m_pStars[i].m_start.z = -10.0f;
			m_pStars[i].timeOffset = m_fTimeElapsed;
		}
		else
		{
			m_pStars[i].m_curPos[0] = m_pStars[i].m_start.x;
			m_pStars[i].m_curPos[1] = m_pStars[i].m_start.y;
		}
	}
}

GLvoid KillGLWindow(GLvoid)								// Properly Kill The Window
{
	if (fullscreen)										// Are We In Fullscreen Mode?
	{
		ChangeDisplaySettings(NULL, 0);					// If So Switch Back To The Desktop
		ShowCursor(TRUE);								// Show Mouse Pointer
	}

	if (hRC)											// Do We Have A Rendering Context?
	{
		if (!wglMakeCurrent(NULL, NULL))					// Are We Able To Release The DC And RC Contexts?
		{
			MessageBox(NULL, "Release Of DC And RC Failed.", "SHUTDOWN ERROR", MB_OK | MB_ICONINFORMATION);
		}

		if (!wglDeleteContext(hRC))						// Are We Able To Delete The RC?
		{
			MessageBox(NULL, "Release Rendering Context Failed.", "SHUTDOWN ERROR", MB_OK | MB_ICONINFORMATION);
		}
		hRC = NULL;										// Set RC To NULL
	}

	if (hDC && !ReleaseDC(hWnd, hDC))					// Are We Able To Release The DC
	{
		MessageBox(NULL, "Release Device Context Failed.", "SHUTDOWN ERROR", MB_OK | MB_ICONINFORMATION);
		hDC = NULL;										// Set DC To NULL
	}

	if (hWnd && !DestroyWindow(hWnd))					// Are We Able To Destroy The Window?
	{
		MessageBox(NULL, "Could Not Release hWnd.", "SHUTDOWN ERROR", MB_OK | MB_ICONINFORMATION);
		hWnd = NULL;										// Set hWnd To NULL
	}

	if (!UnregisterClass("OpenGL", hInstance))			// Are We Able To Unregister Class
	{
		MessageBox(NULL, "Could Not Unregister Class.", "SHUTDOWN ERROR", MB_OK | MB_ICONINFORMATION);
		hInstance = NULL;									// Set hInstance To NULL
	}

	KillFont();
	KillFont();
}

/*	This Code Creates Our OpenGL Window.  Parameters Are:					*
*	title			- Title To Appear At The Top Of The Window				*
*	width			- Width Of The GL Window Or Fullscreen Mode				*
*	height			- Height Of The GL Window Or Fullscreen Mode			*
*	bits			- Number Of Bits To Use For Color (8/16/24/32)			*
*	fullscreenflag	- Use Fullscreen Mode (TRUE) Or Windowed Mode (FALSE)	*/

BOOL CreateGLWindow(char* title, int width, int height, int bits, bool fullscreenflag)
{
	GLuint		PixelFormat;			// Holds The Results After Searching For A Match
	WNDCLASS	wc;						// Windows Class Structure
	DWORD		dwExStyle;				// Window Extended Style
	DWORD		dwStyle;				// Window Style
	RECT		WindowRect;				// Grabs Rectangle Upper Left / Lower Right Values
	WindowRect.left = (long)0;			// Set Left Value To 0
	WindowRect.right = (long)width;		// Set Right Value To Requested Width
	WindowRect.top = (long)0;				// Set Top Value To 0
	WindowRect.bottom = (long)height;		// Set Bottom Value To Requested Height

	fullscreen = fullscreenflag;			// Set The Global Fullscreen Flag

	hInstance = GetModuleHandle(NULL);				// Grab An Instance For Our Window
	wc.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;	// Redraw On Size, And Own DC For Window.
	wc.lpfnWndProc = (WNDPROC)WndProc;					// WndProc Handles Messages
	wc.cbClsExtra = 0;									// No Extra Window Data
	wc.cbWndExtra = 0;									// No Extra Window Data
	wc.hInstance = hInstance;							// Set The Instance
	wc.hIcon = LoadIcon(NULL, IDI_WINLOGO);			// Load The Default Icon
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);			// Load The Arrow Pointer
	wc.hbrBackground = NULL;									// No Background Required For GL
	wc.lpszMenuName = NULL;									// We Don't Want A Menu
	wc.lpszClassName = "OpenGL";								// Set The Class Name

	if (!RegisterClass(&wc))									// Attempt To Register The Window Class
	{
		MessageBox(NULL, "Failed To Register The Window Class.", "ERROR", MB_OK | MB_ICONEXCLAMATION);
		return FALSE;											// Return FALSE
	}

	if (fullscreen)												// Attempt Fullscreen Mode?
	{
		DEVMODE dmScreenSettings;								// Device Mode
		memset(&dmScreenSettings, 0, sizeof(dmScreenSettings));	// Makes Sure Memory's Cleared
																//		if (!EnumDisplaySettings(NULL, ENUM_CURRENT_SETTINGS, &dmScreenSettings)) {
																//			memset(&dmScreenSettings, 0, sizeof(dmScreenSettings));	// Makes Sure Memory's Cleared
		dmScreenSettings.dmSize = sizeof(dmScreenSettings);		// Size Of The Devmode Structure
		dmScreenSettings.dmPelsWidth = width;				// Selected Screen Width
		dmScreenSettings.dmPelsHeight = height;				// Selected Screen Height
		dmScreenSettings.dmBitsPerPel = bits;					// Selected Bits Per Pixel
		dmScreenSettings.dmFields = DM_BITSPERPEL | DM_PELSWIDTH | DM_PELSHEIGHT;
		//		}

		// Try To Set Selected Mode And Get Results.  NOTE: CDS_FULLSCREEN Gets Rid Of Start Bar.
		if (ChangeDisplaySettings(&dmScreenSettings, CDS_FULLSCREEN) != DISP_CHANGE_SUCCESSFUL)
		{
			// If The Mode Fails, Offer Two Options.  Quit Or Use Windowed Mode.
			if (MessageBox(NULL, "The Requested Fullscreen Mode Is Not Supported By\nYour Video Card. Use Windowed Mode Instead?", " GL", MB_YESNO | MB_ICONEXCLAMATION) == IDYES)
			{
				fullscreen = FALSE;		// Windowed Mode Selected.  Fullscreen = FALSE
			}
			else
			{
				// Pop Up A Message Box Letting User Know The Program Is Closing.
				MessageBox(NULL, "Program Will Now Close.", "ERROR", MB_OK | MB_ICONSTOP);
				return FALSE;									// Return FALSE
			}
		}
	}

	if (fullscreen)												// Are We Still In Fullscreen Mode?
	{
		dwExStyle = WS_EX_APPWINDOW;								// Window Extended Style
		dwStyle = WS_POPUP;										// Windows Style
		ShowCursor(FALSE);										// Hide Mouse Pointer
	}
	else
	{
		dwExStyle = WS_EX_APPWINDOW | WS_EX_WINDOWEDGE;			// Window Extended Style
		dwStyle = WS_OVERLAPPEDWINDOW;							// Windows Style
	}

	AdjustWindowRectEx(&WindowRect, dwStyle, FALSE, dwExStyle);		// Adjust Window To True Requested Size

	int screenWidth = GetSystemMetrics(SM_CXSCREEN);
	int screenHeight = GetSystemMetrics(SM_CYSCREEN);
	int halfScreenWidth = width;
	int halfScreenHeight = height;
	int left = (screenWidth - halfScreenWidth) / 2;
	int top = (screenHeight - halfScreenHeight) / 2;
	top -= 30;
	if (fullscreen) {
		top = left = 0;
	}

	// Create The Window
	if (!(hWnd = CreateWindowEx(dwExStyle,							// Extended Style For The Window
		"OpenGL",							// Class Name
		title,								// Window Title
		dwStyle |							// Defined Window Style
		WS_CLIPSIBLINGS |					// Required Window Style
		WS_CLIPCHILDREN,					// Required Window Style
		left, top,								// Window Position
		WindowRect.right - WindowRect.left,	// Calculate Window Width
		WindowRect.bottom - WindowRect.top,	// Calculate Window Height
		NULL,								// No Parent Window
		NULL,								// No Menu
		hInstance,							// Instance
		NULL)))								// Dont Pass Anything To WM_CREATE
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL, "Window Creation Error.", "ERROR", MB_OK | MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	static	PIXELFORMATDESCRIPTOR pfd =				// pfd Tells Windows How We Want Things To Be
	{
		sizeof(PIXELFORMATDESCRIPTOR),				// Size Of This Pixel Format Descriptor
		1,											// Version Number
		PFD_DRAW_TO_WINDOW |						// Format Must Support Window
		PFD_SUPPORT_OPENGL |						// Format Must Support OpenGL
		PFD_DOUBLEBUFFER,							// Must Support Double Buffering
		PFD_TYPE_RGBA,								// Request An RGBA Format
		bits,										// Select Our Color Depth
		0, 0, 0, 0, 0, 0,							// Color Bits Ignored
		0,											// No Alpha Buffer
		0,											// Shift Bit Ignored
		0,											// No Accumulation Buffer
		0, 0, 0, 0,									// Accumulation Bits Ignored
		16,											// 16Bit Z-Buffer (Depth Buffer)  
		0,											// No Stencil Buffer
		0,											// No Auxiliary Buffer
		PFD_MAIN_PLANE,								// Main Drawing Layer
		0,											// Reserved
		0, 0, 0										// Layer Masks Ignored
	};

	if (!(hDC = GetDC(hWnd)))							// Did We Get A Device Context?
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL, "Can't Create A GL Device Context.", "ERROR", MB_OK | MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if (!(PixelFormat = ChoosePixelFormat(hDC, &pfd)))	// Did Windows Find A Matching Pixel Format?
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL, "Can't Find A Suitable PixelFormat.", "ERROR", MB_OK | MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if (!SetPixelFormat(hDC, PixelFormat, &pfd))		// Are We Able To Set The Pixel Format?
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL, "Can't Set The PixelFormat.", "ERROR", MB_OK | MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if (!(hRC = wglCreateContext(hDC)))				// Are We Able To Get A Rendering Context?
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL, "Can't Create A GL Rendering Context.", "ERROR", MB_OK | MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if (!wglMakeCurrent(hDC, hRC))					// Try To Activate The Rendering Context
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL, "Can't Activate The GL Rendering Context.", "ERROR", MB_OK | MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	ShowWindow(hWnd, SW_SHOW);						// Show The Window
	SetForegroundWindow(hWnd);						// Slightly Higher Priority
	SetFocus(hWnd);									// Sets Keyboard Focus To The Window
	ReSizeGLScene(width, height);					// Set Up Our Perspective GL Screen

	if (!InitGL())									// Initialize Our Newly Created GL Window
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL, "Initialization Failed.", "ERROR", MB_OK | MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	return TRUE;									// Success
}


//
//  FUNCTION: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND  - process the application menu
//  WM_PAINT    - Paint the main window
//  WM_DESTROY  - post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	case WM_ACTIVATE:							// Watch For Window Activate Message
	{
		if (!HIWORD(wParam))					// Check Minimization State
		{
			active = TRUE;						// Program Is Active
		}
		else
		{
			active = FALSE;						// Program Is No Longer Active
		}

		return 0;								// Return To The Message Loop
	}

	case WM_SYSCOMMAND:							// Intercept System Commands
	{
		switch (wParam)							// Check System Calls
		{
		case SC_SCREENSAVE:					// Screensaver Trying To Start?
		case SC_MONITORPOWER:				// Monitor Trying To Enter Powersave?
			return 0;							// Prevent From Happening
		}
		break;									// Exit
	}

	case WM_CLOSE:								// Did We Receive A Close Message?
	{
		PostQuitMessage(0);						// Send A Quit Message
		return 0;								// Jump Back
	}

	case WM_KEYDOWN:							// Is A Key Being Held Down?
	{
		keys[wParam] = TRUE;					// If So, Mark It As TRUE
		return 0;								// Jump Back
	}

	case WM_KEYUP:								// Has A Key Been Released?
	{
		keys[wParam] = FALSE;					// If So, Mark It As FALSE
		return 0;								// Jump Back
	}

	case WM_SIZE:								// Resize The OpenGL Window
	{
		ReSizeGLScene(LOWORD(lParam), HIWORD(lParam));  // LoWord=Width, HiWord=Height
		return 0;								// Jump Back
	}

	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

int _tmain(int argc, _TCHAR* argv[])
{

	WinEntryPoint();
	return 0;
}


