;RFLAT v0.36b
;Init mode flat & xms

;---------------------------------------------------------------------------
        pnot386 db 'You need at last a 386 to run this program$'
        protec  db 'Can''t run : CPU is already in V86 mode$'
        noxms   db 'XMS driver not installed$'
        xold    db 'XMS driver v2.0 or greater requested$'
        xsize   db 'Not enough free XMS$'
        xmsf    db 'Cannot release XMS driver$'

        gdt     db 0,   0,   0,   0,   0,   0,   0,   0
                db 0ffh,0ffh,0,   0,   0,   92h, 0cfh,0ffh

        gdto    db 6 dup (0)
        xmsd    dd 0                       ; seg:ofs pour appel xms
        xmsv    dw 0                       ; version xms
        xmsb    dd 0                       ; debut fs:xmsb pour xms
        xmm     dd 0                       ;  align 16
        xhandle dw 0                       ; handle xms

        _mem    dw 0
;


; pour init ZE mode flat: tu places dans _mem le nombre de
; ko d'xms que tu veux... ensuite un petit CALL F_INIT
; et ca y est...
; avant de sortir, dealloc l'xms: CALL F_OUT
;
; ca te donne donc acces a toute la mem du pc...
; apres F_INIT tu as dans xmsb le debut de ta xms
; donc si tu fais  mov al,[xmsb] tu as le premier octet
; de ton xms....
;
; t'as droit au trucs bizarres comme lea eax,[ebx*4+ebx]  eax=ebx*5
; ou mov di,[eax]
; ou encore add di,[ebx+ebp]


; Init Mode Flat 
; errcodes  0:ok
;           1:pas de 386
;           2:emm actif
;           3:pas de xmm
;           4:xmm pas assez recent
;           5:adresse mem <1mb
F_init  PROC NEAR

; ------ test si 386 --------


        push sp
        pop ax
        cmp sp,ax
        jnz pn386                          ; 8088 ?
        pushf
        pop ax
        or ax,4000h
        push ax
        popf
        pushf
        pop ax
        test ax,4000h
        jz pn386                           ; 80286 ?
        jmp p80386                         ; 80386 ! (ou+)
pn386:  mov ax,1
        ret
p80386:                                    ; 80386 detecte
;------- test mode ---------
        mov eax,cr0
        test al,1
        jz real                            ; mode protege, on arrete
        mov ax,2
        ret
;------- test xms ----------
real:   mov ax,4300h                       ; mode reel, xms installe ?
        int 2fh
        cmp al,80h
        jz xins                            ; non
        mov ax,3
        ret
xins:                                      ; xms installe
        mov ax,4310h
        int 2fh
        mov WORD PTR xmsd+2,es             ; on obtient l'addresse du
        mov WORD PTR xmsd+0,bx             ; pilote
        xor ax,ax
        call DWORD PTR [xmsd]
        cmp ax,0200h
        jge xvo                            ; version trop ancienne ?
        mov ax,4
        ret
xvo:    mov xmsv,ax                        ; n version xms

;------- INIT -----------
        mov gdto[0],16
        mov eax,SEG gdt
        shl eax,4
        mov bx,OFFSET gdt
        movzx ebx,bx
        add eax,ebx
        mov DWORD PTR gdto[2],eax
        lgdt PWORD PTR gdto                ; charge la gdt
           ;=FWORD PTR
                                           ; (=global descriptor table)
        mov bx,8
        push ds                            ; :bx = entree 1 gdt
        cli
        mov eax,CR0
        or eax,1
        mov CR0,eax                        ; mode protege
        jmp nowprotected                   ; efface executionpipe ($+2)
nowprotected:
        mov gs,bx                          ; segs sur 4 go
        mov fs,bx
        mov es,bx
        mov ds,bx
        and eax,254
        mov CR0,eax                        ; back en reel
        jmp nowreal
nowreal:
        sti
        pop ds
;------- alloc xms ----------
        mov ax,0900h
        mov dx,_mem
        call DWORD PTR [xmsd]              ; alloc dx*1024 bytes xms
        cmp ax,1
        jz nxerrsize
        mov ax,5
        ret
nxerrsize:
        mov xhandle,dx
        mov ax,0c00h
        mov dx,xhandle
        call DWORD PTR [xmsd]              ; handle lock pour addresse
        push bx dx
        mov ax,0d00h
        mov dx,xhandle
        call DWORD PTR [xmsd]              ; on delock
        pop dx bx

        xor eax,eax                        ; adresse de depart=dx*65536+bx
        mov ax,dx                          ; doit etre >100000h
        shl eax,16                         ; car le dos utilise ce meg
        add ax,bx                          
        mov xmsb,eax

        cmp eax,1048576                    ; plantage ?
        jge xmo 
        mov ax,5
        ret
xmo:    mov eax,[xmsb]
        shr eax,16
        inc eax
        shl eax,16
        mov [xmm],eax
        mov ax,0
        mov fs,ax
        mov gs,ax
        ret
F_init  ENDP                               ; fs=gs=0

;  Deallocation XMS 
;errcodes 0:ok
;         1:xms non dealoccable
F_out   PROC NEAR
        mov ax,0a00h
        mov dx,xhandle
        call DWORD PTR [xmsd]              ; dealloc xms
        cmp ax,1
        jz xmsfreed
        mov ax,1
        ret
xmsfreed:mov ax,0
        ret
F_out   ENDP

;----------------------------------------------------------------------------