
#include "shared.h"

void pad_shutdown(void)
{
    IOSEL   = 0x00; /* Manual mode for both ports */
}

void pad_init(void)
{
    DDR1    = 0x60; /* TH,TR out, TL,D3-D0 in */
    DDR2    = 0x60; /* TH,TR out, TL,D3-D0 in */
    IOSEL   = 0x03; /* Manual mode for both ports */
    EXLE    = 0x00;
}


uint16 pad_read(int which)
{
    uint16 temp;
    int count;

    PDR1 = 0x60;
    for(count=0; count < PAD_DELAY; count++)
        asm("nop");
    temp = (PDR1 & 0x08) << 12;

    PDR1 = 0x40;
    for(count=0; count < PAD_DELAY; count++)
        asm("nop");
    temp |= (PDR1 & 0x0F) << 8;

    PDR1 = 0x20;
    for(count=0; count < PAD_DELAY; count++)
        asm("nop");
    temp |= (PDR1 & 0x0F) << 4;

    PDR1 = 0x00;
    for(count=0; count < PAD_DELAY; count++)
        asm("nop");
    temp |= (PDR1 & 0x0F) << 0;

    return (temp ^ 0x8FFF);
}

