;LD HL,CAFE
;ZX Spectrum 48, 256b intro
;code - .ded^RMDA
;18.11.2021, Russia, Samara

;duration: ~ 1:30 min. = 3 x 26 sec. per one scroll, then loop.

;how to build:
;use SjASMplus https://github.com/z00m128/sjasmplus
;sjasmplus.exe 1982.asm

;code footprint:
;010b - CLS
;008b - FX swap
;012b - Triangle fill
;065b - Scroll
;161b - Text data
;---------------------------------------------------------------

	DEVICE	ZXSPECTRUM48

	org	#cafe
begin:	
;-------set screen attributes-----------------------------------
;	di
	xor	a		;set Z-flag
	ld	a,%00100100
	ld	b,a
	out	(#fe),a
attrs:	ld	(bc),a
	inc	bc		;self destruct but save bytes
	jr 	z,attrs
;---------------------------------------------------------------
; attribute scroller based on John Metcalf source:
; https://gist.github.com/BalorPrice/799f815267cd9b8ae16d1efa2e6d57ce
; http://www.retroprogramming.com/
;

attrscr:
	ld	hl,message
nextchr:
	ld	a,(hl)
;	or	a		;replace OR A (00 = EoT control)
	add	a,a		;with ADD/RLCA, same effect
	jr	nz,dalee        ;no need to ADD A,A later
;-------scroll colors scheme swap-------------------------------
	ld	l,#50-2		;low byte of COLOR: label
	ld	a,#04		;LD (HL),A / LD (HL),E swap
	xor	(hl)
	ld	(hl),a
;-------pixel background fill-----------------------------------
	ld	hl,#5155
	ld	a,l
linz2:	dec	h
linz3:	dec	l
	ld	(hl),a
	jr	nz,linz3
	add	a,a
	jr	nz,linz2
	jr	attrscr
;---------------------------------------------------------------
dalee:	push	hl
;	add	a,a		;already done at EoT check
	ld	l,a             ;get bitmap for glyph
	ld	de,#ff0f	;scroll buffer address
	ld	h,e		;ld	h,#0f
	add	hl,hl
	add	hl,hl
;-------copy glyph to workspace---------------------------------
;	ld	de,tempchar	;scroll buffer
	ld	bc,8
	ld	a,c
	ldir
;---------------------------------------------------------------
scroll:	push	af
	ei
	halt
;-------shift screen left by 1 attribute------------------------
	ld	hl,#5901	;ld	hl,#5901
 	ld	c,d		;ld	de,#5900
	ld	e,b             ;ld	bc,#00ff
	ld	d,h		;
	ldir
;-------copy a column of bits from the glyph to the attributes--
;	ld	de,tempchar	;scroll buffer
	ld	de,#ff0f
	ld	hl,#591F
	ld	a,8
	ld	c,32
nextrow:
	ld	(hl),%00100100	;background color
	ex	de,hl
	rl	(hl)
	ex	de,hl
	jr	nc,zerobit
color:	ld	(hl),a		;font color
zerobit:
	add	hl,bc
	inc	de
	dec	a
	jr	nz,nextrow

	pop	af
	dec	a

	jr	nz,scroll
	pop	hl
	inc	hl
	jr	nextchr

message:
	defm	"YOU HAVE BEEN INVITED to CAFe demoparty! 21-23"
	defm	" October 2022, Kazan, Russia. ATARI ZX AMIGA"
	defm	" BK NES C64 and other retro are welcomed! More"
	defm	" info: CAFEPARTY.ORG.RU  "
	defb	#00		; end of text marker

;tempchar:	db	0,0,0,0,0,0,0,0

finish:	
	SAVESNA	"ldhlcafe.sna", begin
	SAVEBIN	"21FECA.bin", begin, finish-begin
;	EMPTYTRD "ldhlcafe.trd","LD HL,CAFE"
;	SAVETRD	"ldhlcafe.trd","21FECA.C",begin,finish-begin
;	EMPTYTAP "ldhlcafe.tap"
;	SAVETAP "ldhlcafe.tap",CODE,"21FECA",begin,finish-begin

;---------------8x8 triangle fill-------------------------------
;degoblinized from 20 to 16 bytes
;
;	ld	hl,#5800	;#5800 for full screen, #5000/#4800 for 1/3
;linz1:	ld	a,#55		;pattern, #ff for triangles, also good #55, only odd A is valid!
;linz2:	dec	h
;linz3:	dec	l
;	ld	(hl),a
;	jr	nz,linz3
;	add	a,a
;	jr	nz,linz2
;	cp	h		;comment this for 1/3 of screen
;	jr	nz,linz1	;comment this for 1/3 of screen
;-------=RMDA=---------------------------------------------[eof]